/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Arrays;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class FindRootsAfterUpdate
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit b1;
    IInstallableUnit b2;
    IInstallableUnit b3;
    IInstallableUnit x1;
    IProfile profile;
    IPlanner planner;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = FindRootsAfterUpdate.createIU("A", Version.create((String)"1.0.0"), FindRootsAfterUpdate.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "B", new VersionRange("[1.0.0, 4.0.0)")));
        this.b1 = FindRootsAfterUpdate.createIU("B", Version.create((String)"1.0.0"), true);
        this.b2 = FindRootsAfterUpdate.createIU("B", Version.create((String)"2.0.0"), true);
        this.b3 = FindRootsAfterUpdate.createIU("B", Version.create((String)"3.0.0"), true);
        this.x1 = FindRootsAfterUpdate.createIU("X", Version.createOSGi((int)2, (int)0, (int)0), FindRootsAfterUpdate.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "B", new VersionRange("[2.0.0, 2.0.0]")));
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.b2, this.b3, this.x1});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = FindRootsAfterUpdate.createPlanner();
    }

    public void testInstallB3() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        ProvisioningContext ctx = new ProvisioningContext(FindRootsAfterUpdate.getAgent());
        IRequirement[] reqs = FindRootsAfterUpdate.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "B", new VersionRange("[2.0.0, 4.0.0]"));
        req.addExtraRequirements(Arrays.asList(reqs[0]));
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, ctx, null);
        FindRootsAfterUpdate.assertEquals((int)0, (int)plan.getStatus().getSeverity());
        FindRootsAfterUpdate.assertInstallOperand(plan, this.b3);
        FindRootsAfterUpdate.assertContains(plan.getFutureState().query(QueryUtil.createMatchQuery((IExpression)reqs[0].getMatches(), (Object[])new Object[0]), null), this.b3);
    }

    public void testConflictThroughExtraRequirements() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        ProvisioningContext ctx = new ProvisioningContext(FindRootsAfterUpdate.getAgent());
        IRequirement reqOnB = FindRootsAfterUpdate.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "B", new VersionRange("[3.0.0, 4.0.0]"))[0];
        IRequirement reqOnX = FindRootsAfterUpdate.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "X", new VersionRange("[2.0.0, 2.0.0]"))[0];
        IRequirement[] extraReqs = new IRequirement[]{reqOnB, reqOnX};
        req.addExtraRequirements(Arrays.asList(extraReqs));
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, ctx, null);
        FindRootsAfterUpdate.assertNotOK(plan.getStatus());
    }
}

