/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class MinimalInstall2
extends AbstractProvisioningTest {
    IInstallableUnit kernelRoot;
    IInstallableUnit kernelBundle;
    IInstallableUnit userRegionRoot;
    IInstallableUnit userRegionBundle;
    IInstallableUnit userRegionRoot2;
    IInstallableUnit kernelProxy;
    IInstallableUnit commonDep;
    IProfile profile;
    IPlanner planner;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.kernelRoot = MinimalInstall2.createIU("KernelRoot", Version.create((String)"1.0.0"), MinimalInstall2.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "KernelBundle", new VersionRange("[1.0.0, 2.0.0)")));
        this.kernelBundle = MinimalInstall2.createIU("KernelBundle", Version.create((String)"1.0.0"), new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"KernelBundle", (Version)Version.create((String)"1.0.0")), MetadataFactory.createProvidedCapability((String)"java.package", (String)"kernel.package", (Version)Version.create((String)"1.0.0"))});
        this.userRegionRoot = MinimalInstall2.createIU("UserRegionRoot", Version.create((String)"1.0.0"), MinimalInstall2.createRequiredCapabilities("org.eclipse.equinox.p2.iu", "UserRegionBundle", new VersionRange("[1.0.0, 2.0.0)")));
        this.userRegionBundle = MinimalInstall2.createIU("UserRegionBundle", Version.create((String)"1.0.0"), MinimalInstall2.createRequiredCapabilities("java.package", "kernel.package"));
        IRequirement[] reqs = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"UserRegionBundle", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"KernelProxy", (VersionRange)new VersionRange("[1.0.0, 2.0.0)"), null, (boolean)false, (boolean)false, (boolean)true)};
        this.userRegionRoot2 = MinimalInstall2.createIU("UserRegionRoot2", reqs);
        this.kernelProxy = MinimalInstall2.createIU("KernelProxy", Version.create((String)"1.0.0"), new IProvidedCapability[]{MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"KernelProxy", (Version)Version.create((String)"1.0.0")), MetadataFactory.createProvidedCapability((String)"java.package", (String)"kernel.package", (Version)Version.create((String)"1.0.0"))});
        this.createTestMetdataRepository(new IInstallableUnit[]{this.kernelRoot, this.kernelBundle, this.userRegionRoot, this.userRegionBundle, this.userRegionRoot2, this.kernelProxy});
        this.profile = this.createProfile("TestProfile." + this.getName());
        this.planner = MinimalInstall2.createPlanner();
    }

    public void testInstallUserRegion() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.userRegionRoot});
        IProvisioningPlan pplan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        MinimalInstall2.assertEquals((int)0, (int)pplan.getStatus().getSeverity());
        MinimalInstall2.assertEquals((int)3, (int)pplan.getAdditions().query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor()).toSet().size());
    }

    public void testInstallUserRegion2() {
        ProfileChangeRequest req = new ProfileChangeRequest(this.profile);
        req.addInstallableUnits(new IInstallableUnit[]{this.userRegionRoot2});
        IProvisioningPlan pplan = this.planner.getProvisioningPlan((IProfileChangeRequest)req, null, null);
        MinimalInstall2.assertEquals((int)0, (int)pplan.getStatus().getSeverity());
        MinimalInstall2.assertEquals((int)3, (int)pplan.getAdditions().query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor()).toSet().size());
        MinimalInstall2.assertFalse((boolean)pplan.getAdditions().query(QueryUtil.createIUQuery((String)this.userRegionRoot2.getId()), (IProgressMonitor)new NullProgressMonitor()).isEmpty());
        MinimalInstall2.assertFalse((boolean)pplan.getAdditions().query(QueryUtil.createIUQuery((String)this.kernelProxy.getId()), (IProgressMonitor)new NullProgressMonitor()).isEmpty());
        MinimalInstall2.assertFalse((boolean)pplan.getAdditions().query(QueryUtil.createIUQuery((String)this.userRegionBundle.getId()), (IProgressMonitor)new NullProgressMonitor()).isEmpty());
    }
}

