/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class NonMinimalState
extends AbstractProvisioningTest {
    IProfile profile = null;
    IMetadataRepository repo = null;
    private String searchedId;
    private Set visited = new HashSet();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File reporegistry1 = NonMinimalState.getTestData("Non Minimal state", "testData/nonMinimalState/");
        File tempFolder = this.getTempFolder();
        NonMinimalState.copy("0.2", reporegistry1, tempFolder);
        SimpleProfileRegistry registry = new SimpleProfileRegistry(NonMinimalState.getAgent(), tempFolder, null, false);
        this.profile = registry.getProfile("NonMinimalState");
        NonMinimalState.getMetadataRepositoryManager().addRepository(NonMinimalState.getTestData("nonMinimalState-galileoM7", "testData/galileoM7/").toURI());
        NonMinimalState.assertNotNull((Object)this.profile);
    }

    public void testValidateProfileWithRepository() {
        IPlanner planner = NonMinimalState.createPlanner();
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, null, (IProgressMonitor)new NullProgressMonitor());
        NonMinimalState.assertOK("Plan OK", plan.getStatus());
        NonMinimalState.assertTrue((boolean)plan.getAdditions().query(QueryUtil.createIUQuery((String)"org.eclipse.tptp.platform.agentcontroller"), null).isEmpty());
        this.why("slf4j.api");
        this.why("slf4j.jcl");
        this.why("org.eclipse.tptp.platform.iac.administrator");
        this.why("org.eclipse.tptp.platform.agentcontroller");
    }

    public void testValidateProfileWithoutRepo() {
        IPlanner planner = NonMinimalState.createPlanner();
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        ProvisioningContext ctx = new ProvisioningContext(NonMinimalState.getAgent());
        ctx.setMetadataRepositories(new URI[0]);
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        NonMinimalState.assertOK("Plan OK", plan.getStatus());
        NonMinimalState.assertTrue((boolean)plan.getAdditions().query(QueryUtil.createIUQuery((String)"org.eclipse.tptp.platform.agentcontroller"), null).isEmpty());
    }

    private void why(String id) {
        System.out.println("=-=-=" + id + "=-=-=");
        this.visited = new HashSet();
        IQueryResult roots = this.profile.query((IQuery)new IUProfilePropertyQuery("org.eclipse.equinox.p2.type.root", "true"), null);
        this.searchedId = id;
        for (IInstallableUnit type : roots) {
            if (type instanceof IInstallableUnitFragment) {
                this.visited.add(type);
                continue;
            }
            if (!this.processIU(type)) continue;
            return;
        }
    }

    public boolean processIU(IInstallableUnit iu) {
        if (iu.getId().equals("toolingorg.eclipse.equinox.launcher") || iu.getId().equals("tooling.osgi.bundle.default") || iu.getId().startsWith("tooling")) {
            this.visited.add(iu);
            return false;
        }
        Collection reqs = iu.getRequirements();
        for (IRequirement req : reqs) {
            boolean result = this.expandRequirement(iu, req);
            if (!result) continue;
            System.out.println(iu + " because " + req.toString());
            return true;
        }
        return false;
    }

    private boolean expandRequirement(IInstallableUnit iu, IRequirement req) {
        IQueryResult matches = this.profile.query(QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]), null);
        for (IInstallableUnit match : matches) {
            if (match.getId().equals(this.searchedId)) {
                return true;
            }
            if (this.visited.contains(match)) continue;
            this.visited.add(match);
            if (!this.processIU(match)) continue;
            return true;
        }
        return false;
    }
}

