/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PatchTest7
extends AbstractProvisioningTest {
    IInstallableUnit c1;
    IInstallableUnit y1;
    IInstallableUnit y2;
    IInstallableUnit f1;
    IInstallableUnitPatch pp1;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.y1 = PatchTest7.createIU("Y", Version.createOSGi((int)1, (int)0, (int)0), true);
        this.y2 = PatchTest7.createIU("Y", Version.createOSGi((int)1, (int)2, (int)0), true);
        this.c1 = PatchTest7.createIU("C", Version.create((String)"1.0.0"), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"Y", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)true)});
        IRequirement[] req = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)true)};
        this.f1 = PatchTest7.createIU("F", Version.createOSGi((int)1, (int)0, (int)0), req);
        IRequirementChange changeY = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"Y", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"Y", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement[][] scopePP = new IRequirement[0][0];
        this.pp1 = PatchTest7.createIUPatch("PP", Version.create((String)"1.0.0"), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, false, null, new IRequirementChange[]{changeY}, scopePP, null, new IRequirement[0]);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.c1, this.y1, this.y2, this.f1, this.pp1});
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        this.planner = PatchTest7.createPlanner();
        this.engine = PatchTest7.createEngine();
    }

    public void testGeneralScope() {
        ProfileChangeRequest req3 = new ProfileChangeRequest(this.profile1);
        req3.addInstallableUnits(new IInstallableUnit[]{this.f1, this.pp1});
        IProvisioningPlan plan3 = this.planner.getProvisioningPlan((IProfileChangeRequest)req3, null, null);
        PatchTest7.assertEquals((int)0, (int)plan3.getStatus().getSeverity());
        PatchTest7.assertInstallOperand(plan3, this.f1);
        PatchTest7.assertInstallOperand(plan3, this.c1);
        PatchTest7.assertInstallOperand(plan3, this.y2);
        PatchTest7.assertInstallOperand(plan3, (IInstallableUnit)this.pp1);
    }
}

