/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Set;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PatchTest9
extends AbstractProvisioningTest {
    IInstallableUnit a1;
    IInstallableUnit b1;
    IInstallableUnit b2;
    IInstallableUnit c1;
    IInstallableUnitPatch p1;
    IInstallableUnitPatch pp1;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.a1 = PatchTest9.createIU("A", Version.create((String)"1.0.0"), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)new VersionRange("[1.0.0, 1.1.0)"), null, (boolean)false, (boolean)true)});
        this.b1 = PatchTest9.createIU("B", Version.createOSGi((int)1, (int)0, (int)0), true);
        this.b2 = PatchTest9.createIU("B", Version.createOSGi((int)1, (int)2, (int)0), true);
        this.c1 = PatchTest9.createIU("C", Version.createOSGi((int)1, (int)0, (int)0), true);
        IRequirementChange changeB = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"B", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirementChange changeC = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)false, (boolean)false, (boolean)true));
        this.p1 = PatchTest9.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{changeB, changeC}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, null);
        IRequirementChange anotherChangeC = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"C", (VersionRange)new VersionRange("[1.1.0, 1.3.0)"), null, (boolean)true, (boolean)false, (boolean)true));
        this.pp1 = PatchTest9.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{changeB, anotherChangeC}, new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"A", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false)}}, null);
        this.createTestMetdataRepository(new IInstallableUnit[]{this.a1, this.b1, this.b2, this.c1, this.p1, this.pp1});
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        this.planner = PatchTest9.createPlanner();
        this.engine = PatchTest9.createEngine();
    }

    public void testPatchDoesNotApply() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p1});
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        PatchTest9.assertEquals((int)4, (int)plan1.getStatus().getSeverity());
    }

    public void testExplanation() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.a1, this.p1});
        ProvisioningPlan plan1 = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        PatchTest9.assertEquals((int)4, (int)plan1.getStatus().getSeverity());
        RequestStatus requestStatus = ((PlannerStatus)plan1.getStatus()).getRequestStatus();
        PatchTest9.assertEquals((int)1, (int)requestStatus.getShortExplanation());
        Set conflictingRoots = requestStatus.getConflictsWithInstalledRoots();
        PatchTest9.assertEquals((int)1, (int)conflictingRoots.size());
        PatchTest9.assertTrue((boolean)conflictingRoots.contains(this.p1));
    }

    public void testPatchApply() {
        ProfileChangeRequest req2 = new ProfileChangeRequest(this.profile1);
        req2.addInstallableUnits(new IInstallableUnit[]{this.a1, this.pp1});
        IProvisioningPlan plan2 = this.planner.getProvisioningPlan((IProfileChangeRequest)req2, null, null);
        PatchTest9.assertEquals((int)0, (int)plan2.getStatus().getSeverity());
        PatchTest9.assertInstallOperand(plan2, this.a1);
        PatchTest9.assertInstallOperand(plan2, (IInstallableUnit)this.pp1);
        PatchTest9.assertInstallOperand(plan2, this.b2);
    }
}

