/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.util.Set;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerStatus;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class PatchTestUpdate
extends AbstractProvisioningTest {
    private static final String PP2 = "PatchForIUP2";
    private static final String PP1 = "PatchForIUP1";
    private static final String P2 = "P2";
    private static final String P1 = "P1";
    private static final String P2_FEATURE = "p2.feature";
    private IInstallableUnit p2Feature;
    private IInstallableUnit p2Feature20;
    private IInstallableUnit p1;
    private IInstallableUnit p2;
    private IInstallableUnitPatch pp1;
    private IInstallableUnitPatch pp2;
    private IInstallableUnit p2b;
    private IInstallableUnit p1b;
    private IProfile profile1;
    private IPlanner planner;
    private IEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.p2Feature = PatchTestUpdate.createIU(P2_FEATURE, Version.createOSGi((int)1, (int)0, (int)0), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P1, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true)});
        this.p1 = PatchTestUpdate.createIU(P1, Version.createOSGi((int)1, (int)0, (int)0), true);
        this.p2 = PatchTestUpdate.createIU(P2, Version.createOSGi((int)1, (int)0, (int)0), true);
        this.p1b = PatchTestUpdate.createIU(P1, Version.createOSGi((int)1, (int)1, (int)1), true);
        this.p2b = PatchTestUpdate.createIU(P2, Version.createOSGi((int)1, (int)1, (int)1), true);
        IRequirementChange changepp1 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P1, (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P1, (VersionRange)new VersionRange("[1.1.1, 1.1.1]"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCyclepp1 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2_FEATURE, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true);
        IRequirement[][] scopepp1 = new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2_FEATURE, (VersionRange)new VersionRange("[1.0.0,1.0.0]"), null, (boolean)false, (boolean)false)}};
        this.pp1 = PatchTestUpdate.createIUPatch(PP1, Version.create((String)"3.0.0"), true, new IRequirementChange[]{changepp1}, scopepp1, lifeCyclepp1);
        IRequirementChange changepp2 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2, (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2, (VersionRange)new VersionRange("[1.1.1, 1.1.1]"), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCyclepp2 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2_FEATURE, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true);
        IRequirement[][] scopepp2 = new IRequirement[][]{{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2_FEATURE, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false)}};
        this.pp2 = PatchTestUpdate.createIUPatch(PP2, Version.create((String)"5.0.0"), true, new IRequirementChange[]{changepp2}, scopepp2, lifeCyclepp2);
        this.p2Feature20 = PatchTestUpdate.createIU(P2_FEATURE, Version.createOSGi((int)2, (int)0, (int)0), new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P1, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)P2, (VersionRange)new VersionRange("[1.0.0, 1.0.0]"), null, (boolean)false, (boolean)false, (boolean)true)});
        this.createTestMetdataRepository(new IInstallableUnit[]{this.p2Feature, this.p1, this.p2, this.p1b, this.p2b, this.pp1, this.pp2, this.p2Feature20});
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        this.planner = PatchTestUpdate.createPlanner();
        this.engine = PatchTestUpdate.createEngine();
        if (!this.install(this.profile1, new IInstallableUnit[]{this.p2Feature, this.pp1, this.pp2}, true, this.planner, this.engine).isOK()) {
            PatchTestUpdate.fail((String)"Setup failed");
        }
        PatchTestUpdate.assertProfileContainsAll("Profile setup incorrectly", this.profile1, new IInstallableUnit[]{this.p2Feature, this.p1b, this.p2b, this.pp1, this.pp2});
    }

    public void testUpdate() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.p2Feature20});
        req1.setInstallableUnitInclusionRules(this.p2Feature20, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.p2Feature20));
        req1.removeInstallableUnits(new IInstallableUnit[]{this.p2Feature});
        IProvisioningPlan plan = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        PatchTestUpdate.assertEquals((int)4, (int)plan.getStatus().getSeverity());
    }

    public void testExplanation() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.p2Feature20});
        req1.setInstallableUnitInclusionRules(this.p2Feature20, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.p2Feature20));
        req1.removeInstallableUnits(new IInstallableUnit[]{this.p2Feature});
        ProvisioningPlan plan = (ProvisioningPlan)this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        PatchTestUpdate.assertEquals((int)4, (int)plan.getStatus().getSeverity());
        RequestStatus requestStatus = ((PlannerStatus)plan.getStatus()).getRequestStatus();
        Set conflictingRoot = requestStatus.getConflictsWithInstalledRoots();
        PatchTestUpdate.assertEquals((int)1, (int)conflictingRoot.size());
        PatchTestUpdate.assertTrue((boolean)conflictingRoot.contains(this.p2Feature20));
        PatchTestUpdate.assertEquals((int)2, (int)requestStatus.getShortExplanation());
    }
}

