/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SDKPatchingTest2
extends AbstractProvisioningTest {
    IProfile profile = null;
    ArrayList newIUs = new ArrayList();
    IInstallableUnit patchInstallingJDTLaunching = null;
    IInstallableUnit patchInstallingDebugUI = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        File reporegistry1 = SDKPatchingTest2.getTestData("test data for sdkpatching test", "testData/sdkpatchingtest");
        File tempFolder = this.getTempFolder();
        SDKPatchingTest2.copy("0.2", reporegistry1, tempFolder);
        SimpleProfileRegistry registry = new SimpleProfileRegistry(SDKPatchingTest2.getAgent(), tempFolder, null, false);
        this.profile = registry.getProfile("SDKPatchingTest");
        SDKPatchingTest2.assertNotNull((Object)this.profile);
        MetadataFactory.InstallableUnitDescription newJDTLaunching = SDKPatchingTest2.createIUDescriptor((IInstallableUnit)this.profile.query(QueryUtil.createIUQuery((String)"org.eclipse.jdt.launching"), (IProgressMonitor)new NullProgressMonitor()).iterator().next());
        Version newJDTLaunchingVersion = Version.createOSGi((int)3, (int)5, (int)0, (String)"zeNewVersion");
        SDKPatchingTest2.changeVersion(newJDTLaunching, newJDTLaunchingVersion);
        this.newIUs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)newJDTLaunching));
        IRequirementChange change = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.eclipse.jdt.launching", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.eclipse.jdt.launching", (VersionRange)new VersionRange(newJDTLaunchingVersion, true, newJDTLaunchingVersion, true), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCycle = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.eclipse.jdt.feature.group", (VersionRange)new VersionRange("[3.5.0.v20081202-0800-7p83FGDFHmHuj2mNpJBSKZe, 3.5.0.v20081202-0800-7p83FGDFHmHuj2mNpJBSKZe]"), null, (boolean)false, (boolean)false, (boolean)true);
        this.patchInstallingJDTLaunching = SDKPatchingTest2.createIUPatch("P", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change}, new IRequirement[0][0], lifeCycle);
        this.newIUs.add(this.patchInstallingJDTLaunching);
        MetadataFactory.InstallableUnitDescription newDebugUI = SDKPatchingTest2.createIUDescriptor((IInstallableUnit)this.profile.query(QueryUtil.createIUQuery((String)"org.eclipse.jdt.debug.ui"), (IProgressMonitor)new NullProgressMonitor()).iterator().next());
        Version newDebugVersion = Version.createOSGi((int)3, (int)3, (int)0, (String)"zeNewVersion");
        SDKPatchingTest2.changeVersion(newDebugUI, newDebugVersion);
        this.newIUs.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)newDebugUI));
        IRequirementChange change2 = MetadataFactory.createRequirementChange((IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.eclipse.jdt.debug.ui", (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false, (boolean)false), (IRequirement)MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.eclipse.jdt.debug.ui", (VersionRange)new VersionRange(newDebugVersion, true, newDebugVersion, true), null, (boolean)false, (boolean)false, (boolean)true));
        IRequirement lifeCycle2 = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)"org.eclipse.jdt.feature.group", (VersionRange)new VersionRange("[3.5.0.v20081202-0800-7p83FGDFHmHuj2mNpJBSKZe, 3.5.0.v20081202-0800-7p83FGDFHmHuj2mNpJBSKZe]"), null, (boolean)false, (boolean)false, (boolean)true);
        this.patchInstallingDebugUI = SDKPatchingTest2.createIUPatch("P2", Version.create((String)"1.0.0"), true, new IRequirementChange[]{change2}, new IRequirement[0][0], lifeCycle2);
        this.newIUs.add(this.patchInstallingDebugUI);
    }

    public void testInstallFeaturePatch() {
        ProvisioningContext ctx = new ProvisioningContext(SDKPatchingTest2.getAgent());
        ctx.setExtraInstallableUnits((List)this.newIUs);
        ProfileChangeRequest validationRequest = new ProfileChangeRequest(this.profile);
        IProvisioningPlan validationPlan = SDKPatchingTest2.createPlanner().getProvisioningPlan((IProfileChangeRequest)validationRequest, null, null);
        SDKPatchingTest2.assertOK("validation", validationPlan.getStatus());
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.addInstallableUnits(new IInstallableUnit[]{this.patchInstallingJDTLaunching, this.patchInstallingDebugUI});
        request.setInstallableUnitInclusionRules(this.patchInstallingJDTLaunching, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.patchInstallingJDTLaunching));
        request.setInstallableUnitInclusionRules(this.patchInstallingDebugUI, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)this.patchInstallingDebugUI));
        IPlanner planner = SDKPatchingTest2.createPlanner();
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, ctx, (IProgressMonitor)new NullProgressMonitor());
        SDKPatchingTest2.assertOK("Installation plan", plan.getStatus());
        SDKPatchingTest2.assertEquals((int)6, (int)this.countPlanElements(plan));
    }
}

