/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class TwoVersionsOfWSDL
extends AbstractProvisioningTest {
    IInstallableUnit wsdl14;
    IInstallableUnit wsdl15;
    IProfile profile1;
    IPlanner planner;
    IEngine engine;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IMetadataRepositoryManager repoMan = (IMetadataRepositoryManager)TwoVersionsOfWSDL.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        IMetadataRepository repo = repoMan.loadRepository(TwoVersionsOfWSDL.getTestData("repository for wsdl test", "testData/metadataRepo/wsdlTestRepo/").toURI(), (IProgressMonitor)new NullProgressMonitor());
        this.wsdl15 = (IInstallableUnit)repo.query(QueryUtil.createIUQuery((String)"javax.wsdl", (VersionRange)new VersionRange("[1.5, 1.6)")), null).iterator().next();
        this.wsdl14 = (IInstallableUnit)repo.query(QueryUtil.createIUQuery((String)"javax.wsdl", (VersionRange)new VersionRange("[1.4, 1.5)")), null).iterator().next();
        this.profile1 = this.createProfile("TestProfile." + this.getName());
        this.planner = TwoVersionsOfWSDL.createPlanner();
        this.engine = TwoVersionsOfWSDL.createEngine();
    }

    public void testInstallTwoVersionsOptionaly() {
        ProfileChangeRequest req1 = new ProfileChangeRequest(this.profile1);
        req1.addInstallableUnits(new IInstallableUnit[]{this.wsdl15, this.wsdl14});
        req1.setInstallableUnitInclusionRules(this.wsdl15, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.wsdl15));
        req1.setInstallableUnitInclusionRules(this.wsdl14, ProfileInclusionRules.createStrictInclusionRule((IInstallableUnit)this.wsdl14));
        IProvisioningPlan plan1 = this.planner.getProvisioningPlan((IProfileChangeRequest)req1, null, null);
        TwoVersionsOfWSDL.assertEquals((int)0, (int)plan1.getStatus().getSeverity());
        TwoVersionsOfWSDL.assertInstallOperand(plan1, this.wsdl15);
        TwoVersionsOfWSDL.assertInstallOperand(plan1, this.wsdl14);
    }
}

