/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.planner;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.metadata.query.UpdateQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class UpdateForTwoIUs
extends AbstractProvisioningTest {
    private IInstallableUnit iua;
    private Collection<IMatchExpression<IInstallableUnit>> x;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        iud.setId("A");
        iud.setVersion(Version.create((String)"1.0.0"));
        String orExpression = "providedCapabilities.exists(pc | pc.namespace == 'org.eclipse.equinox.p2.iu' && (pc.name == 'B' || pc.name == 'C'))";
        IExpression expr = ExpressionUtil.parse((String)orExpression);
        IMatchExpression matchExpression = ExpressionUtil.getFactory().matchExpression(expr, new Object[0]);
        ArrayList<IMatchExpression> updateExpression = new ArrayList<IMatchExpression>();
        updateExpression.add(matchExpression);
        iud.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor(updateExpression, (int)1, null, null));
        this.iua = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
        ius.add(this.iua);
        URI repoURI = this.getTempFolder().toURI();
        this.createMetadataRepository(repoURI, null).addInstallableUnits(ius);
        UpdateForTwoIUs.getMetadataRepositoryManager().removeRepository(repoURI);
        this.x = ((IInstallableUnit)UpdateForTwoIUs.getMetadataRepositoryManager().loadRepository(repoURI, null).query(QueryUtil.ALL_UNITS, null).iterator().next()).getUpdateDescriptor().getIUsBeingUpdated();
        UpdateForTwoIUs.assertEquals((Object)matchExpression, this.x.iterator().next());
    }

    public void testUpdateQueryForTwoIUs() {
        IQueryResult updates = new QueryableArray(new IInstallableUnit[]{this.iua}).query((IQuery)new UpdateQuery(UpdateForTwoIUs.createIU("B")), null);
        UpdateForTwoIUs.assertFalse((boolean)updates.isEmpty());
        UpdateForTwoIUs.assertEquals((Object)this.iua, updates.iterator().next());
        IQueryResult updates2 = new QueryableArray(new IInstallableUnit[]{this.iua}).query((IQuery)new UpdateQuery(UpdateForTwoIUs.createIU("C")), null);
        UpdateForTwoIUs.assertFalse((boolean)updates2.isEmpty());
        UpdateForTwoIUs.assertEquals((Object)this.iua, updates2.iterator().next());
        IQueryResult update3 = new QueryableArray(new IInstallableUnit[]{this.iua}).query((IQuery)new UpdateQuery(UpdateForTwoIUs.createIU("X")), null);
        UpdateForTwoIUs.assertTrue((boolean)update3.isEmpty());
    }
}

