/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRequest;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.osgi.util.NLS;

public class TestArtifactRepository
implements IArtifactRepository {
    private static String provider = null;
    private HashMap<IArtifactDescriptor, byte[]> repo;
    private String name;
    private String description;
    private String version = "1.0.0";
    protected Map<String, String> properties = new OrderedProperties();
    private final IProvisioningAgent agent;

    public TestArtifactRepository(IProvisioningAgent agent) {
        this.agent = agent;
        this.repo = new HashMap();
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
        if (this.contains(descriptor)) {
            String msg = NLS.bind((String)Messages.available_already_in, (Object)this.getLocation());
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.test", 1201, msg, null));
        }
        return new ArtifactOutputStream(new ByteArrayOutputStream(500), descriptor);
    }

    public void addDescriptor(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        this.addDescriptor(descriptor, new byte[0]);
    }

    @Deprecated
    public final void addDescriptor(IArtifactDescriptor descriptor) {
        this.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
    }

    public void addDescriptor(IArtifactDescriptor descriptor, byte[] bytes) {
        this.repo.put(descriptor, bytes);
    }

    public void addDescriptors(IArtifactDescriptor[] descriptors, IProgressMonitor monitor) {
        int i = 0;
        while (i < descriptors.length) {
            this.addDescriptor(descriptors[i]);
            ++i;
        }
    }

    @Deprecated
    public final void addDescriptors(IArtifactDescriptor[] descriptors) {
        this.addDescriptors(descriptors, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        return this.repo.containsKey(descriptor);
    }

    public synchronized boolean contains(IArtifactKey key) {
        for (IArtifactDescriptor descriptor : this.repo.keySet()) {
            if (!descriptor.getArtifactKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        try {
            byte[] repoContents = this.repo.get(descriptor);
            if (repoContents == null) {
                return new Status(4, "test", "no such artifact");
            }
            destination.write(repoContents);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Status(4, "test", "exception occurred", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        HashSet<IArtifactDescriptor> result = new HashSet<IArtifactDescriptor>();
        for (IArtifactDescriptor descriptor : this.repo.keySet()) {
            if (!descriptor.getArtifactKey().equals(key)) continue;
            result.add(descriptor);
        }
        return result.toArray(new IArtifactDescriptor[0]);
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)requests.length);
        try {
            MultiStatus overallStatus = new MultiStatus("org.eclipse.equinox.p2.test", 0, null, null);
            int i = 0;
            while (i < requests.length) {
                overallStatus.add(this.getArtifact((ArtifactRequest)requests[i], (IProgressMonitor)subMonitor.newChild(1)));
                ++i;
            }
            IStatus iStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : overallStatus;
            return iStatus;
        }
        finally {
            subMonitor.done();
        }
    }

    private IStatus getArtifact(ArtifactRequest artifactRequest, IProgressMonitor monitor) {
        artifactRequest.perform((IArtifactRepository)this, monitor);
        return artifactRequest.getResult();
    }

    public void removeDescriptor(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        this.repo.remove(descriptor);
    }

    @Deprecated
    public final void removeDescriptor(IArtifactDescriptor descriptor) {
        this.removeDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
    }

    public void removeDescriptor(IArtifactKey key, IProgressMonitor monitor) {
        ArrayList<IArtifactDescriptor> removeList = new ArrayList<IArtifactDescriptor>();
        for (IArtifactDescriptor descriptor : this.repo.keySet()) {
            if (!descriptor.getArtifactKey().equals(key)) continue;
            removeList.add(descriptor);
        }
        int i = 0;
        while (i < this.repo.size()) {
            this.repo.remove(removeList.get(i));
            ++i;
        }
    }

    @Deprecated
    public final void removeDescriptor(IArtifactKey key) {
        this.removeDescriptor(key, (IProgressMonitor)new NullProgressMonitor());
    }

    public void removeDescriptors(IArtifactDescriptor[] descriptors, IProgressMonitor monitor) {
        IArtifactDescriptor[] iArtifactDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
            this.removeDescriptor(descriptor);
            ++n2;
        }
    }

    @Deprecated
    public final void removeDescriptors(IArtifactDescriptor[] descriptors) {
        this.removeDescriptors(descriptors, (IProgressMonitor)new NullProgressMonitor());
    }

    public void removeDescriptors(IArtifactKey[] keys, IProgressMonitor monitor) {
        IArtifactKey[] iArtifactKeyArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactKey key = iArtifactKeyArray[n2];
            this.removeDescriptor(key);
            ++n2;
        }
    }

    @Deprecated
    public final void removeDescriptors(IArtifactKey[] keys) {
        this.removeDescriptors(keys, (IProgressMonitor)new NullProgressMonitor());
    }

    public String getDescription() {
        return this.description;
    }

    public URI getLocation() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Map getProperties() {
        return OrderedProperties.unmodifiableProperties(this.properties);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String getProvider() {
        return provider;
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.agent;
    }

    public String getType() {
        return "memoryArtifactRepo";
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isModifiable() {
        return true;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String setProperty(String key, String value, IProgressMonitor monitor) {
        return value == null ? this.properties.remove(key) : this.properties.put(key, value);
    }

    public final String setProperty(String key, String value) {
        return this.setProperty(key, value, (IProgressMonitor)new NullProgressMonitor());
    }

    public void setProvider(String value) {
        provider = value;
    }

    public void removeAll(IProgressMonitor monitor) {
        this.repo.clear();
    }

    @Deprecated
    public final void removeAll() {
        this.removeAll((IProgressMonitor)new NullProgressMonitor());
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public ZipInputStream getZipInputStream(IArtifactKey key) {
        IArtifactDescriptor[] descriptor = this.getArtifactDescriptors(key);
        if (descriptor == null || descriptor.length == 0 || descriptor[0] == null) {
            return null;
        }
        return new ZipInputStream(this.getRawInputStream(descriptor[0]));
    }

    public InputStream getRawInputStream(IArtifactDescriptor descriptor) {
        return new ByteArrayInputStream(this.repo.get(descriptor), 0, this.repo.get(descriptor).length);
    }

    public ZipInputStream getZipInputStream(IArtifactDescriptor descriptor) {
        return new ZipInputStream(this.getRawInputStream(descriptor));
    }

    public byte[] getBytes(IArtifactDescriptor artifactDescriptor) {
        return this.repo.get(artifactDescriptor);
    }

    public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        return this.getArtifact(descriptor, destination, monitor);
    }

    public IArtifactDescriptor createArtifactDescriptor(IArtifactKey key) {
        return new ArtifactDescriptor(key);
    }

    public IArtifactKey createArtifactKey(String classifier, String id, Version keyVersion) {
        return new ArtifactKey(classifier, id, keyVersion);
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return Collector.emptyCollector();
        }
        Collector collector = new Collector();
        for (IArtifactDescriptor descriptor : this.repo.keySet()) {
            collector.accept((Object)descriptor.getArtifactKey());
        }
        return collector;
    }

    public IQueryable<IArtifactDescriptor> descriptorQueryable() {
        final Set<IArtifactDescriptor> descs = this.repo.keySet();
        return new IQueryable<IArtifactDescriptor>(){

            public IQueryResult<IArtifactDescriptor> query(IQuery<IArtifactDescriptor> query, IProgressMonitor monitor) {
                return query.perform(descs.iterator());
            }
        };
    }

    public IStatus executeBatch(IRunnableWithProgress runnable, IProgressMonitor monitor) {
        try {
            runnable.run(monitor);
        }
        catch (OperationCanceledException oce) {
            return new Status(8, "org.eclipse.equinox.p2.tests.publisher", oce.getMessage(), (Throwable)oce);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.equinox.p2.tests.publisher", e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public class ArtifactOutputStream
    extends OutputStream
    implements IStateful {
        private boolean closed;
        private long count = 0L;
        private IArtifactDescriptor descriptor;
        private OutputStream destination;
        private IStatus status = Status.OK_STATUS;
        private OutputStream firstLink;

        public ArtifactOutputStream(OutputStream os, IArtifactDescriptor descriptor) {
            this.destination = os;
            this.descriptor = descriptor;
        }

        @Override
        public void close() throws IOException {
            OutputStream testStream;
            if (this.closed) {
                return;
            }
            try {
                this.destination.close();
                this.closed = true;
            }
            catch (IOException e) {
                if (this.getStatus().isOK()) {
                    throw e;
                }
                return;
            }
            OutputStream outputStream = testStream = this.firstLink == null ? this : this.firstLink;
            if (ProcessingStepHandler.checkStatus((OutputStream)testStream).isOK() && this.count > 0L) {
                ((ArtifactDescriptor)this.descriptor).setProperty("download.size", Long.toString(this.count));
                TestArtifactRepository.this.addDescriptor(this.descriptor, ((ByteArrayOutputStream)this.destination).toByteArray());
            }
        }

        public IStatus getStatus() {
            return this.status;
        }

        public OutputStream getDestination() {
            return this.destination;
        }

        public void setStatus(IStatus status) {
            this.status = status == null ? Status.OK_STATUS : status;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.destination.write(b);
            this.count += (long)b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.destination.write(b, off, len);
            this.count += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            this.destination.write(b);
            ++this.count;
        }

        public void setFirstLink(OutputStream value) {
            this.firstLink = value;
        }
    }
}

