/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AdviceFileParser;
import org.eclipse.equinox.p2.query.QueryUtil;

public class AdviceFileParserTest
extends TestCase {
    public void testNoAdvice() {
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, Collections.EMPTY_MAP);
        parser.parse();
        AdviceFileParserTest.assertNull((Object)parser.getAdditionalInstallableUnitDescriptions());
        AdviceFileParserTest.assertNull((Object)parser.getProperties());
        AdviceFileParserTest.assertNull((Object)parser.getProvidedCapabilities());
        AdviceFileParserTest.assertNull((Object)parser.getRequiredCapabilities());
        AdviceFileParserTest.assertNull((Object)parser.getTouchpointInstructions());
    }

    public void testAdviceVersion() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("advice.version", "1.0");
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        map.put("advice.version", "999");
        parser = new AdviceFileParser("id", Version.emptyVersion, map);
        try {
            parser.parse();
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
        AdviceFileParserTest.fail((String)"expected version parse problem");
    }

    public void testUpdateDescriptorAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("update.id", "testName");
        map.put("update.severity", "10");
        map.put("update.description", "Test Description");
        map.put("update.range", "(1.0.0,10.10.10)");
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        IUpdateDescriptor updateDescriptor = parser.getUpdateDescriptor();
        String testName = RequiredCapability.extractName((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        VersionRange testVersionRange = RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        AdviceFileParserTest.assertEquals((String)"testName", (String)testName);
        AdviceFileParserTest.assertEquals((Object)Version.parseVersion((String)"1.0.0"), (Object)testVersionRange.getMinimum());
        AdviceFileParserTest.assertEquals((Object)Version.parseVersion((String)"10.10.10"), (Object)testVersionRange.getMaximum());
        AdviceFileParserTest.assertEquals((int)10, (int)updateDescriptor.getSeverity());
        AdviceFileParserTest.assertEquals((String)"Test Description", (String)updateDescriptor.getDescription());
    }

    public void testUpdateDescriptorAdviceDefaultBound() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("update.id", "testName");
        map.put("update.severity", "10");
        map.put("update.description", "Test Description");
        map.put("update.range", "(1.0.0,$version$)");
        AdviceFileParser parser = new AdviceFileParser("id", Version.parseVersion((String)"9.10.11"), map);
        parser.parse();
        IUpdateDescriptor updateDescriptor = parser.getUpdateDescriptor();
        String testName = RequiredCapability.extractName((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        VersionRange testVersionRange = RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        AdviceFileParserTest.assertEquals((String)"testName", (String)testName);
        AdviceFileParserTest.assertEquals((Object)Version.parseVersion((String)"1.0.0"), (Object)testVersionRange.getMinimum());
        AdviceFileParserTest.assertEquals((Object)Version.parseVersion((String)"9.10.11"), (Object)testVersionRange.getMaximum());
        AdviceFileParserTest.assertEquals((int)10, (int)updateDescriptor.getSeverity());
        AdviceFileParserTest.assertEquals((String)"Test Description", (String)updateDescriptor.getDescription());
    }

    public void testUpdateDescriptorWithMatch() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("update.matchExp", "providedCapabilities.exists(pc | pc.namespace == 'org.eclipse.equinox.p2.iu' && (pc.name == 'B' || pc.name == 'C'))");
        map.put("update.severity", "10");
        map.put("update.description", "Test Description");
        AdviceFileParser parser = new AdviceFileParser("id", Version.parseVersion((String)"9.10.11"), map);
        parser.parse();
        IUpdateDescriptor updateDescriptor = parser.getUpdateDescriptor();
        AdviceFileParserTest.assertEquals((String)"Test Description", (String)updateDescriptor.getDescription());
        AdviceFileParserTest.assertEquals((int)10, (int)updateDescriptor.getSeverity());
        boolean exceptionRaised = false;
        try {
            RequiredCapability.extractName((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exceptionRaised = true;
        }
        AdviceFileParserTest.assertTrue((boolean)exceptionRaised);
    }

    public void testUpdateDescriptorAdviceDefaultBound2() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("update.id", "testName");
        map.put("update.severity", "10");
        map.put("update.description", "Test Description");
        AdviceFileParser parser = new AdviceFileParser("id", Version.parseVersion((String)"9.10.11"), map);
        parser.parse();
        IUpdateDescriptor updateDescriptor = parser.getUpdateDescriptor();
        String testName = RequiredCapability.extractName((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        VersionRange testVersionRange = RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        AdviceFileParserTest.assertEquals((String)"testName", (String)testName);
        AdviceFileParserTest.assertEquals((Object)Version.parseVersion((String)"0.0.0"), (Object)testVersionRange.getMinimum());
        AdviceFileParserTest.assertEquals((Object)Version.parseVersion((String)"9.10.11"), (Object)testVersionRange.getMaximum());
        AdviceFileParserTest.assertEquals((int)10, (int)updateDescriptor.getSeverity());
        AdviceFileParserTest.assertEquals((String)"Test Description", (String)updateDescriptor.getDescription());
    }

    public void testUpdateDescriptorAdviceDefaultID() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("update.severity", "10");
        map.put("update.description", "Test Description");
        AdviceFileParser parser = new AdviceFileParser("id", Version.parseVersion((String)"9.10.11"), map);
        parser.parse();
        IUpdateDescriptor updateDescriptor = parser.getUpdateDescriptor();
        String testName = RequiredCapability.extractName((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        VersionRange testVersionRange = RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        AdviceFileParserTest.assertEquals((String)"id", (String)testName);
        AdviceFileParserTest.assertEquals((Object)Version.parseVersion((String)"0.0.0"), (Object)testVersionRange.getMinimum());
        AdviceFileParserTest.assertEquals((Object)Version.parseVersion((String)"9.10.11"), (Object)testVersionRange.getMaximum());
        AdviceFileParserTest.assertEquals((int)10, (int)updateDescriptor.getSeverity());
        AdviceFileParserTest.assertEquals((String)"Test Description", (String)updateDescriptor.getDescription());
    }

    public void testUpdateDescriptorAdviceDefaults() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("update.id", "id");
        AdviceFileParser parser = new AdviceFileParser("id", Version.parseVersion((String)"9.10.11"), map);
        parser.parse();
        IUpdateDescriptor updateDescriptor = parser.getUpdateDescriptor();
        String testName = RequiredCapability.extractName((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        VersionRange testVersionRange = RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)updateDescriptor.getIUsBeingUpdated().iterator().next()));
        AdviceFileParserTest.assertEquals((String)"id", (String)testName);
        AdviceFileParserTest.assertEquals((Object)Version.parseVersion((String)"0.0.0"), (Object)testVersionRange.getMinimum());
        AdviceFileParserTest.assertEquals((Object)Version.parseVersion((String)"9.10.11"), (Object)testVersionRange.getMaximum());
        AdviceFileParserTest.assertEquals((int)0, (int)updateDescriptor.getSeverity());
        AdviceFileParserTest.assertEquals(null, (String)updateDescriptor.getDescription());
    }

    public void testPropertyAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("properties.0.name", "testName1");
        map.put("properties.0.value", "testValue1");
        map.put("properties.1.name", "testName2");
        map.put("properties.1.value", "testValue2");
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        AdviceFileParserTest.assertEquals((String)"testValue1", (String)((String)parser.getProperties().get("testName1")));
        AdviceFileParserTest.assertEquals((String)"testValue2", (String)((String)parser.getProperties().get("testName2")));
    }

    public void testProvidesAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("provides.0.namespace", "testNamespace1");
        map.put("provides.0.name", "testName1");
        map.put("provides.0.version", "1.2.3.$qualifier$");
        AdviceFileParser parser = new AdviceFileParser("id", Version.create((String)"1.0.0.v20090909"), map);
        parser.parse();
        IProvidedCapability[] capabilities = parser.getProvidedCapabilities();
        AdviceFileParserTest.assertEquals((int)1, (int)capabilities.length);
        AdviceFileParserTest.assertEquals((String)"testNamespace1", (String)capabilities[0].getNamespace());
        AdviceFileParserTest.assertEquals((String)"testName1", (String)capabilities[0].getName());
        AdviceFileParserTest.assertEquals((Object)Version.create((String)"1.2.3.v20090909"), (Object)capabilities[0].getVersion());
        map.put("provides.1.namespace", "testNamespace2");
        map.put("provides.1.name", "testName2");
        map.put("provides.1.version", "$version$");
        parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        capabilities = parser.getProvidedCapabilities();
        AdviceFileParserTest.assertEquals((int)2, (int)capabilities.length);
        AdviceFileParserTest.assertEquals((String)"testNamespace1", (String)capabilities[0].getNamespace());
        AdviceFileParserTest.assertEquals((String)"testName1", (String)capabilities[0].getName());
        AdviceFileParserTest.assertEquals((Object)Version.create((String)"1.2.3"), (Object)capabilities[0].getVersion());
        AdviceFileParserTest.assertEquals((String)"testNamespace2", (String)capabilities[1].getNamespace());
        AdviceFileParserTest.assertEquals((String)"testName2", (String)capabilities[1].getName());
        AdviceFileParserTest.assertEquals((Object)Version.emptyVersion, (Object)capabilities[1].getVersion());
    }

    public void testRequiresAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("requires.0.namespace", "testNamespace1");
        map.put("requires.0.name", "testName1");
        map.put("requires.0.range", "[1.2.3.$qualifier$, 2)");
        map.put("requires.0.greedy", Boolean.TRUE.toString());
        map.put("requires.0.optional", Boolean.TRUE.toString());
        map.put("requires.0.multiple", Boolean.TRUE.toString());
        AdviceFileParser parser = new AdviceFileParser("id", Version.create((String)"1.0.0.v20090909"), map);
        parser.parse();
        IRequirement[] reqs = parser.getRequiredCapabilities();
        AdviceFileParserTest.assertEquals((int)1, (int)reqs.length);
        AdviceFileParserTest.assertEquals((String)"testNamespace1", (String)RequiredCapability.extractNamespace((IMatchExpression)reqs[0].getMatches()));
        AdviceFileParserTest.assertEquals((String)"testName1", (String)RequiredCapability.extractName((IMatchExpression)reqs[0].getMatches()));
        AdviceFileParserTest.assertEquals((Object)new VersionRange("[1.2.3.v20090909, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)reqs[0].getMatches()));
        map.put("requires.1.namespace", "testNamespace2");
        map.put("requires.1.name", "testName2");
        map.put("requires.1.range", "$version$");
        map.put("requires.1.greedy", Boolean.FALSE.toString());
        map.put("requires.1.optional", Boolean.FALSE.toString());
        parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        reqs = parser.getRequiredCapabilities();
        AdviceFileParserTest.assertEquals((int)2, (int)reqs.length);
        AdviceFileParserTest.assertEquals((String)"testNamespace1", (String)RequiredCapability.extractNamespace((IMatchExpression)reqs[0].getMatches()));
        AdviceFileParserTest.assertEquals((String)"testName1", (String)RequiredCapability.extractName((IMatchExpression)reqs[0].getMatches()));
        AdviceFileParserTest.assertEquals((Object)new VersionRange("[1.2.3, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)reqs[0].getMatches()));
        AdviceFileParserTest.assertEquals((boolean)true, (boolean)reqs[0].isGreedy());
        AdviceFileParserTest.assertEquals((int)0, (int)reqs[0].getMin());
        AdviceFileParserTest.assertEquals((String)"testNamespace2", (String)RequiredCapability.extractNamespace((IMatchExpression)reqs[1].getMatches()));
        AdviceFileParserTest.assertEquals((String)"testName2", (String)RequiredCapability.extractName((IMatchExpression)reqs[1].getMatches()));
        AdviceFileParserTest.assertEquals((Object)new VersionRange(Version.emptyVersion.toString()), (Object)RequiredCapability.extractRange((IMatchExpression)reqs[1].getMatches()));
        AdviceFileParserTest.assertEquals((boolean)false, (boolean)reqs[1].isGreedy());
        AdviceFileParserTest.assertEquals((int)1, (int)reqs[1].getMin());
    }

    public void testRequireWithExpression() {
        HashMap<String, String> map = new HashMap<String, String>();
        String matchExp = "properties[abc] == 'def'";
        map.put("requires.0.matchExp", matchExp);
        map.put("requires.0.greedy", Boolean.TRUE.toString());
        map.put("requires.0.min", "1");
        map.put("requires.0.max", "1");
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        IRequirement[] reqs = parser.getRequiredCapabilities();
        reqs = parser.getRequiredCapabilities();
        AdviceFileParserTest.assertEquals((int)1, (int)reqs.length);
        IMatchExpression matchExpression = ExpressionUtil.getFactory().matchExpression(ExpressionUtil.parse((String)matchExp), new Object[0]);
        AdviceFileParserTest.assertEquals((Object)matchExpression, (Object)reqs[0].getMatches());
    }

    public void testRequireWithExpressionAndOptional() {
        HashMap<String, String> map = new HashMap<String, String>();
        String matchExp = "properties[abc] == 'def'";
        map.put("requires.0.matchExp", matchExp);
        map.put("requires.0.greedy", Boolean.TRUE.toString());
        map.put("requires.0.optional", Boolean.TRUE.toString());
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        IRequirement[] reqs = parser.getRequiredCapabilities();
        reqs = parser.getRequiredCapabilities();
        AdviceFileParserTest.assertEquals((int)1, (int)reqs.length);
        IMatchExpression matchExpression = ExpressionUtil.getFactory().matchExpression(ExpressionUtil.parse((String)matchExp), new Object[0]);
        AdviceFileParserTest.assertEquals((Object)matchExpression, (Object)reqs[0].getMatches());
        AdviceFileParserTest.assertEquals((int)0, (int)reqs[0].getMin());
        AdviceFileParserTest.assertEquals((int)1, (int)reqs[0].getMax());
    }

    public void testMetaRequiresAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("metaRequirements.0.namespace", "testNamespace1");
        map.put("metaRequirements.0.name", "testName1");
        map.put("metaRequirements.0.range", "[1.2.3.$qualifier$, 2)");
        map.put("metaRequirements.0.greedy", Boolean.TRUE.toString());
        map.put("metaRequirements.0.optional", Boolean.TRUE.toString());
        map.put("metaRequirements.0.multiple", Boolean.TRUE.toString());
        AdviceFileParser parser = new AdviceFileParser("id", Version.create((String)"1.0.0.v20090909"), map);
        parser.parse();
        IRequirement[] reqs = parser.getMetaRequiredCapabilities();
        AdviceFileParserTest.assertEquals((int)1, (int)reqs.length);
        AdviceFileParserTest.assertEquals((String)"testNamespace1", (String)RequiredCapability.extractNamespace((IMatchExpression)reqs[0].getMatches()));
        AdviceFileParserTest.assertEquals((String)"testName1", (String)RequiredCapability.extractName((IMatchExpression)reqs[0].getMatches()));
        AdviceFileParserTest.assertEquals((Object)new VersionRange("[1.2.3.v20090909, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)reqs[0].getMatches()));
        map.put("metaRequirements.1.namespace", "testNamespace2");
        map.put("metaRequirements.1.name", "testName2");
        map.put("metaRequirements.1.range", "$version$");
        map.put("metaRequirements.1.greedy", Boolean.FALSE.toString());
        map.put("metaRequirements.1.optional", Boolean.FALSE.toString());
        parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        reqs = parser.getMetaRequiredCapabilities();
        AdviceFileParserTest.assertEquals((int)2, (int)reqs.length);
        AdviceFileParserTest.assertEquals((String)"testNamespace1", (String)RequiredCapability.extractNamespace((IMatchExpression)reqs[0].getMatches()));
        AdviceFileParserTest.assertEquals((String)"testName1", (String)RequiredCapability.extractName((IMatchExpression)reqs[0].getMatches()));
        AdviceFileParserTest.assertEquals((Object)new VersionRange("[1.2.3, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)reqs[0].getMatches()));
        AdviceFileParserTest.assertEquals((boolean)true, (boolean)reqs[0].isGreedy());
        AdviceFileParserTest.assertEquals((int)0, (int)reqs[0].getMin());
        AdviceFileParserTest.assertEquals((String)"testNamespace2", (String)RequiredCapability.extractNamespace((IMatchExpression)reqs[1].getMatches()));
        AdviceFileParserTest.assertEquals((String)"testName2", (String)RequiredCapability.extractName((IMatchExpression)reqs[1].getMatches()));
        AdviceFileParserTest.assertEquals((Object)new VersionRange(Version.emptyVersion.toString()), (Object)RequiredCapability.extractRange((IMatchExpression)reqs[1].getMatches()));
        AdviceFileParserTest.assertEquals((boolean)false, (boolean)reqs[1].isGreedy());
        AdviceFileParserTest.assertEquals((int)1, (int)reqs[1].getMin());
    }

    public void testInstructionsAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("instructions.configure", "addProgramArg(programArg:-startup); addProgramArg(programArg:@artifact);");
        map.put("instructions.unconfigure", "removeProgramArg(programArg:-startup); removeProgramArg(programArg:@artifact);)");
        map.put("instructions.unconfigure.import", "some.removeProgramArg");
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        ITouchpointInstruction configure = (ITouchpointInstruction)parser.getTouchpointInstructions().get("configure");
        AdviceFileParserTest.assertEquals(null, (String)configure.getImportAttribute());
        AdviceFileParserTest.assertEquals((String)"addProgramArg(programArg:-startup); addProgramArg(programArg:@artifact);", (String)configure.getBody());
        ITouchpointInstruction unconfigure = (ITouchpointInstruction)parser.getTouchpointInstructions().get("unconfigure");
        AdviceFileParserTest.assertEquals((String)"some.removeProgramArg", (String)unconfigure.getImportAttribute());
        AdviceFileParserTest.assertEquals((String)"removeProgramArg(programArg:-startup); removeProgramArg(programArg:@artifact);)", (String)unconfigure.getBody());
    }

    public void testAdditionalInstallableUnitDescriptionsAdvice() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("units.0.id", "testid0");
        map.put("units.0.version", "1.2.3");
        map.put("units.1.id", "testid1");
        map.put("units.1.version", "1.2.4");
        map.put("units.1.singleton", "true");
        map.put("units.1.copyright", "testCopyright");
        map.put("units.1.copyright.location", "http://localhost/test");
        map.put("units.1.filter", "(test=testFilter)");
        map.put("units.1.touchpoint.id", "testTouchpointId");
        map.put("units.1.touchpoint.version", "1.2.5");
        map.put("units.1.update.id", "testid1");
        map.put("units.1.update.range", "(1,2)");
        map.put("units.1.update.severity", "2");
        map.put("units.1.update.description", "some description");
        map.put("units.1.artifacts.0.id", "testArtifact1");
        map.put("units.1.artifacts.0.version", "1.2.6");
        map.put("units.1.artifacts.0.classifier", "testClassifier1");
        map.put("units.1.artifacts.1.id", "testArtifact2");
        map.put("units.1.artifacts.1.version", "1.2.7");
        map.put("units.1.artifacts.1.classifier", "testClassifier2");
        map.put("units.1.licenses.0", "testLicense");
        map.put("units.1.licenses.0.location", "http://localhost/license");
        map.put("units.1.properties.0.name", "testName1");
        map.put("units.1.properties.0.value", "testValue1");
        map.put("units.1.properties.1.name", "testName2");
        map.put("units.1.properties.1.value", "testValue2");
        map.put("units.1.requires.0.namespace", "testNamespace1");
        map.put("units.1.requires.0.name", "testName1");
        map.put("units.1.requires.0.range", "[1.2.3.$qualifier$, 2)");
        map.put("units.1.requires.0.greedy", Boolean.TRUE.toString());
        map.put("units.1.requires.0.optional", Boolean.TRUE.toString());
        map.put("units.1.requires.0.multiple", Boolean.TRUE.toString());
        map.put("units.1.requires.1.namespace", "testNamespace2");
        map.put("units.1.requires.1.name", "testName2");
        map.put("units.1.requires.1.range", "$version$");
        map.put("units.1.requires.1.greedy", Boolean.FALSE.toString());
        map.put("units.1.requires.1.optional", Boolean.FALSE.toString());
        map.put("units.1.metaRequirements.0.namespace", "testNamespace1");
        map.put("units.1.metaRequirements.0.name", "testName1");
        map.put("units.1.metaRequirements.0.range", "[1.2.3.$qualifier$, 2)");
        map.put("units.1.metaRequirements.0.greedy", Boolean.TRUE.toString());
        map.put("units.1.metaRequirements.0.optional", Boolean.TRUE.toString());
        map.put("units.1.metaRequirements.0.multiple", Boolean.TRUE.toString());
        map.put("units.1.metaRequirements.1.namespace", "testNamespace2");
        map.put("units.1.metaRequirements.1.name", "testName2");
        map.put("units.1.metaRequirements.1.range", "$version$");
        map.put("units.1.metaRequirements.1.greedy", Boolean.FALSE.toString());
        map.put("units.1.metaRequirements.1.optional", Boolean.FALSE.toString());
        map.put("units.1.provides.0.namespace", "testNamespace1");
        map.put("units.1.provides.0.name", "testName1");
        map.put("units.1.provides.0.version", "1.2.3.$qualifier$");
        map.put("units.1.provides.1.namespace", "testNamespace2");
        map.put("units.1.provides.1.name", "testName2");
        map.put("units.1.provides.1.version", "$version$");
        map.put("units.1.instructions.configure", "addProgramArg(programArg:-startup); addProgramArg(programArg:@artifact);");
        map.put("units.1.instructions.unconfigure", "removeProgramArg(programArg:-startup); removeProgramArg(programArg:@artifact);)");
        map.put("units.1.instructions.unconfigure.import", "some.removeProgramArg");
        map.put("units.1.hostRequirements.0.namespace", "testNamespace1");
        map.put("units.1.hostRequirements.0.name", "testName1");
        map.put("units.1.hostRequirements.0.range", "[1.2.3.$qualifier$, 2)");
        map.put("units.1.hostRequirements.0.greedy", Boolean.TRUE.toString());
        map.put("units.1.hostRequirements.0.optional", Boolean.TRUE.toString());
        map.put("units.1.hostRequirements.0.multiple", Boolean.TRUE.toString());
        map.put("units.1.hostRequirements.1.namespace", "testNamespace2");
        map.put("units.1.hostRequirements.1.name", "testName2");
        map.put("units.1.hostRequirements.1.range", "$version$");
        map.put("units.1.hostRequirements.1.greedy", Boolean.FALSE.toString());
        map.put("units.1.hostRequirements.1.optional", Boolean.FALSE.toString());
        AdviceFileParser parser = new AdviceFileParser("id", Version.emptyVersion, map);
        parser.parse();
        MetadataFactory.InstallableUnitDescription[] descriptions = parser.getAdditionalInstallableUnitDescriptions();
        IInstallableUnit iu0 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptions[0]);
        AdviceFileParserTest.assertEquals((String)"testid0", (String)iu0.getId());
        AdviceFileParserTest.assertEquals((Object)Version.create((String)"1.2.3"), (Object)iu0.getVersion());
        AdviceFileParserTest.assertFalse((boolean)iu0.isSingleton());
        AdviceFileParserTest.assertFalse((boolean)QueryUtil.isFragment((IInstallableUnit)iu0));
        AdviceFileParserTest.assertEquals((int)0, (int)iu0.getArtifacts().size());
        AdviceFileParserTest.assertEquals(null, (Object)iu0.getCopyright());
        AdviceFileParserTest.assertEquals(null, (Object)iu0.getFilter());
        AdviceFileParserTest.assertEquals((int)0, (int)iu0.getLicenses().size());
        AdviceFileParserTest.assertEquals((int)0, (int)iu0.getProperties().size());
        AdviceFileParserTest.assertEquals((int)0, (int)iu0.getRequirements().size());
        AdviceFileParserTest.assertEquals((int)0, (int)iu0.getProvidedCapabilities().size());
        AdviceFileParserTest.assertEquals((int)0, (int)iu0.getMetaRequirements().size());
        AdviceFileParserTest.assertEquals((int)0, (int)iu0.getTouchpointData().size());
        AdviceFileParserTest.assertEquals((Object)ITouchpointType.NONE, (Object)iu0.getTouchpointType());
        AdviceFileParserTest.assertEquals(null, (Object)iu0.getUpdateDescriptor());
        IInstallableUnit iu1 = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptions[1]);
        AdviceFileParserTest.assertEquals((String)"testid1", (String)iu1.getId());
        AdviceFileParserTest.assertEquals((Object)Version.create((String)"1.2.4"), (Object)iu1.getVersion());
        AdviceFileParserTest.assertTrue((boolean)iu1.isSingleton());
        AdviceFileParserTest.assertEquals((int)2, (int)iu1.getArtifacts().size());
        Iterator it = iu1.getArtifacts().iterator();
        IArtifactKey key0 = (IArtifactKey)it.next();
        IArtifactKey key1 = (IArtifactKey)it.next();
        AdviceFileParserTest.assertEquals((String)"testArtifact1", (String)key0.getId());
        AdviceFileParserTest.assertEquals((Object)Version.create((String)"1.2.6"), (Object)key0.getVersion());
        AdviceFileParserTest.assertEquals((String)"testClassifier1", (String)key0.getClassifier());
        AdviceFileParserTest.assertEquals((String)"testArtifact2", (String)key1.getId());
        AdviceFileParserTest.assertEquals((Object)Version.create((String)"1.2.7"), (Object)key1.getVersion());
        AdviceFileParserTest.assertEquals((String)"testClassifier2", (String)key1.getClassifier());
        AdviceFileParserTest.assertEquals((String)"testCopyright", (String)iu1.getCopyright().getBody());
        AdviceFileParserTest.assertEquals((String)"http://localhost/test", (String)iu1.getCopyright().getLocation().toString());
        AdviceFileParserTest.assertEquals((Object)InstallableUnit.parseFilter((String)"(test=testFilter)"), (Object)iu1.getFilter());
        AdviceFileParserTest.assertEquals((String)"testLicense", (String)((ILicense)iu1.getLicenses().iterator().next()).getBody());
        AdviceFileParserTest.assertEquals((String)"http://localhost/license", (String)((ILicense)iu1.getLicenses().iterator().next()).getLocation().toString());
        AdviceFileParserTest.assertEquals((String)"testValue1", (String)iu1.getProperty("testName1"));
        AdviceFileParserTest.assertEquals((String)"testValue2", (String)iu1.getProperty("testName2"));
        Collection reqs = iu1.getRequirements();
        Iterator it2 = reqs.iterator();
        IRequirement req0 = (IRequirement)it2.next();
        IRequirement req1 = (IRequirement)it2.next();
        AdviceFileParserTest.assertEquals((int)2, (int)reqs.size());
        AdviceFileParserTest.assertEquals((String)"testNamespace1", (String)RequiredCapability.extractNamespace((IMatchExpression)req0.getMatches()));
        AdviceFileParserTest.assertEquals((String)"testName1", (String)RequiredCapability.extractName((IMatchExpression)req0.getMatches()));
        AdviceFileParserTest.assertEquals((Object)new VersionRange("[1.2.3, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)req0.getMatches()));
        AdviceFileParserTest.assertEquals((boolean)true, (boolean)req0.isGreedy());
        AdviceFileParserTest.assertEquals((int)0, (int)req0.getMin());
        AdviceFileParserTest.assertEquals((String)"testNamespace2", (String)RequiredCapability.extractNamespace((IMatchExpression)req1.getMatches()));
        AdviceFileParserTest.assertEquals((String)"testName2", (String)RequiredCapability.extractName((IMatchExpression)req1.getMatches()));
        AdviceFileParserTest.assertEquals((Object)new VersionRange(Version.emptyVersion.toString()), (Object)RequiredCapability.extractRange((IMatchExpression)req1.getMatches()));
        AdviceFileParserTest.assertEquals((boolean)false, (boolean)req1.isGreedy());
        AdviceFileParserTest.assertEquals((int)1, (int)req1.getMin());
        Collection provided = iu1.getProvidedCapabilities();
        Iterator it4 = provided.iterator();
        IProvidedCapability cap1 = (IProvidedCapability)it4.next();
        IProvidedCapability cap2 = (IProvidedCapability)it4.next();
        AdviceFileParserTest.assertEquals((int)2, (int)provided.size());
        AdviceFileParserTest.assertEquals((String)"testNamespace1", (String)cap1.getNamespace());
        AdviceFileParserTest.assertEquals((String)"testName1", (String)cap1.getName());
        AdviceFileParserTest.assertEquals((Object)Version.create((String)"1.2.3"), (Object)cap1.getVersion());
        AdviceFileParserTest.assertEquals((String)"testNamespace2", (String)cap2.getNamespace());
        AdviceFileParserTest.assertEquals((String)"testName2", (String)cap2.getName());
        AdviceFileParserTest.assertEquals((Object)Version.emptyVersion, (Object)cap2.getVersion());
        Collection metarequirements = iu1.getMetaRequirements();
        AdviceFileParserTest.assertEquals((int)2, (int)metarequirements.size());
        Iterator it3 = metarequirements.iterator();
        IRequirement metaReq0 = (IRequirement)it3.next();
        IRequirement metaReq1 = (IRequirement)it3.next();
        AdviceFileParserTest.assertEquals((String)"testNamespace1", (String)RequiredCapability.extractNamespace((IMatchExpression)metaReq0.getMatches()));
        AdviceFileParserTest.assertEquals((String)"testName1", (String)RequiredCapability.extractName((IMatchExpression)metaReq0.getMatches()));
        AdviceFileParserTest.assertEquals((Object)new VersionRange("[1.2.3, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)metaReq0.getMatches()));
        AdviceFileParserTest.assertEquals((boolean)true, (boolean)metaReq0.isGreedy());
        AdviceFileParserTest.assertEquals((int)0, (int)metaReq0.getMin());
        AdviceFileParserTest.assertEquals((String)"testNamespace2", (String)RequiredCapability.extractNamespace((IMatchExpression)metaReq1.getMatches()));
        AdviceFileParserTest.assertEquals((String)"testName2", (String)RequiredCapability.extractName((IMatchExpression)metaReq1.getMatches()));
        AdviceFileParserTest.assertEquals((Object)new VersionRange(Version.emptyVersion.toString()), (Object)RequiredCapability.extractRange((IMatchExpression)metaReq1.getMatches()));
        AdviceFileParserTest.assertEquals((boolean)false, (boolean)metaReq1.isGreedy());
        AdviceFileParserTest.assertEquals((int)1, (int)metaReq1.getMin());
        AdviceFileParserTest.assertEquals((int)1, (int)iu1.getTouchpointData().size());
        ITouchpointInstruction configure = ((ITouchpointData)iu1.getTouchpointData().iterator().next()).getInstruction("configure");
        AdviceFileParserTest.assertEquals(null, (String)configure.getImportAttribute());
        AdviceFileParserTest.assertEquals((String)"addProgramArg(programArg:-startup); addProgramArg(programArg:@artifact);", (String)configure.getBody());
        ITouchpointInstruction unconfigure = ((ITouchpointData)iu1.getTouchpointData().iterator().next()).getInstruction("unconfigure");
        AdviceFileParserTest.assertEquals((String)"some.removeProgramArg", (String)unconfigure.getImportAttribute());
        AdviceFileParserTest.assertEquals((String)"removeProgramArg(programArg:-startup); removeProgramArg(programArg:@artifact);)", (String)unconfigure.getBody());
        AdviceFileParserTest.assertEquals((Object)MetadataFactory.createTouchpointType((String)"testTouchpointId", (Version)Version.create((String)"1.2.5")), (Object)iu1.getTouchpointType());
        AdviceFileParserTest.assertEquals((String)"testid1", (String)RequiredCapability.extractName((IMatchExpression)((IMatchExpression)iu1.getUpdateDescriptor().getIUsBeingUpdated().iterator().next())));
        AdviceFileParserTest.assertEquals((Object)new VersionRange("(1,2)"), (Object)RequiredCapability.extractRange((IMatchExpression)((IMatchExpression)iu1.getUpdateDescriptor().getIUsBeingUpdated().iterator().next())));
        AdviceFileParserTest.assertEquals((int)2, (int)iu1.getUpdateDescriptor().getSeverity());
        AdviceFileParserTest.assertEquals((String)"some description", (String)iu1.getUpdateDescriptor().getDescription());
        AdviceFileParserTest.assertTrue((boolean)QueryUtil.isFragment((IInstallableUnit)iu1));
        Collection hostRequired = ((IInstallableUnitFragment)iu1).getHost();
        AdviceFileParserTest.assertEquals((int)2, (int)hostRequired.size());
        Iterator iterator = hostRequired.iterator();
        IRequirement requirement = (IRequirement)iterator.next();
        AdviceFileParserTest.assertEquals((String)"testNamespace1", (String)RequiredCapability.extractNamespace((IMatchExpression)requirement.getMatches()));
        AdviceFileParserTest.assertEquals((String)"testName1", (String)RequiredCapability.extractName((IMatchExpression)requirement.getMatches()));
        AdviceFileParserTest.assertEquals((Object)new VersionRange("[1.2.3, 2)"), (Object)RequiredCapability.extractRange((IMatchExpression)requirement.getMatches()));
        AdviceFileParserTest.assertEquals((boolean)true, (boolean)requirement.isGreedy());
        AdviceFileParserTest.assertEquals((int)0, (int)requirement.getMin());
        IRequirement secondRequirement = (IRequirement)iterator.next();
        AdviceFileParserTest.assertEquals((String)"testNamespace2", (String)RequiredCapability.extractNamespace((IMatchExpression)secondRequirement.getMatches()));
        AdviceFileParserTest.assertEquals((String)"testName2", (String)RequiredCapability.extractName((IMatchExpression)secondRequirement.getMatches()));
        AdviceFileParserTest.assertEquals((Object)new VersionRange(Version.emptyVersion.toString()), (Object)RequiredCapability.extractRange((IMatchExpression)secondRequirement.getMatches()));
        AdviceFileParserTest.assertEquals((boolean)false, (boolean)secondRequirement.isGreedy());
        AdviceFileParserTest.assertEquals((int)1, (int)secondRequirement.getMin());
    }
}

