/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.easymock.EasyMock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.IVersionAdvice;
import org.eclipse.equinox.p2.publisher.actions.VersionAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.EquinoxLauncherCUAction;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;

public class EquinoxLauncherCUActionTest
extends ActionTest {
    private static String a_ID = "iua.source";
    private static String b_ID = "iub";
    private static String c_ID = "org.eclipse.equinox.launcher";
    private static String d_ID = "org.eclipse.equinox.launcher.source";

    @Override
    public void setUp() throws Exception {
        this.setupPublisherInfo();
        this.setupPublisherResult();
        this.testAction = new EquinoxLauncherCUAction(this.flavorArg, new String[]{this.configSpec});
    }

    public void testEquinoxLauncherCUAction() throws Exception {
        this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        this.verifyResults();
        this.debug("Completed EquinoxLauncherCUAction test.");
    }

    protected IInstallableUnit mockIU(String id, Version version, boolean fragment) {
        IInstallableUnit result = (IInstallableUnit)EasyMock.createMock(IInstallableUnit.class);
        EasyMock.expect((Object)result.getId()).andReturn((Object)id).anyTimes();
        if (version == null) {
            version = Version.emptyVersion;
        }
        EasyMock.expect((Object)result.getVersion()).andReturn((Object)version).anyTimes();
        EasyMock.expect((Object)result.getFilter()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    private void verifyResults() {
        ArrayList ius = new ArrayList(this.publisherResult.getIUs(null, null));
        int i = 0;
        while (i < ius.size()) {
            IInstallableUnit iu = (IInstallableUnit)ius.get(i);
            if (iu.getId().equals(String.valueOf(this.flavorArg) + "org.eclipse.equinox.launcher")) {
                EquinoxLauncherCUActionTest.assertTrue((boolean)(iu instanceof InstallableUnitFragment));
                this.verifyRequiredCapability(((InstallableUnitFragment)iu).getHost(), "osgi.bundle", "org.eclipse.equinox.launcher", VersionRange.emptyRange);
                this.verifyRequiredCapability(((InstallableUnitFragment)iu).getHost(), "org.eclipse.equinox.p2.eclipse.type", "bundle", new VersionRange(Version.create((String)"1.0.0"), true, Version.create((String)"2.0.0"), false), 1, 1, false);
                EquinoxLauncherCUActionTest.assertEquals((int)2, (int)((InstallableUnitFragment)iu).getHost().size());
                Collection cap = iu.getProvidedCapabilities();
                this.verifyProvidedCapability(cap, "org.eclipse.equinox.p2.iu", String.valueOf(this.flavorArg) + "org.eclipse.equinox.launcher", Version.emptyVersion);
                this.verifyProvidedCapability(cap, "org.eclipse.equinox.p2.flavor", this.flavorArg, Version.create((String)"1.0.0"));
                EquinoxLauncherCUActionTest.assertTrue((cap.size() == 2 ? 1 : 0) != 0);
                Map prop = iu.getProperties();
                EquinoxLauncherCUActionTest.assertTrue((boolean)prop.get("org.eclipse.equinox.p2.type.fragment").equals("true"));
                return;
            }
            ++i;
        }
        EquinoxLauncherCUActionTest.fail();
    }

    @Override
    public void setupPublisherResult() {
        this.publisherResult = new PublisherResult();
        ArrayList<IInstallableUnit> iuList = new ArrayList<IInstallableUnit>();
        iuList.add(this.mockIU(a_ID, null, true));
        iuList.add(this.mockIU(b_ID, null, true));
        iuList.add(this.mockIU(c_ID, null, false));
        iuList.add(this.mockIU(d_ID, null, false));
        this.publisherResult.addIUs(iuList, "root");
    }

    @Override
    protected void insertPublisherInfoBehavior() {
        VersionAdvice versionAdvice = new VersionAdvice();
        versionAdvice.setVersion("org.eclipse.equinox.p2.iu", String.valueOf(this.flavorArg) + "org.eclipse.equinox.launcher", Version.emptyVersion);
        versionAdvice.setVersion("org.eclipse.equinox.p2.iu", "org.eclipse.equinox.launcher", Version.emptyVersion);
        versionAdvice.setVersion("org.eclipse.equinox.p2.flavor", this.flavorArg, Version.create((String)"1.0.0"));
        ArrayList<VersionAdvice> versionList = new ArrayList<VersionAdvice>();
        versionList.add(versionAdvice);
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, true, "org.eclipse.equinox.launcher", null, IVersionAdvice.class)).andReturn(versionList);
        EasyMock.expect((Object)this.publisherInfo.getAdvice(this.configSpec, true, "org.eclipse.equinox.launcher." + this.configSpec, null, IVersionAdvice.class)).andReturn(versionList);
    }
}

