/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.IAdditionalInstallableUnitAdvice;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.publisher.actions.IFeatureRootAdvice;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.publisher.actions.ITouchpointAdvice;
import org.eclipse.equinox.p2.publisher.actions.IUpdateDescriptorAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.TestMetadataRepository;
import org.eclipse.equinox.p2.tests.publisher.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.eclipse.equinox.p2.tests.publisher.actions.CaptureList;

public class FeaturesActionTest
extends ActionTest {
    public static IArtifactKey FOO_KEY = ArtifactKey.parse((String)"org.eclipse.update.feature,foo,1.0.0");
    public static IArtifactKey BAR_KEY = ArtifactKey.parse((String)"org.eclipse.update.feature,bar,1.1.1");
    private static File root = new File(TestActivator.getTestDataFolder().toString(), "FeaturesActionTest");
    protected TestArtifactRepository artifactRepository = new TestArtifactRepository(FeaturesActionTest.getAgent());
    protected TestMetadataRepository metadataRepository;
    private Version fooVersion = Version.create((String)"1.0.0");
    private Version barVersion = Version.create((String)"1.1.1");
    private String BAR = "bar";
    private String FOO = "foo";
    private Capture<ITouchpointAdvice> tpAdvice;

    @Override
    public void setUp() throws Exception {
        this.testAction = new FeaturesAction(new File[]{root});
        this.tpAdvice = new Capture();
        this.setupPublisherInfo();
        this.setupPublisherResult();
    }

    public void testSimple() throws Exception {
        this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        this.verifyRepositoryContents();
        this.debug("Completed FeaturesAction.");
    }

    public void testFeaturePatch() throws Exception {
        File testFolder = this.getTestFolder("FeaturesAction.testFilters");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<feature id=\"test.feature\" version=\"1.0.0\" >                                       \n");
        buffer.append("   <requires>                                                                          \n");
        buffer.append("      <import feature=\"org.foo\" version=\"[1.0.0,2.0.0)\" match=\"versionRange\" patch=\"true\"/>  \n");
        buffer.append("   </requires>                                                                         \n");
        buffer.append("</feature>                                                                             \n");
        File featureXML = new File(testFolder, "feature.xml");
        FeaturesActionTest.writeBuffer(featureXML, buffer);
        this.publisherInfo = new PublisherInfo();
        FeaturesAction action = new FeaturesAction(new File[]{testFolder});
        action.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnitPatch iu = (IInstallableUnitPatch)this.publisherResult.getIU("test.feature.feature.group", Version.parseVersion((String)"1.0.0"), null);
        IRequirement[][] applicabilityScope = iu.getApplicabilityScope();
        FeaturesActionTest.assertEquals((int)1, (int)applicabilityScope.length);
        IRequiredCapability require = (IRequiredCapability)applicabilityScope[0][0];
        FeaturesActionTest.assertEquals((String)"org.foo.feature.group", (String)require.getName());
        IMatchExpression matches = require.getMatches();
        FeaturesActionTest.assertEquals((String)"providedCapabilities.exists(x | x.name == $0 && x.namespace == $1 && x.version >= $2 && x.version < $3)", (String)matches.toString());
        FeaturesActionTest.assertEquals((Object)Version.parseVersion((String)"1.0.0"), (Object)matches.getParameters()[2]);
        FeaturesActionTest.assertEquals((Object)Version.parseVersion((String)"2.0.0"), (Object)matches.getParameters()[3]);
    }

    public void testMatchRange() throws Exception {
        File testFolder = this.getTestFolder("FeaturesAction.testFilters");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<feature id=\"test.feature\" version=\"1.0.0\" >                                       \n");
        buffer.append("   <requires>                                                                          \n");
        buffer.append("      <import plugin=\"org.plug\" version=\"[1.0.0,2.0.0)\" match=\"versionRange\" />  \n");
        buffer.append("      <import feature=\"org.foo\" version=\"[1.0.0,2.0.0)\" match=\"versionRange\" />  \n");
        buffer.append("   </requires>                                                                         \n");
        buffer.append("</feature>                                                                             \n");
        File featureXML = new File(testFolder, "feature.xml");
        FeaturesActionTest.writeBuffer(featureXML, buffer);
        this.publisherInfo = new PublisherInfo();
        FeaturesAction action = new FeaturesAction(new File[]{testFolder});
        action.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = this.publisherResult.getIU("test.feature.feature.group", Version.parseVersion((String)"1.0.0"), null);
        Collection requires = iu.getRequirements();
        FeaturesActionTest.assertEquals((int)3, (int)requires.size());
        for (IRequirement require : requires) {
            IMatchExpression matches;
            if (((IRequiredCapability)require).getName().equals("org.foo.feature.group")) {
                matches = require.getMatches();
                FeaturesActionTest.assertEquals((String)"providedCapabilities.exists(x | x.name == $0 && x.namespace == $1 && x.version >= $2 && x.version < $3)", (String)matches.toString());
                FeaturesActionTest.assertEquals((Object)Version.parseVersion((String)"1.0.0"), (Object)matches.getParameters()[2]);
                FeaturesActionTest.assertEquals((Object)Version.parseVersion((String)"2.0.0"), (Object)matches.getParameters()[3]);
                continue;
            }
            if (!((IRequiredCapability)require).getName().equals("org.plug")) continue;
            matches = require.getMatches();
            FeaturesActionTest.assertEquals((String)"providedCapabilities.exists(x | x.name == $0 && x.namespace == $1 && x.version >= $2 && x.version < $3)", (String)matches.toString());
            FeaturesActionTest.assertEquals((Object)Version.parseVersion((String)"1.0.0"), (Object)matches.getParameters()[2]);
            FeaturesActionTest.assertEquals((Object)Version.parseVersion((String)"2.0.0"), (Object)matches.getParameters()[3]);
        }
    }

    public void testFilters() throws Exception {
        File testFolder = this.getTestFolder("FeaturesAction.testFilters");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<feature id=\"test.feature\" version=\"1.0.0\" >                                       \n");
        buffer.append("   <includes id=\"org.foo\" version=\"1.0.0\" filter=\"(osgi.os=win32)\"/>             \n");
        buffer.append("   <plugin id=\"org.plug\" version=\"1.0.0\" filter=\"(my.prop=foo)\" os=\"win32\" />  \n");
        buffer.append("   <requires>                                                                          \n");
        buffer.append("      <import plugin=\"org.plug2\" version=\"1.0.0\" filter=\"(my.prop=foo)\" />       \n");
        buffer.append("      <import feature=\"org.foo2\" version=\"1.0.0\" filter=\"(my.prop=foo)\" />       \n");
        buffer.append("   </requires>                                                                         \n");
        buffer.append("</feature>                                                                             \n");
        File featureXML = new File(testFolder, "feature.xml");
        FeaturesActionTest.writeBuffer(featureXML, buffer);
        this.publisherInfo = new PublisherInfo();
        FeaturesAction action = new FeaturesAction(new File[]{testFolder});
        action.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit iu = this.publisherResult.getIU("test.feature.feature.group", Version.parseVersion((String)"1.0.0"), null);
        Collection requires = iu.getRequirements();
        FeaturesActionTest.assertEquals((int)5, (int)requires.size());
        for (IRequirement require : requires) {
            if (((IRequiredCapability)require).getName().equals("org.foo.feature.group")) {
                FeaturesActionTest.assertEquals((Object)ExpressionUtil.parseLDAP((String)"(osgi.os=win32)"), (Object)require.getFilter().getParameters()[0]);
                continue;
            }
            if (((IRequiredCapability)require).getName().equals("org.plug")) {
                FeaturesActionTest.assertEquals((Object)ExpressionUtil.parseLDAP((String)"(&(my.prop=foo)(osgi.os=win32))"), (Object)require.getFilter().getParameters()[0]);
                continue;
            }
            if (((IRequiredCapability)require).getName().equals("org.plug2")) {
                FeaturesActionTest.assertEquals((Object)ExpressionUtil.parseLDAP((String)"(my.prop=foo)"), (Object)require.getFilter().getParameters()[0]);
                continue;
            }
            if (!((IRequiredCapability)require).getName().equals("org.foo2.feature.group")) continue;
            FeaturesActionTest.assertEquals((Object)ExpressionUtil.parseLDAP((String)"(my.prop=foo)"), (Object)require.getFilter().getParameters()[0]);
        }
    }

    private void verifyRepositoryContents() throws Exception {
        this.verifyArtifacts();
        this.verifyMetadata();
    }

    private void verifyMetadata() {
        ArrayList fooIUs = new ArrayList(this.publisherResult.getIUs("foo.feature.jar", "non_root"));
        FeaturesActionTest.assertTrue((fooIUs.size() == 1 ? 1 : 0) != 0);
        IInstallableUnit foo = (IInstallableUnit)fooIUs.get(0);
        FeaturesActionTest.assertTrue((boolean)foo.getId().equalsIgnoreCase("foo.feature.jar"));
        FeaturesActionTest.assertTrue((boolean)foo.getVersion().equals(this.fooVersion));
        FeaturesActionTest.assertEquals((String)"Foo Feature", (String)foo.getProperty("org.eclipse.equinox.p2.name"));
        FeaturesActionTest.assertEquals((String)"Foo Description", (String)foo.getProperty("org.eclipse.equinox.p2.description"));
        FeaturesActionTest.assertEquals((String)"Foo License", (String)((ILicense)foo.getLicenses().iterator().next()).getBody());
        FeaturesActionTest.assertEquals((String)"Foo Copyright", (String)foo.getCopyright().getBody());
        FeaturesActionTest.assertTrue((boolean)foo.getProperty("key1").equals("value1"));
        FeaturesActionTest.assertTrue((boolean)foo.getProperty("key2").equals("value2"));
        FeaturesActionTest.assertTrue((boolean)((IArtifactKey)foo.getArtifacts().iterator().next()).equals(FOO_KEY));
        FeaturesActionTest.assertEquals((Object)foo.getFilter().getParameters()[0], (Object)ExpressionUtil.parseLDAP((String)"(org.eclipse.update.install.features=true)"));
        FeaturesActionTest.assertTrue((boolean)foo.getTouchpointType().getId().equalsIgnoreCase("org.eclipse.equinox.p2.osgi"));
        FeaturesActionTest.assertTrue((boolean)foo.getTouchpointType().getVersion().equals(this.fooVersion));
        Collection tpData = foo.getTouchpointData();
        String fooValue = ((ITouchpointInstruction)((ITouchpointData)tpData.iterator().next()).getInstructions().get("zipped")).getBody();
        FeaturesActionTest.assertTrue((boolean)fooValue.equalsIgnoreCase("true"));
        Collection fooRequiredCapabilities = foo.getRequirements();
        FeaturesActionTest.assertTrue((fooRequiredCapabilities.size() == 0 ? 1 : 0) != 0);
        Collection fooProvidedCapabilities = foo.getProvidedCapabilities();
        this.contains(fooProvidedCapabilities, "org.eclipse.equinox.p2.iu", "foo.feature.jar", this.fooVersion);
        this.contains(fooProvidedCapabilities, "org.eclipse.equinox.p2.eclipse.type", "feature", this.fooVersion);
        this.contains(fooProvidedCapabilities, "org.eclipse.update.feature", this.FOO, this.fooVersion);
        FeaturesActionTest.assertTrue((fooProvidedCapabilities.size() == 3 ? 1 : 0) != 0);
        fooIUs = new ArrayList(this.publisherResult.getIUs("foo.feature.group", "root"));
        FeaturesActionTest.assertTrue((fooIUs.size() == 1 ? 1 : 0) != 0);
        IInstallableUnit fooGroup = (IInstallableUnit)fooIUs.get(0);
        tpData = fooGroup.getTouchpointData();
        FeaturesActionTest.assertEquals((int)1, (int)tpData.size());
        ITouchpointInstruction instruction = ((ITouchpointData)tpData.iterator().next()).getInstruction("install");
        FeaturesActionTest.assertNotNull((Object)instruction);
        FeaturesActionTest.assertEquals((String)"ln(targetDir:@artifact,linkTarget:foo/lib.1.so,linkName:lib.so);chmod(targetDir:@artifact,targetFile:lib/lib.so,permissions:755);", (String)instruction.getBody());
        FeaturesActionTest.assertNull((Object)fooGroup.getFilter());
        ArrayList barIUs = new ArrayList(this.publisherResult.getIUs("bar.feature.jar", "non_root"));
        FeaturesActionTest.assertTrue((barIUs.size() == 1 ? 1 : 0) != 0);
        IInstallableUnit bar = (IInstallableUnit)barIUs.get(0);
        FeaturesActionTest.assertTrue((boolean)bar.getId().equals("bar.feature.jar"));
        FeaturesActionTest.assertTrue((boolean)bar.getVersion().equals(this.barVersion));
        FeaturesActionTest.assertTrue((boolean)bar.getProperty("key1").equals("value1"));
        FeaturesActionTest.assertTrue((boolean)bar.getProperty("key2").equals("value2"));
        FeaturesActionTest.assertTrue((boolean)bar.getProperties().containsKey("org.eclipse.update.installHandler"));
        FeaturesActionTest.assertTrue((boolean)bar.getProperties().containsValue("handler=bar handler"));
        FeaturesActionTest.assertTrue((boolean)((IArtifactKey)bar.getArtifacts().iterator().next()).equals(BAR_KEY));
        FeaturesActionTest.assertEquals((Object)bar.getFilter().getParameters()[0], (Object)ExpressionUtil.parseLDAP((String)"(org.eclipse.update.install.features=true)"));
        FeaturesActionTest.assertTrue((boolean)bar.isSingleton());
        barIUs = new ArrayList(this.publisherResult.getIUs("bar.feature.group", "root"));
        FeaturesActionTest.assertTrue((fooIUs.size() == 1 ? 1 : 0) != 0);
        IInstallableUnit barGroup = (IInstallableUnit)barIUs.get(0);
        Collection barRequiredCapabilities = barGroup.getRequirements();
        this.contains(barRequiredCapabilities, "org.eclipse.equinox.p2.iu", "bar.feature.jar", new VersionRange(this.barVersion, true, this.barVersion, true), "(org.eclipse.update.install.features=true)", false, false);
        this.contains(barRequiredCapabilities, "org.eclipse.equinox.p2.iu", "org.bar.feature.feature.group", VersionRange.emptyRange, "(&(|(osgi.nl=de)(osgi.nl=en)(osgi.nl=fr)))", false, false);
        FeaturesActionTest.assertEquals((Object)barGroup.getFilter().getParameters()[0], (Object)ExpressionUtil.parseLDAP((String)"(&(|(osgi.os=macosx)(osgi.os=win32))(|(osgi.ws=carbon)(osgi.ws=win32))(|(osgi.arch=ppc)(osgi.arch=x86))(osgi.nl=en))"));
        String barValue = ((ITouchpointInstruction)((ITouchpointData)bar.getTouchpointData().iterator().next()).getInstructions().get("zipped")).getBody();
        FeaturesActionTest.assertTrue((boolean)barValue.equalsIgnoreCase("true"));
        FeaturesActionTest.assertTrue((boolean)bar.getTouchpointType().getId().equalsIgnoreCase("org.eclipse.equinox.p2.osgi"));
        FeaturesActionTest.assertTrue((boolean)bar.getTouchpointType().getVersion().equals(this.fooVersion));
        barRequiredCapabilities = bar.getRequirements();
        FeaturesActionTest.assertTrue((barRequiredCapabilities.size() == 0 ? 1 : 0) != 0);
        Collection barProvidedCapabilities = bar.getProvidedCapabilities();
        this.contains(barProvidedCapabilities, "org.eclipse.equinox.p2.iu", "bar.feature.jar", this.barVersion);
        this.contains(barProvidedCapabilities, "org.eclipse.equinox.p2.eclipse.type", "feature", this.fooVersion);
        this.contains(barProvidedCapabilities, "org.eclipse.update.feature", this.BAR, this.barVersion);
        FeaturesActionTest.assertTrue((barProvidedCapabilities.size() == 3 ? 1 : 0) != 0);
    }

    private void verifyArtifacts() throws IOException {
        ZipInputStream actualStream = this.artifactRepository.getZipInputStream(FOO_KEY);
        Map expected = this.getFileMap(new HashMap(), new File[]{new File(root, this.FOO)}, new Path(new File(root, this.FOO).getAbsolutePath()));
        TestData.assertContains(expected, actualStream, true);
        expected = this.getFileMap(new HashMap(), new File[]{new File(root, this.BAR)}, new Path(new File(root, this.BAR).getAbsolutePath()));
        actualStream = this.artifactRepository.getZipInputStream(BAR_KEY);
        TestData.assertContains(expected, actualStream, true);
    }

    @Override
    protected void insertPublisherInfoBehavior() {
        this.metadataRepository = new TestMetadataRepository(FeaturesActionTest.getAgent(), this.mockIU(this.BAR, null));
        ArrayList adviceCollection = this.fillAdvice(new ArrayList());
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "bar.feature.jar", this.barVersion, IPropertyAdvice.class)).andReturn((Object)adviceCollection).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "bar", this.barVersion, IPropertyAdvice.class)).andReturn((Object)adviceCollection).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "bar", this.barVersion, IFeatureRootAdvice.class)).andReturn((Object)Collections.EMPTY_LIST).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "bar.feature.group", this.barVersion, IPropertyAdvice.class)).andReturn((Object)adviceCollection).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "bar.feature.group", this.barVersion, ITouchpointAdvice.class)).andReturn((Object)Collections.EMPTY_LIST).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "bar.feature.group", this.barVersion, ICapabilityAdvice.class)).andReturn((Object)Collections.EMPTY_LIST).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "bar.feature.group", this.barVersion, IAdditionalInstallableUnitAdvice.class)).andReturn((Object)Collections.EMPTY_LIST).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "foo.feature.jar", this.fooVersion, IPropertyAdvice.class)).andReturn((Object)adviceCollection).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "bar.feature.group", this.barVersion, IUpdateDescriptorAdvice.class)).andReturn((Object)Collections.EMPTY_LIST).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "foo", this.fooVersion, IPropertyAdvice.class)).andReturn((Object)adviceCollection).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "foo", this.fooVersion, IFeatureRootAdvice.class)).andReturn((Object)Collections.EMPTY_LIST).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "foo.feature.group", this.fooVersion, IPropertyAdvice.class)).andReturn((Object)adviceCollection).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "foo.feature.group", this.fooVersion, ICapabilityAdvice.class)).andReturn((Object)Collections.EMPTY_LIST).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "foo.feature.group", this.fooVersion, IAdditionalInstallableUnitAdvice.class)).andReturn((Object)Collections.EMPTY_LIST).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "foo.feature.group", this.fooVersion, IUpdateDescriptorAdvice.class)).andReturn((Object)Collections.EMPTY_LIST).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getArtifactOptions()).andReturn((Object)7).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getArtifactRepository()).andReturn((Object)this.artifactRepository).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getMetadataRepository()).andReturn((Object)this.metadataRepository).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getContextMetadataRepository()).andReturn(null).anyTimes();
        this.publisherInfo.addAdvice((IPublisherAdvice)EasyMock.and((Object)((ITouchpointAdvice)EasyMock.isA(ITouchpointAdvice.class)), (Object)((ITouchpointAdvice)EasyMock.capture(this.tpAdvice))));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getAdvice(null, false, "foo.feature.group", this.fooVersion, ITouchpointAdvice.class)).andReturn(new CaptureList<ITouchpointAdvice>(this.tpAdvice)).anyTimes();
    }

    private ArrayList fillAdvice(ArrayList adviceCollection) {
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("key1", "value1");
        prop.put("key2", "value2");
        IPropertyAdvice propertyAdvice = (IPropertyAdvice)EasyMock.createMock(IPropertyAdvice.class);
        EasyMock.expect((Object)propertyAdvice.getInstallableUnitProperties((MetadataFactory.InstallableUnitDescription)EasyMock.anyObject())).andReturn(prop).anyTimes();
        EasyMock.expect((Object)propertyAdvice.getArtifactProperties((IInstallableUnit)EasyMock.anyObject(), (IArtifactDescriptor)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{propertyAdvice});
        adviceCollection.add(propertyAdvice);
        return adviceCollection;
    }
}

