/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.easymock.EasyMock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.actions.JREAction;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.TestMetadataRepository;
import org.eclipse.equinox.p2.tests.publisher.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.eclipse.equinox.p2.tests.publisher.actions.StatusMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class JREActionTest
extends ActionTest {
    private File J14 = new File(TestActivator.getTestDataFolder(), "JREActionTest/1.4/");
    private File J15 = new File(TestActivator.getTestDataFolder(), "JREActionTest/1.5/");
    private File J16 = new File(TestActivator.getTestDataFolder(), "JREActionTest/1.6/");
    private File jreWithPackageVersionsFolder = new File(TestActivator.getTestDataFolder(), "JREActionTest/packageVersions/");
    private File jreWithPackageVersionsProfile = new File(TestActivator.getTestDataFolder(), "JREActionTest/packageVersions/test-1.0.0.profile");
    protected TestArtifactRepository artifactRepository = new TestArtifactRepository(JREActionTest.getAgent());
    protected TestMetadataRepository metadataRepository;

    @Override
    public void setUp() throws Exception {
        this.setupPublisherInfo();
        this.setupPublisherResult();
    }

    public void test14() throws Exception {
        this.performAction(new JREAction(this.J14));
        Version jreVersion = Version.create((String)"1.4.0");
        this.verifyMetadataIU("a.jre.j2se", 91, 0, jreVersion);
        this.verifyConfigIU("a.jre.j2se", jreVersion);
        this.verifyArtifactRepository(ArtifactKey.parse((String)"binary,a.jre.j2se,1.4.0"), this.J14, "J2SE-1.4.profile");
    }

    public void test15() throws Exception {
        this.performAction(new JREAction(this.J15));
        Version jreVersion = Version.create((String)"1.5.0");
        this.verifyMetadataIU("a.jre.j2se", 118, 0, jreVersion);
        this.verifyConfigIU("a.jre.j2se", jreVersion);
        this.verifyArtifactRepository(ArtifactKey.parse((String)"binary,a.jre.j2se,1.5.0"), this.J15, "J2SE-1.5.profile");
    }

    public void test16() throws Exception {
        this.performAction(new JREAction(this.J16));
        Version jreVersion = Version.create((String)"1.6.0");
        this.verifyMetadataIU("a.jre.javase", 116, 0, jreVersion);
        this.verifyConfigIU("a.jre.javase", jreVersion);
        this.verifyArtifactRepository(ArtifactKey.parse((String)"binary,a.jre.javase,1.6.0"), this.J16, "JavaSE-1.6.profile");
    }

    public void testOSGiMin() throws Exception {
        this.performAction(new JREAction("OSGi/Minimum-1.2"));
        Version jreVersion = Version.create((String)"1.2.0");
        this.verifyMetadataIU("a.jre.osgi.minimum", 1, 3, jreVersion);
    }

    public void testPackageVersionsFromJreFolder() throws Exception {
        this.performAction(new JREAction(this.jreWithPackageVersionsFolder));
        Collection<IProvidedCapability> providedCapabilities = this.getPublishedCapabilitiesOf("a.jre.test");
        Assert.assertThat(providedCapabilities, (Matcher)CoreMatchers.hasItem((Object)MetadataFactory.createProvidedCapability((String)"java.package", (String)"my.package", null)));
        Assert.assertThat(providedCapabilities, (Matcher)CoreMatchers.hasItem((Object)MetadataFactory.createProvidedCapability((String)"java.package", (String)"my.package", (Version)Version.create((String)"1.0.0"))));
        this.verifyArtifactRepository(ArtifactKey.parse((String)"binary,a.jre.test,1.0.0"), this.jreWithPackageVersionsFolder, "test-1.0.0.profile");
    }

    public void testPackageVersionsFromJavaProfile() throws Exception {
        this.performAction(new JREAction(this.jreWithPackageVersionsProfile));
        Collection<IProvidedCapability> providedCapabilities = this.getPublishedCapabilitiesOf("a.jre.test");
        Assert.assertThat(providedCapabilities, (Matcher)CoreMatchers.hasItem((Object)MetadataFactory.createProvidedCapability((String)"java.package", (String)"my.package", null)));
        Assert.assertThat(providedCapabilities, (Matcher)CoreMatchers.hasItem((Object)MetadataFactory.createProvidedCapability((String)"java.package", (String)"my.package", (Version)Version.create((String)"1.0.0"))));
    }

    public void testDefaultJavaProfile() throws Exception {
        this.performAction(new JREAction(null));
        this.verifyMetadataIU("a.jre.javase", 158, 12, Version.parseVersion((String)"1.6"));
    }

    public void testNonExistingJreLocation() {
        File nonExistingProfile = new File(this.jreWithPackageVersionsFolder, "no.profile");
        try {
            this.performAction(new JREAction(nonExistingProfile));
            JREActionTest.fail((String)"Expected failure when the JRE location does not exists.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            JREActionTest.fail((String)("Expected IllegalArgumentException when the JRE location does not exists, caught " + e.getClass().getName()));
        }
    }

    public void testOsgiEECapabilities() {
        this.performAction(new JREAction("J2SE-1.5"));
        Collection<IProvidedCapability> capabilities = this.getPublishedCapabilitiesOf("a.jre.j2se");
        Assert.assertThat(capabilities, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)new ProvidedCapability("osgi.ee", "JavaSE", Version.parseVersion((String)"1.6")))));
        Assert.assertThat(capabilities, (Matcher)CoreMatchers.hasItem((Object)new ProvidedCapability("osgi.ee", "JavaSE", Version.parseVersion((String)"1.5"))));
        Assert.assertThat(capabilities, (Matcher)CoreMatchers.hasItem((Object)new ProvidedCapability("osgi.ee", "OSGi/Minimum", Version.parseVersion((String)"1.0"))));
        Assert.assertThat(capabilities, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)new ProvidedCapability("osgi.ee", "J2SE", Version.parseVersion((String)"1.5")))));
    }

    public void testSingleOsgiEECapability() {
        this.performAction(new JREAction("OSGi/Minimum-1.0"));
        Collection<IProvidedCapability> capabilities = this.getPublishedCapabilitiesOf("a.jre.osgi.minimum");
        Assert.assertThat(capabilities, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem((Object)new ProvidedCapability("osgi.ee", "JavaSE", Version.parseVersion((String)"1.5")))));
        Assert.assertThat(capabilities, (Matcher)CoreMatchers.hasItem((Object)new ProvidedCapability("osgi.ee", "OSGi/Minimum", Version.parseVersion((String)"1.0"))));
    }

    public void testInvalidOsgiEECapabilitySpec() {
        this.testAction = new JREAction(new File(TestActivator.getTestDataFolder(), "JREActionTest/invalidOsgiEE/ee-capability-syntax-test.profile"));
        IStatus status = this.testAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.errorStatus()));
        IStatus eeStatus = status.getChildren()[0];
        Assert.assertThat((Object)eeStatus.getMessage(), (Matcher)CoreMatchers.containsString((String)"org.osgi.framework.system.capabilities"));
        Assert.assertThat(Arrays.asList(eeStatus.getChildren()), (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"Attribute 'osgi.ee' is missing"))));
        Assert.assertThat(Arrays.asList(eeStatus.getChildren()), (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"Either 'version:Version' or 'version:List<Version>' must be specified"))));
        Assert.assertThat(Arrays.asList(eeStatus.getChildren()), (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"Syntax error in version '1.a.invalidversion'"))));
        Assert.assertThat(Arrays.asList(eeStatus.getChildren()), (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"Ignoring unknown capability namespace 'other.namespace'"))));
        Assert.assertThat(Arrays.asList(eeStatus.getChildren()), (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"Cannot specify both 'version:Version' and 'version:List<Version>'"))));
        Assert.assertThat((Object)eeStatus.getChildren().length, (Matcher)CoreMatchers.is((Object)5));
    }

    private void performAction(JREAction jreAction) {
        IStatus status = jreAction.perform(this.publisherInfo, this.publisherResult, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.okStatus()));
    }

    private void verifyMetadataIU(String id, int expectedProvidedPackages, int expectedProvidedEEs, Version jreVersion) {
        IInstallableUnit foo = this.getPublishedUnit(id);
        JREActionTest.assertTrue((boolean)foo.getVersion().equals(jreVersion));
        JREActionTest.assertTrue((boolean)foo.getTouchpointType().getId().equalsIgnoreCase("org.eclipse.equinox.p2.native"));
        JREActionTest.assertTrue((boolean)foo.getTouchpointType().getVersion().equals(Version.create((String)"1.0.0")));
        Collection fooProvidedCapabilities = foo.getProvidedCapabilities();
        Assert.assertThat((Object)fooProvidedCapabilities.size(), (Matcher)CoreMatchers.is((Object)(1 + expectedProvidedPackages + expectedProvidedEEs)));
    }

    private void verifyConfigIU(String id, Version jreVersion) {
        IInstallableUnit bar = this.getPublishedUnit("config." + id);
        Map instructions = ((ITouchpointData)bar.getTouchpointData().iterator().next()).getInstructions();
        JREActionTest.assertTrue((boolean)((ITouchpointInstruction)instructions.get("install")).getBody().equals("unzip(source:@artifact, target:${installFolder});"));
        JREActionTest.assertTrue((boolean)((ITouchpointInstruction)instructions.get("uninstall")).getBody().equals("cleanupzip(source:@artifact, target:${installFolder});"));
        JREActionTest.assertTrue((boolean)(bar instanceof IInstallableUnitFragment));
        Collection requiredCapability = ((IInstallableUnitFragment)bar).getHost();
        this.verifyRequiredCapability(requiredCapability, "org.eclipse.equinox.p2.iu", id, new VersionRange(jreVersion, true, Version.MAX_VERSION, true));
        JREActionTest.assertTrue((requiredCapability.size() == 1 ? 1 : 0) != 0);
        Collection providedCapability = bar.getProvidedCapabilities();
        this.verifyProvidedCapability(providedCapability, "org.eclipse.equinox.p2.iu", "config." + id, jreVersion);
        JREActionTest.assertTrue((providedCapability.size() == 1 ? 1 : 0) != 0);
        JREActionTest.assertTrue((boolean)bar.getProperty("org.eclipse.equinox.p2.type.fragment").equals("true"));
        JREActionTest.assertTrue((boolean)bar.getVersion().equals(jreVersion));
    }

    private void verifyArtifactRepository(IArtifactKey key, File JRELocation, final String fileName) throws IOException {
        JREActionTest.assertTrue((boolean)this.artifactRepository.contains(key));
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(fileName);
            }
        };
        File[] contentBytes = JRELocation.listFiles(fileFilter);
        FileUtils.copyStream((InputStream)new FileInputStream(contentBytes[0]), (boolean)false, (OutputStream)content, (boolean)true);
        ZipInputStream zipInputStream = this.artifactRepository.getZipInputStream(key);
        HashMap<String, Object[]> fileMap = new HashMap<String, Object[]>();
        fileMap.put(fileName, new Object[]{contentBytes[0], content.toByteArray()});
        TestData.assertContains(fileMap, zipInputStream, true);
    }

    private IInstallableUnit getPublishedUnit(String id) {
        Collection units = this.publisherResult.getIUs(id, "root");
        Assert.assertThat((Object)units.size(), (Matcher)CoreMatchers.is((Object)1));
        return (IInstallableUnit)units.iterator().next();
    }

    private Collection<IProvidedCapability> getPublishedCapabilitiesOf(String id) {
        Collection ius = this.publisherResult.getIUs(id, "root");
        Assert.assertThat((Object)ius.size(), (Matcher)CoreMatchers.is((Object)1));
        IInstallableUnit iu = (IInstallableUnit)ius.iterator().next();
        return iu.getProvidedCapabilities();
    }

    @Override
    protected void insertPublisherInfoBehavior() {
        EasyMock.expect((Object)this.publisherInfo.getArtifactRepository()).andReturn((Object)this.artifactRepository).anyTimes();
        EasyMock.expect((Object)this.publisherInfo.getArtifactOptions()).andReturn((Object)2).anyTimes();
    }
}

