/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import org.easymock.EasyMock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.actions.QueryableFilterAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ProductAction;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.publisher.TestArtifactRepository;
import org.eclipse.equinox.p2.tests.publisher.actions.ActionTest;
import org.eclipse.equinox.p2.tests.publisher.actions.StatusMatchers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ProductActionTest
extends ActionTest {
    private static final String WIN_FILTER = "(& (osgi.ws=win32)(osgi.os=win32)(osgi.arch=x86))";
    private static final String LINUX_FILTER = "(& (osgi.ws=gtk)(osgi.os=linux)(osgi.arch=x86))";
    private static final String WIN_CONFIG_SPEC = AbstractPublisherAction.createConfigSpec((String)"win32", (String)"win32", (String)"x86");
    private static final String LINUX_CONFIG_SPEC = AbstractPublisherAction.createConfigSpec((String)"gtk", (String)"linux", (String)"x86");
    File executablesFeatureLocation = null;
    String productLocation = "";
    String source = "";
    protected TestArtifactRepository artifactRepository = new TestArtifactRepository(ProductActionTest.getAgent());

    @Override
    protected IPublisherInfo createPublisherInfoMock() {
        return (IPublisherInfo)EasyMock.createNiceMock(IPublisherInfo.class);
    }

    @Override
    public void setUp() throws Exception {
        this.setupPublisherInfo();
        this.setupPublisherResult();
    }

    @Override
    public void setupPublisherInfo() {
        PublisherInfo publisherInfoImpl = new PublisherInfo();
        publisherInfoImpl.setArtifactRepository((IArtifactRepository)this.artifactRepository);
        publisherInfoImpl.setArtifactOptions(2);
        publisherInfoImpl.setConfigurations(new String[]{this.configSpec});
        this.publisherInfo = publisherInfoImpl;
    }

    public void testBrandedApplication() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "brandedProduct/branded.product").toString());
        this.addContextIU("org.eclipse.platform.feature.group", "1.2.3");
        this.performProductAction(productFile);
        Collection ius = this.publisherResult.getIUs("branded.product", "non_root");
        ProductActionTest.assertEquals((String)"1.0", (int)1, (int)ius.size());
    }

    public void testLicense() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "productWithLicense.product").toString());
        this.performProductAction(productFile);
        Collection ius = this.publisherResult.getIUs("licenseIU.product", "non_root");
        ProductActionTest.assertEquals((String)"1.0", (int)1, (int)ius.size());
        IInstallableUnit iu = (IInstallableUnit)ius.iterator().next();
        ProductActionTest.assertEquals((String)"1.1", (String)"http://www.example.com", (String)((ILicense)iu.getLicenses().iterator().next()).getLocation().toString());
        ProductActionTest.assertEquals((String)"1.2", (String)"This is the liCenSE.", (String)((ILicense)iu.getLicenses().iterator().next()).getBody().trim());
    }

    public void testLicenseNoURL() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "licenseNoURL.product").toString());
        this.performProductAction(productFile);
        Collection ius = this.publisherResult.getIUs("licenseIU.product", "non_root");
        ProductActionTest.assertEquals((String)"1.0", (int)1, (int)ius.size());
        IInstallableUnit iu = (IInstallableUnit)ius.iterator().next();
        ProductActionTest.assertEquals((String)"1.1", (String)"", (String)((ILicense)iu.getLicenses().iterator().next()).getLocation().toString());
        ProductActionTest.assertEquals((String)"1.2", (String)"This is the liCenSE.", (String)((ILicense)iu.getLicenses().iterator().next()).getBody().trim());
    }

    public void testLicenseNoText() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "licenseNoText.product").toString());
        this.performProductAction(productFile);
        Collection ius = this.publisherResult.getIUs("licenseIU.product", "non_root");
        ProductActionTest.assertEquals((String)"1.0", (int)1, (int)ius.size());
        IInstallableUnit iu = (IInstallableUnit)ius.iterator().next();
        ProductActionTest.assertEquals((String)"1.1", (String)"http://www.example.com", (String)((ILicense)iu.getLicenses().iterator().next()).getLocation().toString());
        ProductActionTest.assertEquals((String)"1.2", (String)"", (String)((ILicense)iu.getLicenses().iterator().next()).getBody().trim());
    }

    public void testMissingLicense() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "productWithNoLicense.product").toString());
        this.performProductAction(productFile);
        Collection ius = this.publisherResult.getIUs("licenseIU.product", "non_root");
        ProductActionTest.assertEquals((String)"1.0", (int)1, (int)ius.size());
        IInstallableUnit iu = (IInstallableUnit)ius.iterator().next();
        ProductActionTest.assertEquals((int)0, (int)iu.getLicenses().size());
    }

    public void testMultiProductPublishing() throws Exception {
        ProductFile productFile1 = new ProductFile(TestData.getFile("ProductActionTest", "boundedVersionConfigurations.product").toString());
        ProductFile productFile2 = new ProductFile(TestData.getFile("ProductActionTest", "unboundedVersionConfigurations.product").toString());
        this.addContextIU("org.eclipse.core.runtime", "4.0.0");
        this.performProductAction(productFile1);
        this.setupPublisherResult();
        this.addContextIU("org.eclipse.core.runtime", "4.0.0");
        this.performProductAction(productFile2);
        Assert.assertThat((Object)this.publisherResult, ProductActionTest.containsUniqueIU(String.valueOf(this.flavorArg) + this.configSpec + "org.eclipse.core.runtime"));
    }

    public void testMultiPlatformCUs_DifferentPlatforms() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "unboundedVersionConfigurations.product").toString());
        this.setConfiguration(LINUX_CONFIG_SPEC);
        this.addContextIU("org.eclipse.core.runtime", "0.0.0", WIN_FILTER);
        this.performProductAction(productFile);
        Assert.assertThat((Object)this.publisherResult, (Matcher)CoreMatchers.not(ProductActionTest.containsIU(String.valueOf(this.flavorArg) + LINUX_CONFIG_SPEC + "org.eclipse.core.runtime")));
        Assert.assertThat((Object)this.publisherResult, (Matcher)CoreMatchers.not(ProductActionTest.containsIU(String.valueOf(this.flavorArg) + WIN_CONFIG_SPEC + "org.eclipse.core.runtime")));
    }

    public void testMultiPlatformCUs_SamePlatforms() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "unboundedVersionConfigurations.product").toString());
        this.setConfiguration(LINUX_CONFIG_SPEC);
        this.addContextIU("org.eclipse.core.runtime", "0.0.0", LINUX_FILTER);
        this.performProductAction(productFile);
        Assert.assertThat((Object)this.publisherResult, ProductActionTest.containsUniqueIU(String.valueOf(this.flavorArg) + LINUX_CONFIG_SPEC + "org.eclipse.core.runtime"));
        Assert.assertThat((Object)this.publisherResult, (Matcher)CoreMatchers.not(ProductActionTest.containsIU(String.valueOf(this.flavorArg) + WIN_CONFIG_SPEC + "org.eclipse.core.runtime")));
    }

    public void testMultiPlatformCUs_SamePlatforms_NoVersion() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "unboundedVersionConfigurations.product").toString());
        this.setConfiguration(LINUX_CONFIG_SPEC);
        this.addContextIU("org.eclipse.core.runtime", null, LINUX_FILTER);
        this.performProductAction(productFile);
        Assert.assertThat((Object)this.publisherResult, ProductActionTest.containsUniqueIU(String.valueOf(this.flavorArg) + LINUX_CONFIG_SPEC + "org.eclipse.core.runtime"));
        Assert.assertThat((Object)this.publisherResult, (Matcher)CoreMatchers.not(ProductActionTest.containsIU(String.valueOf(this.flavorArg) + WIN_CONFIG_SPEC + "org.eclipse.core.runtime")));
    }

    public void testMultiPlatformCUs_SamePlatforms_BoundedVersions() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "unboundedVersionConfigurations.product").toString());
        this.setConfiguration(LINUX_CONFIG_SPEC);
        this.addContextIU("org.eclipse.core.runtime", "4.0.0", "(osgi.os=linux)");
        this.performProductAction(productFile);
        Assert.assertThat((Object)this.publisherResult, ProductActionTest.containsUniqueIU(String.valueOf(this.flavorArg) + LINUX_CONFIG_SPEC + "org.eclipse.core.runtime"));
        Assert.assertThat((Object)this.publisherResult, (Matcher)CoreMatchers.not(ProductActionTest.containsIU(String.valueOf(this.flavorArg) + WIN_CONFIG_SPEC + "org.eclipse.core.runtime")));
    }

    public void testCUsHost() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "unboundedVersionConfigurations.product").toString());
        this.setConfiguration(LINUX_CONFIG_SPEC);
        this.addContextIU("org.eclipse.core.runtime", "4.0.0", "(osgi.os=linux)");
        this.performProductAction(productFile);
        IInstallableUnitFragment fragment = (IInstallableUnitFragment)this.getUniquePublishedIU(String.valueOf(this.flavorArg) + LINUX_CONFIG_SPEC + "org.eclipse.core.runtime");
        ProductActionTest.assertEquals((String)"1.1", (String)"org.eclipse.core.runtime", (String)RequiredCapability.extractName((IMatchExpression)((IRequirement)fragment.getHost().iterator().next()).getMatches()));
        ProductActionTest.assertEquals((String)"1.2", (Object)Version.create((String)"4.0.0"), (Object)RequiredCapability.extractRange((IMatchExpression)((IRequirement)fragment.getHost().iterator().next()).getMatches()).getMinimum());
        ProductActionTest.assertEquals((String)"1.3", (Object)Version.create((String)"1.0.0"), (Object)fragment.getVersion());
    }

    public void testMultiConfigspecProductPublishing() throws IOException, Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "platform.product").toString());
        ((PublisherInfo)this.publisherInfo).setConfigurations(new String[]{"carbon.macos.x86", "cocoa.macos.x86"});
        this.addContextIU("org.eclipse.platform.feature.group", "1.2.3");
        this.performProductAction(productFile);
        Collection advice = this.publisherInfo.getAdvice("carbon.macos.x86", false, null, null, IConfigAdvice.class);
        ProductActionTest.assertEquals((String)"1.0", (int)1, (int)advice.size());
    }

    public void testANYConfigSpecPublishing_GeneralBundle() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "unboundedVersionConfigurations.product").toString());
        String configSpecANY = AbstractPublisherAction.createConfigSpec((String)"ANY", (String)"ANY", (String)"ANY");
        this.setConfiguration(configSpecANY);
        this.addContextIU("org.eclipse.core.runtime", "4.0.0");
        this.performProductAction(productFile);
        IInstallableUnitFragment fragment = (IInstallableUnitFragment)this.getUniquePublishedIU(String.valueOf(this.flavorArg) + configSpecANY + "org.eclipse.core.runtime");
        ProductActionTest.assertEquals((String)"1.1", (String)"org.eclipse.core.runtime", (String)RequiredCapability.extractName((IMatchExpression)((IRequirement)fragment.getHost().iterator().next()).getMatches()));
        ProductActionTest.assertEquals((String)"1.2", (Object)Version.create((String)"4.0.0"), (Object)RequiredCapability.extractRange((IMatchExpression)((IRequirement)fragment.getHost().iterator().next()).getMatches()).getMinimum());
        ProductActionTest.assertEquals((String)"1.3", (Object)Version.create((String)"1.0.0"), (Object)fragment.getVersion());
        ProductActionTest.assertNull((String)"1.3", (Object)fragment.getFilter());
    }

    public void testANYConfigSpecPublishing_PlatformSpecificBundle() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "unboundedVersionConfigurations.product").toString());
        String configSpecANY = AbstractPublisherAction.createConfigSpec((String)"ANY", (String)"ANY", (String)"ANY");
        this.setConfiguration(configSpecANY);
        this.addContextIU("org.eclipse.core.runtime", "4.0.0", WIN_FILTER);
        this.performProductAction(productFile);
        Assert.assertThat((Object)this.publisherResult, (Matcher)CoreMatchers.not(ProductActionTest.containsIU(String.valueOf(this.flavorArg) + configSpecANY + "org.eclipse.core.runtime")));
    }

    public void testProductFileWithRepoAdvice() throws Exception {
        URI location;
        try {
            location = TestData.getFile("ProductActionTest", "contextRepos").toURI();
        }
        catch (Exception e) {
            ProductActionTest.fail("0.99", e);
            return;
        }
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "platform.product").toString());
        IMetadataRepositoryManager metadataRepositoryManager = ProductActionTest.getMetadataRepositoryManager();
        IMetadataRepository repository = metadataRepositoryManager.loadRepository(location, (IProgressMonitor)new NullProgressMonitor());
        this.testAction = new ProductAction(this.source, (IProductDescriptor)productFile, this.flavorArg, this.executablesFeatureLocation);
        PublisherInfo info = new PublisherInfo();
        info.setContextMetadataRepository(repository);
        info.addAdvice((IPublisherAdvice)new QueryableFilterAdvice((IQueryable)info.getContextMetadataRepository()));
        IStatus status = this.testAction.perform((IPublisherInfo)info, this.publisherResult, null);
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.okStatus()));
        IQueryResult results = this.publisherResult.query(QueryUtil.createIUQuery((String)"org.eclipse.platform.ide", (Version)Version.create((String)"3.5.0.I20081118")), null);
        ProductActionTest.assertEquals((String)"1.0", (int)1, (int)ProductActionTest.queryResultSize(results));
        IInstallableUnit unit = (IInstallableUnit)results.iterator().next();
        Collection requiredCapabilities = unit.getRequirements();
        IRequiredCapability capability = null;
        for (IRequiredCapability req : requiredCapabilities) {
            if (!req.getName().equals("org.eclipse.platform.feature.group")) continue;
            capability = req;
            break;
        }
        ProductActionTest.assertTrue((String)"1.1", (capability != null ? 1 : 0) != 0);
        ProductActionTest.assertEquals((String)"1.2", (Object)InstallableUnit.parseFilter((String)"(org.eclipse.update.install.features=true)"), (Object)capability.getFilter());
    }

    public void testProductWithAdviceFile() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest/productWithAdvice", "productWithAdvice.product").toString());
        this.testAction = new ProductAction(this.source, (IProductDescriptor)productFile, this.flavorArg, this.executablesFeatureLocation);
        IStatus status = this.testAction.perform((IPublisherInfo)new PublisherInfo(), this.publisherResult, null);
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.okStatus()));
        IInstallableUnit product = this.getUniquePublishedIU("productWithAdvice.product");
        Collection data = product.getTouchpointData();
        ProductActionTest.assertEquals((String)"1.1", (int)1, (int)data.size());
        String configure = ((ITouchpointData)data.iterator().next()).getInstruction("configure").getBody();
        ProductActionTest.assertEquals((String)"1.2", (String)"addRepository(type:0,location:http${#58}//download.eclipse.org/releases/fred);addRepository(type:1,location:http${#58}//download.eclipse.org/releases/fred);", (String)configure);
        IUpdateDescriptor update = product.getUpdateDescriptor();
        ProductActionTest.assertEquals((String)"2.0", (int)0, (int)update.getSeverity());
        ProductActionTest.assertEquals((String)"2.1", (String)"This is the description", (String)update.getDescription());
        ProductActionTest.assertTrue((String)"2.2", (boolean)update.isUpdateOf(ProductActionTest.createIU("com.zoobar", Version.createOSGi((int)4, (int)1, (int)0))));
        ProductActionTest.assertFalse((String)"2.3", (boolean)update.isUpdateOf(ProductActionTest.createIU("com.zoobar", Version.createOSGi((int)3, (int)1, (int)0))));
        ProductActionTest.assertFalse((String)"2.4", (boolean)update.isUpdateOf(ProductActionTest.createIU("com.zoobar", Version.createOSGi((int)6, (int)1, (int)0))));
        ProductActionTest.assertFalse((String)"2.6", (boolean)update.isUpdateOf(ProductActionTest.createIU("com.other", Version.createOSGi((int)4, (int)1, (int)0))));
    }

    public void testFiltersOfInclusions() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "productIncludingFragments.product").toString());
        this.addContextIU("generalbundle", "1.0.1");
        this.addContextIU("fragment.win", "1.0.2", WIN_FILTER);
        IStatus status = this.performProductActionAndReturnStatus(productFile);
        IInstallableUnit productIU = this.getUniquePublishedIU("productIncludingFragments.uid");
        Assert.assertThat((Object)productIU.getRequirements(), (Matcher)CoreMatchers.hasItem((Object)ProductActionTest.createIURequirement("generalbundle", ProductActionTest.createStrictVersionRange("1.0.1"))));
        Assert.assertThat((Object)productIU.getRequirements(), (Matcher)CoreMatchers.hasItem((Object)ProductActionTest.createIURequirement("fragment.win", ProductActionTest.createStrictVersionRange("1.0.2"), WIN_FILTER)));
        Assert.assertThat((Object)productIU.getRequirements(), (Matcher)CoreMatchers.hasItem((Object)ProductActionTest.createIURequirement("fragment.linux", ANY_VERSION)));
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.errorStatus()));
        Assert.assertThat(Arrays.asList(status.getChildren()), (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"Included element fragment.linux 0.0.0 is missing"))));
    }

    public void testMessageForProductWithIgnoredContent() throws Exception {
        ProductFile productFile = new ProductFile(TestData.getFile("ProductActionTest", "mixedContentIgnored.product").toString());
        IStatus status = this.performProductActionAndReturnStatus(productFile);
        Assert.assertThat(Arrays.asList(status.getChildren()), (Matcher)CoreMatchers.hasItem(StatusMatchers.statusWithMessageWhich((Matcher<String>)CoreMatchers.containsString((String)"are ignored"))));
    }

    private void performProductAction(ProductFile productFile) {
        IStatus status = this.performProductActionAndReturnStatus(productFile);
        Assert.assertThat((Object)status, (Matcher)CoreMatchers.is(StatusMatchers.okStatus()));
    }

    private IStatus performProductActionAndReturnStatus(ProductFile productFile) {
        this.testAction = new ProductAction(this.source, (IProductDescriptor)productFile, this.flavorArg, this.executablesFeatureLocation);
        return this.testAction.perform(this.publisherInfo, this.publisherResult, null);
    }

    private void setConfiguration(String configSpec) {
        ((PublisherInfo)this.publisherInfo).setConfigurations(new String[]{configSpec});
    }
}

