/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.publisher.actions;

import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.tests.AdditionalCoreMatchers;
import org.eclipse.equinox.p2.tests.TestData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ProductFileTest
extends TestCase {
    String productFileLocation = null;
    ProductFile productFile = null;
    ProductFile noLauncherFlag = null;
    ProductFile falseLauncherFlag = null;
    ProductFile trueLauncherFlag = null;
    ProductFile rootFeaturesProduct;
    String configFile = "/org.eclipse.equinox.p2.tests/testData/ProductActionTest/productWithConfig/config.ini";
    private String uidProductFileLocation;
    private ProductFile uidProductFile;

    protected void setUp() throws Exception {
        this.productFileLocation = TestData.getFile("ProductActionTest/productWithConfig", "sample.product").toString();
        this.noLauncherFlag = new ProductFile(TestData.getFile("ProductActionTest/launcherFlags", "noLauncherFlag.product").toString());
        this.falseLauncherFlag = new ProductFile(TestData.getFile("ProductActionTest/launcherFlags", "falseLauncherFlag.product").toString());
        this.trueLauncherFlag = new ProductFile(TestData.getFile("ProductActionTest/launcherFlags", "trueLauncherFlag.product").toString());
        this.productFile = new ProductFile(this.productFileLocation);
        this.uidProductFileLocation = TestData.getFile("ProductActionTest/productWithConfig", "uidproduct.product").toString();
        this.uidProductFile = new ProductFile(this.uidProductFileLocation);
        this.rootFeaturesProduct = new ProductFile(TestData.getFile("ProductActionTest", "rootFeatures.product").toString());
    }

    public void testGetLauncherName() {
        ProductFileTest.assertEquals((String)"1.0", (String)"sample", (String)this.productFile.getLauncherName());
    }

    public void testGetLocation() {
        ProductFileTest.assertEquals((String)"1.0", (String)this.productFileLocation, (String)this.productFile.getLocation().toString());
    }

    public void testGetConfigurationProperties() {
        Map properties = this.productFile.getConfigurationProperties();
        ProductFileTest.assertEquals((String)"1.0", (int)4, (int)properties.size());
        ProductFileTest.assertEquals((String)"1.1", (String)"bar", (String)((String)properties.get("foo")));
        ProductFileTest.assertEquals((String)"1.2", (String)"", (String)((String)properties.get("foo1")));
        ProductFileTest.assertEquals((String)"1.3", (String)"test.product", (String)((String)properties.get("eclipse.product")));
        ProductFileTest.assertEquals((String)"1.4", (String)"test.app", (String)((String)properties.get("eclipse.application")));
    }

    public void testGetBundles() {
        List bundles = this.productFile.getBundles(false);
        ProductFileTest.assertEquals((String)"1.0", (int)1, (int)bundles.size());
        ProductFileTest.assertEquals((String)"1.1", (String)"org.eclipse.core.runtime", (String)((IVersionedId)bundles.get(0)).getId());
        ProductFileTest.assertEquals((String)"1.2", (Object)Version.createOSGi((int)1, (int)0, (int)4), (Object)((IVersionedId)bundles.get(0)).getVersion());
        bundles = this.productFile.getBundles(true);
        ProductFileTest.assertEquals((String)"1.3", (int)2, (int)bundles.size());
    }

    public void testGetBundleInfos() {
        List bundleInfos = this.productFile.getBundleInfos();
        BundleInfo info = (BundleInfo)bundleInfos.iterator().next();
        ProductFileTest.assertEquals((String)"1.0", (int)1, (int)bundleInfos.size());
        ProductFileTest.assertEquals((String)"1.1", (String)"org.eclipse.core.runtime", (String)info.getSymbolicName());
        ProductFileTest.assertEquals((String)"1.2", (int)2, (int)info.getStartLevel());
        ProductFileTest.assertEquals((String)"1.3", (boolean)true, (boolean)info.isMarkedAsStarted());
    }

    public void testGetFragments() {
        List fragments = this.productFile.getFragments();
        ProductFileTest.assertEquals((String)"1.0", (int)1, (int)fragments.size());
        ProductFileTest.assertEquals((String)"1.1", (String)"org.eclipse.swt.win32.win32.x86", (String)((IVersionedId)fragments.get(0)).getId());
    }

    public void testGetFeatures() {
        List features = this.productFile.getFeatures();
        ProductFileTest.assertEquals((String)"1.0", (int)1, (int)features.size());
        ProductFileTest.assertEquals((String)"1.1", (String)"org.eclipse.rcp", (String)((IVersionedId)features.get(0)).getId());
        ProductFileTest.assertEquals((String)"1.2", (Object)Version.create((String)"3.5.0.v20081110-9C9tEvNEla71LZ2jFz-RFB-t"), (Object)((IVersionedId)features.get(0)).getVersion());
    }

    public void testGetRootFeatures() {
        List features = this.rootFeaturesProduct.getFeatures(2);
        Assert.assertThat((Object)features, (Matcher)CoreMatchers.hasItem((Object)new VersionedId("org.eclipse.help", "2.0.102.v20140128")));
        Assert.assertThat((Object)features, (Matcher)CoreMatchers.hasItem((Object)new VersionedId("org.eclipse.egit", "0.0.0")));
        Assert.assertThat((Object)features, AdditionalCoreMatchers.hasSize(2));
    }

    public void testGetIncludedFeatures() {
        List features = this.rootFeaturesProduct.getFeatures(1);
        Assert.assertThat((Object)features, (Matcher)CoreMatchers.hasItem((Object)new VersionedId("org.eclipse.rcp", "4.4.0.v20140128")));
        Assert.assertThat((Object)features, (Matcher)CoreMatchers.hasItem((Object)new VersionedId("org.eclipse.e4.rcp", "0.0.0")));
        Assert.assertThat((Object)features, AdditionalCoreMatchers.hasSize(2));
    }

    public void testGetFeaturesOnlyReturnsIncludedFeatures() {
        Assert.assertThat((Object)this.rootFeaturesProduct.getFeatures(), (Matcher)CoreMatchers.is((Object)this.rootFeaturesProduct.getFeatures(1)));
    }

    public void testHasFeatures() throws Exception {
        ProductFile featuresOnly = new ProductFile(TestData.getFile("ProductActionTest", "onlyFeatures.product").toString());
        Assert.assertThat((Object)featuresOnly.hasFeatures(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)featuresOnly.hasBundles(false), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)featuresOnly.hasBundles(true), (Matcher)CoreMatchers.is((Object)false));
    }

    public void testHasBundles() throws Exception {
        ProductFile bundlesOnly = new ProductFile(TestData.getFile("ProductActionTest", "onlyBundles.product").toString());
        Assert.assertThat((Object)bundlesOnly.hasFeatures(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)bundlesOnly.hasBundles(false), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)bundlesOnly.hasBundles(true), (Matcher)CoreMatchers.is((Object)true));
    }

    public void testHasFragments() throws Exception {
        ProductFile bundlesOnly = new ProductFile(TestData.getFile("ProductActionTest", "onlyFragments.product").toString());
        Assert.assertThat((Object)bundlesOnly.hasFeatures(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)bundlesOnly.hasBundles(false), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)bundlesOnly.hasBundles(true), (Matcher)CoreMatchers.is((Object)true));
    }

    public void testGetConfigIniPath() {
        String configIni = this.productFile.getConfigIniPath("win32");
        ProductFileTest.assertEquals((String)"1.0", (String)"config.ini", (String)configIni);
    }

    public void testGetId() {
        String id = this.productFile.getId();
        ProductFileTest.assertEquals((String)"1.0", (String)"test.product", (String)id);
    }

    public void testGetUID() {
        String id = this.uidProductFile.getId();
        ProductFileTest.assertEquals((String)"1.0", (String)"UID.test.product", (String)id);
    }

    public void testGetSplashLocation() {
        String splashLocation = this.productFile.getSplashLocation();
        ProductFileTest.assertEquals((String)"1.0", (String)"org.eclipse.equinox.p2.tests", (String)splashLocation);
    }

    public void testGetProductName() {
        String productName = this.productFile.getProductName();
        ProductFileTest.assertEquals((String)"1.0", (String)"aaTestProduct", (String)productName);
    }

    public void testGetApplication() {
        String application = this.productFile.getApplication();
        ProductFileTest.assertEquals((String)"1.0", (String)"test.app", (String)application);
    }

    public void testUseFeatures() {
        boolean useFeatures = this.productFile.useFeatures();
        ProductFileTest.assertTrue((String)"1.0", (!useFeatures ? 1 : 0) != 0);
    }

    public void testGetVersion() {
        String version = this.productFile.getVersion();
        ProductFileTest.assertEquals((String)"1.0", (Object)Version.create((String)"1"), (Object)Version.create((String)version));
    }

    public void testGetVMArguments() {
        String vmArguments = this.productFile.getVMArguments("");
        ProductFileTest.assertEquals((String)"1.0", (String)"vmArg -Dfoo=\"b a r\"", (String)vmArguments);
        vmArguments = this.productFile.getVMArguments(null);
        ProductFileTest.assertEquals((String)"1.1", (String)"vmArg -Dfoo=\"b a r\"", (String)vmArguments);
    }

    public void testIncludeLaunchers() {
        ProductFileTest.assertEquals((String)"1.0", (boolean)true, (boolean)this.noLauncherFlag.includeLaunchers());
        ProductFileTest.assertEquals((String)"1.1", (boolean)false, (boolean)this.falseLauncherFlag.includeLaunchers());
        ProductFileTest.assertEquals((String)"1.2", (boolean)true, (boolean)this.trueLauncherFlag.includeLaunchers());
    }

    public void testGetProgramArguments() {
        String programArguments = this.productFile.getProgramArguments("");
        ProductFileTest.assertEquals((String)"1.0", (String)"programArg -name \"My Name\"", (String)programArguments);
        programArguments = this.productFile.getProgramArguments(null);
        ProductFileTest.assertEquals((String)"1.1", (String)"programArg -name \"My Name\"", (String)programArguments);
    }

    public void testGetLicenseURL() throws Exception {
        String productWithLicense = TestData.getFile("ProductActionTest", "productWithLicense.product").toString();
        ProductFile product = new ProductFile(productWithLicense);
        ProductFileTest.assertEquals((String)"1.0", (String)"http://www.example.com", (String)product.getLicenseURL());
    }

    public void testGetLicenseText() throws Exception {
        String productWithLicense = TestData.getFile("ProductActionTest", "productWithLicense.product").toString();
        ProductFile product = new ProductFile(productWithLicense);
        ProductFileTest.assertEquals((String)"1.0", (String)"This is the liCenSE.", (String)product.getLicenseText().trim());
    }
}

