/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.reconciler.dropins;

import java.io.File;
import junit.framework.Test;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.tests.reconciler.dropins.AbstractReconcilerTest;
import org.eclipse.equinox.p2.tests.reconciler.dropins.ReconcilerTestSuite;

public class BasicTests
extends AbstractReconcilerTest {
    public BasicTests(String name) {
        super(name);
    }

    public static Test suite() {
        ReconcilerTestSuite suite = new ReconcilerTestSuite();
        suite.setName(BasicTests.class.getName());
        suite.addTest((Test)new BasicTests("testOneSessionInstallRemovalOfDependentFeatures"));
        suite.addTest((Test)new BasicTests("testNonSingleton"));
        suite.addTest((Test)new BasicTests("testSingleton"));
        suite.addTest((Test)new BasicTests("testDirectoryBasedPlugin"));
        suite.addTest((Test)new BasicTests("testSimpleRepoWithSiteXMLPlaceHolder"));
        suite.addTest((Test)new BasicTests("testSimpleRepo"));
        suite.addTest((Test)new BasicTests("test_p2Repo"));
        suite.addTest((Test)new BasicTests("testDisabledBundleInLink"));
        suite.addTest((Test)new BasicTests("testMove1"));
        suite.addTest((Test)new BasicTests("testMove2"));
        return suite;
    }

    public void testDirectoryBasedPlugin() {
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("1.0", "directoryBased");
        File dir = BasicTests.getTestData("1.1", "testData/reconciler/plugins/directoryBased_1.0.0");
        this.add("1.2", "dropins", dir);
        this.reconcile("1.3");
        this.assertExistsInBundlesInfo("1.4", "directoryBased", "1.0.0");
        this.remove("2.0", "dropins", "directoryBased_1.0.0");
        this.reconcile("2.1");
        this.assertDoesNotExistInBundlesInfo("2.2", "directoryBased");
    }

    public void testMove1() {
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("0.2", "a");
        this.assertDoesNotExistInBundlesInfo("0.1", "b");
        File jar = BasicTests.getTestData("2.0", "testData/reconciler/move/b_1.0.0.jar");
        this.add("2.1", "dropins", jar);
        this.reconcile("3.0");
        this.assertExistsInBundlesInfo("4.0", "b", "1.0.0", "dropins");
        this.remove("5.0", "dropins", "b_1.0.0.jar");
        this.add("5.1", "plugins", jar);
        this.reconcile("6.0");
        this.assertExistsInBundlesInfo("7.0", "b", "1.0.0", "plugins");
        this.remove("99.0", "plugins", "b_1.0.0.jar");
        this.reconcile("99.1");
        this.assertDoesNotExistInBundlesInfo("99.2", "b");
    }

    public void testOneSessionInstallRemovalOfDependentFeatures() {
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("0.1", "c");
        File jar = BasicTests.getTestData("2.0", "testData/reconciler/installuninstall/c_1.0.0.jar");
        this.add("2.1", "dropins", jar);
        this.reconcile("3.0");
        this.assertExistsInBundlesInfo("4.0", "c", "1.0.0", "c_1.0.0.jar");
        this.remove("4.1", "dropins", jar.getName());
        File jar2 = BasicTests.getTestData("4.2", "testData/reconciler/installuninstall/d_1.0.0.jar");
        this.add("4.3", "dropins", jar2);
        this.reconcile("5.0");
        this.assertDoesNotExistInBundlesInfo("5.0", "c");
    }

    public void testMove2() {
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("0.1", "a");
        this.assertDoesNotExistInBundlesInfo("0.2", "b");
        File jar = BasicTests.getTestData("2.0", "testData/reconciler/move/b_1.0.0.jar");
        this.add("2.1", "dropins", jar);
        this.reconcile("2.2");
        this.assertExistsInBundlesInfo("2.3", "b", "1.0.0", "dropins");
        jar = BasicTests.getTestData("3.0", "testData/reconciler/move/a_1.0.0.jar");
        this.add("3.1", "dropins", jar);
        this.reconcile("3.2");
        this.assertExistsInBundlesInfo("3.3", "a", "1.0.0", "dropins");
        this.remove("5.0", "dropins", "b_1.0.0.jar");
        jar = BasicTests.getTestData("5.1", "testData/reconciler/move/b_1.0.0.jar");
        this.add("5.2", "plugins", jar);
        this.reconcile("5.3");
        this.assertExistsInBundlesInfo("7.0", "b", "1.0.0", "plugins");
        this.assertExistsInBundlesInfo("7.1", "a", "1.0.0", "dropins");
        this.remove("99.0", "dropins", "a_1.0.0.jar");
        this.remove("99.1", "plugins", "b_1.0.0.jar");
        this.reconcile("99.2");
        this.assertDoesNotExistInBundlesInfo("99.3", "a");
        this.assertDoesNotExistInBundlesInfo("99.4", "b");
    }

    public void testNonSingleton() {
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("0.1", "myBundle");
        File jar = BasicTests.getTestData("2.0", "testData/reconciler/plugins/myBundle_1.0.0.jar");
        this.add("0.2", "dropins", jar);
        this.reconcile("0.3");
        this.assertExistsInBundlesInfo("0.4", "myBundle");
        this.remove("1.0", "dropins", "myBundle_1.0.0.jar");
        this.reconcile("1.1");
        this.assertDoesNotExistInBundlesInfo("1.2", "myBundle");
        jar = BasicTests.getTestData("2.0", "testData/reconciler/plugins/myBundle_1.0.0.jar");
        this.add("2.1", "dropins", jar);
        jar = BasicTests.getTestData("2.2", "testData/reconciler/plugins/myBundle_2.0.0.jar");
        this.add("2.3", "dropins", jar);
        this.reconcile("2.4");
        this.assertExistsInBundlesInfo("2.5", "myBundle", "1.0.0");
        this.assertExistsInBundlesInfo("2.6", "myBundle", "2.0.0");
        this.remove("3.0", "dropins", "myBundle_1.0.0.jar");
        this.reconcile("3.1");
        this.assertDoesNotExistInBundlesInfo("3.2", "myBundle", "1.0.0");
        this.assertExistsInBundlesInfo("3.3", "myBundle", "2.0.0");
        this.remove("99.0", "dropins", "myBundle_2.0.0.jar");
        this.reconcile("99.1");
        this.assertDoesNotExistInBundlesInfo("99.2", "myBundle", "2.0.0");
    }

    public void testSingleton() {
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("1.0", "mySingletonBundle");
        File jar = BasicTests.getTestData("2.0", "testData/reconciler/plugins/mySingletonBundle_1.0.0.jar");
        this.add("2.1", "dropins", jar);
        this.reconcile("2.3");
        this.assertExistsInBundlesInfo("3.0", "mySingletonBundle", "1.0.0");
        this.assertDoesNotExistInBundlesInfo("3.1", "mySingletonBundle", "2.0.0");
        jar = BasicTests.getTestData("4.0", "testData/reconciler/plugins/mySingletonBundle_2.0.0.jar");
        this.add("4.1", "dropins", jar);
        this.reconcile("4.3");
        this.assertDoesNotExistInBundlesInfo("5.1", "mySingletonBundle", "1.0.0");
        this.assertExistsInBundlesInfo("5.2", "mySingletonBundle", "2.0.0");
        jar = BasicTests.getTestData("6.0", "testData/reconciler/plugins/mySingletonBundle_1.0.0.jar");
        this.add("6.1", "dropins", jar);
        this.reconcile("6.3");
        this.assertDoesNotExistInBundlesInfo("7.1", "mySingletonBundle", "1.0.0");
        this.assertExistsInBundlesInfo("7.2", "mySingletonBundle", "2.0.0");
        jar = BasicTests.getTestData("8.0", "testData/reconciler/plugins/mySingletonBundle_1.0.0.jar");
        this.add("8.1", "dropins", jar);
        this.reconcile("8.3");
        this.assertDoesNotExistInBundlesInfo("9.1", "mySingletonBundle", "1.0.0");
        this.assertExistsInBundlesInfo("9.2", "mySingletonBundle", "2.0.0");
        this.remove("10.1", "dropins", "mySingletonBundle_2.0.0.jar");
        this.reconcile("10.2");
        this.assertExistsInBundlesInfo("11.0", "mySingletonBundle", "1.0.0");
        this.assertDoesNotExistInBundlesInfo("11.1", "mySingletonBundle", "2.0.0");
        this.remove("99.0", "dropins", "mySingletonBundle_1.0.0.jar");
        this.remove("99.1", "dropins", "mySingletonBundle_2.0.0.jar");
        this.reconcile("99.2");
        this.assertDoesNotExistInBundlesInfo("99.3", "mySingletonBundle", "1.0.0");
        this.assertDoesNotExistInBundlesInfo("99.4", "mySingletonBundle", "2.0.0");
    }

    public void testSimpleRepoWithSiteXMLPlaceHolder() {
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("0.1", "myBundle");
        File jar = BasicTests.getTestData("2.0", "testData/reconciler/plugins/myBundle_1.0.0.jar");
        this.add("1.0", "dropins/simplerepo/plugins", jar);
        jar = BasicTests.getTestData("2.2", "testData/reconciler/plugins/myBundle_2.0.0.jar");
        this.add("1.1", "dropins/simplerepo/plugins", jar);
        File artifactRepo = BasicTests.getTestData("2.0", "testData/reconciler/simplerepo/artifacts.xml");
        this.add("1.1", "dropins/simplerepo", artifactRepo);
        File metadataRepo = BasicTests.getTestData("2.0", "testData/reconciler/simplerepo/content.xml");
        this.add("1.1", "dropins/simplerepo", metadataRepo);
        File dummySiteXML = BasicTests.getTestData("2.0", "testData/reconciler/simplerepo/site.xml");
        this.add("1.1", "dropins/simplerepo", dummySiteXML);
        this.reconcile("2.0");
        this.assertDoesNotExistInBundlesInfo("2.1", "myBundle", "1.0.0");
        this.assertExistsInBundlesInfo("2.2", "myBundle", "2.0.0");
        this.remove("99.0", "dropins", "simplerepo");
        this.reconcile("99.1");
        this.assertDoesNotExistInBundlesInfo("99.2", "myBundle");
    }

    public void testSimpleRepo() {
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("0.1", "myBundle");
        File jar = BasicTests.getTestData("2.0", "testData/reconciler/plugins/myBundle_1.0.0.jar");
        this.add("1.0", "dropins/simplerepo/plugins", jar);
        jar = BasicTests.getTestData("2.2", "testData/reconciler/plugins/myBundle_2.0.0.jar");
        this.add("1.1", "dropins/simplerepo/plugins", jar);
        File artifactRepo = BasicTests.getTestData("2.0", "testData/reconciler/simplerepo/artifacts.xml");
        this.add("1.1", "dropins/simplerepo", artifactRepo);
        File metadataRepo = BasicTests.getTestData("2.0", "testData/reconciler/simplerepo/content.xml");
        this.add("1.1", "dropins/simplerepo", metadataRepo);
        this.reconcile("2.0");
        this.assertDoesNotExistInBundlesInfo("2.1", "myBundle", "1.0.0");
        this.assertExistsInBundlesInfo("2.2", "myBundle", "2.0.0");
        this.remove("99.0", "dropins", "simplerepo");
        this.reconcile("99.1");
        this.assertDoesNotExistInBundlesInfo("99.2", "myBundle");
    }

    public void test_251167() {
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("1.0", "A");
        this.assertDoesNotExistInBundlesInfo("1.1", "B");
        File jar = BasicTests.getTestData("2.0", "testData/reconciler/251167/A_1.0.0.jar");
        this.add("2.1", "dropins", jar);
        jar = BasicTests.getTestData("2.2", "testData/reconciler/251167/B_1.0.0.jar");
        this.add("2.3", "dropins", jar);
        this.reconcile("2.4");
        this.assertExistsInBundlesInfo("3.0", "A");
        this.assertExistsInBundlesInfo("3.1", "B");
        BasicTests.assertTrue((String)"3.2", (boolean)this.isInstalled("A", "1.0.0"));
        BasicTests.assertTrue((String)"3.3", (boolean)this.isInstalled("B", "1.0.0"));
        this.remove("4.0", "dropins", "B_1.0.0.jar");
        this.reconcile("4.1");
        this.assertExistsInBundlesInfo("5.0", "A");
        this.assertDoesNotExistInBundlesInfo("5.1", "B");
        BasicTests.assertTrue((String)"5.2", (boolean)this.isInstalled("A", "1.0.0"));
        BasicTests.assertFalse((String)"5.3", (boolean)this.isInstalled("B", "1.0.0"));
        this.remove("6.0", "dropins", "A_1.0.0.jar");
        this.reconcile("6.1");
        BasicTests.assertFalse((String)"6.2", (boolean)this.isInstalled("A", "1.0.0"));
    }

    public void test_p2Repo() {
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("0.1", "zzz");
        BasicTests.assertFalse((String)"0.2", (boolean)this.isInstalled("zFeature", "1.0.0"));
        File source = BasicTests.getTestData("1.0", "testData/reconciler/basicRepo.jar");
        this.add("1.1", "dropins", source);
        this.reconcile("2.0");
        this.assertExistsInBundlesInfo("3.0", "zzz");
        BasicTests.assertTrue((String)"3.1", (boolean)this.isInstalled("zzz", "1.0.0"));
        BasicTests.assertTrue((String)"3.2", (boolean)this.isInstalled("zFeature.feature.group", "1.0.0"));
        IInstallableUnit unit = this.getRemoteIU("zzz", "1.0.0");
        BasicTests.assertEquals((String)"3.3", (String)"foo", (String)unit.getProperty("test"));
        this.remove("4.0", "dropins", "basicRepo.jar");
        this.reconcile("4.1");
        this.assertDoesNotExistInBundlesInfo("4.2", "zzz");
        BasicTests.assertFalse((String)"4.3", (boolean)this.isInstalled("zzz", "1.0.0"));
        BasicTests.assertFalse((String)"4.4", (boolean)this.isInstalled("zFeature.feature.group", "1.0.0"));
    }

    public void testDisabledBundleInLink() {
        this.assertInitialized();
        File link = BasicTests.getTestData("1.0", "testData/reconciler/link");
        File temp = this.getTempFolder();
        toRemove.add(temp);
        BasicTests.copy("1.1", link, temp);
        String linkFilename = BasicTests.getUniqueString();
        this.createLinkFile("1.2", linkFilename, temp.getAbsolutePath());
        this.reconcile("2.0");
        this.assertDoesNotExistInBundlesInfo("3.0", "bbb");
        BasicTests.assertFalse((String)"3.1", (boolean)this.isInstalled("bbb", "1.0.0"));
        this.assertExistsInBundlesInfo("3.3", "ccc");
        BasicTests.assertTrue((String)"3.4", (boolean)this.isInstalled("ccc", "1.0.0"));
        this.removeLinkFile("4.0", linkFilename);
        this.reconcile("4.1");
        this.assertDoesNotExistInBundlesInfo("5.0", "bbb");
        BasicTests.assertFalse((String)"5.1", (boolean)this.isInstalled("bbb", "1.0.0"));
        this.assertDoesNotExistInBundlesInfo("5.3", "ccc");
        BasicTests.assertFalse((String)"5.4", (boolean)this.isInstalled("ccc", "1.0.0"));
    }
}

