/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.reconciler.dropins;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.equinox.internal.p2.reconciler.dropins.Activator;
import org.eclipse.equinox.internal.p2.reconciler.dropins.ProfileSynchronizer;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;

public class ProfileSynchronizerTest2
extends AbstractProvisioningTest {
    private IProfile sdkProfile;
    private IProvisioningAgent agent;
    private IProfileRegistry registry;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.initializeReconciler();
        File tmpFolder = this.getTempFolder();
        ProfileSynchronizerTest2.copy("copying initialProfile", ProfileSynchronizerTest2.getTestData("p2 folder for synchronizer test", "testData/profileSynchronizerTest2/"), tmpFolder);
        this.agent = ProfileSynchronizerTest2.getAgentProvider().createAgent(new File(tmpFolder, "p2").toURI());
        this.registry = (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
        IEngine engine = (IEngine)this.agent.getService(IEngine.SERVICE_NAME);
        this.sdkProfile = this.registry.getProfile("SDKProfile");
        IProvisioningPlan plan = engine.createPlan(this.sdkProfile, null);
        File installFolder = this.getTempFolder();
        plan.setProfileProperty("org.eclipse.equinox.p2.installFolder", installFolder.getAbsolutePath());
        plan.setProfileProperty("org.eclipse.equinox.p2.cache", installFolder.getAbsolutePath());
        engine.perform(plan, null);
    }

    public void testRemovalOfStrictRoot() throws IllegalArgumentException {
        Set oldRoots = this.sdkProfile.query((IQuery)new IUProfilePropertyQuery("org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString()), null).toUnmodifiableSet();
        ProfileSynchronizerTest2.assertFalse((String)"could not find gmf", (boolean)this.sdkProfile.query(QueryUtil.createIUQuery((String)"org.eclipse.gmf.sdk.feature.group"), null).isEmpty());
        ProfileSynchronizer sync = new ProfileSynchronizer(this.agent, this.sdkProfile, new ArrayList());
        sync.synchronize(null);
        Set newRoots = this.registry.getProfile("SDKProfile").query((IQuery)new IUProfilePropertyQuery("org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString()), null).toSet();
        newRoots.removeAll(oldRoots);
        ProfileSynchronizerTest2.assertEquals((int)0, (int)newRoots.size());
        ProfileSynchronizerTest2.assertTrue((String)"gmf should not be there", (boolean)this.registry.getProfile("SDKProfile").query(QueryUtil.createIUQuery((String)"org.eclipse.gmf.sdk.feature.group"), null).isEmpty());
    }

    private void initializeReconciler() throws IllegalAccessException {
        Field[] fields = Activator.class.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals("bundleContext")) {
                fields[i].setAccessible(true);
                fields[i].set(Activator.class, TestActivator.getContext());
                break;
            }
            ++i;
        }
    }
}

