/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.reconciler.dropins;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import junit.framework.Test;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.p2.tests.reconciler.dropins.ReconcilerTestSuite;
import org.eclipse.equinox.p2.tests.reconciler.dropins.SharedInstallTestsProfileSpoofEnabled;
import org.eclipse.equinox.p2.tests.sharedinstall.AbstractSharedInstallTest;

public class SharedInstallTestsProfileSpoofEnabledConfigured
extends SharedInstallTestsProfileSpoofEnabled {
    private File extensions;

    public static Test suite() {
        ReconcilerTestSuite suite = new ReconcilerTestSuite();
        suite.setName(SharedInstallTestsProfileSpoofEnabledConfigured.class.getName());
        suite.addTest((Test)new SharedInstallTestsProfileSpoofEnabledConfigured("testBasicStartup"));
        suite.addTest((Test)new SharedInstallTestsProfileSpoofEnabledConfigured("testReadOnlyDropinsStartup"));
        suite.addTest((Test)new SharedInstallTestsProfileSpoofEnabledConfigured("testUserDropinsStartup"));
        return suite;
    }

    public SharedInstallTestsProfileSpoofEnabledConfigured(String name) {
        super(name);
    }

    public void reconcileReadOnly(String message, File extensions) {
        this.reconcileReadOnly(message, extensions, false);
    }

    public void reconcileReadOnly(String message, File extensions, boolean debug) {
        File root = new File(Activator.getBundleContext().getProperty("java.home"));
        File exe = new File(root = new File(root, "bin"), "javaw.exe");
        if (!exe.exists()) {
            exe = new File(root, "java");
        }
        String configuration = new File(userBase, "configuration").getAbsolutePath();
        String[] command = !debug ? (extensions != null ? new String[]{new File(output, String.valueOf(SharedInstallTestsProfileSpoofEnabledConfigured.getExeFolder()) + "eclipse").getAbsolutePath(), "--launcher.suppressErrors", "-debug", "-consolelog", "-nosplash", "-application", "org.eclipse.equinox.p2.reconciler.application", "-configuration", configuration, "-vm", exe.getAbsolutePath(), "-vmArgs", "-Dosgi.checkConfiguration=true", "-Dp2.fragments=" + extensions.toString()} : new String[]{new File(output, String.valueOf(SharedInstallTestsProfileSpoofEnabledConfigured.getExeFolder()) + "eclipse").getAbsolutePath(), "--launcher.suppressErrors", "-debug", "-consolelog", "-nosplash", "-application", "org.eclipse.equinox.p2.reconciler.application", "-configuration", configuration, "-vm", exe.getAbsolutePath(), "-vmArgs", "-Dosgi.checkConfiguration=true"}) : (extensions != null ? new String[]{new File(output, String.valueOf(SharedInstallTestsProfileSpoofEnabledConfigured.getExeFolder()) + "eclipse").getAbsolutePath(), "--launcher.suppressErrors", "-debug", "-consolelog", "-nosplash", "-application", "org.eclipse.equinox.p2.reconciler.application", "-configuration", configuration, "-vm", exe.getAbsolutePath(), "-vmArgs", "-Dosgi.checkConfiguration=true", "-Dp2.fragments=" + extensions.toString(), "-Xdebug", "-Xrunjdwp:transport=dt_socket,address=8000,server=y,suspend=y"} : new String[]{new File(output, String.valueOf(SharedInstallTestsProfileSpoofEnabledConfigured.getExeFolder()) + "eclipse").getAbsolutePath(), "--launcher.suppressErrors", "-debug", "-consolelog", "-nosplash", "-application", "org.eclipse.equinox.p2.reconciler.application", "-configuration", configuration, "-vm", exe.getAbsolutePath(), "-vmArgs", "-Dosgi.checkConfiguration=true", "-Xdebug", "-Xrunjdwp:transport=dt_socket,address=8000,server=y,suspend=y"});
        SharedInstallTestsProfileSpoofEnabledConfigured.run(message, command);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.extensions = this.getTempFolder();
        SharedInstallTestsProfileSpoofEnabledConfigured.copy("", SharedInstallTestsProfileSpoofEnabledConfigured.getTestData("", "testData/reconciler/extensions/ext1"), this.extensions);
        SharedInstallTestsProfileSpoofEnabledConfigured.setReadOnly(this.extensions, true);
        AbstractSharedInstallTest.reallyReadOnly(this.extensions);
    }

    @Override
    protected void tearDown() throws Exception {
        AbstractSharedInstallTest.removeReallyReadOnly(this.extensions);
        SharedInstallTestsProfileSpoofEnabledConfigured.setReadOnly(this.extensions, false);
        this.extensions.delete();
        super.tearDown();
    }

    @Override
    public void testBasicStartup() throws IOException {
        this.assertInitialized();
        this.setupReadOnlyInstall();
        try {
            File userBundlesInfo = new File(userBase, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
            File userConfigIni = new File(userBase, "configuration/config.ini");
            SharedInstallTestsProfileSpoofEnabledConfigured.assertFalse((String)"0.1", (boolean)userBundlesInfo.exists());
            SharedInstallTestsProfileSpoofEnabledConfigured.assertFalse((String)"0.2", (boolean)userConfigIni.exists());
            this.reconcileReadOnly("0.21", this.extensions);
            SharedInstallTestsProfileSpoofEnabledConfigured.assertFalse((String)"0.3", (boolean)userBundlesInfo.exists());
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((String)"0.4", (boolean)userConfigIni.exists());
            Properties props = new Properties();
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(userConfigIni));){
                props.load(is);
            }
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((String)"0.5", (boolean)props.containsKey("osgi.sharedConfiguration.area"));
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((String)"0.6", (props.size() == 1 ? 1 : 0) != 0);
        }
        finally {
            SharedInstallTestsProfileSpoofEnabledConfigured.cleanupReadOnlyInstall();
        }
    }

    @Override
    public void testReadOnlyDropinsStartup() throws IOException {
        if (Platform.getOS().equals("macosx")) {
            return;
        }
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("0.1", "myBundle");
        File jar = SharedInstallTestsProfileSpoofEnabledConfigured.getTestData("2.0", "testData/reconciler/plugins/myBundle_1.0.0.jar");
        this.add("0.2", "dropins", jar);
        this.setupReadOnlyInstall();
        try {
            File userBundlesInfo = new File(userBase, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
            File userConfigIni = new File(userBase, "configuration/config.ini");
            SharedInstallTestsProfileSpoofEnabledConfigured.assertFalse((String)"0.1", (boolean)userBundlesInfo.exists());
            SharedInstallTestsProfileSpoofEnabledConfigured.assertFalse((String)"0.2", (boolean)userConfigIni.exists());
            this.reconcileReadOnly("0.21", this.extensions);
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((String)"0.3", (boolean)userBundlesInfo.exists());
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((String)"0.4", (boolean)userConfigIni.exists());
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((boolean)this.isInBundlesInfo(userBundlesInfo, "myBundle", null));
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((boolean)this.isInBundlesInfo(userBundlesInfo, "zzz", null));
            SharedInstallTestsProfileSpoofEnabledConfigured.setReadOnly(readOnlyBase, false);
            AbstractSharedInstallTest.removeReallyReadOnly(readOnlyBase);
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((String)"0.7", (boolean)readOnlyBase.canWrite());
            this.remove("1.0", "dropins", "myBundle_1.0.0.jar");
            SharedInstallTestsProfileSpoofEnabledConfigured.setReadOnly(readOnlyBase, true);
            AbstractSharedInstallTest.reallyReadOnly(readOnlyBase);
            this.reconcileReadOnly("0.21", this.extensions, false);
            SharedInstallTestsProfileSpoofEnabledConfigured.assertFalse((boolean)this.isInBundlesInfo(userBundlesInfo, "myBundle", null));
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((boolean)this.isInBundlesInfo(userBundlesInfo, "zzz", null));
            this.reconcileReadOnly("0.2105", null, false);
            SharedInstallTestsProfileSpoofEnabledConfigured.setReadOnly(readOnlyBase, false);
            AbstractSharedInstallTest.removeReallyReadOnly(readOnlyBase);
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((String)"0.7", (boolean)readOnlyBase.canWrite());
            this.add("0.211", "dropins", jar);
            SharedInstallTestsProfileSpoofEnabledConfigured.setReadOnly(readOnlyBase, true);
            AbstractSharedInstallTest.reallyReadOnly(readOnlyBase);
            this.reconcileReadOnly("0.22", null, false);
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((boolean)this.isInBundlesInfo(userBundlesInfo, "myBundle", null));
            SharedInstallTestsProfileSpoofEnabledConfigured.assertFalse((boolean)this.isInBundlesInfo(userBundlesInfo, "zzz", null));
        }
        finally {
            SharedInstallTestsProfileSpoofEnabledConfigured.cleanupReadOnlyInstall();
            this.remove("1.0", "dropins", "myBundle_1.0.0.jar");
        }
    }

    @Override
    public void testUserDropinsStartup() throws IOException {
        if (Platform.getOS().equals("macosx")) {
            return;
        }
        this.assertInitialized();
        this.assertDoesNotExistInBundlesInfo("0.1", "myBundle");
        File jar = SharedInstallTestsProfileSpoofEnabledConfigured.getTestData("2.0", "testData/reconciler/plugins/myBundle_1.0.0.jar");
        File dropins = new File(userBase, "dropins");
        this.setupReadOnlyInstall();
        try {
            dropins.mkdir();
            SharedInstallTestsProfileSpoofEnabledConfigured.copy("copying to dropins", jar, new File(dropins, jar.getName()));
            File userBundlesInfo = new File(userBase, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
            File userConfigIni = new File(userBase, "configuration/config.ini");
            SharedInstallTestsProfileSpoofEnabledConfigured.assertFalse((String)"0.1", (boolean)userBundlesInfo.exists());
            SharedInstallTestsProfileSpoofEnabledConfigured.assertFalse((String)"0.2", (boolean)userConfigIni.exists());
            this.reconcileReadOnly("0.21", this.extensions);
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((String)"0.3", (boolean)userBundlesInfo.exists());
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((String)"0.4", (boolean)userConfigIni.exists());
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((boolean)this.isInBundlesInfo(userBundlesInfo, "myBundle", null));
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((boolean)this.isInBundlesInfo(userBundlesInfo, "zzz", null));
            SharedInstallTestsProfileSpoofEnabledConfigured.delete(dropins);
            this.reconcileReadOnly("0.21", this.extensions);
            SharedInstallTestsProfileSpoofEnabledConfigured.assertFalse((boolean)this.isInBundlesInfo(userBundlesInfo, "myBundle", null));
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((boolean)this.isInBundlesInfo(userBundlesInfo, "zzz", null));
            this.reconcileReadOnly("0.2105", null, false);
            dropins.mkdir();
            SharedInstallTestsProfileSpoofEnabledConfigured.copy("copying to dropins", jar, new File(dropins, jar.getName()));
            this.reconcileReadOnly("0.22", null, false);
            SharedInstallTestsProfileSpoofEnabledConfigured.assertTrue((boolean)this.isInBundlesInfo(userBundlesInfo, "myBundle", null));
            SharedInstallTestsProfileSpoofEnabledConfigured.assertFalse((boolean)this.isInBundlesInfo(userBundlesInfo, "zzz", null));
        }
        finally {
            SharedInstallTestsProfileSpoofEnabledConfigured.delete(dropins);
            SharedInstallTestsProfileSpoofEnabledConfigured.cleanupReadOnlyInstall();
        }
    }
}

