/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.repository;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CacheManagerTest
extends TestCase {
    private static final int ONE_HOUR = 3600000;
    private URI repositoryLocation;
    private File contentXmlFile;
    private CacheManager cacheManager;
    private final String cachePrefix = "content";

    protected void setUp() throws Exception {
        this.repositoryLocation = this.createRepistory();
        BundleContext bundle = Platform.getBundle((String)"org.eclipse.equinox.p2.repository").getBundleContext();
        ServiceReference serviceReference = bundle.getServiceReference(IProvisioningAgentProvider.class);
        IProvisioningAgentProvider agentServiceFactory = (IProvisioningAgentProvider)bundle.getService(serviceReference);
        IProvisioningAgent agent = agentServiceFactory.createAgent(this.repositoryLocation);
        Transport transport = (Transport)agent.getService(Transport.SERVICE_NAME);
        this.cacheManager = new CacheManager((IAgentLocation)new AgentLocationMock(), transport);
    }

    protected void tearDown() throws Exception {
        Path repositoryLocationPath = new Path(this.repositoryLocation.getPath());
        this.deleteFileOrDirectory(repositoryLocationPath.toFile());
    }

    public void testRepositoryDowngraded() throws ProvisionException, IOException {
        File cache = this.cacheManager.createCache(this.repositoryLocation, "content", (IProgressMonitor)new NullProgressMonitor());
        long lastModifiedInitial = cache.lastModified();
        long lastModifiedContent = this.contentXmlFile.lastModified();
        this.contentXmlFile.setLastModified(lastModifiedContent - 3600000L);
        File cache2 = this.cacheManager.createCache(this.repositoryLocation, "content", (IProgressMonitor)new NullProgressMonitor());
        CacheManagerTest.assertFalse((String)"Cache haven't been updated after repository downgrade", (lastModifiedInitial == cache2.lastModified() ? 1 : 0) != 0);
    }

    public void testClientDifferentTimeZone() throws ProvisionException, IOException {
        File cache = this.cacheManager.createCache(this.repositoryLocation, "content", (IProgressMonitor)new NullProgressMonitor());
        long lastModifiedInitial = cache.lastModified();
        this.contentXmlFile.setLastModified(this.contentXmlFile.lastModified() + 1800000L);
        cache.setLastModified(lastModifiedInitial + 3600000L);
        File cache2 = this.cacheManager.createCache(this.repositoryLocation, "content", (IProgressMonitor)new NullProgressMonitor());
        CacheManagerTest.assertFalse((String)"Cache haven't been updated after repository update", (lastModifiedInitial + 3600000L == cache2.lastModified() ? 1 : 0) != 0);
    }

    public void testRepositoryUpdate() throws ProvisionException, IOException {
        File cache = this.cacheManager.createCache(this.repositoryLocation, "content", (IProgressMonitor)new NullProgressMonitor());
        long lastModifiedInitial = cache.lastModified();
        long lastModifiedContent = this.contentXmlFile.lastModified();
        this.contentXmlFile.setLastModified(lastModifiedContent + 3600000L);
        File cache2 = this.cacheManager.createCache(this.repositoryLocation, "content", (IProgressMonitor)new NullProgressMonitor());
        CacheManagerTest.assertFalse((String)"Cache haven't been updated after repository update", (lastModifiedInitial == cache2.lastModified() ? 1 : 0) != 0);
    }

    private URI createRepistory() throws IOException {
        File repository = File.createTempFile("remoteFile", "");
        repository.deleteOnExit();
        CacheManagerTest.assertTrue((boolean)repository.delete());
        CacheManagerTest.assertTrue((boolean)repository.mkdirs());
        IPath contentXmlPath = new Path(repository.getAbsolutePath()).append("content.xml");
        CacheManagerTest.assertTrue((boolean)contentXmlPath.toFile().createNewFile());
        this.contentXmlFile = contentXmlPath.toFile();
        return repository.toURI();
    }

    private void deleteFileOrDirectory(File path) {
        if (path.exists()) {
            if (path.isDirectory()) {
                this.handleDirectory(path);
            } else {
                CacheManagerTest.assertTrue((boolean)path.delete());
            }
        }
    }

    private void handleDirectory(File path) {
        File[] files;
        File[] fileArray = files = path.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.deleteFileOrDirectory(file);
            } else {
                CacheManagerTest.assertTrue((boolean)file.delete());
            }
            ++n2;
        }
    }

    private class AgentLocationMock
    implements IAgentLocation {
        private AgentLocationMock() {
        }

        public URI getDataArea(String namespace) {
            return CacheManagerTest.this.repositoryLocation;
        }

        public URI getRootLocation() {
            return null;
        }
    }
}

