/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.repository;

import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.testserver.helper.AbstractTestServerClientCase;

public class NTLMTest
extends AbstractTestServerClientCase {
    private IMetadataRepositoryManager mgr;
    private URI repoLoc;
    protected String authTestFailMessage;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.mgr = (IMetadataRepositoryManager)NTLMTest.getAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (this.mgr == null) {
            throw new RuntimeException("Repository manager could not be loaded");
        }
    }

    private void setUpRepo(String repo) throws Exception {
        this.repoLoc = new URI(repo);
        this.mgr.removeRepository(this.repoLoc);
        if (this.mgr.contains(this.repoLoc)) {
            throw new RuntimeException("Error - An earlier test did not leave a clean state - could not remove repo");
        }
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.repoLoc != null) {
            this.mgr.removeRepository(this.repoLoc);
        }
    }

    public void test477Status() throws ProvisionException, Exception {
        this.setUpRepo(String.valueOf(super.getBaseURL()) + "/status/477");
        try {
            this.mgr.loadRepository(this.repoLoc, null);
        }
        catch (OperationCanceledException operationCanceledException) {
            NTLMTest.fail((String)"The repository load was canceled - the UI auth service is probably not running");
        }
        catch (ProvisionException e) {
            IStatus status = e.getStatus();
            String msg = e.getMessage();
            System.out.print(String.format("HTTP 477 => %s e-message: [%s]\n", NTLMTest.provisionCodeToText(status.getCode()), msg));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NTLMTest.assertFalse((String)"Repository should not have been added", (boolean)this.mgr.contains(this.repoLoc));
    }

    private static String provisionCodeToText(int code) {
        String msg = "REPOSITORY_";
        switch (code) {
            case 1001: {
                return String.valueOf(msg) + "EXISTS";
            }
            case 1007: {
                return String.valueOf(msg) + "FAILED_AUTHENTICATION";
            }
            case 1002: {
                return String.valueOf(msg) + "FAILED_READ";
            }
            case 1003: {
                return String.valueOf(msg) + "FAILED_WRITE";
            }
            case 1006: {
                return String.valueOf(msg) + "INVALID_LOCATION";
            }
            case 1000: {
                return String.valueOf(msg) + "NOT_FOUND";
            }
            case 1004: {
                return String.valueOf(msg) + "READ_ONLY";
            }
            case 1005: {
                return String.valueOf(msg) + "UNKNOWN_TYPE";
            }
        }
        return String.valueOf(msg) + String.format("<unrecognized error code: %d >", code);
    }
}

