/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.sharedinstall;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import junit.framework.Test;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.p2.tests.reconciler.dropins.ReconcilerTestSuite;
import org.eclipse.equinox.p2.tests.sharedinstall.BaseChange;

public class BaseChangeExtendedConflicts
extends BaseChange {
    private File extensions;

    public static Test suite() {
        ReconcilerTestSuite suite = new ReconcilerTestSuite();
        suite.setName(BaseChangeExtendedConflicts.class.getName());
        suite.addTest((Test)new BaseChangeExtendedConflicts("testBundlesSpecifiedMultipleTimes"));
        return suite;
    }

    public BaseChangeExtendedConflicts(String name) {
        super(name);
    }

    protected void realExecuteVerifier(Properties verificationProperties, boolean withConfigFlag, File ... extensions) {
        File verifierConfig = new File(this.getTempFolder(), "verification.properties");
        try {
            BaseChangeExtendedConflicts.writeProperties(verifierConfig, verificationProperties);
        }
        catch (IOException e) {
            BaseChangeExtendedConflicts.fail("Failing to write out properties to configure verifier", e);
        }
        String[] args = null;
        args = withConfigFlag ? new String[]{"-configuration", String.valueOf(userBase.getAbsolutePath()) + File.separatorChar + "configuration", "-application", "org.eclipse.equinox.p2.tests.verifier.application", "-verifier.properties", verifierConfig.getAbsolutePath(), "-consoleLog"} : new String[]{"-application", "org.eclipse.equinox.p2.tests.verifier.application", "-verifier.properties", verifierConfig.getAbsolutePath(), "-consoleLog"};
        BaseChangeExtendedConflicts.assertEquals((int)0, (int)this.runEclipse("Running verifier", output, args, extensions));
    }

    protected void executeVerifier(Properties verificationProperties, File ... extensions) {
        this.realExecuteVerifier(verificationProperties, true, extensions);
    }

    protected int runEclipse(String message, File location, String[] args, File ... extensions) {
        int result;
        File root = new File(Activator.getBundleContext().getProperty("java.home"));
        File exe = new File(root = new File(root, "bin"), "javaw.exe");
        if (!exe.exists()) {
            exe = new File(root, "java");
        }
        BaseChangeExtendedConflicts.assertTrue((String)("Java executable not found in: " + exe.getAbsolutePath()), (boolean)exe.exists());
        ArrayList command = new ArrayList();
        Collections.addAll(command, new File(location == null ? output : location, String.valueOf(BaseChangeExtendedConflicts.getExeFolder()) + "eclipse").getAbsolutePath(), "--launcher.suppressErrors", "-nosplash", "-vm", exe.getAbsolutePath());
        Collections.addAll(command, args);
        Collections.addAll(command, "-vmArgs", "-Dosgi.checkConfiguration=true");
        if (extensions != null) {
            String extensionParameter = "";
            File[] fileArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                extensionParameter = String.valueOf(extensionParameter) + f.toString() + ",";
                ++n2;
            }
            extensionParameter = extensionParameter.substring(0, extensionParameter.length() - 1);
            Collections.addAll(command, "-Dp2.fragments=" + extensionParameter);
        }
        if (this.debug) {
            Collections.addAll(command, "-Xdebug", "-Xnoagent", "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=8000");
        }
        if ((result = BaseChangeExtendedConflicts.run(message, command.toArray(new String[command.size()]))) == 13) {
            this.parseExitdata(message);
        }
        return result;
    }

    protected void installFeature1AndVerifierInUser(File ... extension) {
        this.runEclipse("Installing in user", output, new String[]{"-configuration", String.valueOf(userBase.getAbsolutePath()) + File.separatorChar + "configuration", "-application", "org.eclipse.equinox.p2.director", "-installIU", "p2TestFeature1.feature.group,Verifier.feature.group", "-repository", this.getTestRepo()}, extension);
    }

    protected void installFeature2InUser(File ... extension) {
        this.runEclipse("user2", output, new String[]{"-configuration", String.valueOf(userBase.getAbsolutePath()) + File.separatorChar + "configuration", "-application", "org.eclipse.equinox.p2.director", "-installIU", "p2TestFeature2.feature.group", "-repository", this.getTestRepo()}, extension);
    }

    @Override
    protected void installVerifierInBase() {
        BaseChangeExtendedConflicts.setReadOnly(readOnlyBase, false);
        this.runEclipse("Running eclipse", output, new String[]{"-application", "org.eclipse.equinox.p2.director", "-installIU", "Verifier.feature.group", "-repository", this.getTestRepo()});
        BaseChangeExtendedConflicts.setReadOnly(readOnlyBase, true);
    }

    @Override
    protected void tearDown() throws Exception {
        BaseChangeExtendedConflicts.setReadOnly(this.extensions, false);
        this.extensions.delete();
        super.tearDown();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.extensions = this.getTestFolder("ext");
        BaseChangeExtendedConflicts.copy("", BaseChangeExtendedConflicts.getTestData("", "testData/reconciler/extensions/ext1"), this.extensions);
        BaseChangeExtendedConflicts.setReadOnly(this.extensions, true);
    }

    public void testBundlesSpecifiedMultipleTimes() {
        this.assertInitialized();
        BaseChangeExtendedConflicts.setupReadOnlyInstall();
        this.installFeature1AndVerifierInUser(this.extensions, this.extensions);
        Properties verificationProperties = new Properties();
        verificationProperties.setProperty("expectedBundleList", "p2TestBundle1,org.eclipse.equinox.p2.tests.verifier,zzz");
        verificationProperties.setProperty("checkProfileResetFlag", "false");
        verificationProperties.setProperty("not.sysprop.eclipse.ignoreUserConfiguration", "");
        this.executeVerifier(verificationProperties, this.extensions);
        BaseChangeExtendedConflicts.assertTrue((boolean)this.isInUserBundlesInfo("p2TestBundle1"));
        BaseChangeExtendedConflicts.assertTrue((boolean)this.isInUserBundlesInfo("zzz"));
        this.assertProfileStatePropertiesHasKey(this.getUserProfileFolder(), "_simpleProfileRegistry_internal_" + this.getMostRecentProfileTimestampFromBase());
        this.installVerifierInBase();
        verificationProperties = new Properties();
        verificationProperties.setProperty("checkPresenceOfVerifier", "true");
        verificationProperties.setProperty("unexpectedBundleList", "p2TestBundle1,yyy");
        verificationProperties.setProperty("checkPresenceOfVerifier", "false");
        verificationProperties.setProperty("expectedBundleList", "org.eclipse.equinox.p2.tests.verifier,zzz");
        verificationProperties.setProperty("checkProfileResetFlag", "false");
        verificationProperties.setProperty("checkMigrationWizard", "true");
        verificationProperties.setProperty("checkMigrationWizard.open", "true");
        this.executeVerifier(verificationProperties, this.extensions, this.extensions);
        BaseChangeExtendedConflicts.assertTrue((boolean)this.isInUserBundlesInfo("p2TestBundle1"));
        this.assertProfileStatePropertiesHasKey(this.getUserProfileFolder(), "_simpleProfileRegistry_internal_" + this.getMostRecentProfileTimestampFromBase());
        verificationProperties = new Properties();
        verificationProperties.setProperty("checkProfileResetFlag", "false");
        verificationProperties.setProperty("checkPresenceOfVerifier", "false");
        verificationProperties.setProperty("expectedBundleList", "org.eclipse.equinox.p2.tests.verifier,zzz");
        this.executeVerifier(verificationProperties, this.extensions, this.extensions);
        this.installFeature2InUser(this.extensions, this.extensions);
        verificationProperties = new Properties();
        verificationProperties.setProperty("expectedBundleList", "org.eclipse.equinox.p2.tests.verifier,zzz,p2TestBundle2");
        this.executeVerifier(verificationProperties, this.extensions, this.extensions);
        BaseChangeExtendedConflicts.assertFalse((boolean)this.isInUserBundlesInfo("p2TestBundle1"));
        BaseChangeExtendedConflicts.assertTrue((boolean)this.isInUserBundlesInfo("p2TestBundle2"));
        BaseChangeExtendedConflicts.assertTrue((boolean)this.isInUserBundlesInfo("org.eclipse.equinox.p2.tests.verifier"));
        BaseChangeExtendedConflicts.assertTrue((boolean)this.isInUserBundlesInfo("zzz"));
        verificationProperties.setProperty("expectedBundleList", "org.eclipse.equinox.p2.tests.verifier,zzz,p2TestBundle2");
        this.executeVerifier(verificationProperties, this.extensions, this.extensions);
        Properties newVerificationProperties = new Properties();
        newVerificationProperties.setProperty("expectedBundleList", "org.eclipse.equinox.p2.tests.verifier");
        newVerificationProperties.setProperty("unexpectedBundleList", "zzz,p2TestBundle2,p2TestBundle1");
        this.executeVerifier(newVerificationProperties);
        verificationProperties.setProperty("expectedBundleList", "org.eclipse.equinox.p2.tests.verifier,zzz,p2TestBundle2,");
        verificationProperties.setProperty("unexpectedBundleList", "p2TestBundle1");
        this.executeVerifier(verificationProperties, this.extensions, this.extensions);
    }
}

