/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.InstallBundleAction;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class InstallBundleActionTest
extends AbstractProvisioningTest {
    public InstallBundleActionTest(String name) {
        super(name);
    }

    public InstallBundleActionTest() {
        super("");
    }

    public void testExecuteUndo() throws Exception {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.setProperty("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)InstallBundleActionTest.getAgent(), (IProfile)profile);
        File osgiSource = InstallBundleActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        InstallBundleActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        InstallBundleActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor);
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", InstallBundleActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("bundle", key.toString());
        parameters = Collections.unmodifiableMap(parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        InstallBundleActionTest.assertNotNull((Object)manipulator);
        InstallBundleActionTest.assertFalse((boolean)this.inBundles(manipulator, osgiTarget));
        InstallBundleAction action = new InstallBundleAction();
        action.execute(parameters);
        InstallBundleActionTest.assertTrue((boolean)this.inBundles(manipulator, osgiTarget));
        action.undo(parameters);
        InstallBundleActionTest.assertFalse((boolean)this.inBundles(manipulator, osgiTarget));
    }

    private boolean inBundles(Manipulator manipulator, File osgiTarget) {
        URI location = osgiTarget.toURI();
        BundleInfo[] bundles = manipulator.getConfigData().getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (location.equals(bundles[i].getLocation())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

