/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.LinkAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class LinkActionTest
extends AbstractProvisioningTest {
    public LinkActionTest(String name) {
        super(name);
    }

    public LinkActionTest() {
        super("");
    }

    public void testExecuteUndo() {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        File zipSource = LinkActionTest.getTestData("1.0", "/testData/nativeTouchpoint/a.zip");
        File zipTarget = new File(installFolder, "a.zip");
        LinkActionTest.copy("2.0", zipSource, zipTarget);
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", LinkActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        parameters.put("targetDir", installFolder.getAbsolutePath());
        parameters.put("linkName", "b.zip");
        parameters.put("linkTarget", zipTarget.getAbsolutePath());
        parameters = Collections.unmodifiableMap(parameters);
        LinkAction action = new LinkAction();
        action.execute(parameters);
        action.undo(parameters);
    }

    public void testExecuteUndoWithArtifact() throws Exception {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.setProperty("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)LinkActionTest.getAgent(), (IProfile)profile);
        File dirBundleSource = LinkActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/directoryBased_1.0.0");
        File targetPlugins = new File(installFolder, "plugins");
        LinkActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File dirBundleTarget = new File(targetPlugins, "directoryBased_1.0.0");
        LinkActionTest.copy("2.0", dirBundleSource, dirBundleTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)dirBundleTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        ArtifactDescriptor descriptor = (ArtifactDescriptor)PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)dirBundleTarget);
        descriptor.setProperty("artifact.folder", Boolean.TRUE.toString());
        IInstallableUnit iu = this.createBundleIU(bundleDescription, dirBundleTarget.isDirectory(), key);
        bundlePool.addDescriptor((IArtifactDescriptor)descriptor);
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", LinkActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        parameters.put("artifact", key);
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("targetDir", "@artifact");
        parameters.put("linkName", "plugin.xml.link");
        parameters.put("linkTarget", "plugin.xml");
        parameters = Collections.unmodifiableMap(parameters);
        LinkAction action = new LinkAction();
        action.execute(parameters);
        action.undo(parameters);
    }

    public void testExecuteUndoWithArtifactLocation() throws Exception {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.setProperty("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)LinkActionTest.getAgent(), (IProfile)profile);
        File dirBundleSource = LinkActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/directoryBased_1.0.0");
        File targetPlugins = new File(installFolder, "plugins");
        LinkActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File dirBundleTarget = new File(targetPlugins, "directoryBased_1.0.0");
        LinkActionTest.copy("2.0", dirBundleSource, dirBundleTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)dirBundleTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        ArtifactDescriptor descriptor = (ArtifactDescriptor)PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)dirBundleTarget);
        descriptor.setProperty("artifact.folder", Boolean.TRUE.toString());
        IInstallableUnit iu = this.createBundleIU(bundleDescription, dirBundleTarget.isDirectory(), key);
        bundlePool.addDescriptor((IArtifactDescriptor)descriptor);
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", LinkActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        parameters.put("artifact", key);
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("targetDir", parameters.get("artifact.location"));
        parameters.put("linkName", "plugin.xml.link");
        parameters.put("linkTarget", "plugin.xml");
        parameters = Collections.unmodifiableMap(parameters);
        LinkAction action = new LinkAction();
        action.execute(parameters);
        action.undo(parameters);
    }
}

