/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.RemoveRepositoryAction;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class RemoveRepositoryActionTest
extends AbstractProvisioningTest {
    private static final String TEST_LOCATION = "http://eclipse.org/eclipse/updates/RemoveRepositoryActionTest";
    RemoveRepositoryAction action;
    private URI locationURI;

    private Map getValidArguments() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("agent", RemoveRepositoryActionTest.getAgent());
        args.put("location", TEST_LOCATION);
        args.put("type", Integer.toString(1));
        args.put("enabled", "true");
        return args;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.locationURI = new URI(TEST_LOCATION);
        this.action = new RemoveRepositoryAction();
        RemoveRepositoryActionTest.getArtifactRepositoryManager().addRepository(this.locationURI);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        RemoveRepositoryActionTest.getArtifactRepositoryManager().removeRepository(this.locationURI);
    }

    public void testInvalidEnablement() {
        Map args = this.getValidArguments();
        args.put("enabled", "bogus enablement");
        IStatus result = this.action.execute(args);
        RemoveRepositoryActionTest.assertTrue((String)"1.0", (boolean)result.isOK());
        RemoveRepositoryActionTest.assertTrue((String)"1.1", (!RemoveRepositoryActionTest.getArtifactRepositoryManager().isEnabled(this.locationURI) ? 1 : 0) != 0);
    }

    public void testInvalidLocation() {
        Map args = this.getValidArguments();
        args.put("location", "bogus location");
        IStatus result = this.action.execute(args);
        RemoveRepositoryActionTest.assertTrue((String)"1.0", (!result.isOK() ? 1 : 0) != 0);
        RemoveRepositoryActionTest.assertTrue((String)"1.1", (boolean)RemoveRepositoryActionTest.getArtifactRepositoryManager().isEnabled(this.locationURI));
    }

    public void testInvalidType() {
        Map args = this.getValidArguments();
        args.put("type", "bogus type");
        IStatus result = this.action.execute(args);
        RemoveRepositoryActionTest.assertTrue((String)"1.0", (!result.isOK() ? 1 : 0) != 0);
        RemoveRepositoryActionTest.assertTrue((String)"1.1", (boolean)RemoveRepositoryActionTest.getArtifactRepositoryManager().isEnabled(this.locationURI));
    }

    public void testNoArguments() {
        IStatus result = this.action.execute(new HashMap());
        RemoveRepositoryActionTest.assertTrue((String)"1.0", (!result.isOK() ? 1 : 0) != 0);
        RemoveRepositoryActionTest.assertTrue((String)"1.1", (boolean)RemoveRepositoryActionTest.getArtifactRepositoryManager().isEnabled(this.locationURI));
    }

    public void testRemoveMetadataRepository() {
        Map args = this.getValidArguments();
        args.put("type", Integer.toString(0));
        RemoveRepositoryActionTest.getMetadataRepositoryManager().addRepository(this.locationURI);
        IStatus result = this.action.execute(args);
        RemoveRepositoryActionTest.assertTrue((String)"1.0", (boolean)result.isOK());
        RemoveRepositoryActionTest.assertTrue((String)"1.1", (!RemoveRepositoryActionTest.getMetadataRepositoryManager().isEnabled(this.locationURI) ? 1 : 0) != 0);
    }

    public void testUndo() {
        Map args = this.getValidArguments();
        IStatus result = this.action.execute(args);
        RemoveRepositoryActionTest.assertTrue((String)"1.0", (boolean)result.isOK());
        RemoveRepositoryActionTest.assertTrue((String)"1.1", (!RemoveRepositoryActionTest.getArtifactRepositoryManager().isEnabled(this.locationURI) ? 1 : 0) != 0);
        result = this.action.undo(args);
        RemoveRepositoryActionTest.assertTrue((String)"2.0", (boolean)result.isOK());
    }

    public void testUndoInvalidArgument() {
        Map args = this.getValidArguments();
        IStatus result = this.action.execute(args);
        RemoveRepositoryActionTest.assertTrue((String)"1.0", (boolean)result.isOK());
        RemoveRepositoryActionTest.assertTrue((String)"1.1", (!RemoveRepositoryActionTest.getArtifactRepositoryManager().isEnabled(this.locationURI) ? 1 : 0) != 0);
        args.put("type", "bogus type");
        result = this.action.undo(args);
        RemoveRepositoryActionTest.assertTrue((String)"2.0", (!result.isOK() ? 1 : 0) != 0);
    }
}

