/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.SetLauncherNameAction;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SetLauncherNameActionTest
extends AbstractProvisioningTest {
    public SetLauncherNameActionTest(String name) {
        super(name);
    }

    public SetLauncherNameActionTest() {
        super("");
    }

    public void testExecuteUndo() {
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", SetLauncherNameActionTest.getAgent());
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        Properties profileProperties = new Properties();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", this.getTempFolder().toString());
        IProfile profile = this.createProfile("test", profileProperties);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, SetLauncherNameActionTest.createIU("test"));
        touchpoint.initializePhase(null, profile, "test", parameters);
        parameters.put("profile", profile);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        SetLauncherNameActionTest.assertNotNull((Object)manipulator);
        String launcherName = "test";
        SetLauncherNameActionTest.assertNotSame((Object)launcherName, (Object)profile.getProperty("eclipse.touchpoint.launcherName"));
        parameters.put("name", launcherName);
        parameters = Collections.unmodifiableMap(parameters);
        SetLauncherNameAction action = new SetLauncherNameAction();
        action.execute(parameters);
        SetLauncherNameActionTest.assertEquals((String)launcherName, (String)profile.getProperty("eclipse.touchpoint.launcherName"));
        action.undo(parameters);
        SetLauncherNameActionTest.assertNotSame((Object)launcherName, (Object)profile.getProperty("eclipse.touchpoint.launcherName"));
    }

    public void testEmptyName() {
        Map<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("agent", SetLauncherNameActionTest.getAgent());
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        File tempFolder = this.getTempFolder();
        Properties profileProperties = new Properties();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", tempFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.environments", "osgi.ws=cocoa,osgi.os=macosx,osgi.arch=x86");
        IProfile profile = this.createProfile("launcherNameProfile", profileProperties);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, SetLauncherNameActionTest.createIU("test"));
        touchpoint.initializePhase(null, profile, "test", parameters);
        parameters.put("profile", profile);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        SetLauncherNameActionTest.assertNotNull((Object)manipulator);
        parameters.put("name", "");
        parameters = Collections.unmodifiableMap(parameters);
        SetLauncherNameAction action = new SetLauncherNameAction();
        action.execute(parameters);
    }

    public void testChangeName() throws Exception {
        File tempFolder = this.getTempFolder();
        Properties profileProperties = new Properties();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", tempFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.environments", "osgi.ws=win32,osgi.os=win32,osgi.arch=x86");
        IProfile profile = this.createProfile("changeNameProfile", profileProperties);
        File eclipseIni = new File(tempFolder, "eclipse.ini");
        StringBuffer ini = new StringBuffer();
        ini.append("-startup\n");
        ini.append("plugins/org.eclipse.equinox.launcher_1.2.4.v1234.jar\n");
        SetLauncherNameActionTest.writeBuffer(eclipseIni, ini);
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", SetLauncherNameActionTest.getAgent());
        InstallableUnitOperand operand = new InstallableUnitOperand(null, SetLauncherNameActionTest.createIU("test"));
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        parameters.put("profile", profile);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("name", "foo");
        parameters = Collections.unmodifiableMap(parameters);
        SetLauncherNameAction action = new SetLauncherNameAction();
        action.execute(parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        File bundle = new File(tempFolder, "plugins/aBundle_1.0.0.jar");
        bundle.getParentFile().mkdirs();
        SetLauncherNameActionTest.copy("1.0", SetLauncherNameActionTest.getTestData("1.1", "/testData/testRepos/simple.1/plugins/aBundle_1.0.0.jar"), bundle);
        manipulator.getConfigData().addBundle(new BundleInfo(bundle.toURI()));
        manipulator.save(false);
        SetLauncherNameActionTest.assertLogContainsLines(new File(tempFolder, "foo.ini"), new String[]{"-startup", "plugins/org.eclipse.equinox.launcher_1.2.4.v1234.jar"});
        SetLauncherNameActionTest.assertFalse((boolean)eclipseIni.exists());
    }
}

