/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.SetStartLevelAction;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class SetStartLevelActionTest
extends AbstractProvisioningTest {
    public SetStartLevelActionTest(String name) {
        super(name);
    }

    public SetStartLevelActionTest() {
        super("");
    }

    public void testExecuteUndo() throws Exception {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.setProperty("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)SetStartLevelActionTest.getAgent(), (IProfile)profile);
        File osgiSource = SetStartLevelActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        SetStartLevelActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        SetStartLevelActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor);
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", SetStartLevelActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("startLevel", "0");
        parameters = Collections.unmodifiableMap(parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        SetStartLevelActionTest.assertNotNull((Object)manipulator);
        BundleInfo bundleInfo = Util.createBundleInfo((File)osgiTarget, (IInstallableUnit)iu);
        manipulator.getConfigData().addBundle(bundleInfo);
        SetStartLevelActionTest.assertTrue((boolean)this.isStartLevel(manipulator, osgiTarget, -1));
        SetStartLevelAction action = new SetStartLevelAction();
        action.execute(parameters);
        SetStartLevelActionTest.assertTrue((boolean)this.isStartLevel(manipulator, osgiTarget, 0));
        action.undo(parameters);
        SetStartLevelActionTest.assertTrue((boolean)this.isStartLevel(manipulator, osgiTarget, -1));
    }

    public void testExecuteUndoWithMissingArtifact() throws Exception {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.setProperty("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)SetStartLevelActionTest.getAgent(), (IProfile)profile);
        File osgiSource = SetStartLevelActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        SetStartLevelActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi_3.4.2.R34x_v20080826-1230.jar");
        SetStartLevelActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor);
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", SetStartLevelActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("startLevel", "0");
        parameters = Collections.unmodifiableMap(parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        SetStartLevelActionTest.assertNotNull((Object)manipulator);
        BundleInfo bundleInfo = Util.createBundleInfo((File)osgiTarget, (IInstallableUnit)iu);
        manipulator.getConfigData().addBundle(bundleInfo);
        SetStartLevelActionTest.assertTrue((boolean)this.isStartLevel(manipulator, osgiTarget, -1));
        bundlePool.removeDescriptor(descriptor);
        SetStartLevelAction action = new SetStartLevelAction();
        action.execute(parameters);
        SetStartLevelActionTest.assertTrue((boolean)this.isStartLevel(manipulator, osgiTarget, 0));
        action.undo(parameters);
        SetStartLevelActionTest.assertTrue((boolean)this.isStartLevel(manipulator, osgiTarget, -1));
    }

    public void testExecuteOnFragmentBundleResultsInBundleNotBeingMarkedStarted() throws Exception {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.setProperty("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)SetStartLevelActionTest.getAgent(), (IProfile)profile);
        File osgiSource = SetStartLevelActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi.fragment_1.0.0.jar");
        File targetPlugins = new File(installFolder, "plugins");
        SetStartLevelActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi.fragment_1.0.0.jar");
        SetStartLevelActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor);
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", SetStartLevelActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("startLevel", "0");
        parameters = Collections.unmodifiableMap(parameters);
        Manipulator manipulator = (Manipulator)parameters.get("manipulator");
        SetStartLevelActionTest.assertNotNull((Object)manipulator);
        BundleInfo bundleInfo = Util.createBundleInfo((File)osgiTarget, (IInstallableUnit)iu);
        manipulator.getConfigData().addBundle(bundleInfo);
        SetStartLevelActionTest.assertTrue((boolean)this.isStartLevel(manipulator, osgiTarget, -1));
        SetStartLevelAction action = new SetStartLevelAction();
        action.execute(parameters);
        SetStartLevelActionTest.assertTrue((boolean)this.isStartLevel(manipulator, osgiTarget, -1));
        action.undo(parameters);
        SetStartLevelActionTest.assertTrue((boolean)this.isStartLevel(manipulator, osgiTarget, -1));
    }

    private boolean isStartLevel(Manipulator manipulator, File osgiTarget, int startLevel) {
        URI location = osgiTarget.toURI();
        BundleInfo[] bundles = manipulator.getConfigData().getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (location.equals(bundles[i].getLocation()) && startLevel == bundles[i].getStartLevel()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

