/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.AggregatedBundleRepository;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class UtilTest
extends AbstractProvisioningTest {
    public UtilTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(UtilTest.class);
    }

    public void testDefaultBundlePool() {
        IProfile profile = this.createProfile("test");
        IAgentLocation agentLocation = (IAgentLocation)UtilTest.getAgent().getService(IAgentLocation.SERVICE_NAME);
        UtilTest.assertEquals((Object)agentLocation.getDataArea("org.eclipse.equinox.p2.touchpoint.eclipse"), (Object)Util.getBundlePoolLocation((IProvisioningAgent)UtilTest.getAgent(), (IProfile)profile));
    }

    public void testExplicitBundlePool() throws MalformedURLException {
        Properties props = new Properties();
        File cacheDir = new File(System.getProperty("java.io.tmpdir"), "cache");
        props.put("org.eclipse.equinox.p2.cache", cacheDir.toString());
        IProfile profile = this.createProfile("test", props);
        UtilTest.assertEquals((String)cacheDir.toURL().toExternalForm(), (String)Util.getBundlePoolLocation((IProvisioningAgent)UtilTest.getAgent(), (IProfile)profile).toString());
    }

    public void testCheckRunnableArtifactRepos() throws ProvisionException {
        File withFlag = UtilTest.getTestData("Get artifact repo in runnable format", "testData/utilTest/repoWithFlag");
        File withoutFlag = UtilTest.getTestData("Get artifact repo in runnable format", "testData/utilTest/repoWithoutFlag");
        IArtifactRepository repoWithFlag = UtilTest.getArtifactRepositoryManager().loadRepository(withFlag.toURI(), (IProgressMonitor)new NullProgressMonitor());
        IArtifactRepository repoWithoutFlag = UtilTest.getArtifactRepositoryManager().loadRepository(withoutFlag.toURI(), (IProgressMonitor)new NullProgressMonitor());
        UtilTest.assertNotNull((Object)repoWithFlag.getProperty("p2.runnable"));
        UtilTest.assertTrue((boolean)Boolean.TRUE.toString().equalsIgnoreCase(repoWithFlag.getProperty("p2.runnable")));
        UtilTest.assertNull((Object)repoWithoutFlag.getProperty("p2.runnable"));
        AggregatedBundleRepository repos = (AggregatedBundleRepository)Util.getAggregatedBundleRepository((IProvisioningAgent)UtilTest.getAgent(), null, (int)0);
        UtilTest.assertTrue((boolean)repos.testGetBundleRepositories().contains(repoWithFlag));
        UtilTest.assertTrue((!repos.testGetBundleRepositories().contains(repoWithoutFlag) ? 1 : 0) != 0);
    }
}

