/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.natives;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativeTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.CheckAndPromptNativePackageWindowsRegistry;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.Touchpoint;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class CheckAndPromptNativePackageWindowsRegistryTest {
    @Rule
    public final AbstractProvisioningTest.ProvisioningTestRuleAdapter testHelper = new AbstractProvisioningTest.ProvisioningTestRuleAdapter();
    private Preferences prefsNode;

    @BeforeClass
    public static void classSetUp() throws Exception {
        Assume.assumeThat((String)"Windows only: uses Windows registry", (Object)Platform.getOS(), (Matcher)CoreMatchers.equalTo((Object)"win32"));
    }

    @Before
    public void setUp() throws Exception {
        this.prefsNode = Preferences.userNodeForPackage(this.getClass());
        this.prefsNode.clear();
        this.prefsNode.flush();
    }

    @Test
    public void execute_StringAttribute() throws Exception {
        String attributeName = "attribute";
        String attributeValue = "value";
        this.prefsNode.put(attributeName, attributeValue);
        this.prefsNode.flush();
        Map<String, Object> parameters = new HashMap<String, Object>();
        NativeTouchpoint touchpoint = this.createTouchpoint(parameters);
        parameters.put("distro", "windows");
        parameters.put("package", "windows package");
        parameters.put("version", "1.0");
        parameters.put("key", CheckAndPromptNativePackageWindowsRegistryTest.registryPath(this.prefsNode));
        parameters.put("attributeName", attributeName);
        parameters.put("attributeValue", attributeValue);
        parameters = Collections.unmodifiableMap(parameters);
        CheckAndPromptNativePackageWindowsRegistry action = new CheckAndPromptNativePackageWindowsRegistry();
        action.setTouchpoint((Touchpoint)touchpoint);
        AbstractProvisioningTest.assertOK(action.execute(parameters));
        Assert.assertEquals(Collections.emptyList(), (Object)touchpoint.getPackagesToInstall());
    }

    @Test
    public void execute_StringAttribute_DifferentValues() throws Exception {
        String attributeName = "attribute";
        String attributeValue = "value";
        this.prefsNode.put(attributeName, attributeValue);
        this.prefsNode.flush();
        Map<String, Object> parameters = new HashMap<String, Object>();
        NativeTouchpoint touchpoint = this.createTouchpoint(parameters);
        parameters.put("distro", "windows");
        parameters.put("package", "windows package");
        parameters.put("version", "1.0");
        parameters.put("key", CheckAndPromptNativePackageWindowsRegistryTest.registryPath(this.prefsNode));
        parameters.put("attributeName", attributeName);
        parameters.put("attributeValue", String.valueOf(attributeValue) + "_DIFF");
        parameters = Collections.unmodifiableMap(parameters);
        CheckAndPromptNativePackageWindowsRegistry action = new CheckAndPromptNativePackageWindowsRegistry();
        action.setTouchpoint((Touchpoint)touchpoint);
        AbstractProvisioningTest.assertOK(action.execute(parameters));
        Assert.assertEquals((String)touchpoint.getPackagesToInstall().toString(), (long)1L, (long)touchpoint.getPackagesToInstall().size());
    }

    @Test
    public void execute_IntAttribute() throws Exception {
        String attributeName = "attribute";
        int attributeValue = 1;
        this.prefsNode.putInt(attributeName, attributeValue);
        this.prefsNode.flush();
        Map<String, Object> parameters = new HashMap<String, Object>();
        NativeTouchpoint touchpoint = this.createTouchpoint(parameters);
        parameters.put("distro", "windows");
        parameters.put("package", "windows package");
        parameters.put("version", "1.0");
        parameters.put("key", CheckAndPromptNativePackageWindowsRegistryTest.registryPath(this.prefsNode));
        parameters.put("attributeName", attributeName);
        parameters.put("attributeValue", String.valueOf(attributeValue));
        parameters = Collections.unmodifiableMap(parameters);
        CheckAndPromptNativePackageWindowsRegistry action = new CheckAndPromptNativePackageWindowsRegistry();
        action.setTouchpoint((Touchpoint)touchpoint);
        AbstractProvisioningTest.assertOK(action.execute(parameters));
        Assert.assertEquals(Collections.emptyList(), (Object)touchpoint.getPackagesToInstall());
    }

    @Test
    public void execute_IntAttribute_DifferentLiteralValue() throws Exception {
        String attributeName = "attribute";
        int attributeValue = 1;
        this.prefsNode.putInt(attributeName, attributeValue);
        this.prefsNode.flush();
        Map<String, Object> parameters = new HashMap<String, Object>();
        NativeTouchpoint touchpoint = this.createTouchpoint(parameters);
        parameters.put("distro", "windows");
        parameters.put("package", "windows package");
        parameters.put("version", "1.0");
        parameters.put("key", CheckAndPromptNativePackageWindowsRegistryTest.registryPath(this.prefsNode));
        parameters.put("attributeName", attributeName);
        parameters.put("attributeValue", "0" + String.valueOf(attributeValue));
        parameters = Collections.unmodifiableMap(parameters);
        CheckAndPromptNativePackageWindowsRegistry action = new CheckAndPromptNativePackageWindowsRegistry();
        action.setTouchpoint((Touchpoint)touchpoint);
        AbstractProvisioningTest.assertOK(action.execute(parameters));
        Assert.assertEquals(Collections.emptyList(), (Object)touchpoint.getPackagesToInstall());
    }

    @Test
    public void execute_KeyExistence() throws Exception {
        Map<String, Object> parameters = new HashMap<String, Object>();
        NativeTouchpoint touchpoint = this.createTouchpoint(parameters);
        parameters.put("distro", "windows");
        parameters.put("package", "windows package");
        parameters.put("version", "1.0");
        parameters.put("key", CheckAndPromptNativePackageWindowsRegistryTest.registryPath(this.prefsNode));
        parameters = Collections.unmodifiableMap(parameters);
        CheckAndPromptNativePackageWindowsRegistry action = new CheckAndPromptNativePackageWindowsRegistry();
        action.setTouchpoint((Touchpoint)touchpoint);
        AbstractProvisioningTest.assertOK(action.execute(parameters));
        Assert.assertEquals(Collections.emptyList(), (Object)touchpoint.getPackagesToInstall());
    }

    @Test
    public void execute_KeyExistence_DifferentKeys() throws Exception {
        Map<String, Object> parameters = new HashMap<String, Object>();
        NativeTouchpoint touchpoint = this.createTouchpoint(parameters);
        parameters.put("distro", "windows");
        parameters.put("package", "windows package");
        parameters.put("version", "1.0");
        parameters.put("key", String.valueOf(CheckAndPromptNativePackageWindowsRegistryTest.registryPath(this.prefsNode)) + "\\node");
        parameters = Collections.unmodifiableMap(parameters);
        CheckAndPromptNativePackageWindowsRegistry action = new CheckAndPromptNativePackageWindowsRegistry();
        action.setTouchpoint((Touchpoint)touchpoint);
        AbstractProvisioningTest.assertOK(action.execute(parameters));
        Assert.assertEquals((String)touchpoint.getPackagesToInstall().toString(), (long)1L, (long)touchpoint.getPackagesToInstall().size());
    }

    private NativeTouchpoint createTouchpoint(Map<String, Object> parameters) {
        Properties profileProperties = new Properties();
        File installFolder = this.testHelper.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.testHelper.createProfile("test", profileProperties);
        parameters.put("profile", profile);
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        return touchpoint;
    }

    private static String registryPath(Preferences prefs) {
        String path = prefs.absolutePath().replace('/', '\\');
        String root = prefs.isUserNode() ? "HKCU" : "HKLM";
        return String.valueOf(root) + "\\Software\\JavaSoft\\Prefs" + path;
    }
}

