/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.natives;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativeTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.CopyAction;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class CopyActionTest
extends AbstractProvisioningTest {
    public CopyActionTest(String name) {
        super(name);
    }

    public CopyActionTest() {
        super("");
    }

    public void testExecuteUndo() {
        Map parameters = this.createParameters("/testData/nativeTouchpoint/aFolder/a.txt", "a.txt", false);
        Map safeParameters = Collections.unmodifiableMap(parameters);
        CopyAction action = new CopyAction();
        action.execute(safeParameters);
        File target = new File((String)parameters.get("target"));
        CopyActionTest.assertFileContent("copied content", target, "A");
        action.undo(safeParameters);
        CopyActionTest.assertFalse((String)"Target should be removed after undo", (boolean)target.exists());
    }

    public void testCopyDirectory() {
        Map parameters = this.createParameters("/testData/nativeTouchpoint/aFolder/", "aFolder", false);
        Map safeParameters = Collections.unmodifiableMap(parameters);
        CopyAction action = new CopyAction();
        action.execute(safeParameters);
        File target = new File((String)parameters.get("target"));
        CopyActionTest.assertFileContent("copied content A", new File(target, "a.txt"), "A");
        CopyActionTest.assertFileContent("copied content B", new File(target, "b.txt"), "B");
        action.undo(safeParameters);
        CopyActionTest.assertFalse((String)"Target should be removed after undo", (boolean)target.exists());
    }

    public void testMergeDirectory() {
        Map parameters1 = this.createParameters("/testData/nativeTouchpoint/xFolder/", "aFolder", true);
        Map safeParameters1 = Collections.unmodifiableMap(parameters1);
        CopyAction action1 = new CopyAction();
        action1.execute(safeParameters1);
        File target = new File((String)parameters1.get("target"));
        CopyActionTest.assertFileContent("copied content X", new File(target, "x.txt"), "X");
        CopyActionTest.assertFileContent("copied content Y", new File(target, "y.txt"), "Y");
        HashMap<String, String> parameters2 = new HashMap<String, String>();
        parameters2.putAll(parameters1);
        parameters2.put("source", CopyActionTest.getTestData("get folder A", "/testData/nativeTouchpoint/aFolder/").getAbsolutePath());
        Map safeParameters2 = Collections.unmodifiableMap(parameters2);
        CopyAction action2 = new CopyAction();
        action2.execute(safeParameters2);
        CopyActionTest.assertFileContent("copied content A", new File(target, "a.txt"), "A");
        CopyActionTest.assertFileContent("copied content B", new File(target, "b.txt"), "B");
        action1.undo(safeParameters1);
        CopyActionTest.assertTrue((String)"Target should exist after undo", (boolean)target.exists());
        File tmp = new File(target, "x.txt");
        CopyActionTest.assertFalse((String)"File x should not exist", (boolean)tmp.exists());
        tmp = new File(target, "y.txt");
        CopyActionTest.assertFalse((String)"File y should not exist", (boolean)tmp.exists());
        CopyActionTest.assertFileContent("copied content A", new File(target, "a.txt"), "A");
        CopyActionTest.assertFileContent("copied content B", new File(target, "b.txt"), "B");
        action2.undo(safeParameters2);
        CopyActionTest.assertFalse((String)"Target should not exist after undo", (boolean)target.exists());
    }

    public void testMergeOverwrite() {
        Map parameters1 = this.createParameters("/testData/nativeTouchpoint/bcFolder/", "aFolder", true);
        Map safeParameters1 = Collections.unmodifiableMap(parameters1);
        CopyAction action1 = new CopyAction();
        action1.execute(safeParameters1);
        File target = new File((String)parameters1.get("target"));
        CopyActionTest.assertFileContent("copied content C", new File(target, "b.txt"), "C");
        HashMap<String, String> parameters2 = new HashMap<String, String>();
        parameters2.putAll(parameters1);
        parameters2.put("source", CopyActionTest.getTestData("get folder A", "/testData/nativeTouchpoint/aFolder/").getAbsolutePath());
        Map safeParameters2 = Collections.unmodifiableMap(parameters2);
        CopyAction action2 = new CopyAction();
        action2.execute(safeParameters2);
        CopyActionTest.assertFileContent("copied content A", new File(target, "a.txt"), "A");
        CopyActionTest.assertFileContent("copied content B", new File(target, "b.txt"), "B");
        action2.undo(safeParameters2);
        CopyActionTest.assertFalse((String)"Target should not exist after undo", (boolean)target.exists());
    }

    public void testBlockedMergeOverwrite() {
        Map parameters1 = this.createParameters("/testData/nativeTouchpoint/bcFolder/", "aFolder", false);
        Map safeParameters1 = Collections.unmodifiableMap(parameters1);
        CopyAction action1 = new CopyAction();
        action1.execute(safeParameters1);
        File target = new File((String)parameters1.get("target"));
        CopyActionTest.assertFileContent("copied content B", new File(target, "b.txt"), "C");
        HashMap<String, String> parameters2 = new HashMap<String, String>();
        parameters2.putAll(parameters1);
        parameters2.put("source", CopyActionTest.getTestData("get folder A", "/testData/nativeTouchpoint/aFolder/").getAbsolutePath());
        Map safeParameters2 = Collections.unmodifiableMap(parameters2);
        CopyAction action2 = new CopyAction();
        CopyActionTest.assertFalse((String)"Overwrite of b.txt should not succeed", (boolean)action2.execute(safeParameters2).isOK());
        CopyActionTest.assertFileContent("copied content B", new File(target, "b.txt"), "C");
    }

    public void testOverwrite() {
        Map parameters = this.createParameters("/testData/nativeTouchpoint/aFolder/a.txt", "a.txt", true);
        Map safeParameters = Collections.unmodifiableMap(parameters);
        File source = new File((String)parameters.get("source"));
        File target = new File((String)parameters.get("target"));
        CopyActionTest.copy("2.0", CopyActionTest.getTestData("1.0", "/testData/nativeTouchpoint/aFolder/b.txt"), target);
        CopyAction action = new CopyAction();
        action.execute(safeParameters);
        CopyActionTest.assertFileContent("copied content", target, "A");
        CopyActionTest.assertFileContent("source content", source, "A");
        CopyActionTest.assertTrue((String)"copy action status", (boolean)action.undo(safeParameters).isOK());
        CopyActionTest.assertFalse((String)"Target should be removed after undo", (boolean)target.exists());
    }

    public void testBlockedOverwrite() {
        Map parameters = this.createParameters("/testData/nativeTouchpoint/aFolder/a.txt", "a.txt", false);
        Map safeParameters = Collections.unmodifiableMap(parameters);
        File source = new File((String)parameters.get("source"));
        File target = new File((String)parameters.get("target"));
        CopyActionTest.copy("2.0", CopyActionTest.getTestData("1.0", "/testData/nativeTouchpoint/aFolder/b.txt"), target);
        CopyAction action = new CopyAction();
        CopyActionTest.assertFalse((String)"copy action status", (boolean)action.execute(safeParameters).isOK());
        CopyActionTest.assertFileContent("original content", target, "B");
        CopyActionTest.assertFileContent("source content", source, "A");
        action.undo(safeParameters);
        CopyActionTest.assertTrue((String)"Target should remain after undo", (boolean)target.exists());
        CopyActionTest.assertFileContent("original content", target, "B");
    }

    private Map createParameters(String sourceName, String targetName, boolean overwrite) {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        File source = CopyActionTest.getTestData("1.0", sourceName);
        File target = new File(installFolder, targetName);
        MetadataFactory.InstallableUnitDescription iuDesc = new MetadataFactory.InstallableUnitDescription();
        iuDesc.setId("test");
        iuDesc.setVersion(DEFAULT_VERSION);
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey((String)"test", (Version)DEFAULT_VERSION);
        iuDesc.setArtifacts(new IArtifactKey[]{key});
        iuDesc.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        IInstallableUnit iu = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDesc);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("profile", profile);
        parameters.put("iu", iu);
        parameters.put("profile", profile);
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        parameters.put("source", source.getAbsolutePath());
        parameters.put("target", target.getAbsolutePath());
        parameters.put("overwrite", Boolean.toString(overwrite));
        return parameters;
    }
}

