/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.natives;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativeTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.LinkAction;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class LinkActionTest
extends AbstractProvisioningTest {
    public LinkActionTest(String name) {
        super(name);
    }

    public LinkActionTest() {
        super("");
    }

    public void testExecuteUndo() {
        Properties profileProperties = new Properties();
        File installFolder = this.getTempFolder();
        profileProperties.setProperty("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        File zipSource = LinkActionTest.getTestData("1.0", "/testData/nativeTouchpoint/a.zip");
        File zipTarget = new File(installFolder, "a.zip");
        LinkActionTest.copy("2.0", zipSource, zipTarget);
        Map parameters = new HashMap<String, Object>();
        parameters.put("profile", profile);
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        parameters.put("targetDir", installFolder.getAbsolutePath());
        parameters.put("linkName", "b.zip");
        parameters.put("linkTarget", zipTarget.getAbsolutePath());
        parameters = Collections.unmodifiableMap(parameters);
        LinkAction action = new LinkAction();
        LinkActionTest.assertOK("3.0", action.execute(parameters));
        LinkActionTest.assertOK("3.1", action.undo(parameters));
        File linkFile = new File((String)parameters.get("targetDir"));
        linkFile = new File(linkFile, (String)parameters.get("linkName"));
        LinkActionTest.assertFalse((String)"3.2", (boolean)linkFile.exists());
    }
}

