/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.updatesite;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.updatesite.artifact.UpdateSiteArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepositoryFactory;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class DoesNotCacheStaleData
extends AbstractProvisioningTest {
    public void testLoadBadSiteForMetadata() {
        URI siteURI = DoesNotCacheStaleData.getTestData("badUpdateSite", "testData/updatesite/badSiteXML/site.xml").toURI();
        File f = URIUtil.toFile((URI)UpdateSiteMetadataRepositoryFactory.getLocalRepositoryLocation((URI)siteURI));
        File contentXml = new File(f, "content.xml");
        contentXml.delete();
        ProvisionException e = null;
        try {
            UpdateSiteMetadataRepositoryFactory factory = new UpdateSiteMetadataRepositoryFactory();
            factory.setAgent(DoesNotCacheStaleData.getAgent());
            factory.load(siteURI, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e1) {
            e = e1;
        }
        DoesNotCacheStaleData.assertNotNull((Object)((Object)e));
        DoesNotCacheStaleData.assertTrue((boolean)new File(URIUtil.toFile((URI)UpdateSiteMetadataRepositoryFactory.getLocalRepositoryLocation((URI)siteURI)), "content.xml").exists());
        try {
            SimpleMetadataRepositoryFactory simpleFactory = new SimpleMetadataRepositoryFactory();
            simpleFactory.setAgent(DoesNotCacheStaleData.getAgent());
            IMetadataRepository repo = simpleFactory.load(f.toURI(), 0, (IProgressMonitor)new NullProgressMonitor());
            DoesNotCacheStaleData.assertEquals((String)"0", (String)((String)repo.getProperties().get("site.checksum")));
        }
        catch (ProvisionException e1) {
            DoesNotCacheStaleData.fail("3.0", e1);
        }
    }

    public void testLoadBadSiteForArtifact() {
        URI siteURI = DoesNotCacheStaleData.getTestData("badUpdateSite", "testData/updatesite/badSiteXML/site.xml").toURI();
        File f = URIUtil.toFile((URI)UpdateSiteMetadataRepositoryFactory.getLocalRepositoryLocation((URI)siteURI));
        File contentXml = new File(f, "artifacts.xml");
        contentXml.delete();
        ProvisionException e = null;
        try {
            UpdateSiteArtifactRepositoryFactory factory = new UpdateSiteArtifactRepositoryFactory();
            factory.setAgent(DoesNotCacheStaleData.getAgent());
            factory.load(siteURI, 0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e1) {
            e = e1;
        }
        DoesNotCacheStaleData.assertNotNull((Object)((Object)e));
        DoesNotCacheStaleData.assertTrue((boolean)new File(URIUtil.toFile((URI)UpdateSiteMetadataRepositoryFactory.getLocalRepositoryLocation((URI)siteURI)), "artifacts.xml").exists());
        try {
            SimpleArtifactRepositoryFactory simpleFactory = new SimpleArtifactRepositoryFactory();
            simpleFactory.setAgent(DoesNotCacheStaleData.getAgent());
            IArtifactRepository repo = simpleFactory.load(f.toURI(), 0, (IProgressMonitor)new NullProgressMonitor());
            DoesNotCacheStaleData.assertEquals((String)"0", (String)((String)repo.getProperties().get("site.checksum")));
        }
        catch (ProvisionException e1) {
            DoesNotCacheStaleData.fail("3.0", e1);
        }
    }
}

