/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.updatesite;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSitePublisherApplication;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestData;

public class LocalUpdatesiteTest
extends AbstractProvisioningTest {
    protected File repoLocation;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String tempDir = System.getProperty("java.io.tmpdir");
        this.repoLocation = new File(tempDir, "LocalMetadataRepositoryTest");
        AbstractProvisioningTest.delete(this.repoLocation);
        this.repoLocation.mkdir();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalUpdatesiteTest.getMetadataRepositoryManager().removeRepository(this.repoLocation.toURI());
        LocalUpdatesiteTest.delete(this.repoLocation);
        super.tearDown();
    }

    public void testCategoryQualifier() throws IOException, ProvisionException {
        File siteSource = TestData.getFile("updatesite", "SiteXMLActionTest");
        UpdateSitePublisherApplication application = new UpdateSitePublisherApplication();
        try {
            application.run(new String[]{"-metadataRepository", this.repoLocation.toURI().toString(), "-source", siteSource.toString(), "-categoryQualifier", "fooQualifier"});
        }
        catch (Exception exception) {
            LocalUpdatesiteTest.fail((String)"0.99");
        }
        IMetadataRepository repository = LocalUpdatesiteTest.getMetadataRepositoryManager().loadRepository(this.repoLocation.toURI(), (IProgressMonitor)new NullProgressMonitor());
        IQueryResult results = repository.query(QueryUtil.createIUCategoryQuery(), (IProgressMonitor)new NullProgressMonitor());
        LocalUpdatesiteTest.assertEquals((String)"1.0", (int)1, (int)LocalUpdatesiteTest.queryResultSize(results));
        for (IInstallableUnit unit : results) {
            LocalUpdatesiteTest.assertTrue((String)"2.0", (boolean)unit.getId().startsWith("fooQualifier"));
            LocalUpdatesiteTest.assertEquals((String)"3.0", (String)"Test Category Label", (String)unit.getProperty("org.eclipse.equinox.p2.name"));
        }
    }

    public void testBundleInCategory() throws Exception {
        File siteSource = TestData.getFile("updatesite", "SiteXMLActionTest");
        UpdateSitePublisherApplication application = new UpdateSitePublisherApplication();
        try {
            application.run(new String[]{"-metadataRepository", this.repoLocation.toURI().toString(), "-source", siteSource.toString(), "-categoryQualifier", "fooQualifier"});
        }
        catch (Exception exception) {
            LocalUpdatesiteTest.fail((String)"0.99");
        }
        IMetadataRepository repository = LocalUpdatesiteTest.getMetadataRepositoryManager().loadRepository(this.repoLocation.toURI(), (IProgressMonitor)new NullProgressMonitor());
        IQueryResult results = repository.query(QueryUtil.createIUCategoryQuery(), (IProgressMonitor)new NullProgressMonitor());
        Iterator iter = results.iterator();
        IInstallableUnit unit = (IInstallableUnit)iter.next();
        IQuery memberQuery = QueryUtil.createIUCategoryMemberQuery((IInstallableUnit)unit);
        IQueryResult categoryMembers = repository.query(memberQuery, (IProgressMonitor)new NullProgressMonitor());
        HashSet<String> membersId = new HashSet<String>();
        for (IInstallableUnit iu : categoryMembers.toUnmodifiableSet()) {
            membersId.add(iu.getId());
        }
        LocalUpdatesiteTest.assertEquals((String)"1.0", (int)2, (int)membersId.size());
        LocalUpdatesiteTest.assertTrue((String)"2.0", (boolean)membersId.contains("test.bundle"));
    }
}

