/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.util.Map;
import org.eclipse.equinox.internal.security.tests.SecurityTestsActivator;
import org.eclipse.equinox.internal.security.tests.storage.SecurePreferencesTest;
import org.junit.Assume;
import org.junit.Before;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WinPreferencesTest
extends SecurePreferencesTest {
    private static final String WIN_BUNDLE = "org.eclipse.equinox.security.win32.x86";
    private static final String WIN_64BIT_BUNDLE = "org.eclipse.equinox.security.win32.x86_64";
    private boolean is64Bit = "x86-64".equals(SecurityTestsActivator.getDefault().getBundleContext().getProperty("org.osgi.framework.processor"));
    private static final String WIN_MODULE_ID = "org.eclipse.equinox.security.WindowsPasswordProvider";
    private static final String WIN_64BIT_MODULE_ID = "org.eclipse.equinox.security.WindowsPasswordProvider64bit";

    @Before
    public void setUp() {
        Assume.assumeTrue((boolean)WinPreferencesTest.hasBundle(this.is64Bit ? WIN_64BIT_BUNDLE : WIN_BUNDLE));
    }

    @Override
    protected String getModuleID() {
        return this.is64Bit ? WIN_64BIT_MODULE_ID : WIN_MODULE_ID;
    }

    @Override
    protected Map<String, Object> getOptions() {
        return this.getOptions(null);
    }

    private static boolean hasBundle(String symbolicID) {
        BundleContext context = SecurityTestsActivator.getDefault().getBundleContext();
        Bundle[] bundles = context.getBundles();
        int i = 0;
        while (i < bundles.length) {
            String bundleName = bundles[i].getSymbolicName();
            if (symbolicID.equals(bundleName)) {
                int bundleState = bundles[i].getState();
                return bundleState != 2 && bundleState != 1;
            }
            ++i;
        }
        return false;
    }
}

