/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import com.sun.mirror.apt.AnnotationProcessor;
import java.util.HashSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.tests.ExpectedProblem;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.apt.tests.annotations.BaseProcessor;
import org.eclipse.jdt.apt.tests.annotations.ProcessorTestStatus;
import org.eclipse.jdt.apt.tests.annotations.generic.GenericFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.Util;

public abstract class APTTestBase
extends BuilderTests {
    private IJavaProject _jproj;

    public APTTestBase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        APTTestBase.runFinalizers();
        ProcessorTestStatus.reset();
        super.setUp();
        env.resetWorkspace();
        TestUtil.enableAutoBuild(false);
        String projectName = this.getProjectName();
        if (projectName == null) {
            throw new IllegalStateException();
        }
        this._jproj = this.createJavaProject(projectName);
        AptConfig.setEnabled((IJavaProject)this._jproj, (boolean)true);
    }

    protected IJavaProject getCurrentJavaProject() {
        return this._jproj;
    }

    protected IJavaProject createJavaProject(String projectName) throws Exception {
        IPath projectPath = env.addProject(projectName, "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IJavaProject javaProj = env.getJavaProject(projectPath);
        TestUtil.createAndAddAnnotationJar(javaProj);
        return javaProj;
    }

    protected void tearDown() throws Exception {
        AptPlugin.trace((String)("Tearing down " + this.getProjectName()));
        APTTestBase.runFinalizers();
        GenericFactory.PROCESSOR = null;
        super.tearDown();
    }

    private static void runFinalizers() {
        System.gc();
        System.runFinalization();
        System.gc();
        System.runFinalization();
    }

    public String getProjectName() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "Project";
    }

    public IPath getSourcePath() {
        IProject project = env.getProject(this.getProjectName());
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        return srcRoot;
    }

    private String concate(String[] messages) {
        int len = messages == null ? 0 : messages.length;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < len) {
            buffer.append(messages[i]);
            buffer.append('\n');
            ++i;
        }
        return buffer.toString();
    }

    private String concate(IMarker[] markers) {
        int len = markers == null ? 0 : markers.length;
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < len) {
            try {
                buffer.append(markers[i].getAttribute("message"));
            }
            catch (CoreException ce) {
                APTTestBase.assertTrue((String)("unexpected core exception" + ce.getMessage()), (boolean)false);
            }
            buffer.append('\n');
            ++i;
        }
        return buffer.toString();
    }

    protected void clearProcessorResult(Class<? extends AnnotationProcessor> processor) {
        String propertyName = BaseProcessor.getPropertyName(processor);
        System.clearProperty(propertyName);
    }

    protected String checkProcessorResult(Class<? extends AnnotationProcessor> processor) {
        String propertyName = BaseProcessor.getPropertyName(processor);
        String result = System.getProperty(propertyName);
        System.clearProperty(propertyName);
        if (!"succeeded".equals(result)) {
            APTTestBase.fail((String)result);
        }
        return result;
    }

    protected String getProcessorResult(Class<? extends AnnotationProcessor> processor) {
        String propertyName = BaseProcessor.getPropertyName(processor);
        String result = System.getProperty(propertyName);
        System.clearProperty(propertyName);
        return result;
    }

    protected void expectingMarkers(String[] messages) {
        IMarker[] markers = this.getAllAPTMarkers(env.getWorkspaceRootPath());
        HashSet<String> expectedMessages = new HashSet<String>();
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            expectedMessages.add(msg);
            ++n2;
        }
        boolean fail = false;
        try {
            IMarker[] iMarkerArray = markers;
            int n3 = markers.length;
            n = 0;
            while (n < n3) {
                IMarker marker = iMarkerArray[n];
                String markerMsg = (String)marker.getAttribute("message");
                if (!expectedMessages.contains(markerMsg)) {
                    fail = true;
                    break;
                }
                expectedMessages.remove(markerMsg);
                ++n;
            }
            if (!expectedMessages.isEmpty()) {
                fail = true;
            }
        }
        catch (CoreException ce) {
            APTTestBase.assertTrue((String)("unexpected core exception" + ce.getMessage()), (boolean)false);
        }
        if (fail) {
            APTTestBase.assertEquals((String)this.concate(messages), (String)this.concate(markers));
        }
    }

    protected void expectingNoMarkers() {
        this.expectingNoMarkers(env.getWorkspaceRootPath());
    }

    protected void expectingNoMarkers(IPath path) {
        IMarker[] markers = this.getAllAPTMarkers(path);
        if (markers != null && markers.length != 0) {
            try {
                APTTestBase.assertTrue((String)("unexpected marker(s) : " + markers[0].getAttribute("message")), (boolean)false);
            }
            catch (CoreException ce) {
                APTTestBase.assertTrue((String)("unexpected core exception" + ce.getMessage()), (boolean)false);
            }
        }
    }

    protected IMarker[] getAllAPTMarkers(IPath path) {
        IProject p;
        Object resource = path.equals((Object)env.getWorkspaceRootPath()) ? env.getWorkspace().getRoot() : ((p = env.getProject(path)) != null && path.equals((Object)p.getFullPath()) ? env.getProject(path.lastSegment()) : (path.getFileExtension() == null ? env.getWorkspace().getRoot().getFolder(path) : env.getWorkspace().getRoot().getFile(path)));
        try {
            IMarker[] configMarkers;
            IMarker[] markers = null;
            int total = 0;
            IMarker[] processorMarkers = resource.findMarkers("org.eclipse.jdt.apt.core.marker", true, 2);
            total = processorMarkers.length;
            markers = processorMarkers;
            IMarker[] factoryPathMarkers = resource.findMarkers("org.eclipse.jdt.apt.core.buildproblem", true, 2);
            if (factoryPathMarkers.length != 0) {
                if (total != 0) {
                    int len = factoryPathMarkers.length;
                    IMarker[] temp = new IMarker[len + total];
                    System.arraycopy(markers, 0, temp, 0, total);
                    System.arraycopy(factoryPathMarkers, 0, temp, total, len);
                    markers = temp;
                    total += len;
                } else {
                    markers = factoryPathMarkers;
                }
            }
            if ((configMarkers = resource.findMarkers("org.eclipse.jdt.apt.core.configproblem", true, 2)).length != 0) {
                if (total != 0) {
                    int len = configMarkers.length;
                    IMarker[] temp = new IMarker[len + total];
                    System.arraycopy(markers, 0, temp, 0, total);
                    System.arraycopy(configMarkers, 0, temp, total, len);
                    markers = temp;
                    total += len;
                } else {
                    markers = configMarkers;
                }
            }
            return markers;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected void expectingOnlySpecificProblemsFor(IPath root, ExpectedProblem[] expectedProblems) {
        if (DEBUG) {
            this.printProblemsFor(root);
        }
        Problem[] rootProblems = env.getProblemsFor(root);
        int i = 0;
        while (i < expectedProblems.length) {
            ExpectedProblem expectedProblem = expectedProblems[i];
            boolean found = false;
            int j = 0;
            while (j < rootProblems.length) {
                if (expectedProblem.equalsProblem(rootProblems[j])) {
                    found = true;
                    rootProblems[j] = null;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.printProblemsFor(root);
            }
            APTTestBase.assertTrue((String)("problem not found: " + expectedProblem.toString()), (boolean)found);
            ++i;
        }
        i = 0;
        while (i < rootProblems.length) {
            if (rootProblems[i] != null) {
                this.printProblemsFor(root);
                APTTestBase.assertTrue((String)("unexpected problem: " + rootProblems[i].toString()), (boolean)false);
            }
            ++i;
        }
    }

    protected void expectingSpecificProblemsFor(IPath root, ExpectedProblem[] problems) {
        if (DEBUG) {
            this.printProblemsFor(root);
        }
        Problem[] rootProblems = env.getProblemsFor(root);
        int i = 0;
        while (i < problems.length) {
            block6: {
                ExpectedProblem problem = problems[i];
                int j = 0;
                while (j < rootProblems.length) {
                    Problem rootProblem = rootProblems[j];
                    if (rootProblem != null && problem.equalsProblem(rootProblem)) {
                        rootProblems[j] = null;
                        break block6;
                    }
                    ++j;
                }
                j = 0;
                while (j < rootProblems.length) {
                    Problem pb = rootProblems[j];
                    if (pb != null) {
                        System.out.print("got pb:\t\tnew Problem(\"" + pb.getLocation() + "\", \"" + pb.getMessage() + "\", \"" + pb.getResourcePath() + "\"");
                        System.out.print(", " + pb.getStart() + ", " + pb.getEnd() + ", " + pb.getCategoryId());
                        System.out.println(")");
                    }
                    ++j;
                }
                APTTestBase.assertTrue((String)("missing expected problem : " + problem), (boolean)false);
            }
            ++i;
        }
    }

    protected void expectingOnlySpecificProblemFor(IPath root, ExpectedProblem problem) {
        this.expectingOnlySpecificProblemsFor(root, new ExpectedProblem[]{problem});
    }

    protected static void sleep(long millis) {
        long end = System.currentTimeMillis() + millis;
        while (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException interruptedException) {}
            millis = end - System.currentTimeMillis();
        }
    }
}

