/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.apt.tests.annotations.ProcessorTestStatus;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.util.Util;

public class JavaVersionTests
extends BuilderTests {
    public JavaVersionTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(JavaVersionTests.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        IPath projectPath = env.addProject(JavaVersionTests.getProjectName(), "1.4");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        TestUtil.createAndAddAnnotationJar(env.getJavaProject(projectPath));
    }

    public static String getProjectName() {
        return String.valueOf(JavaVersionTests.class.getName()) + "Project";
    }

    public IPath getSourcePath() {
        IProject project = env.getProject(JavaVersionTests.getProjectName());
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        return srcRoot;
    }

    public void testMirror() throws Exception {
        ProcessorTestStatus.reset();
        IProject project = env.getProject(JavaVersionTests.getProjectName());
        IPath srcRoot = this.getSourcePath();
        String code = "package mirrortestpackage;\n\nimport java.io.Serializable;\nimport org.eclipse.jdt.apt.tests.annotations.mirrortest.MirrorTestAnnotation;\n\npublic class MirrorTestClass implements Serializable {\n\n    public static final String STATIC_FIELD = \"Static Field\";\n\n    private static final long serialVersionUID = 42L;\n\n    public String field;\n\n    public MirrorTestClass() {\n        field = \"Field\";\n    }\n\n    @MirrorTestAnnotation\n    public static Object staticMethod() {\n        return null;\n    }\n\n    public String stringMethod() {\n        return null;\n    }\n\n\n    public String toString() {\n        return null;\n    }\n\n    public static class InnerClass extends MirrorTestClass {\n\n        private static final long serialVersionUID = 148L;\n\n        public static Object staticMethod() {\n            return null;\n        }\n\n    }\n}";
        env.addClass(srcRoot, "mirrortestpackage", "MirrorTestClass", code);
        this.fullBuild(project.getFullPath());
        JavaVersionTests.assertFalse((String)"Processor was run", (boolean)ProcessorTestStatus.processorRan());
    }
}

