/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.ExpectedProblem;
import org.eclipse.jdt.apt.tests.annotations.ProcessorTestStatus;
import org.eclipse.jdt.core.tests.util.Util;

public class AnnotationValueConversionTests
extends APTTestBase {
    private int counter = 0;
    private String projectName = null;

    public AnnotationValueConversionTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(AnnotationValueConversionTests.class);
    }

    public String getUniqueProjectName() {
        this.projectName = String.valueOf(AnnotationValueConversionTests.class.getName()) + "Project" + this.counter;
        ++this.counter;
        return this.projectName;
    }

    @Override
    public IPath getSourcePath() {
        IProject project = env.getProject(this.getProjectName());
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        return srcRoot;
    }

    public IPath getBinaryPath() {
        IProject project = env.getProject(this.getProjectName());
        IFolder srcFolder = project.getFolder("binary");
        IPath lib = srcFolder.getFullPath();
        return lib;
    }

    public IPath getOutputPath() {
        IProject project = env.getProject(this.getProjectName());
        IFolder binFolder = project.getFolder("bin");
        IPath bin = binFolder.getFullPath();
        return bin;
    }

    private IProject setupTest() throws Exception {
        ProcessorTestStatus.reset();
        IPath projectPath = env.addProject(this.getUniqueProjectName(), "1.5");
        env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src");
        return env.getProject(this.getProjectName());
    }

    public void testByteConversion() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.Annotation;\n@Annotation(z=(byte)49,\n\t\t\t\t  b=(byte)49,\n\t\t\t\t  s=(byte)49,\n\t\t\t\t  i=(byte)49,\n                 l=(byte)49,\n\t \t \t      f=(byte)49,\n\t\t\t      d=(byte)49,\n\t\t\t\t  c=(byte)49)\n\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from byte to boolean", testPath), new ExpectedProblem("", "type mismatch for member z expected java.lang.Boolean but got java.lang.Byte", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testByteConversion_Reflection() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.RefAnnotation;\n@RefAnnotation(z=(byte)49,\n\t\t\t\t  b=(byte)49,\n\t\t\t\t  s=(byte)49,\n\t\t\t\t  i=(byte)49,\n                 l=(byte)49,\n\t \t \t      f=(byte)49,\n\t\t\t      d=(byte)49,\n\t\t\t\t  c=(byte)49)\n\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from byte to boolean", testPath), new ExpectedProblem("", "value mismatch for member z expected true but got false", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testShortConversion() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.Annotation;\n@Annotation(z=(short)49,\n\t\t\t\t  b=(short)49,\n\t\t\t\t  s=(short)49,\n\t\t\t\t  i=(short)49,\n                 l=(short)49,\n\t \t \t      f=(short)49,\n\t\t\t      d=(short)49,\n\t\t\t\t  c=(short)49)\n\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from short to boolean", testPath), new ExpectedProblem("", "type mismatch for member z expected java.lang.Boolean but got java.lang.Short", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testShortConversion_Reflection() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.RefAnnotation;\n@RefAnnotation(z=(short)49,\n\t\t\t\t  b=(short)49,\n\t\t\t\t  s=(short)49,\n\t\t\t\t  i=(short)49,\n                 l=(short)49,\n\t \t \t      f=(short)49,\n\t\t\t      d=(short)49,\n\t\t\t\t  c=(short)49)\n\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from short to boolean", testPath), new ExpectedProblem("", "value mismatch for member z expected true but got false", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testCharConversion() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.Annotation;\n@Annotation(z='1',\n                 b='1',\n\t\t\t\t  s='1',\n\t\t\t\t  i='1',\n                 l='1',\n\t \t \t      f='1',\n\t\t\t      d='1',\n\t\t\t\t  c='1')\n\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from char to boolean", testPath), new ExpectedProblem("", "type mismatch for member z expected java.lang.Boolean but got java.lang.Character", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testCharConversion_Reflection() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.RefAnnotation;\n@RefAnnotation(z='1',\n\t\t\t\t  b='1',\n\t\t\t\t  s='1',\n\t\t\t\t  i='1',\n                 l='1',\n\t \t \t      f='1',\n\t\t\t      d='1',\n\t\t\t\t  c='1')\n\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from char to boolean", testPath), new ExpectedProblem("", "value mismatch for member z expected true but got false", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testIntConversion() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.Annotation;\n@Annotation(z=49,\n\t\t\t\t  b=49,\n\t\t\t\t  s=49,\n\t\t\t\t  i=49,\n                 l=49,\n\t \t \t      f=49,\n\t\t\t      d=49,\n\t\t\t\t  c=49)\n\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from int to boolean", testPath), new ExpectedProblem("", "type mismatch for member z expected java.lang.Boolean but got java.lang.Integer", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testIntConversion_Reflection() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.RefAnnotation;\n@RefAnnotation(z=49,\n\t\t\t\t  b=49,\n\t\t\t\t  s=49,\n\t\t\t\t  i=49,\n                 l=49,\n\t \t \t      f=49,\n\t\t\t      d=49,\n\t\t\t\t  c=49)\n\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from int to boolean", testPath), new ExpectedProblem("", "value mismatch for member z expected true but got false", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testLongConversion() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.Annotation;\n@Annotation(z=49l,\n\t\t\t\t  c=49l,\n\t\t\t\t  b=49l,\n\t\t\t\t  s=49l,\n\t\t\t\t  i=49l,\n\t\t\t\t  l=49l,\n\t \t \t      f=49l,\n\t\t\t      d=49l)\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from long to boolean", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from long to char", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from long to byte", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from long to short", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from long to int", testPath), new ExpectedProblem("", "type mismatch for member z expected java.lang.Boolean but got java.lang.Long", testPath), new ExpectedProblem("", "type mismatch for member s expected java.lang.Short but got java.lang.Long", testPath), new ExpectedProblem("", "type mismatch for member i expected java.lang.Integer but got java.lang.Long", testPath), new ExpectedProblem("", "type mismatch for member c expected java.lang.Character but got java.lang.Long", testPath), new ExpectedProblem("", "type mismatch for member b expected java.lang.Byte but got java.lang.Long", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testLongConversion_Reflection() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.RefAnnotation;\n@RefAnnotation(z=49l,\n\t\t\t\t  c=49l,\n\t\t\t\t  b=49l,\n\t\t\t\t  s=49l,\n\t\t\t\t  i=49l,\n\t\t\t\t  l=49l,\n\t \t \t      f=49l,\n\t\t\t      d=49l)\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from long to boolean", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from long to char", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from long to byte", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from long to short", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from long to int", testPath), new ExpectedProblem("", "value mismatch for member z expected true but got false", testPath), new ExpectedProblem("", "value mismatch for member s expected 49 but got 0", testPath), new ExpectedProblem("", "value mismatch for member i expected 49 but got 0", testPath), new ExpectedProblem("", "value mismatch for member c expected 1 but got 0", testPath), new ExpectedProblem("", "value mismatch for member b expected 49 but got 0", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testFloatConversion() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.Annotation;\n@Annotation(z=49f,\n\t\t\t\t  c=49f,\n\t\t\t\t  b=49f,\n\t\t\t\t  s=49f,\n\t\t\t\t  i=49f,\n\t\t\t\t  l=49f,\n\t\t\t\t  f=49f,\n\t\t\t      d=49f)\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from float to boolean", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from float to int", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from float to long", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from float to char", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from float to byte", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from float to short", testPath), new ExpectedProblem("", "type mismatch for member z expected java.lang.Boolean but got java.lang.Float", testPath), new ExpectedProblem("", "type mismatch for member s expected java.lang.Short but got java.lang.Float", testPath), new ExpectedProblem("", "type mismatch for member i expected java.lang.Integer but got java.lang.Float", testPath), new ExpectedProblem("", "type mismatch for member c expected java.lang.Character but got java.lang.Float", testPath), new ExpectedProblem("", "type mismatch for member b expected java.lang.Byte but got java.lang.Float", testPath), new ExpectedProblem("", "type mismatch for member l expected java.lang.Long but got java.lang.Float", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testFloatConversion_Reflection() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.RefAnnotation;\n@RefAnnotation(z=49f,\n\t\t\t\t  c=49f,\n\t\t\t\t  b=49f,\n\t\t\t\t  s=49f,\n\t\t\t\t  i=49f,\n\t\t\t\t  l=49f,\n\t\t\t\t  f=49f,\n\t\t\t      d=49f)\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from float to boolean", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from float to int", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from float to long", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from float to char", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from float to byte", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from float to short", testPath), new ExpectedProblem("", "value mismatch for member z expected true but got false", testPath), new ExpectedProblem("", "value mismatch for member s expected 49 but got 0", testPath), new ExpectedProblem("", "value mismatch for member i expected 49 but got 0", testPath), new ExpectedProblem("", "value mismatch for member c expected 1 but got 0", testPath), new ExpectedProblem("", "value mismatch for member b expected 49 but got 0", testPath), new ExpectedProblem("", "value mismatch for member l expected 49 but got 0", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testDoubleConversion() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.Annotation;\n@Annotation(z=49d,\t\t\t\t  c=49d,\n\t\t\t\t  b=49d,\n\t\t\t\t  s=49d,\n\t\t\t\t  i=49d,\n\t\t\t\t  l=49d,\n\t\t\t\t  f=49d,\n\t\t\t      d=49d)\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from double to boolean", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from double to int", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from double to long", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from double to char", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from double to byte", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from double to short", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from double to float", testPath), new ExpectedProblem("", "type mismatch for member z expected java.lang.Boolean but got java.lang.Double", testPath), new ExpectedProblem("", "type mismatch for member s expected java.lang.Short but got java.lang.Double", testPath), new ExpectedProblem("", "type mismatch for member i expected java.lang.Integer but got java.lang.Double", testPath), new ExpectedProblem("", "type mismatch for member c expected java.lang.Character but got java.lang.Double", testPath), new ExpectedProblem("", "type mismatch for member b expected java.lang.Byte but got java.lang.Double", testPath), new ExpectedProblem("", "type mismatch for member l expected java.lang.Long but got java.lang.Double", testPath), new ExpectedProblem("", "type mismatch for member f expected java.lang.Float but got java.lang.Double", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testDoubleConversion_Reflection() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.RefAnnotation;\n@RefAnnotation(z=49d,\n\t\t\t\t  c=49d,\n\t\t\t\t  b=49d,\n\t\t\t\t  s=49d,\n\t\t\t\t  i=49d,\n\t\t\t\t  l=49d,\n\t\t\t\t  f=49d,\n\t\t\t      d=49d)\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from double to boolean", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from double to int", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from double to long", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from double to char", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from double to byte", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from double to short", testPath), new ExpectedProblem("", "Type mismatch: cannot convert from double to float", testPath), new ExpectedProblem("", "value mismatch for member z expected true but got false", testPath), new ExpectedProblem("", "value mismatch for member s expected 49 but got 0", testPath), new ExpectedProblem("", "value mismatch for member i expected 49 but got 0", testPath), new ExpectedProblem("", "value mismatch for member c expected 1 but got 0", testPath), new ExpectedProblem("", "value mismatch for member b expected 49 but got 0", testPath), new ExpectedProblem("", "value mismatch for member l expected 49 but got 0", testPath), new ExpectedProblem("", "value mismatch for member f expected 49.0 but got 0.0", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testArrayification() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.AnnotationWithArray;\n@AnnotationWithArray(booleans=true,\n\t\t\t\t  bytes=(byte)49,\n\t\t\t\t  shorts=(short)49,\n\t\t\t\t  ints=49,\n                 longs=49,\n\t \t \t      floats=49,\n\t\t\t      doubles=49,\n\t\t\t\t  chars='1')\n\npublic class Test {}\n";
        env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testArrayification_Reflection() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.RefAnnotationWithArray;\n@RefAnnotationWithArray(booleans=true,\n\t\t\t\t  bytes=(byte)49,\n\t\t\t\t  shorts=(short)49,\n\t\t\t\t  ints=49,\n                 longs=49,\n\t \t \t      floats=49,\n\t\t\t      doubles=49,\n\t\t\t\t  chars='1')\n\npublic class Test {}\n";
        env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testArrayElementConversion() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.AnnotationWithArray;\n@AnnotationWithArray(booleans={true, true },\n\t\t\t\t  bytes=  {(byte)49, 50}, \n\t\t\t\t  shorts= {(byte)49, 50},\n\t\t\t\t  ints=   {(byte)49, 50},\n                 longs=  {(byte)49, 50},\n\t \t \t      floats= {(byte)49, 50},\n\t\t\t      doubles={(byte)49, 50},\n\t\t\t\t  chars=  {'1','2'})\n\npublic class Test {}\n";
        env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testArrayElementConversion_Reflection() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.RefAnnotationWithArray;\n@RefAnnotationWithArray(booleans={true, true },\n\t\t\t\t  bytes=  {(byte)49, 50}, \n\t\t\t\t  shorts= {(byte)49, 50},\n\t\t\t\t  ints=   {(byte)49, 50},\n                 longs=  {(byte)49, 50},\n\t \t \t      floats= {(byte)49, 50},\n\t\t\t      doubles={(byte)49, 50},\n\t\t\t\t  chars=  {'1','2'})\n\npublic class Test {}\n";
        env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testErrorStringValue() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.AnnotationWithArray;\n@AnnotationWithArray(booleans={true, true },\n\t\t\t\t  bytes=  {(byte)49, 50}, \n\t\t\t\t  shorts= {(byte)49, 50},\n\t\t\t\t  ints=   {(byte)49, 50},\n                 longs=  {(byte)49, 50},\n\t \t \t      floats= {(byte)49, 50},\n\t\t\t      doubles={(byte)49, 50},\n\t\t\t\t  chars=  {'1','2'},\n                 str=true)\n\npublic class Test {}\n";
        env.addClass(srcRoot, "sample", "Test", content);
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from boolean to String", testPath), new ExpectedProblem("", "type mismatch for member str expected java.lang.String but got java.lang.Boolean", testPath)});
    }

    public void testErrorStringValue_Reflection() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.RefAnnotationWithArray;\n@RefAnnotationWithArray(booleans={true, true },\n\t\t\t\t  bytes=  {(byte)49, 50}, \n\t\t\t\t  shorts= {(byte)49, 50},\n\t\t\t\t  ints=   {(byte)49, 50},\n                 longs=  {(byte)49, 50},\n\t \t \t      floats= {(byte)49, 50},\n\t\t\t      doubles={(byte)49, 50},\n\t\t\t\t  chars=  {'1','2'},\n                 str=true)\n\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "Type mismatch: cannot convert from boolean to String", testPath), new ExpectedProblem("", "value mismatch for member str expected string but got null", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }

    public void testMissingPrimitiveTypeValues_Reflection() throws Exception {
        IProject project = this.setupTest();
        IPath srcRoot = this.getSourcePath();
        String content = "package sample; \n\nimport org.eclipse.jdt.apt.tests.annotations.valueconversion.RefAnnotation;\n@RefAnnotation()\npublic class Test {}\n";
        IPath testPath = env.addClass(srcRoot, "sample", "Test", content);
        this.fullBuild(project.getFullPath());
        this.expectingSpecificProblemsFor(testPath, new ExpectedProblem[]{new ExpectedProblem("", "The annotation @RefAnnotation must define the attribute z", testPath), new ExpectedProblem("", "The annotation @RefAnnotation must define the attribute c", testPath), new ExpectedProblem("", "The annotation @RefAnnotation must define the attribute b", testPath), new ExpectedProblem("", "The annotation @RefAnnotation must define the attribute s", testPath), new ExpectedProblem("", "The annotation @RefAnnotation must define the attribute i", testPath), new ExpectedProblem("", "The annotation @RefAnnotation must define the attribute l", testPath), new ExpectedProblem("", "The annotation @RefAnnotation must define the attribute f", testPath), new ExpectedProblem("", "The annotation @RefAnnotation must define the attribute d", testPath), new ExpectedProblem("", "value mismatch for member z expected true but got false", testPath), new ExpectedProblem("", "value mismatch for member s expected 49 but got 0", testPath), new ExpectedProblem("", "value mismatch for member i expected 49 but got 0", testPath), new ExpectedProblem("", "value mismatch for member c expected 1 but got 0", testPath), new ExpectedProblem("", "value mismatch for member b expected 49 but got 0", testPath), new ExpectedProblem("", "value mismatch for member l expected 49 but got 0", testPath), new ExpectedProblem("", "value mismatch for member f expected 49.0 but got 0.0", testPath), new ExpectedProblem("", "value mismatch for member d expected 49.0 but got 0.0", testPath)});
        AnnotationValueConversionTests.assertEquals((String)"NO ERRORS", (String)ProcessorTestStatus.getErrors());
    }
}

