/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.FactoryPluginManager;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedSourceFolderManager;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.apt.core.internal.util.FactoryPathUtil;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.util.Util;

public class PreferencesTests
extends APTTestBase {
    private static final String JAR_PATH_1;
    private static final String JAR_PATH_2;
    private static final String serializedFactories;

    static {
        File jar1 = null;
        File jar2 = null;
        try {
            try {
                jar1 = File.createTempFile("test1", "jar");
                jar2 = File.createTempFile("test2", "jar");
                JAR_PATH_1 = jar1.getAbsolutePath();
                JAR_PATH_2 = jar2.getAbsolutePath();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not create temp jar files", ioe);
            }
        }
        finally {
            if (jar1 != null) {
                jar1.delete();
            }
            if (jar2 != null) {
                jar2.delete();
            }
        }
        serializedFactories = "<factorypath>\n    <factorypathentry kind=\"EXTJAR\" id=\"" + JAR_PATH_1 + "\" enabled=\"true\" runInBatchMode=\"false\"/>\n" + "    <factorypathentry kind=\"EXTJAR\" id=\"" + JAR_PATH_2 + "\" enabled=\"true\" runInBatchMode=\"true\"/>\n" + "    <factorypathentry kind=\"PLUGIN\" id=\"org.eclipse.jdt.apt.tests\" enabled=\"false\" runInBatchMode=\"false\"/>\n" + "</factorypath>\n";
    }

    public PreferencesTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(PreferencesTests.class);
    }

    public void testFactoryPathEncodingAndDecoding() throws Exception {
        Map factories = new LinkedHashMap<FactoryContainer, FactoryPath.Attributes>();
        FactoryContainer jarFactory1 = FactoryPathUtil.newExtJarFactoryContainer((File)new File(JAR_PATH_1));
        FactoryPath.Attributes jarFPA1 = new FactoryPath.Attributes(true, false);
        FactoryContainer jarFactory2 = FactoryPathUtil.newExtJarFactoryContainer((File)new File(JAR_PATH_2));
        FactoryPath.Attributes jarFPA2 = new FactoryPath.Attributes(true, true);
        FactoryContainer pluginFactory = FactoryPluginManager.getPluginFactoryContainer((String)"org.eclipse.jdt.apt.tests");
        FactoryPath.Attributes pluginFPA = new FactoryPath.Attributes(false, false);
        factories.put(jarFactory1, jarFPA1);
        factories.put(jarFactory2, jarFPA2);
        factories.put(pluginFactory, pluginFPA);
        String xml = FactoryPathUtil.encodeFactoryPath(factories);
        PreferencesTests.assertEquals((String)serializedFactories, (String)xml);
        factories = FactoryPathUtil.decodeFactoryPath((String)xml);
        PreferencesTests.assertEquals((int)3, (int)factories.size());
        int index = 0;
        for (Map.Entry entry : factories.entrySet()) {
            FactoryContainer container = (FactoryContainer)entry.getKey();
            switch (index) {
                case 0: {
                    PreferencesTests.assertEquals((Object)FactoryContainer.FactoryType.EXTJAR, (Object)container.getType());
                    PreferencesTests.assertTrue((boolean)((FactoryPath.Attributes)entry.getValue()).isEnabled());
                    PreferencesTests.assertFalse((boolean)((FactoryPath.Attributes)entry.getValue()).runInBatchMode());
                    break;
                }
                case 1: {
                    PreferencesTests.assertEquals((Object)FactoryContainer.FactoryType.EXTJAR, (Object)container.getType());
                    PreferencesTests.assertTrue((boolean)((FactoryPath.Attributes)entry.getValue()).isEnabled());
                    PreferencesTests.assertTrue((boolean)((FactoryPath.Attributes)entry.getValue()).runInBatchMode());
                    break;
                }
                case 2: {
                    PreferencesTests.assertEquals((Object)FactoryContainer.FactoryType.PLUGIN, (Object)container.getType());
                    PreferencesTests.assertFalse((boolean)((FactoryPath.Attributes)entry.getValue()).isEnabled());
                    PreferencesTests.assertEquals((String)"org.eclipse.jdt.apt.tests", (String)container.getId());
                    break;
                }
                default: {
                    PreferencesTests.fail((String)("FactoryPath had an unexpected number of entries: " + (index + 1)));
                }
            }
            ++index;
        }
    }

    public void testSimpleConfigApi() throws Exception {
        IJavaProject jproj = env.getJavaProject(this.getProjectName());
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)false);
        PreferencesTests.assertFalse((boolean)AptConfig.isEnabled((IJavaProject)jproj));
        PreferencesTests.assertFalse((boolean)AptConfig.isEnabled(null));
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)true);
        PreferencesTests.assertTrue((boolean)AptConfig.isEnabled((IJavaProject)jproj));
        PreferencesTests.assertFalse((boolean)AptConfig.isEnabled(null));
        HashMap<String, String> wkspOpts = new HashMap<String, String>(3);
        wkspOpts.put("b", "bVal");
        wkspOpts.put("another option", "and\\more \"punctuation!\"");
        AptConfig.setProcessorOptions(wkspOpts, null);
        Map retrievedWkspOpts = AptConfig.getRawProcessorOptions(null);
        PreferencesTests.assertTrue((String)"getRawProcessorOptions() should return the values set in setProcessorOptions()", (boolean)wkspOpts.equals(retrievedWkspOpts));
        HashMap<String, String> projOpts = new HashMap<String, String>(3);
        projOpts.put("a", "aVal");
        projOpts.put("with spaces", "value also has spaces");
        projOpts.put("foo", "bar");
        AptConfig.setProcessorOptions(projOpts, (IJavaProject)jproj);
        Map retrievedProjOpts = AptConfig.getRawProcessorOptions((IJavaProject)jproj);
        PreferencesTests.assertTrue((String)"getRawProcessorOptions() should return the values set in setProcessorOptions()", (boolean)projOpts.equals(retrievedProjOpts));
        wkspOpts.clear();
        wkspOpts.put("noodle", "nubble");
        wkspOpts.put("spoo/mack", "wumpus");
        AptConfig.setProcessorOptions(wkspOpts, null);
        retrievedWkspOpts = AptConfig.getRawProcessorOptions(null);
        PreferencesTests.assertTrue((String)"getRawProcessorOptions() should return the values set in setProcessorOptions()", (boolean)wkspOpts.equals(retrievedWkspOpts));
        projOpts.clear();
        projOpts.put("smurf", "more smurfs\\=bad");
        projOpts.put("baz/quack", "quux");
        AptConfig.setProcessorOptions(projOpts, (IJavaProject)jproj);
        retrievedProjOpts = AptConfig.getRawProcessorOptions((IJavaProject)jproj);
        PreferencesTests.assertTrue((String)"getRawProcessorOptions() should return the values set in setProcessorOptions()", (boolean)projOpts.equals(retrievedProjOpts));
        AptConfig.addProcessorOption((IJavaProject)jproj, (String)"foo", (String)"bar");
        AptConfig.addProcessorOption((IJavaProject)jproj, (String)"space", (String)"\"text with spaces\"");
        AptConfig.addProcessorOption((IJavaProject)jproj, (String)"quux", null);
        AptConfig.addProcessorOption((IJavaProject)jproj, (String)"quux", null);
        Map options = AptConfig.getProcessorOptions((IJavaProject)jproj);
        String val = (String)options.get("foo");
        PreferencesTests.assertEquals((String)val, (String)"bar");
        val = (String)options.get("quux");
        PreferencesTests.assertNull((Object)val);
        val = (String)options.get("space");
        PreferencesTests.assertEquals((String)val, (String)"\"text with spaces\"");
        AptConfig.removeProcessorOption((IJavaProject)jproj, (String)"foo");
        options = AptConfig.getProcessorOptions((IJavaProject)jproj);
        PreferencesTests.assertFalse((boolean)options.containsKey("foo"));
        PreferencesTests.assertTrue((boolean)options.containsKey("quux"));
        AptConfig.removeProcessorOption((IJavaProject)jproj, (String)"quux");
        AptConfig.removeProcessorOption((IJavaProject)jproj, (String)"anOptionThatDoesn'tExist");
        AptConfig.addProcessorOption(null, (String)"workspace option", (String)"corresponding value");
        AptConfig.addProcessorOption(null, (String)"foo", (String)"whatever");
        AptConfig.removeProcessorOption(null, (String)"foo");
        options = AptConfig.getProcessorOptions(null);
        PreferencesTests.assertFalse((boolean)options.containsKey("foo"));
        PreferencesTests.assertTrue((boolean)options.containsKey("workspace option"));
        AptConfig.removeProcessorOption(null, (String)"workspace option");
    }

    public void testAutomaticOptions() throws Exception {
        IJavaProject jproj = env.getJavaProject(this.getProjectName());
        Map options = AptConfig.getProcessorOptions((IJavaProject)jproj);
        String classpath = (String)options.get("-classpath");
        PreferencesTests.assertNotNull((Object)classpath);
        PreferencesTests.assertTrue((classpath.length() > 0 ? 1 : 0) != 0);
        String sourcepath = (String)options.get("-sourcepath");
        PreferencesTests.assertNotNull((Object)sourcepath);
        PreferencesTests.assertTrue((sourcepath.length() > 0 ? 1 : 0) != 0);
        String target = (String)options.get("-target");
        PreferencesTests.assertEquals((String)target, (String)"1.5");
        String source = (String)options.get("-source");
        PreferencesTests.assertEquals((String)source, (String)"1.5");
        String bindir = (String)options.get("-d");
        PreferencesTests.assertNotNull((Object)bindir);
        PreferencesTests.assertTrue((bindir.length() > 0 ? 1 : 0) != 0);
        String gensrcdirAuto = (String)options.get("-s");
        PreferencesTests.assertNotNull((Object)gensrcdirAuto);
        PreferencesTests.assertTrue((gensrcdirAuto.length() > 0 ? 1 : 0) != 0);
    }

    public void testGenSrcDir() throws Exception {
        IJavaProject jproj = env.getJavaProject(this.getProjectName());
        String genSrcDir = AptConfig.getGenSrcDir((IJavaProject)jproj);
        PreferencesTests.assertEquals((String)".apt_generated", (String)genSrcDir);
        AptConfig.setGenSrcDir((IJavaProject)jproj, (String)"gen/src");
        genSrcDir = AptConfig.getGenSrcDir((IJavaProject)jproj);
        PreferencesTests.assertEquals((String)"gen/src", (String)genSrcDir);
    }

    public void testConfigGenSrcDir() throws Exception {
        IPath projectPath = env.addProject("ConfigTestProj", "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        IJavaProject javaProj = env.getJavaProject("ConfigTestProj");
        boolean aptEnabled = AptConfig.isEnabled((IJavaProject)javaProj);
        PreferencesTests.assertEquals((boolean)false, (boolean)aptEnabled);
        GeneratedSourceFolderManager gsfm = AptPlugin.getAptProject((IJavaProject)javaProj).getGeneratedSourceFolderManager();
        IFolder srcFolder = gsfm.getFolder();
        String folderName = srcFolder.getProjectRelativePath().toOSString();
        PreferencesTests.assertEquals((boolean)srcFolder.exists(), (boolean)false);
        PreferencesTests.assertEquals((String)folderName, (String)".apt_generated");
        String newName = ".gensrcdir";
        AptConfig.setGenSrcDir((IJavaProject)javaProj, (String)newName);
        srcFolder = gsfm.getFolder();
        folderName = srcFolder.getProjectRelativePath().toOSString();
        PreferencesTests.assertEquals((boolean)false, (boolean)srcFolder.exists());
        PreferencesTests.assertEquals((String)newName, (String)folderName);
        PreferencesTests.assertEquals((boolean)false, (boolean)this.isOnClasspath(javaProj, srcFolder.getFullPath()));
        AptConfig.setEnabled((IJavaProject)javaProj, (boolean)true);
        aptEnabled = AptConfig.isEnabled((IJavaProject)javaProj);
        PreferencesTests.assertEquals((boolean)true, (boolean)aptEnabled);
        srcFolder = gsfm.getFolder();
        folderName = srcFolder.getProjectRelativePath().toOSString();
        PreferencesTests.assertEquals((boolean)true, (boolean)srcFolder.exists());
        PreferencesTests.assertEquals((String)newName, (String)folderName);
        PreferencesTests.assertEquals((boolean)true, (boolean)this.isOnClasspath(javaProj, srcFolder.getFullPath()));
        AptConfig.setEnabled((IJavaProject)javaProj, (boolean)false);
        aptEnabled = AptConfig.isEnabled((IJavaProject)javaProj);
        PreferencesTests.assertEquals((boolean)false, (boolean)aptEnabled);
        srcFolder = gsfm.getFolder();
        folderName = srcFolder.getProjectRelativePath().toOSString();
        PreferencesTests.assertEquals((boolean)false, (boolean)srcFolder.exists());
        PreferencesTests.assertEquals((String)newName, (String)folderName);
        PreferencesTests.assertEquals((boolean)false, (boolean)this.isOnClasspath(javaProj, srcFolder.getFullPath()));
    }

    private boolean isOnClasspath(IJavaProject javaProj, IPath path) throws JavaModelException {
        IClasspathEntry[] cp = javaProj.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getPath().equals((Object)path)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

