/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedSourceFolderManager;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.apt.tests.APTTestBase;
import org.eclipse.jdt.apt.tests.ExpectedProblem;
import org.eclipse.jdt.apt.tests.TestUtil;
import org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotationProcessor;
import org.eclipse.jdt.apt.tests.annotations.messager.MessagerAnnotationProcessor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.tests.util.Util;

public class StarProcessorTests
extends APTTestBase {
    public StarProcessorTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(StarProcessorTests.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        IPath projectPath = env.addProject(StarProcessorTests.getProjectName_ProjectRootAsSrcDir(), "1.5");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.setOutputFolder(projectPath, "bin");
        IJavaProject jproj = env.getJavaProject(projectPath);
        AptConfig.setEnabled((IJavaProject)jproj, (boolean)true);
        TestUtil.createAndAddAnnotationJar(jproj);
    }

    public static String getProjectName_ProjectRootAsSrcDir() {
        return String.valueOf(StarProcessorTests.class.getName()) + "NoSrcProject";
    }

    public IPath getSourcePath(String projectName) {
        if (StarProcessorTests.getProjectName_ProjectRootAsSrcDir().equals(projectName)) {
            return new Path("/" + StarProcessorTests.getProjectName_ProjectRootAsSrcDir());
        }
        IProject project = env.getProject(projectName);
        IFolder srcFolder = project.getFolder("src");
        IPath srcRoot = srcFolder.getFullPath();
        return srcRoot;
    }

    public void testGeneratedFileInBuilder() throws Exception {
        this._testGeneratedFileInBuilder0(this.getProjectName());
    }

    public void testGeneratedFileInBuilder_ProjectRootAsSourceDir() throws Exception {
        this._testGeneratedFileInBuilder0(StarProcessorTests.getProjectName_ProjectRootAsSrcDir());
    }

    public void testGeneratedFileInBuilder1() throws Exception {
        this._testGeneratedFileInBuilder1(this.getProjectName());
    }

    private void _testGeneratedFileInBuilder0(String projectName) {
        IProject project = env.getProject(projectName);
        IPath srcRoot = this.getSourcePath(projectName);
        String code = "package p1;\n//import org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class A \n{    //@HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        generatedfilepackage.GeneratedFileTest.helloWorld();\n    }\n}\n";
        IPath p1aPath = env.addClass(srcRoot, "p1", "A", code);
        this.fullBuild(project.getFullPath());
        this.expectingOnlyProblemsFor(p1aPath);
        this.expectingOnlySpecificProblemFor(p1aPath, new ExpectedProblem("A", "generatedfilepackage cannot be resolved", p1aPath));
        code = "package p1;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class A \n{    @HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n         generatedfilepackage.GeneratedFileTest.helloWorld();\n    }\n}\n";
        env.addClass(srcRoot, "p1", "A", code);
        this.fullBuild(project.getFullPath());
        this.expectingOnlyProblemsFor(new IPath[0]);
    }

    private void _testGeneratedFileInBuilder1(String projectName) {
        IProject project = env.getProject(projectName);
        IPath srcRoot = this.getSourcePath(projectName);
        String code = "package p1;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;import generatedfilepackage.GeneratedFileTest;\npublic class A \n{    @HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        GeneratedFileTest.helloWorld();\n    }\n}\n";
        env.addClass(srcRoot, "p1", "A", code);
        this.fullBuild(project.getFullPath());
        this.expectingOnlyProblemsFor(new IPath[0]);
    }

    public void testGeneratingIllegalTypeName() {
        String projectName = this.getProjectName();
        this.clearProcessorResult(HelloWorldAnnotationProcessor.class);
        IProject project = env.getProject(projectName);
        IPath srcRoot = this.getSourcePath(projectName);
        String code = "package p1;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;import generatedfilepackage.GeneratedFileTest;\npublic class A \n{    @HelloWorldAnnotation(\"Bad-Type-Name\")\n    public static void main( String[] argv )\n    {\n        GeneratedFileTest.helloWorld();\n    }\n}\n";
        env.addClass(srcRoot, "p1", "A", code);
        this.fullBuild(project.getFullPath());
        StarProcessorTests.assertEquals((String)"Could not generate text file due to IOException", (String)this.getProcessorResult(HelloWorldAnnotationProcessor.class));
        String code2 = "package p1;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;import generatedfilepackage.lowercase;\npublic class A \n{    @HelloWorldAnnotation(\"lowercase\")\n    public static void main( String[] argv )\n    {\n        lowercase.helloWorld();\n    }\n}\n";
        env.addClass(srcRoot, "p1", "A", code2);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
    }

    public void testTwoAnnotations() {
        String projectName = this.getProjectName();
        this.clearProcessorResult(HelloWorldAnnotationProcessor.class);
        this.clearProcessorResult(MessagerAnnotationProcessor.class);
        IProject project = env.getProject(projectName);
        IPath srcRoot = this.getSourcePath(projectName);
        String codeMessageFirst = "package p1;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\nimport org.eclipse.jdt.apt.tests.annotations.messager.MessagerAnnotation;\nimport generatedfilepackage.GeneratedFileTest;\n@MessagerAnnotation(severity=MessagerAnnotation.Severity.ERROR)\n@HelloWorldAnnotation\npublic class A {\n    public static void main( String[] argv ) {\n        GeneratedFileTest.helloWorld();\n    }\n}\n";
        IPath p1aPath = env.addClass(srcRoot, "p1", "A", codeMessageFirst);
        this.fullBuild(project.getFullPath());
        this.checkProcessorResult(HelloWorldAnnotationProcessor.class);
        this.checkProcessorResult(MessagerAnnotationProcessor.class);
        this.expectingOnlySpecificProblemFor(p1aPath, new ExpectedProblem("A", "Annotated with MessagerAnnotation(ERROR)", p1aPath));
    }

    public void testNestedGeneratedFileInBuilder() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath(this.getProjectName());
        String code = "package p1;\n//import org.eclipse.jdt.apt.tests.annotations.nestedhelloworld.NestedHelloWorldAnnotation;import generatedfilepackage.GeneratedFileTest;\npublic class A \n{    //@NestedHelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        GeneratedFileTest.helloWorld();\n    }\n}\n";
        IPath p1aPath = env.addClass(srcRoot, "p1", "A", code);
        this.fullBuild(project.getFullPath());
        this.expectingOnlyProblemsFor(p1aPath);
        this.expectingOnlySpecificProblemFor(p1aPath, new ExpectedProblem("A", "GeneratedFileTest cannot be resolved", p1aPath));
        code = "package p1;\nimport org.eclipse.jdt.apt.tests.annotations.nestedhelloworld.NestedHelloWorldAnnotation;\nimport generatedfilepackage.GeneratedFileTest;\npublic class A \n{    @NestedHelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        GeneratedFileTest.helloWorld();\n    }\n}\n";
        env.addClass(srcRoot, "p1", "A", code);
        this.fullBuild(project.getFullPath());
        this.expectingOnlyProblemsFor(new IPath[0]);
    }

    public void testExtraDependencies() {
        String codeA = "package p1.p2.p3.p4;\npublic class A { B b; }";
        String codeB1 = "package p1.p2.p3.p4;\npublic class B { }";
        String codeB2 = "package p1.p2.p3.p4;\npublic class B { public static void main( String[] argv ) {} }";
        String codeC = "package p1.p2.p3.p4;\npublic class C { }";
        String codeC2 = "package p1.p2.p3.p4;\npublic class C { public int foo; }";
        String codeD = "package p1.p2.p3.p4;\npublic class D { }";
        String codeE = "package p1.p2.p3.p4;\npublic class E { }";
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath(this.getProjectName());
        env.addClass(srcRoot, "p1.p2.p3.p4", "A", codeA);
        env.addClass(srcRoot, "p1.p2.p3.p4", "B", codeB1);
        env.addClass(srcRoot, "p1.p2.p3.p4", "C", codeC);
        env.addClass(srcRoot, "p1.p2.p3.p4", "D", codeD);
        env.addClass(srcRoot, "p1.p2.p3.p4", "E", codeE);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        env.addClass(srcRoot, "p1.p2.p3.p4", "B", codeB2);
        this.incrementalBuild(project.getFullPath());
        this.expectingNoProblems();
        this.expectingCompiledClasses(new String[]{"p1.p2.p3.p4.B", "p1.p2.p3.p4.A"});
        this.expectingCompilingOrder(new String[]{"p1.p2.p3.p4.B", "p1.p2.p3.p4.A"});
        codeA = "package p1.p2.p3.p4;\nimport org.eclipse.jdt.apt.tests.annotations.extradependency.ExtraDependencyAnnotation;\n@ExtraDependencyAnnotation\npublic class A {  }";
        env.addClass(srcRoot, "p1.p2.p3.p4", "A", codeA);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        env.addClass(srcRoot, "p1.p2.p3.p4", "C", codeC2);
        this.incrementalBuild(project.getFullPath());
        this.expectingNoProblems();
        this.expectingCompiledClasses(new String[]{"p1.p2.p3.p4.C", "p1.p2.p3.p4.A", "p1.p2.p3.p4.A"});
        this.expectingCompilingOrder(new String[]{"p1.p2.p3.p4.C", "p1.p2.p3.p4.A", "p1.p2.p3.p4.A"});
        codeA = "package p1.p2.p3.p4;\nimport org.eclipse.jdt.apt.tests.annotations.noop.NoOpAnnotation;\n@NoOpAnnotation\npublic class A { B b; D d; }";
        env.addClass(srcRoot, "p1.p2.p3.p4", "A", codeA);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        env.addClass(srcRoot, "p1.p2.p3.p4", "C", codeC2);
        this.incrementalBuild(project.getFullPath());
        this.expectingNoProblems();
        this.expectingCompiledClasses(new String[]{"p1.p2.p3.p4.C"});
        this.expectingCompilingOrder(new String[]{"p1.p2.p3.p4.C"});
    }

    public void testCaching() {
        String code = "package p1;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class A \n{    @HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n    }\n}\n";
        String modifiedCode = "package p1;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class A \n{    @HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        \n    }\n    public static void otherMethod()\n    {        System.out.println();\n    }}\n";
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath(this.getProjectName());
        env.addClass(srcRoot, "p1", "A", code);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        this.expectingCompiledClasses(new String[]{"p1.A", "p1.A", "generatedfilepackage.GeneratedFileTest"});
        env.addClass(srcRoot, "p1", "A", modifiedCode);
        this.incrementalBuild(project.getFullPath());
        this.expectingNoProblems();
        this.expectingCompiledClasses(new String[]{"p1.A", "p1.A"});
    }

    public void testDeletedParentFile() throws Exception {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath(this.getProjectName());
        String a1Code = "package p1; \nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\n@HelloWorldAnnotation\npublic class A1 {}";
        String a2Code = "package p1; \nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\n@HelloWorldAnnotation\npublic class A2 {}";
        String bCode = "package p1; \npublic class B { generatedfilepackage.GeneratedFileTest gft; }";
        IPath p1a1Path = env.addClass(srcRoot, "p1", "A1", a1Code);
        IPath p1a2Path = env.addClass(srcRoot, "p1", "A2", a2Code);
        IPath p1bPath = env.addClass(srcRoot, "p1", "B", bCode);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        TestUtil.deleteFile(p1a1Path);
        StarProcessorTests.sleep(1000L);
        this.incrementalBuild(project.getFullPath());
        this.expectingNoProblems();
        TestUtil.deleteFile(p1a2Path);
        StarProcessorTests.sleep(1000L);
        this.incrementalBuild(project.getFullPath());
        this.expectingOnlyProblemsFor(p1bPath);
        this.expectingOnlySpecificProblemFor(p1bPath, new ExpectedProblem("B", "generatedfilepackage cannot be resolved to a type", p1bPath));
    }

    public void testStopGeneratingFileInBuilder_FullBuild() {
        this.internalTestStopGeneratingFileInBuilder(true);
    }

    public void testStopGeneratingFileInBuilder_IncrementalBuild() {
        this.internalTestStopGeneratingFileInBuilder(false);
    }

    private void internalTestStopGeneratingFileInBuilder(boolean fullBuild) {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath(this.getProjectName());
        String code = "package p1;\n//import org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\nimport generatedfilepackage.GeneratedFileTest;\npublic class A \n{    //@HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        GeneratedFileTest.helloWorld();\n    }\n}\n";
        IPath p1aPath = env.addClass(srcRoot, "p1", "A", code);
        if (fullBuild) {
            this.fullBuild(project.getFullPath());
        } else {
            this.incrementalBuild(project.getFullPath());
        }
        this.expectingOnlyProblemsFor(p1aPath);
        this.expectingOnlySpecificProblemsFor(p1aPath, new ExpectedProblem[]{new ExpectedProblem("A", "The import generatedfilepackage cannot be resolved", p1aPath), new ExpectedProblem("A", "GeneratedFileTest cannot be resolved", p1aPath)});
        code = "package p1;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;import generatedfilepackage.GeneratedFileTest;\npublic class A \n{    @HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        GeneratedFileTest.helloWorld();\n    }\n}\n";
        env.addClass(srcRoot, "p1", "A", code);
        if (fullBuild) {
            this.fullBuild(project.getFullPath());
        } else {
            this.incrementalBuild(project.getFullPath());
        }
        this.expectingOnlyProblemsFor(new IPath[0]);
        if (!fullBuild) {
            this.fullBuild(project.getFullPath());
        }
        code = "package p1;\n//import org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;import generatedfilepackage.GeneratedFileTest;\npublic class A \n{    //@HelloWorldAnnotation\n    public static void main( String[] argv )\n    {\n        GeneratedFileTest.helloWorld();\n    }\n}\n";
        env.addClass(srcRoot, "p1", "A", code);
        if (fullBuild) {
            this.fullBuild(project.getFullPath());
        } else {
            this.incrementalBuild(project.getFullPath());
        }
        this.expectingOnlyProblemsFor(p1aPath);
        this.expectingOnlySpecificProblemFor(p1aPath, new ExpectedProblem("A", "GeneratedFileTest cannot be resolved", p1aPath));
    }

    public void testAPTRounding() {
        IProject project = env.getProject(this.getProjectName());
        IPath srcRoot = this.getSourcePath(this.getProjectName());
        String codeX = "package p1;\n\n import org.eclipse.jdt.apt.tests.annotations.aptrounding.*;\n@GenBean\npublic class X {}\n";
        env.addClass(srcRoot, "p1", "X", codeX);
        String codeY = "package p1;\n\n import org.eclipse.jdt.apt.tests.annotations.aptrounding.*;public class Y { @GenBean2 test.Bean _bean = null; }\n";
        env.addClass(srcRoot, "p1", "Y", codeY);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
    }

    public void testConfigMarker() throws Exception {
        IJavaProject javaProj = this.createJavaProject("ConfigMarkerTestProject");
        IClasspathEntry[] cp = javaProj.getRawClasspath();
        IProject project = env.getProject("ConfigMarkerTestProject");
        IPath srcRoot = this.getSourcePath("ConfigMarkerTestProject");
        String code = "package pkg;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class Foo{\n    @HelloWorldAnnotation\n    public static void main( String[] argv ){}\n}";
        env.addClass(srcRoot, "pkg", "Foo", code);
        AptConfig.setEnabled((IJavaProject)javaProj, (boolean)true);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        this.expectingNoMarkers();
        javaProj.setRawClasspath(cp, null);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        this.expectingMarkers(new String[]{"Generated source folder '.apt_generated' is missing from classpath"});
        code = "package pkg;\n\npublic class Foo{\n    public static void main( String[] argv ){}\n}";
        env.addClass(srcRoot, "pkg", "Foo", code);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        this.expectingNoMarkers();
    }

    public void testDeletedGeneratedSourceFolder() throws Exception {
        IJavaProject javaProj = this.createJavaProject("DeleteGenSourceFolderTestProject");
        IProject project = env.getProject("DeleteGenSourceFolderTestProject");
        IPath srcRoot = this.getSourcePath("DeleteGenSourceFolderTestProject");
        String code = "package pkg;\nimport org.eclipse.jdt.apt.tests.annotations.helloworld.HelloWorldAnnotation;\npublic class Foo{\n    @HelloWorldAnnotation\n    public static void main( String[] argv ){}\n}";
        env.addClass(srcRoot, "pkg", "Foo", code);
        AptConfig.setEnabled((IJavaProject)javaProj, (boolean)true);
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        this.expectingNoMarkers();
        GeneratedSourceFolderManager mgr = AptPlugin.getAptProject((IJavaProject)javaProj).getGeneratedSourceFolderManager();
        IFolder srcFolder = mgr.getFolder();
        StarProcessorTests.assertEquals((boolean)true, (boolean)srcFolder.exists());
        Util.delete((IResource)srcFolder);
        StarProcessorTests.assertEquals((boolean)false, (boolean)srcFolder.exists());
        this.fullBuild(project.getFullPath());
        this.expectingNoProblems();
        this.expectingNoMarkers();
    }
}

