/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.compiler.tool.tests;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.ServiceLoader;
import javax.lang.model.SourceVersion;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.compiler.tool.tests.AbstractCompilerToolTest;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.tool.EclipseCompiler;

public class CompilerToolJava9Tests
extends TestCase {
    private static final boolean DEBUG = false;
    private static final String RESOURCES_DIR = "resources";
    private JavaCompiler[] compilers;
    private String[] compilerNames;
    private boolean isJREBelow9;
    private static String _tmpFolder;
    private static String _tmpSrcFolderName;
    private static File _tmpSrcDir;
    private static String _tmpBinFolderName;
    private static File _tmpBinDir;
    public static String _tmpGenFolderName;
    private static File _tmpGenDir;
    private static String modules_directory;

    public CompilerToolJava9Tests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        boolean bl = this.isJREBelow9 = SourceVersion.latest().compareTo(SourceVersion.RELEASE_8) <= 0;
        if (this.isJREBelow9) {
            return;
        }
        this.compilers = new JavaCompiler[2];
        this.compilerNames = new String[2];
        ServiceLoader<JavaCompiler> javaCompilerLoader = ServiceLoader.load(JavaCompiler.class);
        int compilerCounter = 0;
        for (JavaCompiler compiler : javaCompilerLoader) {
            ++compilerCounter;
            if (!(compiler instanceof EclipseCompiler)) continue;
            this.compilers[1] = compiler;
            this.compilerNames[1] = "Eclipse Compiler";
        }
        this.compilerNames[0] = "System compiler";
        this.compilers[0] = ToolProvider.getSystemJavaCompiler();
        CompilerToolJava9Tests.assertEquals((String)"Only one compiler available", (int)2, (int)compilerCounter);
        CompilerToolJava9Tests.assertNotNull((String)"System compiler unavailable", (Object)this.compilers[0]);
        CompilerToolJava9Tests.assertNotNull((String)"Eclipse compiler unavailable", (Object)this.compilers[1]);
        this.initializeLocations();
    }

    protected void initializeLocations() {
        _tmpFolder = System.getProperty("java.io.tmpdir");
        _tmpFolder = _tmpFolder.endsWith(File.separator) ? String.valueOf(_tmpFolder) + "eclipse-temp" : String.valueOf(_tmpFolder) + File.separator + "eclipse-temp";
        _tmpBinFolderName = String.valueOf(_tmpFolder) + File.separator + "bin";
        _tmpBinDir = new File(_tmpBinFolderName);
        CompilerToolJava9Tests.deleteTree(_tmpBinDir);
        _tmpBinDir.mkdirs();
        assert (_tmpBinDir.exists()) : "couldn't mkdirs " + _tmpBinFolderName;
        _tmpGenFolderName = String.valueOf(_tmpFolder) + File.separator + "gen-src";
        _tmpGenDir = new File(_tmpGenFolderName);
        CompilerToolJava9Tests.deleteTree(_tmpGenDir);
        _tmpGenDir.mkdirs();
        assert (_tmpGenDir.exists()) : "couldn't mkdirs " + _tmpGenFolderName;
        _tmpSrcFolderName = String.valueOf(_tmpFolder) + File.separator + "src";
        _tmpSrcDir = new File(_tmpSrcFolderName);
        CompilerToolJava9Tests.deleteTree(_tmpSrcDir);
        _tmpSrcDir.mkdirs();
        assert (_tmpSrcDir.exists()) : "couldn't mkdirs " + _tmpSrcFolderName;
        modules_directory = String.valueOf(CompilerToolJava9Tests.getPluginDirectoryPath()) + File.separator + RESOURCES_DIR + File.separator + "module_locations";
    }

    public void testGetLocationForModule1() {
        if (this.isJREBelow9) {
            return;
        }
        int i = 0;
        while (i < 2) {
            String cName = this.compilerNames[i];
            JavaCompiler compiler = this.compilers[i];
            StandardJavaFileManager manager = compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
            try {
                JavaFileManager.Location location = manager.getLocationForModule((JavaFileManager.Location)StandardLocation.SYSTEM_MODULES, "java.base");
                CompilerToolJava9Tests.assertNotNull((String)(String.valueOf(cName) + ": Location should not be null"), (Object)location);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                CompilerToolJava9Tests.fail((String)(String.valueOf(cName) + ": Should support getLocationForModule()"));
            }
            catch (IOException iOException) {
                CompilerToolJava9Tests.fail((String)(String.valueOf(cName) + ": Should support getLocationForModule()"));
            }
            ++i;
        }
    }

    public void testGetLocationForModule2() throws IOException {
        if (this.isJREBelow9) {
            return;
        }
        int i = 0;
        while (i < 2) {
            String cName = this.compilerNames[i];
            JavaCompiler compiler = this.compilers[i];
            StandardJavaFileManager manager = compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
            Path path = Paths.get(String.valueOf(modules_directory) + File.separator + "SimpleModules", new String[0]);
            manager.setLocationFromPaths(StandardLocation.MODULE_PATH, Arrays.asList(path));
            try {
                JavaFileManager.Location location = manager.getLocationForModule((JavaFileManager.Location)StandardLocation.MODULE_PATH, "module.two");
                CompilerToolJava9Tests.assertNotNull((String)(String.valueOf(cName) + ":module path location should not be null"), (Object)location);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                CompilerToolJava9Tests.fail((String)(String.valueOf(cName) + ":Should support getLocationForModule()"));
            }
            ++i;
        }
    }

    public void testGetLocationForModule3() throws IOException {
        if (this.isJREBelow9) {
            return;
        }
        int i = 0;
        while (i < 2) {
            String cName = this.compilerNames[i];
            JavaCompiler compiler = this.compilers[i];
            StandardJavaFileManager manager = compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
            Path path = Paths.get(String.valueOf(modules_directory) + File.separator + "SimpleModules" + File.separator + "module.one", new String[0]);
            manager.setLocationFromPaths(StandardLocation.MODULE_PATH, Arrays.asList(path));
            try {
                JavaFileManager.Location location = manager.getLocationForModule((JavaFileManager.Location)StandardLocation.MODULE_PATH, "module.one");
                CompilerToolJava9Tests.assertNotNull((String)(String.valueOf(cName) + ":module path location should not be null"), (Object)location);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                CompilerToolJava9Tests.fail((String)(String.valueOf(cName) + ":Should support getLocationForModule()"));
            }
            ++i;
        }
    }

    public void testOptionRelease1() {
        File inputFile;
        String tmpFolder;
        JavaCompiler compiler;
        block19: {
            if (this.isJREBelow9) {
                return;
            }
            compiler = this.compilers[1];
            tmpFolder = System.getProperty("java.io.tmpdir");
            inputFile = new File(tmpFolder, "X.java");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("package p;\npublic class X {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        StandardJavaFileManager manager = compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
        ForwardingJavaFileManager<StandardJavaFileManager> forwardingJavaFileManager = new ForwardingJavaFileManager<StandardJavaFileManager>(manager){

            @Override
            public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
                return super.getFileForInput(location, packageName, relativeName);
            }

            @Override
            public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
                return super.getJavaFileForInput(location, className, kind);
            }

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                JavaFileObject javaFileForOutput = super.getJavaFileForOutput(location, className, kind, sibling);
                return javaFileForOutput;
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        files.add(inputFile);
        Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromFiles(files);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(tmpFolder);
        options.add("--release");
        options.add("8");
        ByteArrayOutputStream errBuffer = new ByteArrayOutputStream();
        PrintWriter err = new PrintWriter(errBuffer);
        AbstractCompilerToolTest.CompilerInvocationDiagnosticListener listener = new AbstractCompilerToolTest.CompilerInvocationDiagnosticListener(err){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                JavaFileObject source = diagnostic.getSource();
                CompilerToolJava9Tests.assertNotNull((String)"No source", (Object)source);
                super.report(diagnostic);
            }
        };
        JavaCompiler.CompilationTask task = compiler.getTask(printWriter, forwardingJavaFileManager, listener, options, null, units);
        CompilerToolJava9Tests.assertTrue((String)"Has no location CLASS_OUPUT", (boolean)forwardingJavaFileManager.hasLocation(StandardLocation.CLASS_OUTPUT));
        Boolean result = task.call();
        printWriter.flush();
        printWriter.close();
        if (!result.booleanValue()) {
            System.err.println("Compilation failed: " + stringWriter.getBuffer().toString());
            CompilerToolJava9Tests.assertTrue((String)"Compilation failed ", (boolean)false);
        }
        ClassFileReader reader = null;
        try {
            reader = ClassFileReader.read((File)new File(tmpFolder, "p/X.class"), (boolean)true);
        }
        catch (ClassFormatException classFormatException) {
            CompilerToolJava9Tests.assertTrue((String)"Should not happen", (boolean)false);
        }
        catch (IOException iOException) {
            CompilerToolJava9Tests.assertTrue((String)"Should not happen", (boolean)false);
        }
        CompilerToolJava9Tests.assertNotNull((String)"No reader", (Object)reader);
        CompilerToolJava9Tests.assertEquals((String)"Wrong value", (long)0x340000L, (long)reader.getVersion());
        CompilerToolJava9Tests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
    }

    public void testOptionRelease2() {
        File inputFile;
        String tmpFolder;
        JavaCompiler compiler;
        block19: {
            if (this.isJREBelow9) {
                return;
            }
            compiler = this.compilers[1];
            tmpFolder = System.getProperty("java.io.tmpdir");
            inputFile = new File(tmpFolder, "X.java");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("package p;\npublic class X {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        StandardJavaFileManager manager = compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
        ForwardingJavaFileManager<StandardJavaFileManager> forwardingJavaFileManager = new ForwardingJavaFileManager<StandardJavaFileManager>(manager){

            @Override
            public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
                return super.getFileForInput(location, packageName, relativeName);
            }

            @Override
            public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
                return super.getJavaFileForInput(location, className, kind);
            }

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                JavaFileObject javaFileForOutput = super.getJavaFileForOutput(location, className, kind, sibling);
                return javaFileForOutput;
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        files.add(inputFile);
        Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromFiles(files);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(tmpFolder);
        options.add("--release");
        options.add("8");
        ByteArrayOutputStream errBuffer = new ByteArrayOutputStream();
        PrintWriter err = new PrintWriter(errBuffer);
        AbstractCompilerToolTest.CompilerInvocationDiagnosticListener listener = new AbstractCompilerToolTest.CompilerInvocationDiagnosticListener(err){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                JavaFileObject source = diagnostic.getSource();
                CompilerToolJava9Tests.assertNotNull((String)"No source", (Object)source);
                super.report(diagnostic);
            }
        };
        JavaCompiler.CompilationTask task = compiler.getTask(printWriter, forwardingJavaFileManager, listener, options, null, units);
        CompilerToolJava9Tests.assertTrue((String)"Has no location CLASS_OUPUT", (boolean)forwardingJavaFileManager.hasLocation(StandardLocation.CLASS_OUTPUT));
        Boolean result = task.call();
        printWriter.flush();
        printWriter.close();
        if (!result.booleanValue()) {
            System.err.println("Compilation failed: " + stringWriter.getBuffer().toString());
            CompilerToolJava9Tests.assertTrue((String)"Compilation failed ", (boolean)false);
        }
        ClassFileReader reader = null;
        try {
            reader = ClassFileReader.read((File)new File(tmpFolder, "p/X.class"), (boolean)true);
        }
        catch (ClassFormatException classFormatException) {
            CompilerToolJava9Tests.assertTrue((String)"Should not happen", (boolean)false);
        }
        catch (IOException iOException) {
            CompilerToolJava9Tests.assertTrue((String)"Should not happen", (boolean)false);
        }
        CompilerToolJava9Tests.assertNotNull((String)"No reader", (Object)reader);
        CompilerToolJava9Tests.assertEquals((String)"Wrong value", (long)0x340000L, (long)reader.getVersion());
        CompilerToolJava9Tests.assertTrue((String)"delete failed", (boolean)inputFile.delete());
    }

    public void testOptionRelease3() {
        File inputFile;
        String tmpFolder;
        JavaCompiler compiler;
        block17: {
            if (this.isJREBelow9) {
                return;
            }
            compiler = this.compilers[1];
            tmpFolder = System.getProperty("java.io.tmpdir");
            inputFile = new File(tmpFolder, "X.java");
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(inputFile));
                    writer.write("package p;\npublic class X {}");
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        StandardJavaFileManager manager = compiler.getStandardFileManager(null, Locale.getDefault(), Charset.defaultCharset());
        ForwardingJavaFileManager<StandardJavaFileManager> forwardingJavaFileManager = new ForwardingJavaFileManager<StandardJavaFileManager>(manager){

            @Override
            public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
                return super.getFileForInput(location, packageName, relativeName);
            }

            @Override
            public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
                return super.getJavaFileForInput(location, className, kind);
            }

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
                JavaFileObject javaFileForOutput = super.getJavaFileForOutput(location, className, kind, sibling);
                return javaFileForOutput;
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        files.add(inputFile);
        Iterable<? extends JavaFileObject> units = manager.getJavaFileObjectsFromFiles(files);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(tmpFolder);
        options.add("--release");
        options.add("8");
        options.add("-source");
        options.add("7");
        ByteArrayOutputStream errBuffer = new ByteArrayOutputStream();
        PrintWriter err = new PrintWriter(errBuffer);
        AbstractCompilerToolTest.CompilerInvocationDiagnosticListener listener = new AbstractCompilerToolTest.CompilerInvocationDiagnosticListener(err){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                JavaFileObject source = diagnostic.getSource();
                CompilerToolJava9Tests.assertNotNull((String)"No source", (Object)source);
                super.report(diagnostic);
            }
        };
        try {
            compiler.getTask(printWriter, forwardingJavaFileManager, listener, options, null, units);
            CompilerToolJava9Tests.fail((String)"compilation didn't fail as expected");
        }
        catch (IllegalArgumentException iae) {
            CompilerToolJava9Tests.assertEquals((String)"option -source is not supported when --release is used", (String)iae.getMessage());
        }
    }

    public void testGetJavaFileObjects() {
        if (this.isJREBelow9) {
            return;
        }
    }

    public void testGetJavaFileObjects2() {
        if (this.isJREBelow9) {
            return;
        }
    }

    public void testSetLocationAsPaths() {
        if (this.isJREBelow9) {
            return;
        }
    }

    public void testContains() {
        if (this.isJREBelow9) {
            return;
        }
    }

    public void testGetServiceLoader() {
        if (this.isJREBelow9) {
            return;
        }
    }

    public void testInferModuleName() {
        if (this.isJREBelow9) {
            return;
        }
    }

    public void testListLocationsForModules() {
        if (this.isJREBelow9) {
            return;
        }
    }

    public void testAsPath() {
        if (this.isJREBelow9) {
            return;
        }
    }

    public static void deleteTree(File f) {
        if (f == null) {
            return;
        }
        File[] children = f.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                CompilerToolJava9Tests.deleteTree(child);
                ++n2;
            }
        }
        f.delete();
    }

    public static void copyResource(File src, File dest) throws IOException {
        if (dest.exists() && src.lastModified() < dest.lastModified() && src.length() == dest.length()) {
            return;
        }
        byte[] srcBytes = null;
        srcBytes = CompilerToolJava9Tests.read(src);
        if (CompilerToolJava9Tests.shouldConvertToIndependentLineDelimiter(src)) {
            String contents = new String(srcBytes);
            contents = CompilerToolJava9Tests.convertToIndependentLineDelimiter(contents);
            srcBytes = contents.getBytes();
        }
        CompilerToolJava9Tests.writeFile(dest, srcBytes);
    }

    public static void writeFile(File dest, byte[] srcBytes) throws IOException {
        File destFolder = dest.getParentFile();
        if (!destFolder.exists() && !destFolder.mkdirs()) {
            throw new IOException("Unable to create directory " + destFolder);
        }
        try (FileOutputStream out = null;){
            out = new FileOutputStream(dest);
            out.write(srcBytes);
            out.flush();
        }
    }

    public static File copyResource(String resourcePath, File targetFolder) throws IOException {
        File resDir = new File(CompilerToolJava9Tests.getPluginDirectoryPath(), RESOURCES_DIR);
        File resourceFile = new File(resDir, resourcePath);
        File targetFile = new File(targetFolder, resourcePath);
        CompilerToolJava9Tests.copyResource(resourceFile, targetFile);
        return targetFile;
    }

    public static void copyResources(String resourceFolderName, File destFolder) throws IOException {
        File resDir = new File(CompilerToolJava9Tests.getPluginDirectoryPath(), RESOURCES_DIR);
        File resourceFolder = new File(resDir, resourceFolderName);
        CompilerToolJava9Tests.copyResources(resourceFolder, destFolder);
    }

    private static void copyResources(File resourceFolder, File destFolder) throws IOException {
        if (resourceFolder == null) {
            return;
        }
        String[] children = resourceFolder.list();
        if (children == null) {
            return;
        }
        String[] stringArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            if (!"CVS".equals(child)) {
                File childRes = new File(resourceFolder, child);
                File childDest = new File(destFolder, child);
                if (childRes.isDirectory()) {
                    CompilerToolJava9Tests.copyResources(childRes, childDest);
                } else {
                    CompilerToolJava9Tests.copyResource(childRes, childDest);
                }
            }
            ++n2;
        }
    }

    protected static String getPluginDirectoryPath() {
        try {
            if (Platform.isRunning()) {
                URL platformURL = Platform.getBundle((String)"org.eclipse.jdt.compiler.tool.tests").getEntry("/");
                return new File(FileLocator.toFileURL((URL)platformURL).getFile()).getAbsolutePath();
            }
            return new File(System.getProperty("user.dir")).getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean shouldConvertToIndependentLineDelimiter(File file) {
        return file.getName().endsWith(".java");
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] read(File file) throws IOException {
        int fileLength = (int)file.length();
        byte[] fileBytes = new byte[fileLength];
        try (FileInputStream stream = null;){
            block7: {
                int lastReadSize;
                int bytesRead;
                block6: {
                    stream = new FileInputStream(file);
                    bytesRead = 0;
                    lastReadSize = 0;
                    if (!true) break block6;
                    if (lastReadSize == -1) return fileBytes;
                    if (bytesRead == fileLength) break block7;
                }
                do {
                    lastReadSize = stream.read(fileBytes, bytesRead, fileLength - bytesRead);
                    bytesRead += lastReadSize;
                    if (lastReadSize == -1) return fileBytes;
                } while (bytesRead != fileLength);
            }
            return fileBytes;
        }
    }

    public static String convertToIndependentLineDelimiter(String source) {
        if (source.indexOf(10) == -1 && source.indexOf(13) == -1) {
            return source;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = source.length();
        while (i < length) {
            char car = source.charAt(i);
            if (car == '\r') {
                buffer.append('\n');
                if (i < length - 1 && source.charAt(i + 1) == '\n') {
                    ++i;
                }
            } else {
                buffer.append(car);
            }
            ++i;
        }
        return buffer.toString();
    }
}

