/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.Util;
import org.osgi.framework.Bundle;

public class AnnotationDependencyTests
extends BuilderTests {
    private IPath srcRoot = null;
    private IPath projectPath = null;

    public AnnotationDependencyTests(String name) {
        super(name);
    }

    public static Test suite() {
        return AnnotationDependencyTests.buildTestSuite(AnnotationDependencyTests.class);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.projectPath = env.addProject("Project", "1.5");
        env.addExternalJars(this.projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(this.projectPath, "");
        this.srcRoot = env.addPackageFragmentRoot(this.projectPath, "src");
        env.setOutputFolder(this.projectPath, "bin");
    }

    @Override
    protected void tearDown() throws Exception {
        this.projectPath = null;
        this.srcRoot = null;
        super.tearDown();
    }

    private void addAnnotationType() {
        String annoCode = "package p1;\n@interface Anno {\nString value();\n}\n";
        env.addClass(this.srcRoot, "p1", "Anno", annoCode);
        annoCode = "package p1;\n@interface AnnoInt {\nint value();\n}\n";
        env.addClass(this.srcRoot, "p1", "AnnoInt", annoCode);
        annoCode = "package p1;\n@interface AnnoBoolean {\nboolean value();\n}\n";
        env.addClass(this.srcRoot, "p1", "AnnoBoolean", annoCode);
        annoCode = "package p1;\n@interface AnnoByte {\nbyte value();\n}\n";
        env.addClass(this.srcRoot, "p1", "AnnoByte", annoCode);
        annoCode = "package p1;\n@interface AnnoChar {\nchar value();\n}\n";
        env.addClass(this.srcRoot, "p1", "AnnoChar", annoCode);
        annoCode = "package p1;\n@interface AnnoShort {\nshort value();\n}\n";
        env.addClass(this.srcRoot, "p1", "AnnoShort", annoCode);
        annoCode = "package p1;\n@interface AnnoDouble {\ndouble value();\n}\n";
        env.addClass(this.srcRoot, "p1", "AnnoDouble", annoCode);
        annoCode = "package p1;\n@interface AnnoFloat {\nfloat value();\n}\n";
        env.addClass(this.srcRoot, "p1", "AnnoFloat", annoCode);
        annoCode = "package p1;\n@interface AnnoLong {\nlong value();\n}\n";
        env.addClass(this.srcRoot, "p1", "AnnoLong", annoCode);
        annoCode = "package p1;\n@interface AnnoStringArray {\nString[] value();\n}\n";
        env.addClass(this.srcRoot, "p1", "AnnoStringArray", annoCode);
        annoCode = "package p1;\n@interface AnnoAnnotation {\nAnnoLong value();\n}\n";
        env.addClass(this.srcRoot, "p1", "AnnoAnnotation", annoCode);
        annoCode = "package p1;\nenum E {\nA, B, C\n}\n";
        env.addClass(this.srcRoot, "p1", "E", annoCode);
        annoCode = "package p1;\n@interface AnnoEnum {\nE value();\n}\n";
        env.addClass(this.srcRoot, "p1", "AnnoEnum", annoCode);
        annoCode = "package p1;\n@interface AnnoClass {\nClass<?> value();\n}\n";
        env.addClass(this.srcRoot, "p1", "AnnoClass", annoCode);
    }

    void setupProjectForNullAnnotations() throws IOException, JavaModelException {
        Bundle[] bundles = Platform.getBundles((String)"org.eclipse.jdt.annotation", (String)"[1.1.0,2.0.0)");
        File bundleFile = FileLocator.getBundleFile((Bundle)bundles[0]);
        String annotationsLib = bundleFile.isDirectory() ? String.valueOf(bundleFile.getPath()) + "/bin" : bundleFile.getPath();
        IJavaProject javaProject = env.getJavaProject(this.projectPath);
        IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
        int len = rawClasspath.length;
        IClasspathEntry[] iClasspathEntryArray = rawClasspath;
        rawClasspath = new IClasspathEntry[len + 1];
        System.arraycopy(iClasspathEntryArray, 0, rawClasspath, 0, len);
        rawClasspath[len] = JavaCore.newLibraryEntry((IPath)new Path(annotationsLib), null, null);
        javaProject.setRawClasspath(rawClasspath, null);
        javaProject.setOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", "enabled");
    }

    public void testTypeAnnotationDependency() throws Exception {
        String a1Code = "package p1; \n@Anno(\"A1\")\npublic class A {}";
        String a2Code = "package p1; \n@Anno(\"A2\")\npublic class A {}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testFieldAnnotationDependency() throws Exception {
        String a1Code = "package p1; \npublic class A {\n  @Anno(\"A1\")\n  protected int f;\n}";
        String a2Code = "package p1; \npublic class A {\n  @Anno(\"A2\")\n  protected int f;\n}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testMethodAnnotationDependency() throws Exception {
        String a1Code = "package p1; \npublic class A {\n  @Anno(\"A1\")\n  protected int f() { return 0; }\n}";
        String a2Code = "package p1; \npublic class A {\n  @Anno(\"A2\")\n  protected int f() { return 0; }\n}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testInnerTypeAnnotationDependency() throws Exception {
        String a1Code = "package p1; \npublic class A {\n  @Anno(\"A1\")\n  public class X { }\n}";
        String a2Code = "package p1; \npublic class A {\n  @Anno(\"A2\")\n  public class X { }\n}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.A$X", "p1.B"});
    }

    public void testUnrelatedTypeAnnotationDependency() throws Exception {
        String a1Code = "package p1; \n@Anno(\"A1\")\npublic class A {}";
        String a2Code = "package p1; \n@Anno(\"A2\")\npublic class A {}";
        String bCode = "package p1; \npublic class B {\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testPackageInfoDependency() throws Exception {
        String notypes = "@question.SimpleAnnotation(\"foo\") package notypes;";
        String question = "package question;";
        String deprecatedQuestion = "@Deprecated package question;";
        String SimpleAnnotation = "package question; \npublic @interface SimpleAnnotation { String value(); }";
        IPath notypesPath = env.addClass(this.srcRoot, "notypes", "package-info", notypes);
        env.addClass(this.srcRoot, "question", "package-info", question);
        env.addClass(this.srcRoot, "question", "SimpleAnnotation", SimpleAnnotation);
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "question", "package-info", deprecatedQuestion);
        this.incrementalBuild(this.projectPath);
        this.expectingOnlySpecificProblemFor(notypesPath, new Problem("", "The type SimpleAnnotation is deprecated", notypesPath, 10, 26, 110, 1));
        env.addClass(this.srcRoot, "question", "package-info", question);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
    }

    public void testTypeAnnotationDependency2() throws Exception {
        String a1Code = "package p1; \n@Anno(\"A1\")\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@Anno(\"A1\")\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testTypeAnnotationDependency3() throws Exception {
        String a1Code = "package p1; \n@AnnoInt(24)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoInt(24)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testTypeAnnotationDependency4() throws Exception {
        String a1Code = "package p1; \n@AnnoByte(3)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoByte(3)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testTypeAnnotationDependency5() throws Exception {
        String a1Code = "package p1; \n@AnnoBoolean(true)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoBoolean(true)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testTypeAnnotationDependency6() throws Exception {
        String a1Code = "package p1; \n@AnnoChar('c')\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoChar('c')\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testTypeAnnotationDependency7() throws Exception {
        String a1Code = "package p1; \n@AnnoDouble(1.0)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoDouble(1.0)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testTypeAnnotationDependency8() throws Exception {
        String a1Code = "package p1; \n@AnnoFloat(1.0f)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoFloat(1.0f)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testTypeAnnotationDependency9() throws Exception {
        String a1Code = "package p1; \n@AnnoLong(1L)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoLong(1L)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testTypeAnnotationDependency10() throws Exception {
        String a1Code = "package p1; \n@AnnoShort(3)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoShort(3)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testTypeAnnotationDependency11() throws Exception {
        String a1Code = "package p1; \n@AnnoStringArray({\"A1\",\"A2\"})\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoStringArray({\"A1\",\"A2\"})\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testTypeAnnotationDependency12() throws Exception {
        String a1Code = "package p1; \n@AnnoAnnotation(@AnnoLong(3))\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoAnnotation(@AnnoLong(3))\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testTypeAnnotationDependency13() throws Exception {
        String a1Code = "package p1; \n@AnnoEnum(E.A)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoEnum(E.A)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testTypeAnnotationDependency14() throws Exception {
        String a1Code = "package p1; \n@AnnoClass(Object.class)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoClass(Object.class)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A"});
    }

    public void testTypeAnnotationDependency15() throws Exception {
        String a1Code = "package p1; \n@Anno(\"A1\")\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@Anno(\"A2\")\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testTypeAnnotationDependency16() throws Exception {
        String a1Code = "package p1; \n@AnnoInt(3)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoInt(4)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testTypeAnnotationDependency17() throws Exception {
        String a1Code = "package p1; \n@AnnoByte(3)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoByte(4)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testTypeAnnotationDependency18() throws Exception {
        String a1Code = "package p1; \n@AnnoBoolean(true)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoBoolean(false)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testTypeAnnotationDependency19() throws Exception {
        String a1Code = "package p1; \n@AnnoChar('c')\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoChar('d')\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testTypeAnnotationDependency20() throws Exception {
        String a1Code = "package p1; \n@AnnoDouble(1.0)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoDouble(2.0)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testTypeAnnotationDependency21() throws Exception {
        String a1Code = "package p1; \n@AnnoFloat(1.0f)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoFloat(2.0f)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testTypeAnnotationDependency22() throws Exception {
        String a1Code = "package p1; \n@AnnoLong(1L)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoLong(2L)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testTypeAnnotationDependency23() throws Exception {
        String a1Code = "package p1; \n@AnnoShort(3)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoShort(5)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testTypeAnnotationDependency24() throws Exception {
        String a1Code = "package p1; \n@AnnoStringArray({\"A1\",\"A2\"})\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoStringArray({\"A2\",\"A1\"})\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testTypeAnnotationDependency25() throws Exception {
        String a1Code = "package p1; \n@AnnoAnnotation(@AnnoLong(3))\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoAnnotation(@AnnoLong(4))\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testTypeAnnotationDependency26() throws Exception {
        String a1Code = "package p1; \n@AnnoEnum(E.A)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoEnum(E.C)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testTypeAnnotationDependency27() throws Exception {
        String a1Code = "package p1; \n@AnnoClass(Object.class)\npublic class A {\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String a2Code = "package p1; \n@AnnoClass(String.class)\npublic class A {\n\n    public void foo() {\n        System.out.println(\"test\");    }}";
        String bCode = "package p1; \npublic class B {\n  public A a;\n}";
        env.addClass(this.srcRoot, "p1", "A", a1Code);
        env.addClass(this.srcRoot, "p1", "B", bCode);
        this.addAnnotationType();
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        env.addClass(this.srcRoot, "p1", "A", a2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.A", "p1.B"});
    }

    public void testParameterAnnotationDependency01() throws JavaModelException, IOException {
        this.setupProjectForNullAnnotations();
        String test1Code = "package p1;\npublic class Test1 {\n    public void foo() {\n        new Test2().bar(null);\n    }\n}";
        String test2Code = "package p1;\npublic class Test2 {\n    public void bar(String str) {}\n}";
        IPath test1Path = env.addClass(this.srcRoot, "p1", "Test1", test1Code);
        env.addClass(this.srcRoot, "p1", "Test2", test2Code);
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        String test2CodeB = "package p1;\nimport org.eclipse.jdt.annotation.NonNull;\npublic class Test2 {\n    public void bar(@NonNull String str) {}\n}";
        env.addClass(this.srcRoot, "p1", "Test2", test2CodeB);
        this.incrementalBuild(this.projectPath);
        this.expectingProblemsFor(test1Path, "Problem : Null type mismatch: required '@NonNull String' but the provided value is null [ resource : </Project/src/p1/Test1.java> range : <81,85> category : <90> severity : <2>]");
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test1", "p1.Test2"});
        String test2CodeC = "package p1;\nimport org.eclipse.jdt.annotation.Nullable;\npublic class Test2 {\n    public void bar(@Nullable String str) {}\n}";
        env.addClass(this.srcRoot, "p1", "Test2", test2CodeC);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test1", "p1.Test2"});
    }

    public void testReturnAnnotationDependency01() throws JavaModelException, IOException {
        this.setupProjectForNullAnnotations();
        String test1Code = "package p1;\nimport org.eclipse.jdt.annotation.NonNull;\npublic class Test1 {\n    public @NonNull Object foo() {\n        return new Test2().bar();\n    }\n}";
        String test2Code = "package p1;\nimport org.eclipse.jdt.annotation.NonNull;\npublic class Test2 {\n    public @NonNull Object bar() { return this; }\n}";
        IPath test1Path = env.addClass(this.srcRoot, "p1", "Test1", test1Code);
        env.addClass(this.srcRoot, "p1", "Test2", test2Code);
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        String test2CodeB = "package p1;\nimport org.eclipse.jdt.annotation.Nullable;\npublic class Test2 {\n    public @Nullable Object bar() { return null; }\n}";
        env.addClass(this.srcRoot, "p1", "Test2", test2CodeB);
        this.incrementalBuild(this.projectPath);
        this.expectingProblemsFor(test1Path, "Problem : Null type mismatch: required '@NonNull Object' but the provided value is specified as @Nullable [ resource : </Project/src/p1/Test1.java> range : <126,143> category : <90> severity : <2>]");
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test1", "p1.Test2"});
        String test2CodeC = "package p1;\npublic class Test2 {\n    public Object bar() { return null; }\n}";
        env.addClass(this.srcRoot, "p1", "Test2", test2CodeC);
        this.incrementalBuild(this.projectPath);
        this.expectingProblemsFor(test1Path, "Problem : Null type safety: The expression of type 'Object' needs unchecked conversion to conform to '@NonNull Object' [ resource : </Project/src/p1/Test1.java> range : <126,143> category : <90> severity : <1>]");
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test1", "p1.Test2"});
        env.addClass(this.srcRoot, "p1", "Test2", test2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test1", "p1.Test2"});
    }

    public void testReturnAnnotationDependency02() throws JavaModelException, IOException {
        this.setupProjectForNullAnnotations();
        String test1Code = "package p1;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n@NonNullByDefault\npublic class Test1 {\n    public void doStuff(int i) {\n    }\n}";
        env.addClass(this.srcRoot, "p1", "Test1", test1Code);
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        String test2Code = "package p1;\nimport org.eclipse.jdt.annotation.NonNullByDefault;\n@NonNullByDefault\npublic class Test2 extends Test1{\n\t@Override\n    public void doStuff(int i) {\n\t\t super.doStuff(i);\n    }\n}";
        env.addClass(this.srcRoot, "p1", "Test2", test2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test2"});
        test2Code = "package p1;\npublic class Test2 extends Test1{\n\t@Override\n    public void doStuff(int i) {\n\t\t super.doStuff(i);\n    }\n}";
        env.addClass(this.srcRoot, "p1", "Test2", test2Code);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.Test2"});
    }

    public void test411771a() throws IOException, JavaModelException {
        this.setupProjectForNullAnnotations();
        String testEnumCode = "package p1;\nenum TestEnum {FOO };\n";
        env.addClass(this.srcRoot, "p1", "TestEnum", testEnumCode);
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        String nullTestCode = "package p1;\nimport org.eclipse.jdt.annotation.NonNull;\npublic class NullTest {\n\tpublic static TestEnum bla() {\n\t\t@NonNull final TestEnum t = TestEnum.FOO;\n\t\treturn t;\n\t}\n}";
        env.addClass(this.srcRoot, "p1", "NullTest", nullTestCode);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        this.expectingUniqueCompiledClasses(new String[]{"p1.NullTest"});
    }

    public void test411771b() throws IOException, JavaModelException {
        this.setupProjectForNullAnnotations();
        String testEnumCode = "package p1;\nenum TestEnum { FOO };\n";
        env.addClass(this.srcRoot, "p1", "TestEnum", testEnumCode);
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        String testClass = "package p1;\npublic class X { TestEnum f; };\n";
        env.addClass(this.srcRoot, "p1", "X", testClass);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        String nullTestCode = "package p1;\nimport org.eclipse.jdt.annotation.NonNull;\npublic class NullTest {\n\tpublic static TestEnum bla(X x) {\n\t\t@NonNull final TestEnum t = x.f;\n\t\treturn t;\n\t}\n}\n";
        IPath test1Path = env.addClass(this.srcRoot, "p1", "NullTest", nullTestCode);
        this.incrementalBuild(this.projectPath);
        this.expectingProblemsFor(test1Path, "Problem : Null type safety: The expression of type 'TestEnum' needs unchecked conversion to conform to '@NonNull TestEnum' [ resource : </Project/src/p1/NullTest.java> range : <144,147> category : <90> severity : <1>]");
        this.expectingUniqueCompiledClasses(new String[]{"p1.NullTest"});
    }

    public void test411771c() throws IOException, JavaModelException {
        this.setupProjectForNullAnnotations();
        String testClass = "package p1;\npublic class A {}";
        env.addClass(this.srcRoot, "p1", "A", testClass);
        this.fullBuild(this.projectPath);
        this.expectingNoProblems();
        String testEnumCode = "package p1;\nenum TestEnum {\n\tFOO;\n\tpublic static A a;};\n";
        env.addClass(this.srcRoot, "p1", "TestEnum", testEnumCode);
        this.incrementalBuild(this.projectPath);
        this.expectingNoProblems();
        String nullTestCode = "package p1;\nimport org.eclipse.jdt.annotation.NonNull;\npublic class NullTest {\n\tpublic static TestEnum bla() {\n\t\t@NonNull final TestEnum t = TestEnum.FOO;\n\t\treturn t;\n\t}\n\tpublic A testint() {\n\t@NonNull A a = TestEnum.a;\n\t\treturn a;\n\t}\n}";
        IPath test1Path = env.addClass(this.srcRoot, "p1", "NullTest", nullTestCode);
        this.incrementalBuild(this.projectPath);
        this.expectingProblemsFor(test1Path, "Problem : Null type safety: The expression of type 'A' needs unchecked conversion to conform to '@NonNull A' [ resource : </Project/src/p1/NullTest.java> range : <208,218> category : <90> severity : <1>]");
        this.expectingUniqueCompiledClasses(new String[]{"p1.NullTest"});
    }
}

