/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IDebugRequestor;
import org.eclipse.jdt.internal.core.util.Util;

public class EfficiencyCompilerRequestor
implements IDebugRequestor {
    private boolean isActive = false;
    private ArrayList<String> compiledClasses = new ArrayList();
    private ArrayList<String> compiledFiles = new ArrayList();

    public void acceptDebugResult(CompilationResult result) {
        this.compiledFiles.add(new String(result.fileName));
        Object[] classFiles = result.getClassFiles();
        Util.sort((Object[])classFiles, (Util.Comparer)new Util.Comparer(){

            public int compare(Object a, Object b) {
                String aName = new String(((ClassFile)a).fileName());
                String bName = new String(((ClassFile)b).fileName());
                return aName.compareTo(bName);
            }
        });
        int i = 0;
        while (i < classFiles.length) {
            String className = new String(classFiles[i].fileName());
            this.compiledClasses.add(className.replace('/', '.'));
            ++i;
        }
    }

    String[] getCompiledClasses() {
        return this.compiledClasses.toArray(new String[0]);
    }

    String[] getCompiledFiles() {
        return this.compiledFiles.toArray(new String[0]);
    }

    public void clearResult() {
        this.compiledClasses.clear();
        this.compiledFiles.clear();
    }

    public void reset() {
    }

    public void activate() {
        this.isActive = true;
    }

    public void deactivate() {
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }
}

