/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;

public class ErrorsTests
extends BuilderTests {
    private static final IClasspathAttribute ATTR_IGNORE_OPTIONAL_PROBLEMS_TRUE = JavaCore.newClasspathAttribute((String)"ignore_optional_problems", (String)"true");
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            int length2;
            IResource resource1 = (IResource)o1;
            IResource resource2 = (IResource)o2;
            String path1 = resource1.getFullPath().toString();
            String path2 = resource2.getFullPath().toString();
            int length1 = path1.length();
            if (length1 != (length2 = path2.length())) {
                return length1 - length2;
            }
            return path1.toString().compareTo(path2.toString());
        }
    };

    public ErrorsTests(String name) {
        super(name);
    }

    public static Test suite() {
        return ErrorsTests.buildTestSuite(ErrorsTests.class);
    }

    public void testErrors() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild(projectPath);
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(root, "p1", "Indicted", "package p1;\npublic abstract class Indicted {\n}\n");
        IPath collaboratorPath = env.addClass(root, "p2", "Collaborator", "package p2;\nimport p1.*;\npublic class Collaborator extends Indicted{\n}\n");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        env.addClass(root, "p1", "Indicted", "package p1;\npublic abstract class Indicted {\n   public abstract void foo();\n}\n");
        this.incrementalBuild(projectPath);
        this.expectingOnlyProblemsFor(collaboratorPath);
        this.expectingOnlySpecificProblemFor(collaboratorPath, new Problem("Collaborator", "The type Collaborator must implement the inherited abstract method Indicted.foo()", collaboratorPath, 38, 50, 50, 2));
    }

    public void testRenameToNonJava() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        env.setOutputFolder(projectPath, "bin");
        IPath cuPath = env.addClass(root, "p1", "X", "package p1;\npublic class X extends Y {\n}\n");
        this.fullBuild(projectPath);
        this.expectingOnlyProblemsFor(cuPath);
        this.expectingOnlySpecificProblemFor(cuPath, new Problem("X", "Y cannot be resolved to a type", cuPath, 35, 36, 40, 2));
        env.renameCU(root.append("p1"), "X.java", "X.txt");
        this.incrementalBuild(projectPath);
        this.expectingNoProblems();
    }

    public void test0100() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        IPath classTest1 = env.addClass(root, "p1", "Test1", "package p1;\npublic class Test1 extends Test2 {}");
        this.fullBuild();
        Problem[] prob1 = env.getProblemsFor(classTest1);
        this.expectingSpecificProblemFor(classTest1, new Problem("p1", "Test2 cannot be resolved to a type", classTest1, 39, 44, 40, 2));
        ErrorsTests.assertEquals((String)"JDT", (String)prob1[0].getSourceId());
    }

    public void test0101() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        IPath classTest1 = env.addClass(root, "p1", "Test1", "package p1;\npublic class Test1 extends {}");
        this.fullBuild();
        Problem[] prob1 = env.getProblemsFor(classTest1);
        this.expectingSpecificProblemFor(classTest1, new Problem("p1", "Syntax error on token \"extends\", Type expected after this token", classTest1, 31, 38, 20, 2));
        ErrorsTests.assertEquals((String)"JDT", (String)prob1[0].getSourceId());
    }

    public void test0102() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        IPath classTest1 = env.addClass(root, "p1", "Test1", "package p1;\npublic class Test1 {\n  private static int i;\n  int j = i;\n}\nclass Test2 {\n  static int i = Test1.i;\n}\n");
        this.fullBuild();
        Problem[] prob1 = env.getProblemsFor(classTest1);
        this.expectingSpecificProblemFor(classTest1, new Problem("p1", "The field Test1.i is not visible", classTest1, 109, 110, 50, 2));
        ErrorsTests.assertEquals((String)"JDT", (String)prob1[0].getSourceId());
    }

    public void test0103() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        IPath classTest1 = env.addClass(root, "p1", "Test1", "package p1;\npublic class Test1 {\n  // TODO: marker only\n}\n");
        this.fullBuild();
        Problem[] prob1 = env.getProblemsFor(classTest1);
        this.expectingSpecificProblemFor(classTest1, new Problem("p1", "TODO: marker only", classTest1, 38, 55, -1, 2));
        ErrorsTests.assertEquals((String)"JDT", (String)prob1[0].getSourceId());
    }

    public void test0104() throws JavaModelException {
        IPath projectPath = env.addProject("Project");
        env.removePackageFragmentRoot(projectPath, "");
        IPath root = env.addPackageFragmentRoot(projectPath, "src");
        IPath classTest1 = env.addClass(root, "p1", "Test1", "package p1;\npublic class Test1 {}");
        this.fullBuild();
        Problem[] prob1 = env.getProblemsFor(classTest1);
        this.expectingSpecificProblemFor(classTest1, new Problem("p1", "The type java.lang.Object cannot be resolved. It is indirectly referenced from required .class files", classTest1, 0, 1, 10, 2));
        ErrorsTests.assertEquals((String)"JDT", (String)prob1[0].getSourceId());
    }

    public void _test0105() throws JavaModelException, CoreException, IOException {
        if ("Linux".equals(System.getProperty("os.name"))) {
            Process process;
            File outputFolder;
            block29: {
                IPath projectPath = env.addProject("P");
                env.addExternalJars(projectPath, Util.getJavaClassLibs());
                IPath root = env.getPackageFragmentRootPath(projectPath, "");
                IPath outputFolderPath = env.getOutputLocation(projectPath);
                outputFolder = env.getWorkspaceRootPath().append(outputFolderPath).toFile();
                env.addClass(root, "p1", "X", "package p1;\npublic class X {\n}\n");
                try {
                    this.fullBuild(projectPath);
                    this.expectingNoProblems();
                    outputFolder.setReadOnly();
                    System.err.println("\n\n=== EXPECTED EXCEPTION =========================================================");
                    System.err.println("ErrorsTests#test0105 will emit an expected exception below");
                    this.cleanBuild();
                    System.err.println("=== END OF EXPECTED EXCEPTION ==================================================\n\n");
                    this.expectingOnlySpecificProblemFor(env.getWorkspaceRootPath(), new Problem("", "The project was not built due to \"Could not delete '" + env.getWorkspaceRootPath() + "/P/bin/.classpath'.\". " + "Fix the problem, then try refreshing this project and building " + "it since it may be inconsistent", projectPath, -1, -1, 10, 2));
                }
                catch (Throwable throwable) {
                    block27: {
                        Process process2 = null;
                        try {
                            try {
                                process2 = Runtime.getRuntime().exec("chmod -R a+w " + outputFolder.getAbsolutePath());
                                process2.waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                                if (process2 != null) {
                                    process2.destroy();
                                }
                                break block27;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (process2 != null) {
                                process2.destroy();
                            }
                            throw throwable2;
                        }
                        if (process2 != null) {
                            process2.destroy();
                        }
                    }
                    throw throwable;
                }
                process = null;
                try {
                    try {
                        process = Runtime.getRuntime().exec("chmod -R a+w " + outputFolder.getAbsolutePath());
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        if (process != null) {
                            process.destroy();
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    if (process != null) {
                        process.destroy();
                    }
                    throw throwable;
                }
                if (process != null) {
                    process.destroy();
                }
            }
            try {
                this.cleanBuild();
                this.expectingNoProblems();
            }
            catch (Throwable t) {
                block31: {
                    process = null;
                    try {
                        try {
                            process = Runtime.getRuntime().exec("chmod -R a+w " + outputFolder.getAbsolutePath());
                            process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            if (process != null) {
                                process.destroy();
                            }
                            break block31;
                        }
                    }
                    catch (Throwable throwable) {
                        if (process != null) {
                            process.destroy();
                        }
                        throw throwable;
                    }
                    if (process != null) {
                        process.destroy();
                    }
                }
                ErrorsTests.fail((String)t.getMessage());
            }
        }
    }

    public void test0106() throws JavaModelException {
        IClassFileReader classFileReader;
        IPath projectPath;
        block16: {
            projectPath = env.addProject("Project");
            env.addExternalJars(projectPath, Util.getJavaClassLibs());
            this.fullBuild(projectPath);
            env.removePackageFragmentRoot(projectPath, "");
            IPath root = env.addPackageFragmentRoot(projectPath, "src", null, null);
            env.setOutputFolder(projectPath, "bin");
            IPath classTest1 = env.addClass(root, "p1", "X", "package p1;\npublic class X implements I {\n}\n");
            env.addClass(root, "p1", "I", "package p1;\npublic interface I {\n   public void foo() {\n   }\n}\n");
            this.incrementalBuild(projectPath);
            this.expectingSpecificProblemFor(classTest1, new Problem("p1", "The type X must implement the inherited abstract method I.foo()", classTest1, 25, 26, 50, 2));
            IJavaProject project = env.getJavaProject(projectPath);
            IRegion region = JavaCore.newRegion();
            region.add((IJavaElement)project);
            IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
            ErrorsTests.assertEquals((String)"Wrong size", (int)2, (int)resources.length);
            Arrays.sort(resources, COMPARATOR);
            String actualOutput = this.getResourceOuput(resources);
            String expectedOutput = "/Project/bin/p1/I.class\n/Project/bin/p1/X.class\n";
            ErrorsTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
            ErrorsTests.assertEquals((String)"Wrong type", (int)1, (int)resources[1].getType());
            IFile classFile = (IFile)resources[1];
            classFileReader = null;
            InputStream stream = null;
            try {
                try {
                    stream = classFile.getContents();
                    classFileReader = ToolFactory.createDefaultClassFileReader((InputStream)stream, (int)65535);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        ErrorsTests.assertNotNull((String)"No class file reader", (Object)classFileReader);
        IMethodInfo[] methodInfos = classFileReader.getMethodInfos();
        IMethodInfo found = null;
        int i = 0;
        int max = methodInfos.length;
        while (i < max) {
            IMethodInfo methodInfo = methodInfos[i];
            if (CharOperation.equals((char[])methodInfo.getName(), (char[])"foo".toCharArray())) {
                found = methodInfo;
                break;
            }
            ++i;
        }
        ErrorsTests.assertNotNull((String)"No method found", found);
        ErrorsTests.assertTrue((String)"Not a synthetic method", (boolean)found.isSynthetic());
        env.removeProject(projectPath);
    }

    public void test0107() throws JavaModelException {
        block14: {
            IPath projectPath = env.addProject("Project");
            env.addExternalJars(projectPath, Util.getJavaClassLibs());
            this.fullBuild(projectPath);
            env.removePackageFragmentRoot(projectPath, "");
            IPath root = env.addPackageFragmentRoot(projectPath, "src", null, null);
            env.setOutputFolder(projectPath, "bin");
            IPath classTest1 = env.addClass(root, "", "C", "public class C implements None {\n        public String toString(Arg a) {\n                return null;\n        }\n        public String toString(Arg[] a) {\n                return null;\n        }\n}");
            this.incrementalBuild(projectPath);
            this.expectingOnlySpecificProblemsFor(classTest1, new Problem[]{new Problem("", "None cannot be resolved to a type", classTest1, 26, 30, 40, 2), new Problem("", "Arg cannot be resolved to a type", classTest1, 64, 67, 40, 2), new Problem("", "Arg cannot be resolved to a type", classTest1, 143, 146, 40, 2)});
            IJavaProject project = env.getJavaProject(projectPath);
            IRegion region = JavaCore.newRegion();
            region.add((IJavaElement)project);
            IResource[] resources = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
            ErrorsTests.assertEquals((String)"Wrong size", (int)1, (int)resources.length);
            Arrays.sort(resources, COMPARATOR);
            String actualOutput = this.getResourceOuput(resources);
            String expectedOutput = "/Project/bin/C.class\n";
            ErrorsTests.assertEquals((String)"Wrong names", (String)Util.convertToIndependantLineDelimiter((String)expectedOutput), (String)actualOutput);
            ErrorsTests.assertEquals((String)"Wrong type", (int)1, (int)resources[0].getType());
            IFile classFile = (IFile)resources[0];
            InputStream stream = null;
            try {
                try {
                    stream = classFile.getContents();
                    ClassFileReader.read((InputStream)stream, (String)"C.java");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ErrorsTests.assertTrue((String)"Should not happen", (boolean)false);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getResourceOuput(IResource[] resources) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        int i = 0;
        int max = resources.length;
        while (i < max) {
            writer.println(resources[i].getFullPath().toString());
            ++i;
        }
        writer.flush();
        writer.close();
        return Util.convertToIndependantLineDelimiter((String)String.valueOf(stringWriter));
    }

    public void test0108() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath projectPath = env.addProject("P");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.setOutputFolder(projectPath, "bin");
        Path root = new Path("/P/src");
        env.addEntry(projectPath, JavaCore.newSourceEntry((IPath)root, null, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{ATTR_IGNORE_OPTIONAL_PROBLEMS_TRUE}));
        env.addClass((IPath)root, "p", "X", "package p;\npublic class X {\n\tpublic void foo() {\n\t\tint i;\n\t}\n}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        JavaCore.setOptions((Hashtable)options);
    }

    public void test0109() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath projectPath = env.addProject("P");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.setOutputFolder(projectPath, "bin");
        Path src = new Path("/P/src");
        Path src2 = new Path("/P/src2");
        env.addEntry(projectPath, JavaCore.newSourceEntry((IPath)src, null, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{ATTR_IGNORE_OPTIONAL_PROBLEMS_TRUE}));
        env.addEntry(projectPath, JavaCore.newSourceEntry((IPath)src2));
        env.addClass((IPath)src, "p", "X", "package p;\npublic class X {\n\tpublic void foo() {\n\t\tint i;\n\t}\n}");
        IPath classY = env.addClass((IPath)src2, "q", "Y", "package q;\npublic class Y {\n\tpublic void foo() {\n\t\tint i;\n\t}\n}");
        this.fullBuild(projectPath);
        this.expectingNoProblemsFor((IPath)src);
        this.expectingOnlySpecificProblemFor(classY, new Problem("q", "The value of the local variable i is not used", classY, 55, 56, 120, 2));
        JavaCore.setOptions((Hashtable)options);
    }

    public void test0110() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath projectPath = env.addProject("P");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.setOutputFolder(projectPath, "bin");
        Path src = new Path("/P/src");
        Path src2 = new Path("/P/src2");
        env.addEntry(projectPath, JavaCore.newSourceEntry((IPath)src, null, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{ATTR_IGNORE_OPTIONAL_PROBLEMS_TRUE}));
        env.addEntry(projectPath, JavaCore.newSourceEntry((IPath)src2, null, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{ATTR_IGNORE_OPTIONAL_PROBLEMS_TRUE}));
        env.addClass((IPath)src, "p", "X", "package p;\npublic class X {\n\tpublic void foo() {\n\t\tint i;\n\t}\n}");
        env.addClass((IPath)src2, "q", "Y", "package q;\npublic class Y {\n\tpublic void foo() {\n\t\tint i;\n\t}\n}");
        this.fullBuild(projectPath);
        this.expectingNoProblems();
        JavaCore.setOptions((Hashtable)options);
    }

    public void test0111() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath projectPath = env.addProject("P");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.setOutputFolder(projectPath, "bin");
        Path root = new Path("/P/src");
        env.addEntry(projectPath, JavaCore.newSourceEntry((IPath)root, null, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{ATTR_IGNORE_OPTIONAL_PROBLEMS_TRUE}));
        IPath classX = env.addClass((IPath)root, "p", "X", "package p;\npublic class X {\n\tpublic void foo() {\n\t\tint i;\n\t}\n\tpublic void bar() {\n\t\ta++;\n\t}\n}");
        this.fullBuild(projectPath);
        this.expectingOnlySpecificProblemFor(classX, new Problem("p", "a cannot be resolved to a variable", classX, 84, 85, 50, 2));
        JavaCore.setOptions((Hashtable)options);
    }

    public void test0112() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "error");
        newOptions.put("org.eclipse.jdt.core.compiler.taskTags", "TODO");
        newOptions.put("org.eclipse.jdt.core.compiler.taskPriorities", "NORMAL");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath projectPath = env.addProject("P");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(projectPath, "");
        env.setOutputFolder(projectPath, "bin");
        Path root = new Path("/P/src");
        env.addEntry(projectPath, JavaCore.newSourceEntry((IPath)root, null, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{ATTR_IGNORE_OPTIONAL_PROBLEMS_TRUE}));
        IPath classX = env.addClass((IPath)root, "p", "X", "package p;\npublic class X {\n\tpublic void foo() {\n\t\tint i;\n\t}\n\tpublic void bar() {\n\t\t// TODO nothing\n\t}\n}");
        this.fullBuild(projectPath);
        this.expectingOnlySpecificProblemFor(classX, new Problem("p", "TODO nothing", classX, 87, 99, -1, 2));
        JavaCore.setOptions((Hashtable)options);
    }
}

