/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.util.Hashtable;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.util.Util;
import org.eclipse.test.OrderedTestSuite;

public class MultiProjectTests
extends BuilderTests {
    public MultiProjectTests(String name) {
        super(name);
    }

    public static Test suite() {
        return new OrderedTestSuite(MultiProjectTests.class);
    }

    public void testCompileOnlyDependent() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "", "A", "public class A {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "B", "public class B extends A {\n}\n");
        IPath project3Path = env.addProject("Project3");
        env.addExternalJars(project3Path, Util.getJavaClassLibs());
        IPath root3 = env.getPackageFragmentRootPath(project3Path, "");
        env.addClass(root3, "", "C", "public class C {\n}\n");
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        env.addClass(root1, "", "A", "public class A {\n   int x;\n}\n");
        env.waitForManualRefresh();
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingCompiledClasses(new String[]{"A", "B"});
        env.removeProject(project1Path);
        env.removeProject(project2Path);
        env.removeProject(project3Path);
    }

    public void testCompileOnlyStructuralDependent() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "", "A", "public class A {\n}\n");
        env.addClass(root1, "", "Unreferenced", "public class Unreferenced {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "B", "public class B extends A {\n}\n");
        IPath project3Path = env.addProject("Project3");
        env.addExternalJars(project3Path, Util.getJavaClassLibs());
        IPath root3 = env.getPackageFragmentRootPath(project3Path, "");
        env.addClass(root3, "", "C", "public class C {\n}\n");
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        env.addClass(root1, "", "A", "public class A {\n   // add comment (non-structural change)\n}\n");
        env.addClass(root1, "", "Unreferenced", "public class Unreferenced {\n   int x; //structural change\n}\n");
        env.waitForManualRefresh();
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingCompiledClasses(new String[]{"A", "Unreferenced"});
        env.removeProject(project1Path);
        env.removeProject(project2Path);
        env.removeProject(project3Path);
    }

    public void testRemoveField() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", "ignore");
        JavaCore.setOptions((Hashtable)options);
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "", "A", "public class A {\n   public int x;\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        IPath b = env.addClass(root2, "", "B", "public class B {\n   public void foo(){\n      int x = new A().x;\n   }\n}\n");
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        env.addClass(root1, "", "A", "public class A {\n}\n");
        env.waitForManualRefresh();
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingSpecificProblemFor(b, new Problem("B.foo()", "x cannot be resolved or is not a field", b, 61, 62, 50, 2));
        env.removeProject(project1Path);
        env.removeProject(project2Path);
    }

    public void testCompileOrder() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        IPath c1 = env.addClass(root1, "p1", "X", "package p1;\npublic class X {\n  W w;\n}\n");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        IPath c2 = env.addClass(root2, "p2", "Y", "package p2;\npublic class Y {\n  W w;\n}\n");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        IPath c3 = env.addClass(root3, "p3", "Z", "package p3;\npublic class Z {\n  W w;\n}\n");
        env.setBuildOrder(new String[]{"P1", "P3", "P2"});
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingCompilingOrder(new String[]{"/P1/src/p1/X.java", "/P3/src/p3/Z.java", "/P2/src/p2/Y.java"});
        IPath workspaceRootPath = env.getWorkspaceRootPath();
        this.expectingOnlySpecificProblemsFor(workspaceRootPath, new Problem[]{new Problem("p3", "W cannot be resolved to a type", c3, 31, 32, 40, 2), new Problem("p2", "W cannot be resolved to a type", c2, 31, 32, 40, 2), new Problem("p1", "W cannot be resolved to a type", c1, 31, 32, 40, 2)});
        JavaCore.setOptions((Hashtable)options);
        env.removeProject(p1);
        env.removeProject(p2);
        env.removeProject(p3);
    }

    public void testCyclesCleared() throws JavaModelException {
        IPath p1 = env.addProject("P1");
        IPath p2 = env.addProject("P2");
        try {
            env.addRequiredProject(p1, p2);
            env.addRequiredProject(p2, p1);
            this.fullBuild();
            env.waitForAutoBuild();
            this.printProblems();
            this.expectingOnlySpecificProblemsFor(p1, new Problem[]{new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2}", p1, -1, -1, 10, 2), new Problem("p1", "The project cannot be built until build path errors are resolved", p1, -1, -1, 10, 2)});
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2}", p2, -1, -1, 10, 2), new Problem("p2", "The project cannot be built until build path errors are resolved", p2, -1, -1, 10, 2)});
            env.removeRequiredProject(p1, p2);
            this.fullBuild();
            env.waitForAutoBuild();
            this.expectingNoProblems();
        }
        finally {
            env.removeProject(p1);
            env.removeProject(p2);
        }
    }

    public void testCycle1() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addClass(root1, "p1", "X", "package p1;\nimport p2.Y;\npublic class X {\n  public void bar(Y y){\n    y.zork();\n  }\n}\n");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        env.addClass(root2, "p2", "Y", "package p2;\nimport p1.X;\nimport p3.Z;\npublic class Y extends Z{\n  public X zork(){\n    X x = foo();\n    x.bar(this);\n    return x;\n  }\n}\n");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        env.addClass(root3, "p3", "Z", "package p3;\nimport p1.X;\npublic class Z {\n  public X foo(){\n    return null;\n  }\n}\n");
        env.addRequiredProject(p1, p2);
        env.addRequiredProject(p1, p3);
        env.addRequiredProject(p2, p1);
        env.addRequiredProject(p2, p3);
        env.addRequiredProject(p3, p1);
        try {
            env.setBuildOrder(new String[]{"P1", "P2", "P3"});
            env.waitForManualRefresh();
            this.fullBuild();
            env.waitForAutoBuild();
            this.expectingCompilingOrder(new String[]{"/P1/src/p1/X.java", "/P2/src/p2/Y.java", "/P3/src/p3/Z.java", "/P1/src/p1/X.java", "/P2/src/p2/Y.java", "/P3/src/p3/Z.java", "/P1/src/p1/X.java"});
            this.expectingOnlySpecificProblemFor(p1, new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemFor(p2, new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemFor(p3, new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1));
            JavaCore.setOptions((Hashtable)options);
        }
        finally {
            env.setBuildOrder(null);
            env.removeProject(p1);
            env.removeProject(p2);
            env.removeProject(p3);
        }
    }

    public void testCycle2() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addClass(root1, "p1", "X", "package p1;\nimport p2.Y;\npublic class X {\n  public void bar(Y y, int i){\n    y.zork();\n  }\n}\n");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        IPath c2 = env.addClass(root2, "p2", "Y", "package p2;\nimport p1.X;\nimport p3.Z;\npublic class Y extends Z{\n  public X zork(){\n    X x = foo();\n    x.bar(this);\n    return x;\n  }\n}\n");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        env.addClass(root3, "p3", "Z", "package p3;\nimport p1.X;\npublic class Z {\n  public X foo(){\n    return null;\n  }\n}\n");
        env.addRequiredProject(p1, p2);
        env.addRequiredProject(p1, p3);
        env.addRequiredProject(p2, p1);
        env.addRequiredProject(p2, p3);
        env.addRequiredProject(p3, p1);
        try {
            env.setBuildOrder(new String[]{"P1", "P2", "P3"});
            env.waitForManualRefresh();
            this.fullBuild();
            env.waitForAutoBuild();
            this.expectingCompilingOrder(new String[]{"/P1/src/p1/X.java", "/P2/src/p2/Y.java", "/P3/src/p3/Z.java", "/P1/src/p1/X.java", "/P2/src/p2/Y.java", "/P3/src/p3/Z.java", "/P1/src/p1/X.java"});
            this.expectingOnlySpecificProblemFor(p1, new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "The method bar(Y, int) in the type X is not applicable for the arguments (Y)", c2, 106, 109, 50, 2), new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemFor(p3, new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1));
            JavaCore.setOptions((Hashtable)options);
        }
        finally {
            env.setBuildOrder(null);
            env.removeProject(p1);
            env.removeProject(p2);
            env.removeProject(p3);
        }
    }

    public void testCycle3() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addClass(root1, "p1", "X", "package p1;\nimport p2.Y;\npublic class X {\n  public void bar(Y y){\n    y.zork();\n  }\n}\n");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        IPath c2 = env.addClass(root2, "p2", "Y", "package p2;\nimport p1.X;\nimport p3.Z;\npublic class Y extends Z{\n  public X zork(){\n    X x = foo();\n    x.bar(this);\n    return x;\n  }\n}\n");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        env.addClass(root3, "p3", "Z", "package p3;\nimport p1.X;\npublic class Z {\n  public X foo(){\n    return null;\n  }\n}\n");
        env.addRequiredProject(p1, p2);
        env.addRequiredProject(p1, p3);
        env.addRequiredProject(p2, p1);
        env.addRequiredProject(p2, p3);
        env.addRequiredProject(p3, p1);
        try {
            env.setBuildOrder(new String[]{"P1", "P2", "P3"});
            env.waitForManualRefresh();
            this.fullBuild();
            env.waitForAutoBuild();
            this.expectingCompilingOrder(new String[]{"/P1/src/p1/X.java", "/P2/src/p2/Y.java", "/P3/src/p3/Z.java", "/P1/src/p1/X.java", "/P2/src/p2/Y.java", "/P3/src/p3/Z.java", "/P1/src/p1/X.java"});
            this.expectingOnlySpecificProblemFor(p1, new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemFor(p2, new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemFor(p3, new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1));
            env.addClass(root1, "p1", "X", "package p1;\nimport p2.Y;\npublic class X {\n  public void bar(Y y, int i){\n    y.zork();\n  }\n}\n");
            this.incrementalBuild();
            env.waitForAutoBuild();
            this.expectingCompilingOrder(new String[]{"/P1/src/p1/X.java", "/P2/src/p2/Y.java", "/P3/src/p3/Z.java"});
            this.expectingOnlySpecificProblemFor(p1, new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "The method bar(Y, int) in the type X is not applicable for the arguments (Y)", c2, 106, 109, 50, 2), new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemFor(p3, new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1));
            JavaCore.setOptions((Hashtable)options);
        }
        finally {
            env.setBuildOrder(null);
            env.removeProject(p1);
            env.removeProject(p2);
            env.removeProject(p3);
        }
    }

    public void testCycle4() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        IPath c2 = env.addClass(root2, "p2", "Y", "package p2;\nimport p1.X;\nimport p3.Z;\npublic class Y extends Z{\n  public X zork(){\n    X x = foo();\n    x.bar(this);\n    return x;\n  }\n}\n");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        IPath c3 = env.addClass(root3, "p3", "Z", "package p3;\nimport p1.X;\npublic class Z {\n  public X foo(){\n    return null;\n  }\n}\n");
        env.addRequiredProject(p1, p2);
        env.addRequiredProject(p1, p3);
        env.addRequiredProject(p2, p1);
        env.addRequiredProject(p2, p3);
        env.addRequiredProject(p3, p1);
        try {
            env.setBuildOrder(new String[]{"P1", "P2", "P3"});
            env.waitForManualRefresh();
            this.fullBuild();
            env.waitForAutoBuild();
            this.expectingCompilingOrder(new String[]{"/P2/src/p2/Y.java", "/P3/src/p3/Z.java", "/P2/src/p2/Y.java"});
            this.expectingOnlySpecificProblemFor(p1, new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "X cannot be resolved to a type", c2, 87, 88, 40, 2), new Problem("p2", "The method foo() from the type Z refers to the missing type X", c2, 93, 96, 50, 2), new Problem("p2", "The import p1 cannot be resolved", c2, 19, 21, 30, 2), new Problem("p2", "X cannot be resolved to a type", c2, 73, 74, 40, 2), new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p3, new Problem[]{new Problem("p3", "X cannot be resolved to a type", c3, 51, 52, 40, 2), new Problem("p3", "The import p1 cannot be resolved", c3, 19, 21, 30, 2), new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1)});
            env.addClass(root1, "p1", "X", "package p1;\nimport p2.Y;\npublic class X {\n  public void bar(Y y){\n    y.zork();\n  }\n}\n");
            this.incrementalBuild();
            env.waitForAutoBuild();
            this.expectingCompilingOrder(new String[]{"/P1/src/p1/X.java", "/P2/src/p2/Y.java", "/P3/src/p3/Z.java", "/P1/src/p1/X.java", "/P2/src/p2/Y.java"});
            this.expectingOnlySpecificProblemFor(p1, new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemFor(p2, new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1));
            this.expectingOnlySpecificProblemFor(p3, new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1));
            JavaCore.setOptions((Hashtable)options);
        }
        finally {
            env.setBuildOrder(null);
            env.removeProject(p1);
            env.removeProject(p2);
            env.removeProject(p3);
        }
    }

    public void testCycle5() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        IPath c1 = env.addClass(root1, "p1", "X", "package p1;\nimport p2.*;\nimport p22.*;\npublic class X {\n  Y y;\n}\n");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        IPath c2 = env.addClass(root2, "p2", "Y", "package p2;\nimport p1.*;\nimport p11.*;\npublic class Y {\n  X x;\n}\n");
        env.addRequiredProject(p1, p2);
        env.addRequiredProject(p2, p1);
        try {
            env.setBuildOrder(new String[]{"P1", "P2"});
            env.waitForManualRefresh();
            this.fullBuild();
            env.waitForAutoBuild();
            this.expectingCompilingOrder(new String[]{"/P1/src/p1/X.java", "/P2/src/p2/Y.java", "/P1/src/p1/X.java", "/P2/src/p2/Y.java"});
            this.expectingOnlySpecificProblemsFor(p1, new Problem[]{new Problem("p1", "The import p22 cannot be resolved", c1, 32, 35, 30, 2), new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2}", p1, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "The import p11 cannot be resolved", c2, 32, 35, 30, 2), new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2}", p2, -1, -1, 10, 1)});
            env.addClass(root1, "p11", "XX", "package p11;\npublic class XX {\n}\n");
            env.addClass(root2, "p22", "YY", "package p22;\npublic class YY {\n}\n");
            this.incrementalBuild();
            env.waitForAutoBuild();
            this.expectingCompilingOrder(new String[]{"/P1/src/p11/XX.java", "/P2/src/p22/YY.java", "/P2/src/p2/Y.java", "/P1/src/p1/X.java"});
            this.expectingOnlySpecificProblemsFor(p1, new Problem[]{new Problem("p1", "The import p22 is never used", c1, 32, 35, 120, 1), new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2}", p1, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "The import p11 is never used", c2, 32, 35, 120, 1), new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2}", p2, -1, -1, 10, 1)});
            JavaCore.setOptions((Hashtable)options);
        }
        finally {
            env.setBuildOrder(null);
            env.removeProject(p1);
            env.removeProject(p2);
        }
    }

    public void testCycle6() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addClass(root1, "java/lang", "Object", "package java.lang;\npublic class Object {\n  Class getClass() { return null; }\n  String toString() { return \"\"; }\n}\n");
        IPath p2 = env.addProject("P2");
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        env.addClass(root2, "java/lang", "Class", "package java.lang;\npublic class Class {\n  String getName() { return \"\"; };\n}\n");
        IPath p3 = env.addProject("P3");
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        env.addClass(root3, "java/lang", "String", "package java.lang;\npublic class String {\n}\n");
        IPath[] accessiblePaths = new IPath[]{new Path("java/lang/*")};
        IPath[] forbiddenPaths = new IPath[]{new Path("**/*")};
        env.addRequiredProject(p1, p2, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p1, p3, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p2, p1, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p2, p3, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p3, p1, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p3, p2, accessiblePaths, forbiddenPaths, false);
        try {
            env.waitForManualRefresh();
            this.fullBuild();
            env.waitForAutoBuild();
            this.expectingOnlySpecificProblemsFor(p1, new Problem[]{new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p3, new Problem[]{new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1)});
        }
        finally {
            JavaCore.setOptions((Hashtable)options);
            env.removeProject(p1);
            env.removeProject(p2);
            env.removeProject(p3);
        }
    }

    public void testCycle7() throws JavaModelException {
        Hashtable options = JavaCore.getOptions();
        Hashtable newOptions = JavaCore.getOptions();
        newOptions.put("org.eclipse.jdt.core.circularClasspath", "warning");
        JavaCore.setOptions((Hashtable)newOptions);
        IPath p1 = env.addProject("P1");
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addClass(root1, "java/lang", "Object", "package java.lang;\npublic class Object {\n  Class getClass() { return null; }\n  String toString() { return null; }\n}\n");
        IPath p2 = env.addProject("P2");
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        env.addClass(root2, "java/lang", "Class", "package java.lang;\npublic class Class {\n  String getName() { return \"\"; };\n}\n");
        IPath p3 = env.addProject("P3");
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        env.addClass(root3, "java/lang", "String", "package java.lang;\npublic class String {\n}\n");
        IPath[] accessiblePaths = new IPath[]{new Path("java/lang/*")};
        IPath[] forbiddenPaths = new IPath[]{new Path("**/*")};
        env.addRequiredProject(p1, p2, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p1, p3, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p2, p1, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p2, p3, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p3, p1, accessiblePaths, forbiddenPaths, false);
        env.addRequiredProject(p3, p2, accessiblePaths, forbiddenPaths, false);
        try {
            env.waitForManualRefresh();
            this.fullBuild();
            env.waitForAutoBuild();
            this.expectingOnlySpecificProblemsFor(p1, new Problem[]{new Problem("p1", "A cycle was detected in the build path of project 'P1'. The cycle consists of projects {P1, P2, P3}", p1, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p2, new Problem[]{new Problem("p2", "A cycle was detected in the build path of project 'P2'. The cycle consists of projects {P1, P2, P3}", p2, -1, -1, 10, 1)});
            this.expectingOnlySpecificProblemsFor(p3, new Problem[]{new Problem("p3", "A cycle was detected in the build path of project 'P3'. The cycle consists of projects {P1, P2, P3}", p3, -1, -1, 10, 1)});
        }
        finally {
            JavaCore.setOptions((Hashtable)options);
            env.removeProject(p1);
            env.removeProject(p2);
            env.removeProject(p3);
        }
    }

    public void testExcludePartOfAnotherProject1() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p.api", "A", "package p.api;\npublic class A {\n}\n");
        env.addClass(root1, "p.internal", "B", "package p.internal;\npublic class B {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path, new IPath[0], new IPath[]{new Path("**/internal/")}, false);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "C", "public class C extends p.api.A {\n}\n");
        IPath d = env.addClass(root2, "", "D", "public class D extends p.internal.B {\n}\n");
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingSpecificProblemFor(project2Path, new Problem("", "Access restriction: The type 'B' is not API (restriction on required project 'Project1')", d, 23, 35, 150, 2));
        env.removeProject(project1Path);
        env.removeProject(project2Path);
    }

    public void testExcludePartOfAnotherProject2() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p.api", "A", "package p.api;\npublic class A {\n}\n");
        env.addClass(root1, "p.internal", "B", "package p.internal;\npublic class B {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path, new IPath[0], new IPath[]{new Path("**/internal/")}, false);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "C", "public class C extends p.api.A {\n}\n");
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        IPath d = env.addClass(root2, "", "D", "public class D extends p.internal.B {\n}\n");
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingSpecificProblemFor(project2Path, new Problem("", "Access restriction: The type 'B' is not API (restriction on required project 'Project1')", d, 23, 35, 150, 2));
        env.removeProject(project1Path);
        env.removeProject(project2Path);
    }

    public void testExcludePartOfAnotherProject3() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p.api", "A", "package p.api;\npublic class A {\n}\n");
        env.addClass(root1, "p.internal", "B", "package p.internal;\npublic class B {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path, new IPath[0], new IPath[]{new Path("**/internal/")}, false);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "C", "public class C extends p.api.A {\n}\n");
        IPath d = env.addClass(root2, "", "D", "public class D extends p.internal.B {\n}\n");
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingSpecificProblemFor(project2Path, new Problem("", "Access restriction: The type 'B' is not API (restriction on required project 'Project1')", d, 23, 35, 150, 2));
        env.removeRequiredProject(project2Path, project1Path);
        env.addRequiredProject(project2Path, project1Path, new IPath[0], new IPath[0], false);
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        env.removeProject(project1Path);
        env.removeProject(project2Path);
    }

    public void testIncludePartOfAnotherProject1() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p.api", "A", "package p.api;\npublic class A {\n}\n");
        env.addClass(root1, "p.internal", "B", "package p.internal;\npublic class B {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path, new IPath[]{new Path("**/api/")}, new IPath[]{new Path("**")}, false);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "C", "public class C extends p.api.A {\n}\n");
        IPath d = env.addClass(root2, "", "D", "public class D extends p.internal.B {\n}\n");
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingSpecificProblemFor(project2Path, new Problem("", "Access restriction: The type 'B' is not API (restriction on required project 'Project1')", d, 23, 35, 150, 2));
        env.removeProject(project1Path);
        env.removeProject(project2Path);
    }

    public void testIncludePartOfAnotherProject2() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p.api", "A", "package p.api;\npublic class A {\n}\n");
        env.addClass(root1, "p.internal", "B", "package p.internal;\npublic class B {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path, new IPath[]{new Path("**/api/")}, new IPath[]{new Path("**")}, false);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "C", "public class C extends p.api.A {\n}\n");
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        IPath d = env.addClass(root2, "", "D", "public class D extends p.internal.B {\n}\n");
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingSpecificProblemFor(project2Path, new Problem("", "Access restriction: The type 'B' is not API (restriction on required project 'Project1')", d, 23, 35, 150, 2));
        env.removeProject(project1Path);
        env.removeProject(project2Path);
    }

    public void testIncludePartOfAnotherProject3() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p.api", "A", "package p.api;\npublic class A {\n}\n");
        env.addClass(root1, "p.internal", "B", "package p.internal;\npublic class B {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        env.addRequiredProject(project2Path, project1Path, new IPath[]{new Path("**/api/")}, new IPath[]{new Path("**")}, false);
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "", "C", "public class C extends p.api.A {\n}\n");
        IPath d = env.addClass(root2, "", "D", "public class D extends p.internal.B {\n}\n");
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingSpecificProblemFor(project2Path, new Problem("", "Access restriction: The type 'B' is not API (restriction on required project 'Project1')", d, 23, 35, 150, 2));
        env.removeRequiredProject(project2Path, project1Path);
        env.addRequiredProject(project2Path, project1Path, new IPath[0], new IPath[0], false);
        this.incrementalBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        env.removeProject(project1Path);
        env.removeProject(project2Path);
    }

    public void testIgnoreIfBetterNonAccessibleRule1() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p", "A", "package p;\npublic class A {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "p", "A", "package p;\npublic class A {\n}\n");
        IPath project3Path = env.addProject("Project3");
        env.addExternalJars(project3Path, Util.getJavaClassLibs());
        env.addRequiredProject(project3Path, project1Path, (IPath)new Path("**/p/"), 257);
        env.addRequiredProject(project3Path, project2Path, (IPath)new Path("**/p/A"), 0);
        IPath root3 = env.getPackageFragmentRootPath(project3Path, "");
        env.addClass(root3, "p3", "B", "package p3;\npublic class B extends p.A {\n}\n");
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        env.removeProject(project1Path);
        env.removeProject(project2Path);
        env.removeProject(project3Path);
    }

    public void testIgnoreIfBetterNonAccessibleRule2() throws JavaModelException {
        IPath project1Path = env.addProject("Project1");
        env.addExternalJars(project1Path, Util.getJavaClassLibs());
        IPath root1 = env.getPackageFragmentRootPath(project1Path, "");
        env.addClass(root1, "p", "A", "package p;\npublic class A {\n}\n");
        IPath project2Path = env.addProject("Project2");
        env.addExternalJars(project2Path, Util.getJavaClassLibs());
        IPath root2 = env.getPackageFragmentRootPath(project2Path, "");
        env.addClass(root2, "p", "A", "package p;\npublic class A {\n}\n");
        IPath project3Path = env.addProject("Project3");
        env.addExternalJars(project3Path, Util.getJavaClassLibs());
        env.addRequiredProject(project3Path, project1Path, (IPath)new Path("**/p/"), 257);
        env.addRequiredProject(project3Path, project2Path, (IPath)new Path("**/p/A"), 2);
        IPath root3 = env.getPackageFragmentRootPath(project3Path, "");
        IPath b = env.addClass(root3, "p3", "B", "package p3;\npublic class B extends p.A {\n}\n");
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingSpecificProblemFor(project3Path, new Problem("", "Discouraged access: The type 'A' is not API (restriction on required project 'Project2')", b, 35, 38, 150, 1));
        env.removeProject(project1Path);
        env.removeProject(project2Path);
        env.removeProject(project3Path);
    }

    public void testMissingRequiredBinaries() throws JavaModelException {
        IPath p1 = env.addProject("P1");
        IPath p2 = env.addProject("P2");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.addRequiredProject(p1, p2);
        env.setOutputFolder(p1, "bin");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.addRequiredProject(p2, p3);
        env.setOutputFolder(p2, "bin");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        IPath x = env.addClass(root1, "p1", "X", "package p1;\nimport p2.*;\npublic class X extends Y{\n}\n");
        env.addClass(root2, "p2", "Y", "package p2;\nimport p3.*;\npublic class Y extends Z {\n}\n");
        env.addClass(root3, "p3", "Z", "package p3;\npublic class Z {\n}\n");
        try {
            env.waitForManualRefresh();
            this.fullBuild();
            env.waitForAutoBuild();
            this.expectingOnlySpecificProblemsFor(p1, new Problem[]{new Problem("p1", "The type p3.Z cannot be resolved. It is indirectly referenced from required .class files", x, 48, 49, 10, 2), new Problem("p1", "The project was not built since its build path is incomplete. Cannot find the class file for p3.Z. Fix the build path then try building this project", p1, -1, -1, 10, 2)});
        }
        finally {
            env.setBuildOrder(null);
            env.removeProject(p1);
            env.removeProject(p1);
            env.removeProject(p3);
        }
    }

    public void test100_class_folder_exported() throws JavaModelException {
        IPath P1 = env.addProject("P1");
        env.setOutputFolder(P1, "bin");
        env.addExternalJars(P1, Util.getJavaClassLibs());
        env.addClass(env.addPackage(env.getPackageFragmentRootPath(P1, ""), "p"), "A", "package p;\npublic class A {\n}\n");
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        env.removePackageFragmentRoot(P1, "");
        env.addClassFolder(P1, P1.append("bin"), true);
        IPath P2 = env.addProject("P2");
        env.addExternalJars(P2, Util.getJavaClassLibs());
        env.addRequiredProject(P2, P1);
        env.addClass(env.getPackageFragmentRootPath(P2, ""), "X", "import p.A;\npublic class X {\n  A f;\n}");
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        env.removeProject(P1);
        env.removeProject(P2);
    }

    public void test101_class_folder_non_exported() throws JavaModelException {
        IPath P1 = env.addProject("P1");
        env.setOutputFolder(P1, "bin");
        env.addExternalJars(P1, Util.getJavaClassLibs());
        env.addClass(env.addPackage(env.getPackageFragmentRootPath(P1, ""), "p"), "A", "package p;\npublic class A {\n}\n");
        this.fullBuild();
        this.expectingNoProblems();
        env.removePackageFragmentRoot(P1, "");
        env.addClassFolder(P1, P1.append("bin"), false);
        IPath P2 = env.addProject("P2");
        env.addExternalJars(P2, Util.getJavaClassLibs());
        env.addRequiredProject(P2, P1);
        IPath c = env.addClass(env.getPackageFragmentRootPath(P2, ""), "X", "import p.A;\npublic class X {\n  A f;\n}");
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingSpecificProblemsFor(P2, new Problem[]{new Problem("", "The import p cannot be resolved", c, 7, 8, 30, 2), new Problem("", "A cannot be resolved to a type", c, 31, 32, 40, 2)});
        env.removeProject(P1);
        env.removeProject(P2);
    }

    public void test102_missing_required_binaries() throws JavaModelException {
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.addRequiredProject(p2, p1);
        env.setOutputFolder(p2, "bin");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.addRequiredProject(p3, p2);
        env.setOutputFolder(p3, "bin");
        env.addClass(root1, "", "I", "public interface I {\n}\n");
        env.addClass(root2, "", "X", "public class X implements I {\n}\n");
        IPath y = env.addClass(root3, "", "Y", "public class Y extends X {\n  X m = new X() {};\n}\n");
        try {
            env.waitForManualRefresh();
            this.fullBuild();
            env.waitForAutoBuild();
            this.expectingOnlySpecificProblemsFor(p3, new Problem[]{new Problem("p3", "The project was not built since its build path is incomplete. Cannot find the class file for I. Fix the build path then try building this project", p3, -1, -1, 10, 2), new Problem("p3", "The type I cannot be resolved. It is indirectly referenced from required .class files", y, 23, 24, 10, 2)});
        }
        finally {
            env.setBuildOrder(null);
            env.removeProject(p1);
            env.removeProject(p2);
            env.removeProject(p3);
        }
    }

    public void test103_missing_required_binaries() throws JavaModelException {
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.addRequiredProject(p2, p1);
        env.setOutputFolder(p2, "bin");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.addRequiredProject(p3, p2);
        env.setOutputFolder(p3, "bin");
        env.addClass(root1, "", "I", "public interface I {\n}\n");
        env.addClass(root2, "", "X", "public class X implements I {\n}\n");
        IPath y = env.addClass(root3, "", "Y", "public class Y {\n  X m = new X() {};\n  X n = new X() {};\n}\n");
        try {
            env.waitForManualRefresh();
            this.fullBuild();
            env.waitForAutoBuild();
            this.expectingOnlySpecificProblemsFor(p3, new Problem[]{new Problem("p3", "The project was not built since its build path is incomplete. Cannot find the class file for I. Fix the build path then try building this project", p3, -1, -1, 10, 2), new Problem("p3", "The type I cannot be resolved. It is indirectly referenced from required .class files", y, 0, 1, 10, 2)});
        }
        finally {
            env.setBuildOrder(null);
            env.setBuildOrder(null);
            env.removeProject(p1);
            env.removeProject(p2);
            env.removeProject(p3);
        }
    }

    public void test104_missing_required_binaries() throws CoreException {
        IPath p0 = env.addProject("JRE17", "1.7");
        env.addExternalJars(p0, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p0, "");
        IPath root0 = env.addPackageFragmentRoot(p0, "src");
        env.setOutputFolder(p0, "bin");
        IPath p1 = env.addProject("org.eclipse.jgit", "1.7");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.addRequiredProject(p1, p0);
        env.setOutputFolder(p1, "bin");
        IPath p2 = env.addProject("org.eclipse.releng.tools", "1.5");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.addRequiredProject(p2, p1);
        env.setOutputFolder(p2, "bin");
        env.addClass(root0, "jre17", "AutoClosable", "package jre17;\npublic interface AutoClosable {\n\tvoid closeIt();\n}\n");
        env.addClass(root1, "org.eclipse.jgit.lib", "Repository", "package org.eclipse.jgit.lib;\nimport jre17.AutoClosable;\npublic abstract class Repository implements AutoClosable {\n\tpublic void resolve(final String revstr) { }\n}\n");
        IPath gca = env.addClass(root2, "org.eclipse.releng.tools.git", "GitCopyrightAdapter", "package org.eclipse.releng.tools.git;\nimport org.eclipse.jgit.lib.Repository;\npublic class GitCopyrightAdapter {\n\tvoid foo(Repository repo) {\n\t\trepo.resolve(\"Head\");\n\t}\n}\n");
        env.addClass(root2, "org.eclipse.releng.tools.preferences", "Messages", "package org.eclipse.releng.tools.preferences;\nfinal class Messages {\n\t{\n\t\t@SuppressWarnings(\"unused\")\n\t\tObject o = \"\"; // triggers the bug\n\t}\n}\n");
        try {
            env.waitForManualRefresh();
            this.fullBuild();
            env.waitForAutoBuild();
            this.expectingNoProblems();
            IFile gcaFile = (IFile)env.getWorkspace().getRoot().findMember(gca);
            gcaFile.touch(null);
            env.waitForManualRefresh();
            this.incrementalBuild(p2);
            env.waitForAutoBuild();
            this.expectingNoProblems();
        }
        finally {
            env.setBuildOrder(null);
            env.setBuildOrder(null);
            env.removeProject(p1);
            env.removeProject(p2);
            env.removeProject(p0);
        }
    }

    public void test438923() throws JavaModelException {
        IPath p1 = env.addProject("P1");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addClass(root1, "p1", "P1I0", "package p1;\npublic interface P1I0 {\n  interface II {/*empty*/}\n}\n");
        IPath p2 = env.addProject("P2");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        env.addClass(root2, "p2", "P2C0", "package p2;\nimport p1.P1I0;\npublic class P2C0 {\n  public void z(final P1I0.II [] ii) {/*empty*/}\n}\n");
        IPath p3 = env.addProject("P3");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        env.addClass(root3, "p3", "P3C0", "package p3;\nimport p2.P2C0;\npublic class P3C0\n  extends P2C0 {/*empty*/}\n");
        env.addRequiredProject(p2, p1);
        env.addRequiredProject(p3, p2);
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        env.setBuildOrder(null);
        env.removeProject(p1);
        env.removeProject(p2);
        env.removeProject(p3);
    }

    public void test461074() throws JavaModelException {
        IPath p1 = env.addProject("SampleMissing");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addClass(root1, "pack.missing", "MissingType", "package pack.missing;\npublic class MissingType {\n}\n");
        IPath p2 = env.addProject("SampleLib", "1.5");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        env.addClass(root2, "pack.lib", "TopClass", "package pack.lib;\npublic class TopClass {\n  Object get() { return null; }\n}\n");
        env.addClass(root2, "pack.lib", "SuperClass", "package pack.lib;\nimport pack.missing.MissingType;\npublic class SuperClass extends TopClass {\n  @Override\n  MissingType get() { return null; }\n}\n");
        IPath p3 = env.addProject("SampleTest", "1.5");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        env.addClass(root3, "pack.test", "Test", "package pack.test;\nimport pack.lib.SuperClass;\npublic class Test extends SuperClass {/*empty*/}\n");
        env.addRequiredProject(p2, p1);
        env.addRequiredProject(p3, p2);
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingNoProblems();
        env.setBuildOrder(null);
        env.removeProject(p1);
        env.removeProject(p2);
        env.removeProject(p3);
    }

    public void test461074_error() throws JavaModelException {
        IPath p1 = env.addProject("SampleMissing");
        env.addExternalJars(p1, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p1, "");
        IPath root1 = env.addPackageFragmentRoot(p1, "src");
        env.setOutputFolder(p1, "bin");
        env.addClass(root1, "pack.missing", "MissingType", "package pack.missing;\npublic class MissingType {\n}\n");
        IPath p2 = env.addProject("SampleLib", "1.5");
        env.addExternalJars(p2, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p2, "");
        IPath root2 = env.addPackageFragmentRoot(p2, "src");
        env.setOutputFolder(p2, "bin");
        env.addClass(root2, "pack.lib", "TopClass", "package pack.lib;\npublic abstract class TopClass {\n  abstract Object get();\n}\n");
        env.addClass(root2, "pack.lib", "SuperClass", "package pack.lib;\nimport pack.missing.MissingType;\npublic class SuperClass extends TopClass {\n  @Override\n  MissingType get() { return null; }\n}\n");
        IPath p3 = env.addProject("SampleTest", "1.5");
        env.addExternalJars(p3, Util.getJavaClassLibs());
        env.removePackageFragmentRoot(p3, "");
        IPath root3 = env.addPackageFragmentRoot(p3, "src");
        env.setOutputFolder(p3, "bin");
        IPath test = env.addClass(root3, "pack.test", "Test", "package pack.test;\nimport pack.lib.SuperClass;\npublic class Test extends SuperClass {/*empty*/}\n");
        env.addRequiredProject(p2, p1);
        env.addRequiredProject(p3, p2);
        env.waitForManualRefresh();
        this.fullBuild();
        env.waitForAutoBuild();
        this.expectingOnlySpecificProblemsFor(p3, new Problem[]{new Problem("p3", "The project was not built since its build path is incomplete. Cannot find the class file for pack.missing.MissingType. Fix the build path then try building this project", p3, -1, -1, 10, 2), new Problem("p3", "The type pack.missing.MissingType cannot be resolved. It is indirectly referenced from required .class files", test, 0, 1, 10, 2)});
        env.setBuildOrder(null);
        env.removeProject(p1);
        env.removeProject(p2);
        env.removeProject(p3);
    }
}

