/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import junit.framework.Test;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.builder.BuilderTests;
import org.eclipse.jdt.core.tests.util.Util;

public class MultiSourceFolderAndOutputFolderTests
extends BuilderTests {
    public MultiSourceFolderAndOutputFolderTests(String name) {
        super(name);
    }

    public static Test suite() {
        return MultiSourceFolderAndOutputFolderTests.buildTestSuite(MultiSourceFolderAndOutputFolderTests.class);
    }

    public void test0001() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src1 = env.addPackageFragmentRoot(projectPath, "src1", null, "bin1");
        env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addClass(src1, "", "X", "public class X {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(projectPath.append("bin1/X.class"));
        this.expectingNoPresenceOf(projectPath.append("bin/X.class"));
    }

    public void test0002() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src1 = env.addPackageFragmentRoot(projectPath, "src1", null, "bin1");
        IPath src2 = env.addPackageFragmentRoot(projectPath, "src2");
        env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addClass(src1, "p", "X", "package p;public class X {}");
        env.addClass(src2, "p", "Y", "package p;public class Y {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(projectPath.append("bin1/p/X.class"));
        this.expectingPresenceOf(projectPath.append("bin/p/Y.class"));
        this.expectingNoPresenceOf(projectPath.append("bin/p/X.class"));
        this.expectingNoPresenceOf(projectPath.append("bin1/p/Y.class"));
    }

    public void test0003() {
        try {
            IPath projectPath = env.addProject("P");
            env.removePackageFragmentRoot(projectPath, "");
            env.addPackageFragmentRoot(projectPath, "src", null, null);
            env.addPackageFragmentRoot(projectPath, "src/f1", null, null);
            env.setOutputFolder(projectPath, "bin");
            env.addExternalJars(projectPath, Util.getJavaClassLibs());
            this.fullBuild();
            this.expectingNoProblems();
            MultiSourceFolderAndOutputFolderTests.assertTrue((String)"JavaModelException", (boolean)false);
        }
        catch (JavaModelException e) {
            MultiSourceFolderAndOutputFolderTests.assertEquals((String)"Cannot nest 'P/src/f1' inside 'P/src'. To enable the nesting exclude 'f1/' from 'P/src'", (String)e.getMessage());
        }
    }

    public void test0004() {
        try {
            IPath projectPath = env.addProject("P");
            env.removePackageFragmentRoot(projectPath, "");
            env.addPackageFragmentRoot(projectPath, "src/f1", null, null);
            env.addPackageFragmentRoot(projectPath, "src", new IPath[]{new Path("f1")}, null);
            env.setOutputFolder(projectPath, "bin");
            env.addExternalJars(projectPath, Util.getJavaClassLibs());
            this.fullBuild();
            this.expectingNoProblems();
            MultiSourceFolderAndOutputFolderTests.assertTrue((String)"JavaModelException", (boolean)false);
        }
        catch (JavaModelException e) {
            MultiSourceFolderAndOutputFolderTests.assertEquals((String)"End exclusion filter 'f1' with / to fully exclude 'P/src/f1'", (String)e.getMessage());
        }
    }

    public void test0005() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        env.addPackageFragmentRoot(projectPath, "src/f1", null, null);
        env.addPackageFragmentRoot(projectPath, "src", new IPath[]{new Path("f1/")}, null);
        env.setOutputFolder(projectPath, "bin");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        this.fullBuild();
        this.expectingNoProblems();
    }

    public void test0006() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        IPath srcF1 = env.addPackageFragmentRoot(projectPath, "src/f1", null, null);
        IPath src = env.addPackageFragmentRoot(projectPath, "src", new IPath[]{new Path("f1/")}, null);
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addClass(src, "p", "X", "package p;public class X extends p2.Y{}");
        env.addClass(srcF1, "p2", "Y", "package p2;public class Y {}");
        this.fullBuild();
        this.expectingNoProblems();
    }

    public void test0007() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        IPath srcF1 = env.addPackageFragmentRoot(projectPath, "src/f1", null, null);
        IPath src = env.addPackageFragmentRoot(projectPath, "src", new IPath[]{new Path("f1/")}, null);
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        IPath xPath = env.addClass(src, "p", "X", "package p;public class X extends f1.p2.Y{}");
        env.addClass(srcF1, "p2", "Y", "package p2;public class Y {}");
        this.fullBuild();
        this.expectingOnlyProblemsFor(xPath);
    }

    public void test0008() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        IPath srcF1 = env.addPackageFragmentRoot(projectPath, "src/f1", null, null);
        IPath src = env.addPackageFragmentRoot(projectPath, "src", new IPath[]{new Path("f1/")}, null);
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        IPath xPath = env.addClass(src, "p", "X", "package p;public class X extends p2.Y{}");
        env.addClass(srcF1, "p2", "Y", "package p2;public abstract class Y {  abstract void foo();}");
        this.fullBuild();
        this.expectingOnlyProblemsFor(xPath);
        env.addClass(srcF1, "p2", "Y", "package p2;public class Y {}");
        this.incrementalBuild();
        this.expectingNoProblems();
    }

    public void test0009() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addPackageFragmentRoot(projectPath, "", null, "bin2");
        env.addFolder(projectPath, "bin");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(projectPath, "", "X", "public class X {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(projectPath.append("bin2").append("X.class"));
        this.expectingNoPresenceOf(projectPath.append("bin").append("X.class"));
        this.expectingNoPresenceOf(projectPath.append("bin2").append("bin"));
        this.expectingNoPresenceOf(projectPath.append("bin").append("bin2"));
    }

    public void test0010() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addPackageFragmentRoot(projectPath, "", new IPath[]{new Path("src/")}, "bin2");
        IPath src = env.addPackageFragmentRoot(projectPath, "src", null, null);
        env.addFolder(projectPath, "bin");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(projectPath, "", "X", "public class X {}");
        env.addClass(src, "", "Y", "public class Y {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(projectPath.append("bin2").append("X.class"));
        this.expectingNoPresenceOf(projectPath.append("bin").append("X.class"));
        this.expectingPresenceOf(projectPath.append("bin").append("Y.class"));
        this.expectingNoPresenceOf(projectPath.append("bin2").append("Y.class"));
        this.expectingNoPresenceOf(projectPath.append("bin2").append("bin"));
        this.expectingNoPresenceOf(projectPath.append("bin").append("bin2"));
    }

    public void test0011() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addPackageFragmentRoot(projectPath, "", new IPath[]{new Path("src/")}, null);
        IPath src = env.addPackageFragmentRoot(projectPath, "src", null, "bin2");
        env.addFolder(projectPath, "bin");
        env.setOutputFolder(projectPath, "bin");
        env.addClass(projectPath, "", "X", "public class X {}");
        env.addClass(src, "", "Y", "public class Y {}");
        this.fullBuild();
        this.expectingNoProblems();
        this.expectingPresenceOf(projectPath.append("bin").append("X.class"));
        this.expectingNoPresenceOf(projectPath.append("bin2").append("X.class"));
        this.expectingPresenceOf(projectPath.append("bin2").append("Y.class"));
        this.expectingNoPresenceOf(projectPath.append("bin").append("Y.class"));
        this.expectingNoPresenceOf(projectPath.append("bin2").append("bin"));
        this.expectingNoPresenceOf(projectPath.append("bin").append("bin2"));
    }

    public void test0012() throws JavaModelException {
        IPath projectPath = env.addProject("P");
        env.removePackageFragmentRoot(projectPath, "");
        IPath src = env.addPackageFragmentRoot(projectPath, "", new IPath[]{new Path("p1/p2/p3/X.java"), new Path("Y.java")}, null, "");
        env.addExternalJars(projectPath, Util.getJavaClassLibs());
        env.addClass(src, "p1.p2.p3", "X", "package p1.p2.p3;\npublic class X {}");
        this.fullBuild();
        this.expectingNoProblems();
        env.addClass(src, "", "Y", "import p1.p2.p3.X;\npublic class Y extends X {}");
        this.incrementalBuild();
        this.expectingNoProblems();
    }
}

