/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.builder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.tests.builder.AbstractMethodTests;
import org.eclipse.jdt.core.tests.builder.AnnotationDependencyTests;
import org.eclipse.jdt.core.tests.builder.BasicBuildTests;
import org.eclipse.jdt.core.tests.builder.BuildpathTests;
import org.eclipse.jdt.core.tests.builder.CopyResourceTests;
import org.eclipse.jdt.core.tests.builder.DependencyTests;
import org.eclipse.jdt.core.tests.builder.EfficiencyCompilerRequestor;
import org.eclipse.jdt.core.tests.builder.EfficiencyTests;
import org.eclipse.jdt.core.tests.builder.ErrorsTests;
import org.eclipse.jdt.core.tests.builder.ExecutionTests;
import org.eclipse.jdt.core.tests.builder.FriendDependencyTests;
import org.eclipse.jdt.core.tests.builder.GetResourcesTests;
import org.eclipse.jdt.core.tests.builder.IncrementalTests;
import org.eclipse.jdt.core.tests.builder.IncrementalTests18;
import org.eclipse.jdt.core.tests.builder.Java50Tests;
import org.eclipse.jdt.core.tests.builder.MultiProjectTests;
import org.eclipse.jdt.core.tests.builder.MultiSourceFolderAndOutputFolderTests;
import org.eclipse.jdt.core.tests.builder.OutputFolderTests;
import org.eclipse.jdt.core.tests.builder.PackageInfoTest;
import org.eclipse.jdt.core.tests.builder.PackageTests;
import org.eclipse.jdt.core.tests.builder.ParticipantBuildTests;
import org.eclipse.jdt.core.tests.builder.Problem;
import org.eclipse.jdt.core.tests.builder.StaticFinalTests;
import org.eclipse.jdt.core.tests.builder.TestingEnvironment;
import org.eclipse.jdt.core.tests.junit.extension.TestCase;
import org.eclipse.jdt.core.tests.util.AbstractCompilerTest;
import org.eclipse.jdt.core.tests.util.TestVerifier;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.core.util.Util;

public class BuilderTests
extends TestCase {
    protected static boolean DEBUG = false;
    protected static TestingEnvironment env = null;
    protected EfficiencyCompilerRequestor debugRequestor = null;

    public BuilderTests(String name) {
        super(name);
    }

    protected void cleanBuild() {
        this.debugRequestor.clearResult();
        this.debugRequestor.activate();
        env.cleanBuild();
        this.debugRequestor.deactivate();
    }

    protected void cleanBuild(String name) {
        this.debugRequestor.clearResult();
        this.debugRequestor.activate();
        env.cleanBuild(name);
        this.debugRequestor.deactivate();
    }

    protected void executeClass(IPath projectPath, String className, String expectingOutput, String expectedError) {
        TestVerifier verifier = new TestVerifier(false);
        Vector<String> classpath = new Vector<String>(5);
        IPath workspacePath = env.getWorkspaceRootPath();
        classpath.addElement(workspacePath.append(env.getOutputLocation(projectPath)).toOSString());
        IClasspathEntry[] cp = env.getClasspath(projectPath);
        int i = 0;
        while (i < cp.length) {
            IPath c = cp[i].getPath();
            String ext = c.getFileExtension();
            if (ext != null && (ext.equals("zip") || ext.equals("jar"))) {
                if (c.getDevice() == null) {
                    classpath.addElement(workspacePath.append(c).toOSString());
                } else {
                    classpath.addElement(c.toOSString());
                }
            }
            ++i;
        }
        verifier.execute(className, classpath.toArray(new String[0]));
        if (DEBUG) {
            System.out.println("ERRORS\n");
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString((String)verifier.getExecutionError()));
            System.out.println("OUTPUT\n");
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString((String)verifier.getExecutionOutput()));
        }
        String actualError = verifier.getExecutionError();
        char[] error = actualError.toCharArray();
        if ((actualError = new String(CharOperation.replace((char[])error, (char[])System.getProperty("line.separator").toCharArray(), (char[])new char[]{'\n'}))).indexOf(expectedError) == -1) {
            System.out.println("ERRORS\n");
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString((String)actualError));
        }
        BuilderTests.assertTrue((String)("unexpected error : " + actualError + " expected : " + expectedError), (actualError.indexOf(expectedError) != -1 ? 1 : 0) != 0);
        String actualOutput = verifier.getExecutionOutput();
        if (actualOutput.indexOf(expectingOutput) == -1) {
            System.out.println("OUTPUT\n");
            System.out.println(org.eclipse.jdt.core.tests.util.Util.displayString((String)actualOutput));
        }
        BuilderTests.assertTrue((String)("unexpected output :" + actualOutput + " expected: " + expectingOutput), (actualOutput.indexOf(expectingOutput) != -1 ? 1 : 0) != 0);
    }

    protected void expectingParticipantProblems(IPath path, String expected) {
        Problem[] problems = env.getProblemsFor(path, "org.eclipse.jdt.core.tests.compile.problem");
        StringBuffer buf = new StringBuffer();
        int i = 0;
        int length = problems.length;
        while (i < length) {
            Problem problem = problems[i];
            buf.append(problem.getMessage());
            if (i < length - 1) {
                buf.append('\n');
            }
            ++i;
        }
        BuilderTests.assertEquals((String)"Unexpected problems", (String)expected, (String)buf.toString());
    }

    protected void expectingPresenceOf(IPath path) {
        this.expectingPresenceOf(new IPath[]{path});
    }

    protected void expectingPresenceOf(IPath[] paths) {
        IPath wRoot = env.getWorkspaceRootPath();
        int i = 0;
        while (i < paths.length) {
            BuilderTests.assertTrue((String)(paths[i] + " is not present"), (boolean)wRoot.append(paths[i]).toFile().exists());
            ++i;
        }
    }

    protected void expectingNoPresenceOf(IPath path) {
        this.expectingNoPresenceOf(new IPath[]{path});
    }

    protected void expectingNoPresenceOf(IPath[] paths) {
        IPath wRoot = env.getWorkspaceRootPath();
        int i = 0;
        while (i < paths.length) {
            BuilderTests.assertTrue((String)(paths[i] + " is present"), (!wRoot.append(paths[i]).toFile().exists() ? 1 : 0) != 0);
            ++i;
        }
    }

    protected void expectingCompiledClasses(String[] expected) {
        String[] actual = this.debugRequestor.getCompiledClasses();
        Util.sort((String[])actual);
        Util.sort((String[])expected);
        this.expectingCompiling(actual, expected, "unexpected recompiled units");
    }

    protected void expectingUniqueCompiledClasses(String[] expected) {
        String[] actual = this.debugRequestor.getCompiledClasses();
        Util.sort((String[])actual);
        int dups = 0;
        int i = 0;
        while (i < actual.length - 1) {
            if (actual[i + 1].equals(actual[i])) {
                ++dups;
                actual[i] = null;
            }
            ++i;
        }
        String[] uniqueActual = new String[actual.length - dups];
        int i2 = 0;
        int j = 0;
        while (i2 < actual.length) {
            if (actual[i2] != null) {
                uniqueActual[j++] = actual[i2];
            }
            ++i2;
        }
        Util.sort((String[])expected);
        this.expectingCompiling(uniqueActual, expected, "unexpected compiled units");
    }

    protected void expectingCompilingOrder(String[] expected) {
        this.expectingCompiling(this.debugRequestor.getCompiledClasses(), expected, "unexpected compiling order");
    }

    private void expectingCompiling(String[] actual, String[] expected, String message) {
        if (DEBUG) {
            int i = 0;
            while (i < actual.length) {
                System.out.println(actual[i]);
                ++i;
            }
        }
        StringBuffer actualBuffer = new StringBuffer("{");
        int i = 0;
        while (i < actual.length) {
            if (i > 0) {
                actualBuffer.append(",");
            }
            actualBuffer.append(actual[i]);
            ++i;
        }
        actualBuffer.append('}');
        StringBuffer expectedBuffer = new StringBuffer("{");
        int i2 = 0;
        while (i2 < expected.length) {
            if (i2 > 0) {
                expectedBuffer.append(",");
            }
            expectedBuffer.append(expected[i2]);
            ++i2;
        }
        expectedBuffer.append('}');
        BuilderTests.assertEquals((String)message, (String)expectedBuffer.toString(), (String)actualBuffer.toString());
    }

    protected void expectingNoProblems() {
        this.expectingNoProblemsFor(env.getWorkspaceRootPath());
    }

    protected void expectingNoProblemsFor(IPath root) {
        this.expectingNoProblemsFor(new IPath[]{root});
    }

    protected void expectingNoProblemsFor(IPath[] roots) {
        StringBuffer buffer = new StringBuffer();
        Problem[] allProblems = this.allSortedProblems(roots);
        if (allProblems != null) {
            int i = 0;
            int length = allProblems.length;
            while (i < length) {
                buffer.append(allProblems[i] + "\n");
                ++i;
            }
        }
        String actual = buffer.toString();
        this.assumeEquals("Unexpected problem(s)!!!", "", actual);
    }

    protected void expectingOnlyProblemsFor(IPath expected) {
        this.expectingOnlyProblemsFor(new IPath[]{expected});
    }

    protected void expectingOnlyProblemsFor(IPath[] expected) {
        if (DEBUG) {
            this.printProblems();
        }
        Problem[] rootProblems = env.getProblems();
        Hashtable<IPath, IPath> actual = new Hashtable<IPath, IPath>(rootProblems.length * 2 + 1);
        int i = 0;
        while (i < rootProblems.length) {
            IPath culprit = rootProblems[i].getResourcePath();
            actual.put(culprit, culprit);
            ++i;
        }
        i = 0;
        while (i < expected.length) {
            if (!actual.containsKey(expected[i])) {
                BuilderTests.assertTrue((String)("missing expected problem with " + expected[i].toString()), (boolean)false);
            }
            ++i;
        }
        if (actual.size() > expected.length) {
            Enumeration e = actual.elements();
            while (e.hasMoreElements()) {
                IPath path = (IPath)e.nextElement();
                boolean found = false;
                int i2 = 0;
                while (i2 < expected.length) {
                    if (path.equals((Object)expected[i2])) {
                        found = true;
                        break;
                    }
                    ++i2;
                }
                if (found) continue;
                BuilderTests.assertTrue((String)("unexpected problem(s) with " + path.toString()), (boolean)false);
            }
        }
    }

    protected void expectingOnlySpecificProblemFor(IPath root, Problem problem) {
        this.expectingOnlySpecificProblemsFor(root, new Problem[]{problem});
    }

    protected void expectingOnlySpecificProblemsFor(IPath root, Problem[] expectedProblems) {
        if (DEBUG) {
            this.printProblemsFor(root);
        }
        Problem[] rootProblems = env.getProblemsFor(root);
        int i = 0;
        while (i < expectedProblems.length) {
            Problem expectedProblem = expectedProblems[i];
            boolean found = false;
            int j = 0;
            while (j < rootProblems.length) {
                if (expectedProblem.equals(rootProblems[j])) {
                    found = true;
                    rootProblems[j] = null;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.printProblemsFor(root);
            }
            BuilderTests.assertTrue((String)("problem not found: " + expectedProblem.toString()), (boolean)found);
            ++i;
        }
        i = 0;
        while (i < rootProblems.length) {
            if (rootProblems[i] != null) {
                this.printProblemsFor(root);
                BuilderTests.assertTrue((String)("unexpected problem: " + rootProblems[i].toString()), (boolean)false);
            }
            ++i;
        }
    }

    protected void expectingProblemsFor(IPath root, String expected) {
        this.expectingProblemsFor(new IPath[]{root}, expected);
    }

    protected void expectingProblemsFor(IPath[] roots, String expected) {
        Object[] problems = this.allSortedProblems(roots);
        this.assumeEquals("Invalid problem(s)!!!", expected, this.arrayToString(problems));
    }

    protected void expectingProblemsFor(IPath root, List expected) {
        this.expectingProblemsFor(new IPath[]{root}, expected);
    }

    protected void expectingProblemsFor(IPath[] roots, List expected) {
        Object[] allProblems = this.allSortedProblems(roots);
        this.assumeEquals("Invalid problem(s)!!!", this.arrayToString(expected.toArray()), this.arrayToString(allProblems));
    }

    protected void expectingSpecificProblemFor(IPath root, Problem problem) {
        this.expectingSpecificProblemsFor(root, new Problem[]{problem});
    }

    protected void expectingSpecificProblemsFor(IPath root, Problem[] problems) {
        if (DEBUG) {
            this.printProblemsFor(root);
        }
        Object[] rootProblems = env.getProblemsFor(root);
        int i = 0;
        while (i < problems.length) {
            block4: {
                Problem problem = problems[i];
                int j = 0;
                while (j < rootProblems.length) {
                    Problem rootProblem = rootProblems[j];
                    if (rootProblem != null && problem.equals(rootProblem)) {
                        rootProblems[j] = null;
                        break block4;
                    }
                    ++j;
                }
                System.out.println("--------------------------------------------------------------------------------");
                System.out.println("Missing problem while running test " + this.getName() + ":");
                System.out.println("\t- expected : " + problem);
                System.out.println("\t- current: " + this.arrayToString(rootProblems));
                this.assumeTrue("missing expected problem: " + problem, false);
            }
            ++i;
        }
    }

    protected void fullBuild() {
        this.debugRequestor.clearResult();
        this.debugRequestor.activate();
        env.fullBuild();
        this.debugRequestor.deactivate();
    }

    protected void fullBuild(IPath projectPath) {
        this.debugRequestor.clearResult();
        this.debugRequestor.activate();
        env.fullBuild(projectPath);
        this.debugRequestor.deactivate();
    }

    protected void incrementalBuild(IPath projectPath) {
        this.debugRequestor.clearResult();
        this.debugRequestor.activate();
        env.incrementalBuild(projectPath);
        this.debugRequestor.deactivate();
    }

    protected void incrementalBuild() {
        this.debugRequestor.clearResult();
        this.debugRequestor.activate();
        env.incrementalBuild();
        this.debugRequestor.deactivate();
    }

    protected void printProblems() {
        this.printProblemsFor(env.getWorkspaceRootPath());
    }

    protected void printProblemsFor(IPath root) {
        this.printProblemsFor(new IPath[]{root});
    }

    protected void printProblemsFor(IPath[] roots) {
        int i = 0;
        while (i < roots.length) {
            IPath path = roots[i];
            Object[] problems = env.getProblemsFor(path);
            System.out.println(this.arrayToString(problems));
            System.out.println();
            ++i;
        }
    }

    protected String arrayToString(Object[] array) {
        StringBuffer buffer = new StringBuffer();
        int length = array == null ? 0 : array.length;
        int i = 0;
        while (i < length) {
            if (array[i] != null) {
                if (i > 0) {
                    buffer.append('\n');
                }
                buffer.append(array[i].toString());
            }
            ++i;
        }
        return buffer.toString();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.debugRequestor = new EfficiencyCompilerRequestor();
        Compiler.DebugRequestor = this.debugRequestor;
        if (env == null) {
            env = new TestingEnvironment();
            env.openEmptyWorkspace();
        }
        env.resetWorkspace();
    }

    protected void tearDown() throws Exception {
        env.resetWorkspace();
        JavaCore.setOptions((Hashtable)JavaCore.getDefaultOptions());
        super.tearDown();
    }

    Problem[] allSortedProblems(IPath[] roots) {
        Problem[] allProblems = null;
        int i = 0;
        int max = roots.length;
        while (i < max) {
            Problem[] problems = env.getProblemsFor(roots[i]);
            int length = problems.length;
            if (problems.length != 0) {
                if (allProblems == null) {
                    allProblems = problems;
                } else {
                    int all = allProblems.length;
                    Problem[] problemArray = allProblems;
                    allProblems = new Problem[all + length];
                    System.arraycopy(problemArray, 0, allProblems, 0, all);
                    System.arraycopy(problems, 0, allProblems, all, length);
                }
            }
            ++i;
        }
        if (allProblems != null) {
            Arrays.sort(allProblems);
        }
        return allProblems;
    }

    private static Class[] getAllTestClasses() {
        Class[] classes = new Class[]{AbstractMethodTests.class, BasicBuildTests.class, BuildpathTests.class, CopyResourceTests.class, DependencyTests.class, ErrorsTests.class, EfficiencyTests.class, ExecutionTests.class, IncrementalTests.class, IncrementalTests18.class, MultiProjectTests.class, MultiSourceFolderAndOutputFolderTests.class, OutputFolderTests.class, PackageTests.class, StaticFinalTests.class, GetResourcesTests.class, FriendDependencyTests.class};
        if ((AbstractCompilerTest.getPossibleComplianceLevels() & 4) != 0) {
            int length = classes.length;
            Class[] classArray = classes;
            classes = new Class[length + 4];
            System.arraycopy(classArray, 0, classes, 0, length);
            classes[length++] = Java50Tests.class;
            classes[length++] = PackageInfoTest.class;
            classes[length++] = ParticipantBuildTests.class;
            classes[length++] = AnnotationDependencyTests.class;
        }
        return classes;
    }

    public static Test buildTestSuite(Class evaluationTestClass, long ordering) {
        TestSuite suite = new TestSuite(evaluationTestClass.getName());
        List tests = BuilderTests.buildTestsList((Class)evaluationTestClass, (int)0, (long)ordering);
        int index = 0;
        int size = tests.size();
        while (index < size) {
            suite.addTest((Test)tests.get(index));
            ++index;
        }
        return suite;
    }

    public static Test buildTestSuite(Class evaluationTestClas) {
        return BuilderTests.buildTestSuite(evaluationTestClas, 5L);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(BuilderTests.class.getName());
        Class[] classes = BuilderTests.getAllTestClasses();
        TestCase.TESTS_PREFIX = null;
        TestCase.TESTS_NAMES = null;
        TestCase.TESTS_NUMBERS = null;
        TestCase.TESTS_RANGE = null;
        TestCase.RUN_ONLY_ID = null;
        int i = 0;
        int length = classes.length;
        while (i < length) {
            block6: {
                Object test;
                Method suiteMethod;
                Class clazz = classes[i];
                try {
                    suiteMethod = clazz.getDeclaredMethod("suite", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    break block6;
                }
                try {
                    test = suiteMethod.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    break block6;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    break block6;
                }
                suite.addTest((Test)test);
            }
            ++i;
        }
        return suite;
    }
}

