/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class ParserTest
extends AbstractRegressionTest {
    public ParserTest(String name) {
        super(name);
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tthrows\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tthrows\n\t^^^^^^\nSyntax error on token \"throws\", delete this token\n----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tthrows new\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tthrows new\n\t^^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tthrows new X\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tthrows new X\n\t^^^^^^\nSyntax error on token \"throws\", throw expected\n----------\n2. ERROR in X.java (at line 3)\n\tthrows new X\n\t           ^\nSyntax error, insert \"( )\" to complete Expression\n----------\n3. ERROR in X.java (at line 3)\n\tthrows new X\n\t           ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t{\n\t\tthrows\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tthrows\n\t^^^^^^\nSyntax error on token \"throws\", delete this token\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t{\n\t\tthrows new\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tthrows new\n\t^^^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\t{\n\t\tthrows new X\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tthrows new X\n\t^^^^^^\nSyntax error on token \"throws\", throw expected\n----------\n2. ERROR in X.java (at line 3)\n\tthrows new X\n\t           ^\nSyntax error, insert \"( )\" to complete Expression\n----------\n3. ERROR in X.java (at line 3)\n\tthrows new X\n\t           ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo()throw {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo()throw {\n\t          ^^^^^\nSyntax error on token \"throw\", { expected\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo()throw E {\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X {\n\t               ^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n2. ERROR in X.java (at line 2)\n\tvoid foo()throw E {\n\t          ^^^^^\nSyntax error on token \"throw\", throws expected\n----------\n3. ERROR in X.java (at line 4)\n\t}\n\t^\nSyntax error on token \"}\", delete this token\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tthrows e\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tthrows e\n\t^^^^^^^^\nSyntax error on tokens, delete these tokens\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tvoid foo(){\n\t\tthrows e;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\tthrows e;\n\t^^^^^^\nSyntax error on token \"throws\", throw expected\n----------\n");
    }

    public void _test011() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo(X, Object o, String s) {\n\t}\n   public void bar(){}\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic void foo(X, Object o, String s) {\n\t                 ^\nSyntax error on token \",\", . expected\n----------\n");
    }

    public void test012() {
        Hashtable<String, String> nls = new Hashtable<String, String>();
        nls.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tpublic void foo() {\n\t\t\"foo\".equals(\"bar\");\n\t\t;\n\t}\n}\n"}, null, nls, "----------\n1. ERROR in X.java (at line 3)\n\t\"foo\".equals(\"bar\");\n\t^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n2. ERROR in X.java (at line 3)\n\t\"foo\".equals(\"bar\");\n\t             ^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test013() {
        Hashtable<String, String> nls = new Hashtable<String, String>();
        nls.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n\tpublic void foo() {\n\t\t\"foo\".equals(\"bar\");\n\t\t//;\n\t}\n}\n"}, null, nls, "----------\n1. ERROR in X.java (at line 3)\n\t\"foo\".equals(\"bar\");\n\t^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n2. ERROR in X.java (at line 3)\n\t\"foo\".equals(\"bar\");\n\t             ^^^^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void foo() { \n\t\timport java.lang.*;\n\t} \n}\n"}, "----------\n1. ERROR in X.java (at line 3)\n\timport java.lang.*;\n\t^^^^^^\nSyntax error on token \"import\", delete this token\n----------\n2. ERROR in X.java (at line 3)\n\timport java.lang.*;\n\t^^^^^^^^^^^^^^^^^\nSyntax error on token(s), misplaced construct(s)\n----------\n");
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n// some code\n}\n/*\n// some comments\n"}, "----------\n1. ERROR in X.java (at line 4)\n\t/*\n// some comments\n\n\t^^^^^^^^^^^^^^^^^^^^\nUnexpected end of comment\n----------\n");
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tString s = \""}, "----------\n1. ERROR in X.java (at line 2)\n\tString s = \"\n\t           ^\nString literal is not properly closed by a double-quote\n----------\n");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tchar c = '"}, "----------\n1. ERROR in X.java (at line 2)\n\tchar c = '\n\t         ^\nInvalid character constant\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tchar c = '\\u0"}, "----------\n1. ERROR in X.java (at line 2)\n\tchar c = '\\u0\n\t          ^^^\nInvalid unicode\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic void doit() {\n\t\tint[] foo = null;\n\t\tfoo[0] = \n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tfoo[0] = \n\t     ^\nSyntax error, insert \"AssignmentOperator Expression\" to complete Assignment\n----------\n2. ERROR in X.java (at line 4)\n\tfoo[0] = \n\t     ^\nSyntax error, insert \";\" to complete Statement\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t}\n\tpublic static int newLibraryEntry() {\n\t\tif (sourceAttachmentPath != null) {\n\t\t\tif (sourceAttachmentPath.isEmpty()) { && !\nsourceAttachmentPath.isAbsolute()) {\n\t\t\tfoo();\n\t\t}\n\t\treturn null;\n\t}\n\t}\n\tpublic void foo() {\n\t}\n\tpublic void bar() {\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tif (sourceAttachmentPath.isEmpty()) { && !\n\t                                      ^^\nSyntax error on token \"&&\", invalid (\n----------\n2. ERROR in X.java (at line 7)\n\tsourceAttachmentPath.isAbsolute()) {\n\t                                   ^\nSyntax error on token \"{\", invalid AssignmentOperator\n----------\n");
    }

    public void test021() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("public class X {\n");
        int i = 0;
        while (i < 1000) {
            buffer.append("\tint field_" + i + " = 0; \n");
            ++i;
        }
        i = 0;
        while (i < 1000) {
            if (i == 0) {
                buffer.append("\tvoid method_" + i + "() { /* default */ } \n");
            } else {
                buffer.append("\tvoid method_" + i + "() { method_" + (i - 1) + "() \n");
            }
            ++i;
        }
        buffer.append("}\n");
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", "10");
        this.runNegativeTest(new String[]{"X.java", buffer.toString()}, "----------\n1. ERROR in X.java (at line 1003)\n\tvoid method_1() { method_0() \n\t                           ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n2. ERROR in X.java (at line 1003)\n\tvoid method_1() { method_0() \n\t                           ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n3. ERROR in X.java (at line 1004)\n\tvoid method_2() { method_1() \n\t                           ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n4. ERROR in X.java (at line 1004)\n\tvoid method_2() { method_1() \n\t                           ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n5. ERROR in X.java (at line 1005)\n\tvoid method_3() { method_2() \n\t                           ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n6. ERROR in X.java (at line 1005)\n\tvoid method_3() { method_2() \n\t                           ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n7. ERROR in X.java (at line 1006)\n\tvoid method_4() { method_3() \n\t                           ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n8. ERROR in X.java (at line 1006)\n\tvoid method_4() { method_3() \n\t                           ^\nSyntax error, insert \";\" to complete BlockStatements\n----------\n9. ERROR in X.java (at line 1007)\n\tvoid method_5() { method_4() \n\t                           ^\nSyntax error, insert \"}\" to complete MethodBody\n----------\n10. ERROR in X.java (at line 2002)\n\t}\n\t^\nSyntax error, insert \"}\" to complete ClassBody\n----------\n", null, true, options);
    }

    public void test022() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", "error");
        this.runNegativeTest(true, new String[]{"X.java", "interface X {\n    int f= 1;;\n}"}, null, options, "----------\n1. ERROR in X.java (at line 2)\n\tint f= 1;;\n\t         ^\nUnnecessary semicolon\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test023() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", "error");
        this.runNegativeTest(true, new String[]{"X.java", "class X {\n    int f= 1;;\n}"}, null, options, "----------\n1. ERROR in X.java (at line 2)\n\tint f= 1;;\n\t         ^\nUnnecessary semicolon\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test024() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", "error");
        this.runNegativeTest(true, new String[]{"X.java", "interface X {\n    int f= 1;\\u003B\n}"}, null, options, "----------\n1. ERROR in X.java (at line 2)\n\tint f= 1;\\u003B\n\t         ^^^^^^\nUnnecessary semicolon\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test025() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n        static class Y {\n                public void foo(int i) {}\n        }\n        static Y FakeInvocationSite = new Y(){\n                public void foo(int i) {}\n        };\n}"}, null, options, "----------\n1. ERROR in X.java (at line 3)\n\tpublic void foo(int i) {}\n\t                       ^^\nEmpty block should be documented\n----------\n2. ERROR in X.java (at line 6)\n\tpublic void foo(int i) {}\n\t                       ^^\nEmpty block should be documented\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test026() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", "error");
        this.runNegativeTest(true, new String[]{"X.java", "public class X {\n        static class Y {\n                public void foo(int i) {}\n        }\n        static Y FakeInvocationSite = new Y(){\n                public void foo(int i) {\n\t\t\t\t\tclass A {\n\t\t\t\t\t\tA() {}\n\t\t\t\t\t\tpublic void bar() {}\n\t\t\t\t\t}\n\t\t\t\t\tnew A().bar();\n\t\t\t\t }\n        };\n}"}, null, options, "----------\n1. ERROR in X.java (at line 3)\n\tpublic void foo(int i) {}\n\t                       ^^\nEmpty block should be documented\n----------\n2. ERROR in X.java (at line 9)\n\tpublic void bar() {}\n\t                  ^^\nEmpty block should be documented\n----------\n", AbstractRegressionTest.JavacTestOptions.Excuse.EclipseWarningConfiguredAsError);
    }

    public void test027() {
        this.runNegativeTest(new String[]{"X.java", "import java.io.EOFException;\nimport java.io.FileNotFoundException;\nimport java.io.IOException;\nimport org.xml.sax.SAXException;\npublic class X {\npublic void doSomething() throws FileNotFoundException, EOFException, SAXException{\n\n}\npublic void doSomethingElse() {\ntry {\n\tdoSomething();\n}\n catch ( SAXException exception) {\n\n}  \ncatch ( FileNotFoundException exception ) {\n\n}    \ncatch (\n\t// working before the slashes\n) {\n\n} \n} \n}\n"}, "----------\n1. ERROR in X.java (at line 19)\n\tcatch (\n\t      ^\nSyntax error on token \"(\", FormalParameter expected after this token\n----------\n");
    }

    public void test028() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", "error");
        this.runNegativeTest(new String[]{"X.java", "class X {\n    public static void foo(String param) {\n    \tString foo= param;\n    \tSrtring bar = \"\"\"\n    }\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\tSrtring bar = \"\"\"\n\t              ^^\nNon-externalized string literal; it should be followed by //$NON-NLS-<n>$\n----------\n2. ERROR in X.java (at line 4)\n\tSrtring bar = \"\"\"\n\t                ^\nString literal is not properly closed by a double-quote\n----------\n", null, true, options);
    }

    public void testBug485477() {
        this.runNegativeTest(new String[]{"T.java", "public class T {{\n  Object o = T.super; // error: '.' expected\n  System.out.println(o.toString());\n}}\nclass U {\n  Object o1;\n  Object o2 = T.super;\n  U() {\n    o1 = U.super;\n    System.out.println(o1.toString());\n  }\n}"}, "----------\n1. ERROR in T.java (at line 2)\n\tObject o = T.super; // error: '.' expected\n\t             ^^^^^\nSyntax error, insert \". Identifier\" to complete Expression\n----------\n2. ERROR in T.java (at line 7)\n\tObject o2 = T.super;\n\t              ^^^^^\nSyntax error, insert \". Identifier\" to complete Expression\n----------\n3. ERROR in T.java (at line 9)\n\to1 = U.super;\n\t       ^^^^^\nSyntax error, insert \". Identifier\" to complete Expression\n----------\n");
    }
}

