/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.parser;

import junit.framework.Test;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.tests.compiler.parser.AbstractSelectionTest;

public class SelectionParserTest18
extends AbstractSelectionTest {
    public static Test suite() {
        return SelectionParserTest18.buildMinimalComplianceTestSuite(SelectionParserTest18.class, 32);
    }

    public SelectionParserTest18(String testName) {
        super(testName);
    }

    public void test424110() throws JavaModelException {
        String string = "public class X {\n\tstatic F f = X::m; // [1] Works\n\tint i = fun(X::m); // [2] Does not work\n\tpublic static int m(int x) {\n\t\treturn x;\n\t}\n\tprivate int fun(F f) {\n\t\treturn f.foo(0);\n\t}\n}\ninterface F {\n\tint foo(int x);\n}\n";
        String selection = "m";
        String expectedCompletionNodeToString = "<SelectionOnReferenceExpressionName:X::m>";
        String completionIdentifier = "m";
        String expectedUnitDisplayString = "public class X {\n  static F f = <SelectionOnReferenceExpressionName:X::m>;\n  int i;\n  <clinit>() {\n  }\n  public X() {\n  }\n  public static int m(int x) {\n  }\n  private int fun(F f) {\n  }\n}\ninterface F {\n  int foo(int x);\n}\n";
        String expectedReplacedSource = "X::m";
        String testName = "<select>";
        int selectionStart = string.indexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkDietParse(string.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test424110a() throws JavaModelException {
        String string = "public class X {\n\tint i = fun(X::m); // [2] Does not work\n\tpublic static int m(int x) {\n\t\treturn x;\n\t}\n\tprivate int fun(F f) {\n\t\treturn f.foo(0);\n\t}\n}\ninterface F {\n\tint foo(int x);\n}\n";
        String selection = "m";
        String expectedCompletionNodeToString = "<SelectionOnReferenceExpressionName:X::m>";
        String completionIdentifier = "m";
        String expectedUnitDisplayString = "public class X {\n  int i = fun(<SelectionOnReferenceExpressionName:X::m>);\n  public X() {\n  }\n  public static int m(int x) {\n  }\n  private int fun(F f) {\n  }\n}\ninterface F {\n  int foo(int x);\n}\n";
        String expectedReplacedSource = "X::m";
        String testName = "<select>";
        int selectionStart = string.indexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkDietParse(string.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test430572() throws JavaModelException {
        String string = "@FunctionalInterface\ninterface FI {\n\tdefault int getID() {\n\t\treturn 11;\n\t}\n\tvoid print();\n}\nclass T {\n\tFI f2 = () -> System.out.println(super.toString());\n}\n";
        String selection = "super";
        String expectedCompletionNodeToString = "<SelectOnSuper:super>";
        String completionIdentifier = "super";
        String expectedUnitDisplayString = "@FunctionalInterface interface FI {\n  default int getID() {\n  }\n  void print();\n}\nclass T {\n  FI f2 = () -> System.out.println(<SelectOnSuper:super>.toString());\n  T() {\n  }\n}\n";
        String expectedReplacedSource = "super";
        String testName = "<select>";
        int selectionStart = string.indexOf(selection);
        int selectionEnd = selectionStart + selection.length() - 1;
        this.checkDietParse(string.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test476693() throws JavaModelException {
        int selectionStart;
        String string = "import static java.util.stream.Collectors.toList;\nimport java.util.List;\nimport java.util.Spliterator;\nimport java.util.stream.Stream;\ninterface Seq<T> extends Stream<T>, Iterable<T> {\n    @Override\n    default Spliterator<T> spliterator() {\n        return Iterable.super.spliterator();\n    }\n}\ninterface Tuple2<T1, T2> {}\ninterface Tuple3<T1, T2, T3> {}\n\npublic class Test<T1, T2, T3> {\n    <T1, T2> Seq<Tuple2<T1, T2>> m(Stream<T1> arg1, Stream<T2> arg2) {\n        System.out.println(\"m1\"); return null;\n    }\n    <T1, T2> Seq<Tuple2<T1, T2>> m(Seq<T1> arg1, Seq<T2> arg2){\n        System.out.println(\"m3\"); return null;\n    }\n    <T1, T2, T3> void m(Seq<T1> c1, Seq<T2> c2, Seq<T3> c3) {\n            // Click F3 on the m() call. This will jump to m1, erroneously\n            List<Tuple2<T1, T2>> l = m(c1, c2).collect(toList());\n            System.out.println(\"Hello\"); // This shouldn't appear in the selection parse tree\n    }\n}";
        String expectedCompletionNodeToString = "<SelectOnMessageSend:m(c1, c2)>";
        String completionIdentifier = "m";
        String expectedUnitDisplayString = "import static java.util.stream.Collectors.toList;\nimport java.util.List;\nimport java.util.Spliterator;\nimport java.util.stream.Stream;\ninterface Seq<T> extends Stream<T>, Iterable<T> {\n  default @Override Spliterator<T> spliterator() {\n  }\n}\ninterface Tuple2<T1, T2> {\n}\ninterface Tuple3<T1, T2, T3> {\n}\npublic class Test<T1, T2, T3> {\n  public Test() {\n  }\n  <T1, T2>Seq<Tuple2<T1, T2>> m(Stream<T1> arg1, Stream<T2> arg2) {\n  }\n  <T1, T2>Seq<Tuple2<T1, T2>> m(Seq<T1> arg1, Seq<T2> arg2) {\n  }\n  <T1, T2, T3>void m(Seq<T1> c1, Seq<T2> c2, Seq<T3> c3) {\n    List<Tuple2<T1, T2>> l = <SelectOnMessageSend:m(c1, c2)>.collect(toList());\n  }\n}\n";
        String expectedReplacedSource = "m(c1, c2)";
        String testName = "<select>";
        int selectionEnd = selectionStart = string.indexOf("m(c1, c2)");
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test495912() {
        String string = "package xy;\npublic class Test {\n\t{\n\t\tRunnable r = () -> {\n\t\t      Integer i= 1;\n\t\t      byte b= i.byteValue();\n\t\t      if (true) {\n\t\t          if (false) {\n\t\t          }\n\t\t      }\n\t\t      String s= new String();\n\t\t};\n\t}\n    public void foo(Runnable r) {\n    }\n}";
        String expectedCompletionNodeToString = "<SelectOnMessageSend:i.byteValue()>";
        String completionIdentifier = "byteValue";
        String expectedUnitDisplayString = "package xy;\npublic class Test {\n  {\n    Runnable r = () ->     {\n      Integer i;\n      byte b = <SelectOnMessageSend:i.byteValue()>;\n      if (true)\n          {\n            if (false)\n                {\n                }\n          }\n      String s;\n    };\n  }\n  public Test() {\n  }\n  public void foo(Runnable r) {\n  }\n}\n";
        String expectedReplacedSource = "i.byteValue()";
        String testName = "<select>";
        int selectionStart = string.indexOf("byteValue");
        int selectionEnd = selectionStart + completionIdentifier.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test495912a() {
        String string = "package xy;\npublic class Test {\n\t{\n\t\tRunnable r = () -> {\n\t\t      Integer i= 1;\n\t\t      byte b= i.byteValue();\n\t\t      if (true) {\n\t\t          if (false) {\n\t\t          }\n\t\t      }\n\t\t      for (int i1 = 0; i1 < 42; i1++) {\n\t\t      }\n\t\t};\n\t}\n    public void foo(Runnable r) {\n    }\n}";
        String expectedCompletionNodeToString = "<SelectOnMessageSend:i.byteValue()>";
        String completionIdentifier = "byteValue";
        String expectedUnitDisplayString = "package xy;\npublic class Test {\n  {\n    Runnable r = () ->     {\n      Integer i;\n      byte b = <SelectOnMessageSend:i.byteValue()>;\n      if (true)\n          {\n            if (false)\n                {\n                }\n          }\n      for (int i1;; (i1 < 42); i1 ++) \n        {\n        }\n    };\n  }\n  public Test() {\n  }\n  public void foo(Runnable r) {\n  }\n}\n";
        String expectedReplacedSource = "i.byteValue()";
        String testName = "<select>";
        int selectionStart = string.indexOf("byteValue");
        int selectionEnd = selectionStart + completionIdentifier.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedCompletionNodeToString, expectedUnitDisplayString, completionIdentifier, expectedReplacedSource, testName);
    }

    public void test495912b() {
        String string = "package xy;\nimport org.eclipse.e4.ui.internal.workbench.PartServiceImpl;\nimport org.eclipse.e4.ui.model.application.ui.basic.MPart;\nimport org.eclipse.swt.widgets.Table;\nimport org.eclipse.ui.IWorkbenchWindow;\npublic abstract class CycleViewHandler extends CycleBaseHandler {\n\t@Override\n\tprotected void addItems(Table table, WorkbenchPage page) {\n\t\tList<MPart> parts = null;\n\t\tparts.stream().sorted((firstPart, secondPart) -> {\n\t\t\tLong firstPartActivationTime = (Long) firstPart.getTransientData()\n\t\t\t\t\t.getOrDefault(PartServiceImpl.PART_ACTIVATION_TIME, Long.MIN_VALUE);\n\t\t\tLong secondPartActivationTime = (Long) secondPart.getTransientData()\n\t\t\t\t\t.getOrDefault(PartServiceImpl.PART_ACTIVATION_TIME, Long.MIN_VALUE);\n\t\t\treturn 0;\n\t\t}).forEach(part -> {\n\t\t\tif (true) {\n\t\t\t\tif (true) {\n\t\t\t\t}\n\t\t\t} \n\t\t\telse {\n\t\t\t\tIWorkbenchWindow iwbw = page.getWorkbenchWindow();\n\t\t\t\tif (true){\n\t\t\t\t}\n\t\t\t}\n\t\t});\n\t}\n}";
        String expectedSelectionNodeToString = "<SelectOnMessageSend:firstPart.getTransientData()>";
        String selectionIdentifier = "getTransientData";
        String expectedUnitDisplayString = "package xy;\nimport org.eclipse.e4.ui.internal.workbench.PartServiceImpl;\nimport org.eclipse.e4.ui.model.application.ui.basic.MPart;\nimport org.eclipse.swt.widgets.Table;\nimport org.eclipse.ui.IWorkbenchWindow;\npublic abstract class CycleViewHandler extends CycleBaseHandler {\n  public CycleViewHandler() {\n  }\n  protected @Override void addItems(Table table, WorkbenchPage page) {\n    List<MPart> parts;\n    parts.stream().sorted((<no type> firstPart, <no type> secondPart) -> {\n  Long firstPartActivationTime = (Long) <SelectOnMessageSend:firstPart.getTransientData()>.getOrDefault(PartServiceImpl.PART_ACTIVATION_TIME, Long.MIN_VALUE);\n  Long secondPartActivationTime;\n  return 0;\n}).forEach((<no type> part) -> {\n  if (true)\n      {\n        if (true)\n            {\n            }\n      }\n  else\n      {\n        IWorkbenchWindow iwbw;\n        if (true)\n            {\n            }\n      }\n});\n  }\n}\n";
        String expectedReplacedSource = "firstPart.getTransientData()";
        String testName = "<select>";
        int selectionStart = string.indexOf("getTransientData");
        int selectionEnd = selectionStart + selectionIdentifier.length() - 1;
        this.checkMethodParse(string.toCharArray(), selectionStart, selectionEnd, expectedSelectionNodeToString, expectedUnitDisplayString, selectionIdentifier, expectedReplacedSource, testName);
    }
}

