/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class AssignmentTest_1_5
extends AbstractRegressionTest {
    public AssignmentTest_1_5(String name) {
        super(name);
    }

    @Override
    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        options.put("org.eclipse.jdt.core.compiler.problem.nullReference", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.potentialNullReference", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.redundantNullCheck", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", "error");
        return options;
    }

    public static Test suite() {
        return AssignmentTest_1_5.buildMinimalComplianceTestSuite(AssignmentTest_1_5.testClass(), 4);
    }

    public void test1() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger value = 4711;\n\t\tdouble test = 47d;\n\t\tvalue += test;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tvalue += test;\n\t^^^^^^^^^^^^^\nThe operator += is undefined for the argument type(s) Integer, double\n----------\n");
    }

    public void test2() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger value = 4711;\n\t\tfloat test = 47f;\n\t\tvalue += test;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tvalue += test;\n\t^^^^^^^^^^^^^\nThe operator += is undefined for the argument type(s) Integer, float\n----------\n");
    }

    public void test3() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger value = 4711;\n\t\tbyte test = 47;\n\t\tvalue += test;\n\t\tSystem.out.println(value);\n\t}\n}"}, "4758");
    }

    public void test4() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger value = 4711;\n\t\tchar test = 'a';\n\t\tvalue += test;\n\t\tSystem.out.println(value);\n\t}\n}"}, "4808");
    }

    public void test5() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger value = 4711;\n\t\tlong test = 100L;\n\t\tvalue += test;\n\t\tSystem.out.println(value);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tvalue += test;\n\t^^^^^^^^^^^^^\nThe operator += is undefined for the argument type(s) Integer, long\n----------\n");
    }

    public void test6() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger value = 4711;\n\t\tboolean test = true;\n\t\tvalue += test;\n\t\tSystem.out.println(value);\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tvalue += test;\n\t^^^^^^^^^^^^^\nThe operator += is undefined for the argument type(s) int, boolean\n----------\n");
    }

    public void test7() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger value = 4711;\n\t\tshort test = 32767;\n\t\tvalue += test;\n\t\tSystem.out.println(value);\n\t}\n}"}, "37478");
    }

    public void test8() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tint x = -8;\n\t\tx += 7.8f;\n\t\tSystem.out.println(x == 0 ? \"SUCCESS\" : \"FAILED\");\n\t}\n}"}, "SUCCESS");
    }

    public void test9() {
        this.runConformTest(new String[]{"X.java", "class XSuper<T> {\n\tT value;\n}\npublic class X extends XSuper<String>{\n\tpublic void a() {\n\t\tthis.value += 1;\n\t\tthis.value = this.value + 1;\n\t\tSystem.out.println(this.value);\n\t}\n\n\tpublic static void main(final String[] args) {\n\t\tX x = new X();\n\t\tx.value = \"[\";\n\t\tx.a();\n\t}\n}\n"}, "[11");
    }

    public void test10() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tByte b = new Byte((byte)1);\n\t\tint i = b++;\n\t\tSystem.out.print(i);\n\t\tSystem.out.print(b);\n\t}\n}\n"}, "12");
    }

    public void test11() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String args[]) { \n\t\tLong _long = new Long(44);\n\t\tbyte b = (byte) 1;\n\t\tchar c = (char) 2;\n\t\tshort s = (short) 32767;\n\t\tint i = 10;\n\t\tlong l = 80L;\n\t\t_long >>>= b;\n\t\t_long <<= c;\n\t\t_long >>= s;\n\t\t_long >>>= i;\n\t\t_long = 77l;\n\t\t_long <<= l;\n\t\tSystem.out.println(_long);\n\t}\n}"}, "5046272");
    }

    public void test12() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tByte b = new Byte((byte)1);\n\t\tint i = ++b;\n\t\tSystem.out.print(i);\n\t\tSystem.out.print(b);\n\t}\n}\n"}, "22");
    }

    public void test13() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger value = 4711;\n\t\tlong test = 47L;\n\t\tvalue &= test;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tvalue &= test;\n\t^^^^^^^^^^^^^\nThe operator &= is undefined for the argument type(s) Integer, long\n----------\n");
    }

    public void test14() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tInteger value = 4711;\n\t\tlong test = 47L;\n\t\tvalue |= test;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tvalue |= test;\n\t^^^^^^^^^^^^^\nThe operator |= is undefined for the argument type(s) Integer, long\n----------\n");
    }

    public void test15() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tByte value = (byte) 1;\n\t\tvalue++;\n\t\tSystem.out.println(value);\n\t}\n}"}, "2");
    }

    public static Class testClass() {
        return AssignmentTest_1_5.class;
    }
}

