/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.jdt.core.tests.compiler.regression.AbstractRegressionTest;

public class ExpressionContextTests
extends AbstractRegressionTest {
    public ExpressionContextTests(String name) {
        super(name);
    }

    public static Test suite() {
        return ExpressionContextTests.buildMinimalComplianceTestSuite(ExpressionContextTests.testClass(), 32);
    }

    @Override
    protected Map getCompilerOptions() {
        Map defaultOptions = super.getCompilerOptions();
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        defaultOptions.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        return defaultOptions;
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n\tdefault void doitalso () {}\n}\npublic class X {\n\tObject o = () -> {};\n\tObject p = (I) () -> {};\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\tObject o = () -> {};\n\t           ^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n\tdefault void doitalso () {}\n}\ninterface J {\n\tvoid doit();\n\tdefault void doitalso () {}\n}\npublic class X {\n\tObject p = (I & J) () -> {};\n}\n"});
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n\tdefault void doitalso () {}\n}\ninterface J {\n\tvoid doit();\n\tdefault void doitalso () {}\n}\npublic class X {\n\tObject p = (int & I & J) () -> {};\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tObject p = (int & I & J) () -> {};\n\t            ^^^\nBase types are not allowed in intersection cast operator\n----------\n2. ERROR in X.java (at line 10)\n\tObject p = (int & I & J) () -> {};\n\t                         ^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n\tdefault void doitalso () {}\n}\ninterface J {\n\tvoid doit();\n\tdefault void doitalso () {}\n}\npublic class X {\n\tObject p = (X[] & Serializable & Cloneable) new X[0];\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tObject p = (X[] & Serializable & Cloneable) new X[0];\n\t            ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nArrays are not allowed in intersection cast operator\n----------\n2. ERROR in X.java (at line 10)\n\tObject p = (X[] & Serializable & Cloneable) new X[0];\n\t                  ^^^^^^^^^^^^\nSerializable cannot be resolved to a type\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n\tdefault void doitalso () {}\n}\ninterface J {\n\tvoid doit();\n\tdefault void doitalso () {}\n}\npublic class X {\n\tObject p = (I & X) () -> {};\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tObject p = (I & X) () -> {};\n\t                ^\nThe type X is not an interface; it cannot be specified as a bounded parameter\n----------\n2. ERROR in X.java (at line 10)\n\tObject p = (I & X) () -> {};\n\t                   ^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n\tdefault void doitalso () {}\n}\ninterface J {\n\tvoid doit();\n\tdefault void doitalso () {}\n}\npublic class X {\n\tObject p = (I & J & I) () -> {};\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tObject p = (I & J & I) () -> {};\n\t                    ^\nDuplicate type in intersection cast operator\n----------\n2. ERROR in X.java (at line 10)\n\tObject p = (I & J & I) () -> {};\n\t                       ^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test007() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\ninterface I<T> {\n\tvoid doit(List<T> x);\n\tdefault void doitalso () {}\n\tboolean equals(Object o);\n}\npublic class X {\n\tI<String> i = (List<String> p) -> {};\n\tI<X> i2 = (List<String> p) -> {};\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tI<X> i2 = (List<String> p) -> {};\n\t           ^^^^\nLambda expression's parameter p is expected to be of type List<X>\n----------\n");
    }

    public void test008() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n\tdefault void doitalso () {}\n}\ninterface J {\n\tvoid doit();\n\tdefault void doitalso () {}\n}\npublic class X {\n\tObject p = (@Marker java.lang. @Readonly String & I & J) () -> {};\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tObject p = (@Marker java.lang. @Readonly String & I & J) () -> {};\n\t            ^^^^^^^\nIllegally placed annotation: type annotations must directly precede the simple name of the type they are meant to affect (or the [] for arrays)\n----------\n2. ERROR in X.java (at line 10)\n\tObject p = (@Marker java.lang. @Readonly String & I & J) () -> {};\n\t             ^^^^^^\nMarker cannot be resolved to a type\n----------\n3. ERROR in X.java (at line 10)\n\tObject p = (@Marker java.lang. @Readonly String & I & J) () -> {};\n\t                                ^^^^^^^^\nReadonly cannot be resolved to a type\n----------\n4. ERROR in X.java (at line 10)\n\tObject p = (@Marker java.lang. @Readonly String & I & J) () -> {};\n\t                                                         ^^^^^\nThe target type of this expression must be a functional interface\n----------\n");
    }

    public void test009() {
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings, new String[]{"X.java", "import java.util.List;\nimport java.util.Map;\ninterface I<T> {\n\tvoid doit(List<T> x);\n\tboolean equals(Object o);\n}\npublic class X {\n\tI<String> i = (List<String> p) -> {};\n\tI<X> i2 = (Map<String, String> & I<X>) null;\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tI<X> i2 = (Map<String, String> & I<X>) null;\n\t          ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from null to Map<String,String> & I<X>\n----------\n");
    }

    public void test010() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.List;\nimport java.util.Map;\ninterface I<T> {\n\tvoid doit(List<T> x);\n\tboolean equals(Object o);\n}\npublic class X {\n\tI<String> i = (List<String> p) -> {};\n\tI<X> i2 = (Map<String, String>.Entry & I<X> & Serializable) null;\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tI<X> i2 = (Map<String, String>.Entry & I<X> & Serializable) null;\n\t           ^^^^^^^^^^^^^^^^^^^^^^^^^\nThe member type Map.Entry<K,V> cannot be qualified with a parameterized type, since it is static. Remove arguments from qualifying type Map<String,String>\n----------\n2. ERROR in X.java (at line 9)\n\tI<X> i2 = (Map<String, String>.Entry & I<X> & Serializable) null;\n\t                                              ^^^^^^^^^^^^\nSerializable cannot be resolved to a type\n----------\n");
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n}\ninterface J {\n}\ninterface K {\n}\npublic class X {\n\tX X = (X & J & K) new Y();\n}\nclass Y {\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tX X = (X & J & K) new Y();\n\t      ^^^^^^^^^^^^^^^^^^^\nCannot cast from Y to X & J & K\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n}\ninterface J {\n}\ninterface K {\n}\npublic class X {\n\tX X = (X & J & K) new Y();\n}\nclass Y extends X implements Zork {\n}\n"}, "----------\n1. WARNING in X.java (at line 8)\n\tX X = (X & J & K) new Y();\n\t      ^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Y to X & J & K\n----------\n2. ERROR in X.java (at line 10)\n\tclass Y extends X implements Zork {\n\t                             ^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n}\ninterface J {\n}\ninterface K {\n}\npublic class X {\n\tX X = (X & J & K) new Y();\n}\nfinal class Y extends X {\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tX X = (X & J & K) new Y();\n\t      ^^^^^^^^^^^^^^^^^^^\nCannot cast from Y to X & J & K\n----------\n2. WARNING in X.java (at line 8)\n\tX X = (X & J & K) new Y();\n\t      ^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from Y to X & J & K\n----------\n");
    }

    public void test014() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n}\ninterface J {\n}\ninterface K {\n}\npublic class X {\n   I i = null;\n\tX X = (X & J & K) i;\n}\nfinal class Y extends P {\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tfinal class Y extends P {\n\t                      ^\nP cannot be resolved to a type\n----------\n");
    }

    public void test015() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n}\ninterface J {\n}\ninterface K {\n}\nfinal public class X {\n   I i = null;\n\tX X = (X & J & K) i;\n   Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 9)\n\tX X = (X & J & K) i;\n\t      ^^^^^^^^^^^^^\nCannot cast from I to X & J & K\n----------\n2. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test016() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n}\ninterface J {\n}\ninterface K {\n}\nfinal public class X implements I {\n   I i = null;\n\tX X = (X & J & K) i;\n   Zork z;\n}\n"}, "----------\n1. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test017() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n}\ninterface J {\n}\ninterface K {\n}\npublic class X {\n   I i = null;\n\tX X = (X & J & K) (X & K & J) i;\n   Zork z;\n}\n"}, "----------\n1. WARNING in X.java (at line 9)\n\tX X = (X & J & K) (X & K & J) i;\n\t      ^^^^^^^^^^^^^^^^^^^^^^^^^\nUnnecessary cast from X & K & J to X & J & K\n----------\n2. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test018() {
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings, new String[]{"X.java", "interface I {\n\tvoid doit();\n}\nclass X {\n\tObject o = (I) () -> {};\n\tI k = (()->{});\n\tI i = 1 == 2 ? () -> {} : () -> {};\n\tI j = () -> {};\n}\n"}, "----------\n1. WARNING in X.java (at line 7)\n\tI i = 1 == 2 ? () -> {} : () -> {};\n\t               ^^^^^^^^\nDead code\n----------\n");
    }

    public void test019() {
        this.runNegativeTest(false, AbstractRegressionTest.JavacTestOptions.Excuse.EclipseHasSomeMoreWarnings, new String[]{"X.java", "interface I {\n\tvoid doit();\n}\nclass X {\n\tI [] k = {(()->{}), ()->{}, 1 == 2 ? () -> {} : ()->{}};\n\tI [][] i = {{()->{}}};\n\tvoid foo() {\n       I i = () -> {};\n   }\n}\n"}, "----------\n1. WARNING in X.java (at line 5)\n\tI [] k = {(()->{}), ()->{}, 1 == 2 ? () -> {} : ()->{}};\n\t                                     ^^^^^^^^\nDead code\n----------\n2. WARNING in X.java (at line 8)\n\tI i = () -> {};\n\t  ^\nThe local variable i is hiding a field from type X\n----------\n");
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tJ doit(int x);\n}\ninterface J {\n\tK doit();\n}\ninterface K {\n   I doit();\n}class X {\n\tI foo() {\n       return x -> { return () -> () -> \"Hello\"; };\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\treturn x -> { return () -> () -> \"Hello\"; };\n\t                                 ^^^^^^^\nType mismatch: cannot convert from String to I\n----------\n");
    }

    public void test021() {
        this.runNegativeTest(new String[]{"X.java", "interface I {\n\tvoid doit();\n}\nclass X {\n\tI foo() {\n       return \"Hello\" + () -> {};\n   }\n\tI goo() {\n       return \"Hello\" + (I)(() -> {});\n   }\n\tI zoo() {\n       return 10 + (() -> {});\n   }\n\tI boo() {\n       return 10 + (I) (() -> {});\n   }\n}\n"}, "----------\n1. ERROR in X.java (at line 6)\n\treturn \"Hello\" + () -> {};\n\t                 ^^^^^\nThe target type of this expression must be a functional interface\n----------\n2. ERROR in X.java (at line 9)\n\treturn \"Hello\" + (I)(() -> {});\n\t       ^^^^^^^^^^^^^^^^^^^^^^^\nType mismatch: cannot convert from String to I\n----------\n3. ERROR in X.java (at line 12)\n\treturn 10 + (() -> {});\n\t            ^^^^^^\nThe target type of this expression must be a functional interface\n----------\n4. ERROR in X.java (at line 15)\n\treturn 10 + (I) (() -> {});\n\t       ^^^^^^^^^^^^^^^^^^^\nThe operator + is undefined for the argument type(s) int, I\n----------\n");
    }

    public void test022() {
        this.runNegativeTest(new String[]{"X.java", "import java.util.Arrays;\nimport java.util.List;\nclass X {\n\tint foo(int x) {\n\t\tList<String> l = x == 2 ? (List<String>)(null) : 1;\n\t\tList<String> m = x == 2 ? 1 : (List<String>)(null);\n\t\treturn 1;\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 5)\n\tList<String> l = x == 2 ? (List<String>)(null) : 1;\n\t                                                 ^\nType mismatch: cannot convert from int to List<String>\n----------\n2. ERROR in X.java (at line 6)\n\tList<String> m = x == 2 ? 1 : (List<String>)(null);\n\t                          ^\nType mismatch: cannot convert from int to List<String>\n----------\n");
    }

    public static Class testClass() {
        return ExpressionContextTests.class;
    }
}

